/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.PasswordDialog;
import com.cisco.dcbu.sm.client.dialogs.UserData;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Fabric;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JButton;

public class SmUserTableModel
extends SmTableModel
implements ActionListener {
    public static final int ANY = 0;
    public static final int USM = 3;
    final int[] _deleteVacmVarOid = MibNode.get("vacmSecurityToGroupStatus").getOid();
    final int[] _authPwdOid = MibNode.get("usmUserOwnAuthKeyChange").getOid();
    final int[] _privPwdOid = MibNode.get("usmUserOwnPrivKeyChange").getOid();
    final int[] _vacmGroupNameOid = MibNode.get("vacmGroupName").getOid();
    static final int[] _cvacmSecurityGrpStatusOid = MibNode.get("cvacmSecurityGrpStatus").getOid();
    final SnmpInt _DESTROY = new SnmpInt(6);
    byte[] engineId;
    static final int NAMECOL = 1;
    static final int SECURITYGRPCOL = 2;
    static final int SECONDARY_ROLE = 3;
    static final int DIGESTCOL = 4;
    static final int ENCRYCOL = 5;
    HashMap _peer2RowIndices = new HashMap();
    Array _peersChgedPswd = new Array();
    HashMap _peer2NewAuthPswd = new HashMap();
    HashMap _peer2NewPrivPswd = new HashMap();
    HashMap _peer2User = new HashMap();
    private static final String[] NEW_BUTTON = new String[]{null, "Change Password...", "W"};
    PasswordDialog _passwordDlg = null;

    public SmUserTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        JButton changeTimerBtn = dataView.insertButton(0, new String[][]{NEW_BUTTON}, new ActionListener[]{this});
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        if (!Fabric.getReferencePeer().isV3()) {
            boolean[] isEditable = this.getEditable();
            for (int i = 0; i < isEditable.length; ++i) {
                isEditable[i] = false;
            }
            this.setEditable(isEditable);
        }
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2User.clear();
        super.getTableVars(nodes);
        this.getvacmSecurityGroupTables();
        return this._responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getvacmSecurityGroupTables() throws SnmpException {
        this._peer2RowIndices.clear();
        Array rowIndices = null;
        VarBindList vbl = null;
        HashMap<SnmpPeer, VarBindList> peer2Vbl = new HashMap<SnmpPeer, VarBindList>();
        for (int i = 0; i < this._responseData.size(); ++i) {
            Object[] row = (Object[])this._responseData.elementAt(i);
            row[2] = new SnmpString("");
            SnmpPeer wrkPeer = (SnmpPeer)row[0];
            if (!this._peer2RowIndices.containsKey(wrkPeer)) {
                rowIndices = new Array();
                this._peer2RowIndices.put(wrkPeer, rowIndices);
                vbl = new VarBindList();
                peer2Vbl.put(wrkPeer, vbl);
            } else {
                rowIndices = (Array)this._peer2RowIndices.get(wrkPeer);
                vbl = (VarBindList)peer2Vbl.get(wrkPeer);
            }
            rowIndices.addElement(new Integer(i));
            int[] indexUsm = ((SnmpOID)row[1]).getValue();
            int userNameLen = indexUsm[indexUsm[0] + 1];
            int[] indexVacmUSM = new int[userNameLen + 2];
            indexVacmUSM[0] = 3;
            indexVacmUSM[1] = userNameLen;
            System.arraycopy(indexUsm, indexUsm[0] + 2, indexVacmUSM, 2, userNameLen);
            vbl.add(new SnmpVarBind(new SnmpOID(this._vacmGroupNameOid, indexVacmUSM)));
        }
        this._timedoutPeers.clear();
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peer2Vbl.keySet()) {
                vbl = (VarBindList)peer2Vbl.get(peer);
                SnmpFetch f = new SnmpFetch();
                f.get(peer, vbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peer2Vbl.keySet()) {
                SnmpFetch f = new SnmpFetch();
                f.getBulk(peer, new String[]{"cvacmSecurityGrpStatus"}, (SnmpCallbackIf)this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public void processCallback(SnmpPeer node, SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpVarBind vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        if (SnmpOID.startsWith(oid, this._firstOid)) {
            super.processCallback(node, session, reqid, pdu, timedOut);
        } else if (SnmpOID.startsWith(oid, this._vacmGroupNameOid)) {
            this.getSecurityGrpCallback(node, pdu);
        } else if (SnmpOID.startsWith(oid, _cvacmSecurityGrpStatusOid)) {
            this.getSecondarySecurityGrpCallback(node, pdu);
        }
    }

    void getSecurityGrpCallback(SnmpPeer node, SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        int[] groupNameOid = MibNode.get("vacmGroupName").getOid();
        int indexOffset = groupNameOid.length;
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            SnmpVar v = vb.getVar();
            if (v.getType() == 5) continue;
            int[] oid = vb.getOid().getValue();
            int[] userName = new int[oid[indexOffset + 1]];
            System.arraycopy(oid, indexOffset + 2, userName, 0, userName.length);
            int rowNo = this.findRow(node, userName);
            if (rowNo == -1) continue;
            Object[] row = (Object[])this._responseData.elementAt(rowNo);
            row[2] = vb.getVar();
        }
    }

    void getSecondarySecurityGrpCallback(SnmpPeer node, SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        int indexOffset = _cvacmSecurityGrpStatusOid.length;
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid;
            SnmpVarBind vb = vbl.getVb(i);
            SnmpVar v = vb.getVar();
            if (v.getType() == 5 || (oid = vb.getOid().getValue())[indexOffset] != 3) continue;
            int[] userName = new int[oid[indexOffset + 1]];
            System.arraycopy(oid, indexOffset + 2, userName, 0, userName.length);
            int rowNo = this.findRow(node, userName);
            if (rowNo == -1) continue;
            Object[] row = (Object[])this._responseData.elementAt(rowNo);
            StringBuffer sb = new StringBuffer((String)row[3]);
            if (!sb.toString().equals("")) {
                sb.append(", ");
            }
            int userNameLength = oid[indexOffset + 1];
            int groupNameOffset = indexOffset + 1 + 1 + userNameLength + 1;
            int groupNameLength = oid[groupNameOffset - 1];
            sb.append(SnmpString.toString(oid, groupNameOffset, groupNameOffset + groupNameLength));
            row[3] = sb.toString();
        }
    }

    int findRow(SnmpPeer peer, int[] user) {
        Array rowIndices = (Array)this._peer2RowIndices.get(peer);
        if (rowIndices == null) {
            return -1;
        }
        for (int i = 0; i < rowIndices.size(); ++i) {
            int rowNo = (Integer)rowIndices.elementAt(i);
            Object[] row = (Object[])this._responseData.elementAt(rowNo);
            int[] rowIndex = ((SnmpOID)row[1]).getValue();
            if (!SnmpOID.equals(user, 0, rowIndex, rowIndex[0] + 2)) continue;
            return rowNo;
        }
        return -1;
    }

    @Override
    public void deleteRows(int[] rows) throws Exception {
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < rows.length; ++i) {
            SnmpPeer node = (SnmpPeer)this.getValueAt(rows[i], 0);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            String sessionUser = node.getUserName();
            this.engineId = node.getEngineId();
            int[] rowIndex = ((SnmpOID)this.getValueAt(rows[i], 1)).getValue();
            String rowUser = SnmpString.toString(rowIndex, rowIndex[0] + 2, rowIndex.length);
            if (rowUser.equals(sessionUser)) {
                throw new SnmpException("You can't delete yourself!");
            }
            if (rowUser.length() == 0) continue;
            int[] vacmIndex = new int[rowUser.length() + 2];
            vacmIndex[0] = 3;
            vacmIndex[1] = rowUser.length();
            int indexPos = 2;
            int j = 0;
            while (j < rowUser.length()) {
                vacmIndex[indexPos] = rowUser.charAt(j);
                ++j;
                ++indexPos;
            }
            pdu.addVar(new SnmpOID(this._deleteVacmVarOid, vacmIndex), this._DESTROY);
            String secRoles = (String)this.getValueAt(rows[i], 3);
            if (secRoles == null || secRoles.equals("")) continue;
            StringTokenizer st = new StringTokenizer(secRoles, ",", true);
            while (st.hasMoreTokens()) {
                String role = st.nextToken().trim();
                int[] cvacmIndex = new int[vacmIndex.length + role.length() + 1];
                System.arraycopy(vacmIndex, 0, cvacmIndex, 0, vacmIndex.length);
                int j2 = vacmIndex.length;
                cvacmIndex[j2++] = role.length();
                for (int k = 0; j2 < cvacmIndex.length && k < role.length(); ++j2, ++k) {
                    cvacmIndex[j2] = role.charAt(k);
                }
                pdu.addVar(new SnmpOID(_cvacmSecurityGrpStatusOid, cvacmIndex), this._DESTROY);
            }
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        int successfulSets = aggregrate.set(pdus.keySet().iterator(), pdus.values().iterator());
        if (successfulSets < pdus.size()) {
            String strErr = "Succeeded on " + successfulSets + " of " + pdus.size() + " device(s) on deletion of selected row(s) in vacmSecurityToGroupTable. See log for details.";
            this._setErrMsg.addElement(strErr);
        }
        super.deleteRows(rows);
    }

    static int[] getUserIndex(byte[] engineId, String newUser) {
        int[] index = new int[engineId.length + newUser.length() + 2];
        index[0] = engineId.length;
        for (int i = 1; i <= engineId.length; ++i) {
            index[i] = engineId[i - 1] & 0xFF;
        }
        index[i++] = newUser.length();
        for (int j = 0; j < newUser.length(); ++j) {
            index[i++] = newUser.charAt(j);
        }
        return index;
    }

    @Override
    protected boolean isSkip(SnmpPeer peer, int[] req, SnmpVarBind firstVb, int[] index, VarBindList vbl, int reqId) {
        if (peer.getVersion() == 3) {
            int[] b = SnmpString.valueOf(peer.getEngineId(), true);
            int[] a = firstVb.getOid().getValue();
            return !SnmpOID.startsWith(a, b, this._firstOid.length);
        }
        return false;
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err.length() == 0) {
            SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
            this._peersChgedPswd.addElement(peer);
        }
    }

    @Override
    public int compare(Object first, Object second) {
        if (this._sortColumn == 1) {
            int[] firstOid = ((SnmpOID)first).getValue();
            int[] firstUserName = new int[firstOid[firstOid[0] + 1]];
            System.arraycopy(firstOid, firstOid[0] + 2, firstUserName, 0, firstUserName.length);
            int[] secondOid = ((SnmpOID)second).getValue();
            int[] secondUserName = new int[secondOid[firstOid[0] + 1]];
            System.arraycopy(secondOid, secondOid[0] + 2, secondUserName, 0, secondUserName.length);
            return MibNode.equals(firstUserName, secondUserName);
        }
        return super.compare(first, second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        row[3] = "";
        Array<UserData> userIndices = (Array<UserData>)this._peer2User.get(node);
        if (userIndices == null) {
            userIndices = new Array<UserData>();
            HashMap hashMap = this._peer2User;
            synchronized (hashMap) {
                this._peer2User.put(node, userIndices);
            }
        }
        SnmpString userV = new SnmpString(vbl.byteValue(1));
        boolean isSHA = ((String)row[4]).equals("SHA");
        boolean isAES = ((String)row[5]).equals("AES");
        userIndices.addElement(new UserData(userV.toString(), isSHA, isAES));
        return row;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.changePasswords();
        }
    }

    void changePasswords() {
        this._passwordDlg = new PasswordDialog(BrowserFrame.getInstance(), this.getWrkingPeers(), this._peer2User);
        this._passwordDlg.setVisible(true);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._passwordDlg != null) {
            this._passwordDlg.dispose();
            this._passwordDlg = null;
        }
    }
}

