/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import com.cisco.dcbu.sm.common.model.Card;
import java.util.List;
import java.util.Map;

public class SwitchCardIpRouteTableModel
extends KTableModel {
    public final int ColumnSize = Column.values().length;

    public SwitchCardIpRouteTableModel(String[] headers) {
        this.setHeaders(headers);
        Array data = new Array();
        this.setData(data);
    }

    public int getSwitchModuleIndex(SwitchCardContainer swCard) {
        Array data = this.getData();
        Integer index = -1;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (!swCard.equals(row[Column.SWITCH_MODULE.ordinal()])) continue;
            index = i;
            break;
        }
        return index;
    }

    public synchronized void setData(Map<SwitchCardContainer, String> cardVsanIpMap, List<Card> cardsNeedingRoutes) {
        for (SwitchCardContainer nextCard : cardVsanIpMap.keySet()) {
            Object[] row = new Object[this.ColumnSize];
            row[Column.SWITCH_MODULE.ordinal()] = nextCard;
            row[Column.IPADDR_MASK.ordinal()] = cardVsanIpMap.get(nextCard);
            row[Column.EXISTS.ordinal()] = cardsNeedingRoutes.contains(nextCard.getCard()) ? "No" : "Yes";
            this.getData().addElement(row);
        }
        this.fireTableDataChanged();
    }

    public synchronized void clearAll() {
        this.getData().clear();
        this.fireTableDataChanged();
    }

    public static enum Column {
        SWITCH_MODULE,
        IPADDR_MASK,
        EXISTS;

    }
}

