/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.view;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.fa.view.AdminStatusEditor;
import com.cisco.dcbu.sm.client.fa.view.AdvancedTableModel;
import com.cisco.dcbu.sm.client.fa.view.FATypeEditor;
import com.cisco.dcbu.sm.client.fa.view.PListModel;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.FlexAtahVPWWN;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class ListListener2
extends JLabel
implements ListSelectionListener,
ActionListener,
TableModelListener,
ListCellRenderer,
MouseListener {
    protected Map<SwitchBase, List<FlexAtahCfg>> swMap;
    protected Map<SwitchBase, List<FlexAtahVPWWN>> wwnMap;
    protected Map<SwitchBase, List<Integer>> vsans;
    protected CardLayout cards;
    protected JPanel parent;
    protected JList list;
    protected Map<SwitchBase, AdvTablePanel> cardMap;
    protected SwitchBase current;
    protected Boolean initFaAuto;
    protected Map<SwitchBase, Array> vOrigMap = new HashMap<SwitchBase, Array>();
    protected Map<SwitchBase, Boolean> faAutos;

    public ListListener2(JList list) {
        this.list = list;
        this.cardMap = new HashMap<SwitchBase, AdvTablePanel>();
    }

    public void updateValue(CardLayout cards, JPanel parent, Map<SwitchBase, List<FlexAtahCfg>> swMap, Map<SwitchBase, List<FlexAtahVPWWN>> wwnMap, Map<SwitchBase, List<Integer>> vsans, Map<SwitchBase, Boolean> faAutos) {
        this.cards = cards;
        this.parent = parent;
        this.swMap = swMap;
        this.wwnMap = wwnMap;
        this.vsans = vsans;
        this.faAutos = faAutos;
        this.addFirst();
    }

    public void addFirst() {
        this.list.setSelectedIndex(0);
    }

    private SnmpKTable createFaTable(SwitchBase sw, List<FlexAtahCfg> cfgs, List<Integer> vsans) {
        AdvancedTableModel.Column[] cols;
        AdvancedTableModel tm = new AdvancedTableModel();
        final SnmpKTable table = new SnmpKTable(tm);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        TableColumnModel tcm = table.getColumnModel();
        for (AdvancedTableModel.Column col : cols = AdvancedTableModel.Column.values()) {
            tcm.getColumn(col.ordinal()).setPreferredWidth(col.getValue() * 10);
        }
        String[] vsanStrs = new String[vsans.size()];
        for (int i = 0; i < vsans.size(); ++i) {
            vsanStrs[i] = vsans.get(i).toString();
        }
        tm.addTableModelListener(this);
        DefaultComboBoxModel<String> vModel = new DefaultComboBoxModel<String>(vsanStrs);
        DefaultCellEditor vEditor = new DefaultCellEditor(new JComboBox<String>(vModel));
        DefaultComboBoxModel<String> faModel = new DefaultComboBoxModel<String>(new String[]{"Auto", "Manual"});
        DefaultComboBoxModel<String> shutModel = new DefaultComboBoxModel<String>(new String[]{"up", "down"});
        FATypeEditor faTypeEditor = new FATypeEditor(faModel, table, AdvancedTableModel.Column.vPWWN.ordinal());
        AdminStatusEditor adminStatusEditor = new AdminStatusEditor(shutModel, table, AdvancedTableModel.Column.Status.ordinal());
        DefaultCellEditor wwnEditor = new DefaultCellEditor(new JTextField()){

            @Override
            public boolean stopCellEditing() {
                if (!table.isEditing()) {
                    return super.stopCellEditing();
                }
                String val = (String)this.getCellEditorValue();
                try {
                    SnmpWWN wwn = new SnmpWWN(val);
                    wwn.toString();
                }
                catch (Exception ex) {
                    table.editingStopped(null);
                    int row = table.getEditingRow();
                    if (row != -1) {
                        table.setRowSelectionInterval(row, row);
                        if (((SnmpWWN)table.getValueAt(row, 1)).toString().equals(val)) {
                            return super.stopCellEditing();
                        }
                    }
                    return false;
                }
                return super.stopCellEditing();
            }
        };
        table.getColumnModel().getColumn(AdvancedTableModel.Column.Vsan.ordinal()).setCellEditor(vEditor);
        table.getColumnModel().getColumn(AdvancedTableModel.Column.FAType.ordinal()).setCellEditor(faTypeEditor);
        table.getColumnModel().getColumn(AdvancedTableModel.Column.Status.ordinal()).setCellEditor(adminStatusEditor);
        table.getColumnModel().getColumn(AdvancedTableModel.Column.vPWWN.ordinal()).setCellEditor(wwnEditor);
        tm.setData(sw, cfgs);
        return table;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (!this.stopCellEditing()) {
            this.list.setSelectedValue(this.current, true);
            return;
        }
        SwitchBase sw = (SwitchBase)this.list.getSelectedValue();
        if (sw == null) {
            this.list.setSelectedIndex(0);
            return;
        }
        if (!this.cardMap.containsKey(sw)) {
            SnmpKTable table = this.createFaTable(sw, this.swMap.get(sw), this.vsans.get(sw));
            AdvTablePanel tPanel = new AdvTablePanel(sw, table, this);
            this.parent.add(sw.getName(), tPanel);
            this.cardMap.put(sw, tPanel);
        }
        this.current = sw;
        this.cards.show(this.parent, sw.getName());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object ob = evt.getSource();
        if (ob instanceof JComboBox) {
            JComboBox combo = (JComboBox)ob;
            SwitchBase sw = (SwitchBase)combo.getSelectedItem();
            return;
        }
        char c = evt.getActionCommand().charAt(0);
        AdvTablePanel tablePanel = this.cardMap.get(this.current);
        SnmpKTable table = tablePanel.getTable();
        AdvancedTableModel model = (AdvancedTableModel)table.getModel();
        switch (c) {
            case 'R': {
                if (!this.stopCellEditing()) break;
                model.setData(this.current, this.swMap.get(this.current));
                break;
            }
            case 'S': {
                if (!this.stopCellEditing()) break;
                int row = model.getRowCount();
                for (int i = 0; i < row; ++i) {
                    int col = AdvancedTableModel.Column.FAType.ordinal();
                    if (!table.isCellEditable(i, col)) continue;
                    table.setValueAt("Auto", i, col);
                }
                model.fireTableDataChanged();
                break;
            }
            case 'F': {
                if (!this.stopCellEditing()) break;
                int[] selected = table.getSelectedRows();
                if (selected.length == 0) {
                    return;
                }
                for (int i = 0; i < selected.length; ++i) {
                    table.setValueAt("Manual", selected[i], AdvancedTableModel.Column.FAType.ordinal());
                    table.setValueAt("00:00:00:00:00:00:00:00", selected[i], AdvancedTableModel.Column.vPWWN.ordinal());
                }
                model.fireTableDataChanged();
                break;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        AdvTablePanel panel = this.cardMap.get(this.current);
        if (panel == null) {
            return;
        }
        SnmpKTable table = panel.getTable();
        if (table == null) {
            return;
        }
        KTableModel model = (KTableModel)table.getModel();
        this.list.revalidate();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        SwitchBase sw;
        if (!(value instanceof SwitchBase)) {
            return this;
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setOpaque(true);
        if (list != null) {
            this.changeList(list, value);
            ListModel model = list.getModel();
            if (model instanceof PListModel) {
                ((PListModel)model).fireContentsChanged(index);
            }
        }
        if ((sw = (SwitchBase)value).getSysName() == null) {
            this.setText(sw.getName());
        } else {
            this.setText(sw.getSysName());
        }
        return this;
    }

    private void updateFont(JList list, SwitchBase sw) {
        AdvTablePanel tablePanel = this.cardMap.get(sw);
        Font font = this.getFont();
        this.setEnabled(list.isEnabled());
        if (tablePanel == null) {
            Font newFont = new Font(font.getName(), 0, font.getSize());
            this.setFont(newFont);
            return;
        }
        if (tablePanel.getTable() == null) {
            return;
        }
        boolean bold = tablePanel.isChanged();
        Font curFont = this.getFont();
        Font newFont = new Font(font.getName(), bold ? 1 : 0, font.getSize());
        this.setFont(newFont);
        this.setOpaque(true);
    }

    private void changeList(JList list, Object value) {
        String val = value.toString();
        this.setText(val);
    }

    public Map<SwitchBase, List<FlexAtahCfg>> getSelection() {
        HashMap<SwitchBase, List<FlexAtahCfg>> retMap = new HashMap<SwitchBase, List<FlexAtahCfg>>();
        Set<SwitchBase> sws = this.cardMap.keySet();
        for (SwitchBase sw : sws) {
            AdvTablePanel tablePanel = this.cardMap.get(sw);
            AdvancedTableModel model = (AdvancedTableModel)tablePanel.getTable().getModel();
            if (!model.isChanged()) continue;
            List<FlexAtahCfg> faList = model.getChangedConfig();
            retMap.put(sw, faList);
        }
        return retMap;
    }

    public boolean stopCellEditing() {
        return this.stopFaCellEditing();
    }

    private boolean stopFaCellEditing() {
        AdvTablePanel panel = this.cardMap.get(this.current);
        if (panel == null) {
            return true;
        }
        SnmpKTable table = panel.getTable();
        TableCellEditor editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.Vsan.ordinal()).getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.Status.ordinal()).getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.FAType.ordinal()).getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.vPWWN.ordinal()).getCellEditor();
        return editor == null || editor.stopCellEditing();
    }

    public boolean isChanged() {
        Set<SwitchBase> sws = this.cardMap.keySet();
        for (SwitchBase sw : sws) {
            AdvTablePanel pane = this.cardMap.get(sw);
            if (!pane.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.stopCellEditing()) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.consume();
    }

    class AdvTablePanel
    extends JPanel
    implements ChangeListener {
        SnmpKTable table;
        SwitchBase sw;
        private JButton allAutoBtn = new JButton("Set All Auto");
        private JButton resetBtn = new JButton("Undo Changes");
        private JButton disableFABtn = new JButton("Disable FlexAttach");

        public AdvTablePanel(SwitchBase sw, SnmpKTable tbl, ActionListener l) {
            this.resetBtn.setActionCommand("Reset");
            this.disableFABtn.setActionCommand("FAOff");
            this.allAutoBtn.setToolTipText(this.allAutoBtn.getText());
            this.resetBtn.setToolTipText(this.resetBtn.getText());
            this.disableFABtn.setToolTipText("Disable FlexAttach on selected Interface(s)");
            this.sw = sw;
            this.table = tbl;
            this.setLayout(new BorderLayout());
            JPanel toolPane = new JPanel(new FlowLayout(0));
            toolPane.add(this.allAutoBtn);
            toolPane.add(this.resetBtn);
            toolPane.add(this.disableFABtn);
            this.allAutoBtn.addActionListener(l);
            this.resetBtn.addActionListener(l);
            this.disableFABtn.addActionListener(l);
            JScrollPane scroller = new JScrollPane(this.table);
            JPanel interfaceTable = new JPanel(new BorderLayout());
            interfaceTable.add((Component)toolPane, "North");
            interfaceTable.add((Component)scroller, "Center");
            this.add(interfaceTable);
        }

        public SnmpKTable getTable() {
            return this.table;
        }

        public boolean isChanged() {
            boolean cfgChanged = ((AdvancedTableModel)this.table.getModel()).isChanged();
            return cfgChanged;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCheckBox faAuto = (JCheckBox)e.getSource();
            boolean sel = faAuto.isSelected();
            ListListener2.this.changeList(ListListener2.this.list, ListListener2.this.list.getSelectedValue());
        }
    }
}

