/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.view;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.sm.client.fa.view.RadioCell;
import com.cisco.dcbu.sm.client.fa.view.ReplaceTableModel;
import java.awt.Component;
import java.util.EventListener;
import java.util.EventObject;
import javax.help.event.EventListenerList;
import javax.swing.DefaultCellEditor;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class RadioTable
extends SnmpKTable {
    private KTableModel model;
    private RadioCell radioRenderer;

    public RadioTable(KTableModel model) {
        super(model);
        ReplaceTableModel.Column[] cols;
        this.model = model;
        this.setSelectionMode(0);
        this.setAutoResizeMode(4);
        this.getSelectionModel().addListSelectionListener(this);
        this.getTableHeader().addMouseListener(new HeaderListener());
        this.setSortable(true);
        this.radioRenderer = new RadioCell();
        this.setDefaultRenderer(JRadioButton.class, new RadioRenderer());
        this.radioRenderer.setHorizontalAlignment(0);
        TableColumnModel tcm = this.getColumnModel();
        for (ReplaceTableModel.Column col : cols = ReplaceTableModel.Column.values()) {
            tcm.getColumn(col.ordinal()).setPreferredWidth(col.size * 10);
        }
        DefaultCellEditor wwnEditor = new DefaultCellEditor(new JTextField()){

            @Override
            public boolean stopCellEditing() {
                if (!RadioTable.this.isEditing()) {
                    return super.stopCellEditing();
                }
                String val = (String)this.getCellEditorValue();
                try {
                    SnmpWWN wwn = new SnmpWWN(val);
                    wwn.toString();
                }
                catch (Exception ex) {
                    RadioTable.this.editingStopped(null);
                    int row = RadioTable.this.getEditingRow();
                    if (row != -1) {
                        RadioTable.this.setRowSelectionInterval(row, row);
                        if (((SnmpWWN)RadioTable.this.getValueAt(row, 1)).toString().equals(val)) {
                            return super.stopCellEditing();
                        }
                    }
                    return false;
                }
                return super.stopCellEditing();
            }
        };
    }

    class RadioEditor
    implements TableCellEditor {
        protected EventListenerList listenerList = new EventListenerList();

        RadioEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            JRadioButton btn = (JRadioButton)value;
            if (!((KTableModel)table.getModel()).isCellActive(row, table.convertColumnIndexToModel(col))) {
                btn.setEnabled(false);
            } else {
                btn.setEnabled(true);
                if (isSelected) {
                    btn.setForeground(table.getSelectionForeground());
                } else {
                    btn.setForeground(table.getForeground());
                }
            }
            if (isSelected) {
                btn.setBackground(table.getSelectionBackground());
            } else {
                btn.setBackground(table.getBackground());
            }
            btn.setHorizontalAlignment(0);
            return btn;
        }

        @Override
        public Object getCellEditorValue() {
            return RadioTable.this.getModel();
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, (EventListener)l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, (EventListener)l);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                ((CellEditorListener)listeners[i + 1]).editingStopped(null);
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                ((CellEditorListener)listeners[i + 1]).editingCanceled(null);
            }
        }
    }

    class RadioRenderer
    implements TableCellRenderer {
        RadioRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JRadioButton btn = (JRadioButton)value;
            if (!((KTableModel)table.getModel()).isCellActive(row, table.convertColumnIndexToModel(col))) {
                btn.setEnabled(false);
            } else {
                btn.setEnabled(true);
                if (isSelected) {
                    btn.setForeground(table.getSelectionForeground());
                } else {
                    btn.setForeground(table.getForeground());
                }
            }
            if (isSelected) {
                btn.setBackground(table.getSelectionBackground());
            } else {
                btn.setBackground(table.getBackground());
            }
            btn.setHorizontalAlignment(0);
            return btn;
        }
    }
}

