/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.wizard;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigFinishPanel;
import com.cisco.dcbu.sm.client.fa.wizard.FAReplaceWizard;
import com.cisco.dcbu.sm.client.fa.wizard.FAWizard;
import com.cisco.dcbu.sm.common.dto.FlexAtahVPWWN;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReplaceAskPWWNStep
extends WizardPanel {
    protected static String WWN_CARD = "WWN Card";
    protected static String FINISH_CARD = "Finish Card";
    protected JPanel wwnPanel = new JPanel();
    protected JPanel mainCard = new JPanel();
    protected CardLayout cardLayout = new CardLayout();
    protected FAPreConfigFinishPanel progress = new FAPreConfigFinishPanel();
    protected JCheckBox removeMapping = new JCheckBox("Allow wizard to change from \"pWWN to vPWWN\" mapping to \"interface to vPWWN\" mapping");
    protected JTextField toWwnTf = new JTextField(40);
    protected FieldPanel fromWwnTf;
    MyMenuButton vpWWNBtn;
    boolean isGlobalVPWWNEmpty;
    protected boolean isMove = false;
    protected JLabel fromWwnLb = new JLabel("Existing flex attach server virtual port WWN to replace: ");
    protected JLabel toWwnLb = new JLabel("New server physical port WWN: ");
    protected static String BRIEF = "Please specify the server port WWN.";
    protected static String TITLE = "Server WWN";

    public ReplaceAskPWWNStep() {
        super(TITLE, BRIEF, FAReplaceWizard.ICON);
        this.init();
    }

    public void init() {
        this.mainCard.setLayout(this.cardLayout);
        this.removeMapping.setSelected(true);
        this.vpWWNBtn = new MyMenuButton(null);
        this.fromWwnTf = new FieldPanel(20, (JComponent)this.vpWWNBtn);
        this.wwnPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.anchor = 21;
        this.wwnPanel.add((Component)this.fromWwnLb, gbc);
        ++gbc.gridy;
        this.wwnPanel.add((Component)this.fromWwnTf, gbc);
        ++gbc.gridy;
        this.wwnPanel.add(Box.createRigidArea(new Dimension(0, 50)), gbc);
        ++gbc.gridy;
        this.wwnPanel.add((Component)this.toWwnLb, gbc);
        ++gbc.gridy;
        this.wwnPanel.add((Component)this.toWwnTf, gbc);
        ++gbc.gridy;
        this.wwnPanel.add(Box.createRigidArea(new Dimension(0, 50)), gbc);
        ++gbc.gridy;
        this.wwnPanel.add((Component)this.removeMapping, gbc);
        this.mainCard.add(WWN_CARD, this.wwnPanel);
        this.mainCard.add(FINISH_CARD, this.progress);
        this.add(this.mainCard);
    }

    @Override
    public boolean refresh() {
        this.setTitle("Step " + (FAReplaceWizard.getInstance().isSamePort() ? "3" : "4") + ":  " + TITLE);
        boolean samePort = FAReplaceWizard.getInstance().isSamePort();
        this.removeMapping.setVisible(!samePort && !this.isGlobalVPWWNEmpty);
        return super.refresh();
    }

    @Override
    public void doFinish() {
        boolean samePort = FAReplaceWizard.getInstance().isSamePort();
        String fromWwn = this.fromWwnTf.getText().trim();
        if ("".equals(fromWwn)) {
            JOptionPane.showMessageDialog(this.getParent(), "WWN is empty.  Please specify a virtual port WWN.", TITLE + ": Virtual Port WWN", 0);
            return;
        }
        try {
            FAClientHelper.checkWwn(fromWwn);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.getParent(), ex.getMessage(), TITLE + ": Virtual Port WWN", 0);
            return;
        }
        if (this.toWwnTf.isVisible()) {
            String toWwn = this.toWwnTf.getText().trim();
            if ("".equals(toWwn)) {
                JOptionPane.showMessageDialog(this.getParent(), "WWN is empty.  Please specify a new physical port WWN.", TITLE + ": New Server Port WWN", 0);
                return;
            }
            try {
                FAClientHelper.checkWwn(toWwn);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getParent(), ex.getMessage(), TITLE + ": New Server Port WWN", 0);
                return;
            }
            if (FAClientHelper.isEqual(fromWwn, toWwn)) {
                JOptionPane.showMessageDialog(this.getParent(), "Real port WWN and virtual port WWN cannot be the same.", TITLE, 0);
                return;
            }
        }
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        this.cardLayout.show(this.mainCard, FINISH_CARD);
        try {
            FAReplaceWizard.getInstance().applyReplace(this.progress);
        }
        catch (Exception ex) {
            FAReplaceWizard.getInstance();
            FAReplaceWizard.logger.error((Object)("Unable to apply configuration: " + ex.getMessage()));
            this.progress.postError(ex.getMessage());
            this.progress.complete();
        }
        super.doFinish();
    }

    @Override
    public void doPrevious() {
        FAReplaceWizard.getInstance().updateStep();
        super.doPrevious();
    }

    @Override
    public void actionFinished(boolean b) {
        if (b) {
            super.actionFinished(b);
        }
        this.getWizard().getNavigator().getCancel().setText("Close");
    }

    public Wwn getVPWWN() {
        return new Wwn(this.fromWwnTf.getText().trim());
    }

    public Wwn getPWWN() {
        return new Wwn(this.toWwnTf.getText().trim());
    }

    public boolean replace() {
        return this.removeMapping.isSelected();
    }

    @Override
    public void doCancel() {
        if (FAWizard.getInstance().isRunningApply()) {
            String msg = "Wizard is applying new settings. Cancelling will stop making further changes but \nwill not roll back already applied configuration. \n\n\n Do you want to continue?";
            int option = JOptionPane.showConfirmDialog(this.getWizard(), msg, "Warning", 2, 3);
            if (option != 0) {
                return;
            }
            FAWizard.getInstance().setCancel(true);
        }
        super.doCancel();
    }

    public void updatePanel(List<FlexAtahVPWWN> globalVPWWN, Wwn interfaceVPWWN) {
        this.fromWwnTf.getField().setText("");
        Wwn[] wwnList = null;
        if (globalVPWWN != null) {
            wwnList = new Wwn[globalVPWWN.size()];
            for (int i = 0; i < globalVPWWN.size(); ++i) {
                wwnList[i] = globalVPWWN.get(i).getSvrVPWWN();
            }
        }
        boolean bl = this.isGlobalVPWWNEmpty = globalVPWWN == null || globalVPWWN.size() == 0;
        if (this.isGlobalVPWWNEmpty) {
            this.vpWWNBtn.setEnabled(false);
            if (interfaceVPWWN != null) {
                String vpwwn = SnmpString.toHexString(interfaceVPWWN.getValue());
                if (vpwwn.indexOf(" ") != -1) {
                    vpwwn = vpwwn.substring(vpwwn.indexOf(" "));
                }
                this.fromWwnTf.getField().setText(vpwwn);
            }
        } else {
            this.vpWWNBtn.setEnabled(true);
            Object[] wwnString = new String[wwnList.length];
            for (int k = 0; k < wwnList.length; ++k) {
                wwnString[k] = SnmpString.toHexString(wwnList[k].getValue());
            }
            this.vpWWNBtn.buildMenu(wwnString);
        }
        this.fromWwnTf.getField().setEditable(!this.isGlobalVPWWNEmpty);
        this.fromWwnTf.getField().setEnabled(!this.isGlobalVPWWNEmpty);
        this.removeMapping.setVisible(!this.isMove && !this.isGlobalVPWWNEmpty);
        this.toWwnLb.setVisible(!this.isMove && !this.isGlobalVPWWNEmpty);
        this.toWwnTf.setVisible(!this.isMove && !this.isGlobalVPWWNEmpty);
    }

    class MyMenuButton
    extends MenuButton {
        public MyMenuButton(Object[] items) {
            super((JMenu)null);
            this._menu = this.buildMenu(items);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                if (this.getParent() instanceof FieldPanel) {
                    String vpwwn = ((JMenuItem)e.getSource()).getText();
                    if (vpwwn.indexOf(" ") != -1) {
                        vpwwn = vpwwn.substring(vpwwn.indexOf(" "));
                    }
                    ((FieldPanel)this.getParent()).setText(vpwwn);
                }
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

