/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.CheckMethods;
import com.cisco.dcbu.sm.client.fc.FabricChecker;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Component;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

class CheckThread
extends Thread {
    static final String _softwareVersion = "swver";
    FabricChecker _window;
    SnmpPeer _peer;
    Array _data;
    Array _optionsData;
    boolean _isStopped;
    Object _pOut;

    public CheckThread(FabricChecker window, SnmpPeer peer, Array data, Array optionsData, Object pout) {
        this._window = window;
        this._peer = peer;
        this._data = data;
        this._optionsData = optionsData;
        this._pOut = pout;
    }

    @Override
    public void run() {
        block7: {
            try {
                this.doIt();
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this._window, this._peer + ": " + ex.getMessage());
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this._window, ex);
                if (!SnmpSession.isTrace()) break block7;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (null != this._data) {
            if (this._data.size() == 0) {
                this._window._status.setText("No Issues. " + new Date());
            } else {
                this._window._status.setText(this._data.size() + " discrepancies found. " + new Date());
            }
        } else {
            this._window._status.setText(" ");
        }
        this._window._model.fireTableDataChanged();
        Dimension d = this._window._table.calcPreferredSize();
        this._window._sp.setPreferredSize(d);
        this._window._table.getTableHeader().resizeAndRepaint();
        this._window._buttons[0].setText(FabricChecker._BLabels[0]);
    }

    public void doIt() throws Exception {
        try {
            this.fetchPeerData(this._peer, this._data, this._optionsData);
        }
        catch (InvocationTargetException ex) {
            Exception realEx = (Exception)ex.getTargetException();
            if (realEx == null) {
                realEx = ex;
            }
            throw realEx;
        }
    }

    public void cancel() {
        this._isStopped = true;
        this._window._status.setText("Stopping...");
    }

    void fetchPeerData(SnmpPeer peer, Array data, Array optionsData) throws Exception {
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        Array<SnmpPeer> peers = new Array<SnmpPeer>();
        for (int i = 0; i < this._window._peers.length; ++i) {
            if (peer == this._window._peers[i] && this._pOut == null || this._window._peers[i] == null) continue;
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(this._window._peers[i].getAddress());
            if (sw == null || !sw.isManageable()) continue;
            peers.addElement(this._window._peers[i]);
        }
        if (peers.size() == 0) {
            Util.errorMessage((Component)this._window, "There are no manageable switches to compare.");
        }
        Document xmlDoc = null;
        Element elm = null;
        if (this._data == null) {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            xmlDoc = builder.newDocument();
            elm = xmlDoc.createElement("switch-" + peer.toString());
            elm.setAttribute("ver", "6.3(1)");
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (null != sw) {
                elm.setAttribute(_softwareVersion, sw.getVersion());
            } else {
                elm.setAttribute(_softwareVersion, "");
            }
            xmlDoc.appendChild(elm);
        } else if (null != this._pOut) {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            xmlDoc = builder.parse((InputStream)this._pOut);
            xmlDoc.getDocumentElement().normalize();
            elm = (Element)xmlDoc.getFirstChild();
            if (!elm.getAttribute("ver").equals("6.3(1)")) {
                throw new Exception("The policy file version " + elm.getAttribute("ver") + "\ndoes not match current software version " + "6.3(1)");
            }
            peers.addElement(peer);
        }
        HashMap<String, Method> methodsByName = new HashMap<String, Method>();
        Method[] methods = CheckMethods.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            methodsByName.put(methods[i].getName(), methods[i]);
        }
        boolean[] checks = new boolean[3];
        for (int i = 0; i < optionsData.size() && !this._isStopped; ++i) {
            block20: {
                String name;
                block19: {
                    Object[] row = (Object[])optionsData.elementAt(i);
                    name = (String)row[0];
                    checks[0] = row[1] == null ? false : (Boolean)row[1];
                    checks[1] = row[2] == null ? false : (Boolean)row[2];
                    checks[2] = row[3] == null ? false : (Boolean)row[3];
                    if (checks[0]) break block19;
                    if (checks[1]) break block19;
                    if (!checks[2]) break block20;
                }
                this._window._status.setText("Checking " + name);
                Method m = (Method)methodsByName.get(name);
                if (m != null) {
                    Object[] args = new Object[]{peer, checks, peers, data, elm, name};
                    m.invoke(CheckMethods.class, args);
                }
                this._window._model.fireTableDataChanged();
            }
            if (peers.size() == 0) break;
        }
        if (this._data == null) {
            if (null != this._pOut) {
                CheckThread.writeDocument(xmlDoc, (OutputStream)this._pOut);
                ((OutputStream)this._pOut).close();
            }
        } else if (null != this._pOut) {
            ((InputStream)this._pOut).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, OutputStream outputStream) throws TransformerConfigurationException, TransformerException {
        if (document == null) {
            throw new IllegalArgumentException("illegal usage of DocumentHelper::writeDocument(), parameter document may not be null");
        }
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputStream);
        try {
            CheckThread.getTransformer(document.getDoctype()).transform(source, result);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    protected static Transformer getTransformer(DocumentType documentType) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        if (documentType != null) {
            if (documentType.getPublicId() != null) {
                transformer.setOutputProperty("doctype-public", documentType.getPublicId());
            }
            if (documentType.getSystemId() != null) {
                transformer.setOutputProperty("doctype-system", documentType.getSystemId());
            }
        }
        return transformer;
    }
}

