/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.wizard;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.fcoe.FCoEConfigurationPanel;
import com.cisco.dcbu.lib.ui.fcoe.FCoEConfigurationTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigCommandsIf;
import com.cisco.dcbu.sm.client.fcoe.wizard.FCoEConfigurationWizard;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ConfigureEthernetInterfacesPanel
extends WizardPanel
implements TableModelListener {
    private static final long serialVersionUID = 5624281884788576263L;
    protected FCoEConfigurationPanel tablePanel;
    protected FCoEConfigurationTableModel tableModel;
    protected JPanel mainPanel;
    private Switch selectedSwitch;
    private JButton finishButton;
    protected JLabel selSwitchLbl;
    private FCoEConfigCommandsIf fcoeCmdObj;
    protected static String _panelName = new String("Step 4 of 4: Configure Ethernet Interfaces");
    protected static String _panelDesc = new String("Create and bind virtual FC interfaces to the ethernet interfaces/channels. Configure the appropriate virtual FC interfaces and ethernet interfaces/channels. Apply FCoE changes to the switch.");

    public ConfigureEthernetInterfacesPanel(JWizard wizard, String panelName, String panelDesc) {
        super(panelName, panelDesc, wizard, FCoEConfigurationWizard._ImageFcoe);
        this.initializePanel();
    }

    public ConfigureEthernetInterfacesPanel(JWizard wizard) {
        super(_panelName, _panelDesc, wizard, FCoEConfigurationWizard._ImageFcoe);
        this.initializePanel();
    }

    private void initializePanel() {
        this.mainPanel = new JPanel();
        this.add((Component)this.mainPanel, "Center");
        this.finishButton = this.getWizard().getNavigator().getNextBtn();
    }

    protected JPanel createSummaryPanel(Switch selectedSwitch) {
        JPanel panel = new JPanel(new FlowLayout(0));
        JLabel lbl = new JLabel("Selected Switch: ");
        panel.add(lbl);
        this.selSwitchLbl = new JLabel(selectedSwitch.toString());
        Font lblFont = this.selSwitchLbl.getFont().deriveFont(1);
        this.selSwitchLbl.setFont(lblFont);
        panel.add(this.selSwitchLbl);
        return panel;
    }

    public JPanel createFCoEConfigurationPanel(TreeMap<Integer, Integer> activeVlanVsans, TreeMap<Integer, Integer> selectedVlanVsan, Switch selectedSwitch) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createSummaryPanel(selectedSwitch), "North");
        this.tablePanel = new FCoEConfigurationPanel(activeVlanVsans, selectedVlanVsan, selectedSwitch, BrowserFrame.getInstance(), selectedSwitch.getPeer(), true, false, this.fcoeCmdObj, selectedSwitch.isNpvEnabled());
        panel.add((Component)this.tablePanel, "Center");
        this.tableModel = (FCoEConfigurationTableModel)this.tablePanel.getTable().getModel();
        this.tableModel.addTableModelListener(this);
        return panel;
    }

    private Runnable getTableDataThread() {
        return new Runnable(){

            @Override
            public void run() {
                Util.setBusy(true, ConfigureEthernetInterfacesPanel.this.mainPanel);
                ConfigureEthernetInterfacesPanel.this.tableModel.refresh();
                if (ConfigureEthernetInterfacesPanel.this.tableModel.getFilteredData().size() == 0) {
                    ConfigureEthernetInterfacesPanel.this.getWizard().getNavigator().getNextBtn().setEnabled(false);
                }
                Util.setBusy(false, ConfigureEthernetInterfacesPanel.this.mainPanel);
            }
        };
    }

    @Override
    public boolean refresh() {
        this.selectedSwitch = (Switch)this.getModelValue("SELECTED_FCOE_SWITCH");
        this.fcoeCmdObj = (FCoEConfigCommandsIf)this.getModelValue("fcoeCmdObj");
        TreeMap activeVlanVsans = (TreeMap)this.getModelValue("Active VLAN VSAN Mappings");
        TreeMap selectedVlanVsan = (TreeMap)this.getModelValue("Selected VLAN VSAN Mapping");
        if (this.selectedSwitch != null && activeVlanVsans != null && activeVlanVsans.size() > 0) {
            this.remove(this.mainPanel);
            this.mainPanel = this.createFCoEConfigurationPanel(activeVlanVsans, selectedVlanVsan, this.selectedSwitch);
            this.add((Component)this.mainPanel, "Center");
            this.repaint();
            SwingUtilities.invokeLater(this.getTableDataThread());
        }
        return true;
    }

    @Override
    public void setDataValid(boolean b) {
        super.setDataValid(b);
    }

    @Override
    public void doFinish() {
        if (this.tablePanel != null && this.tablePanel.startConfiguration()) {
            super.doFinish();
            this.getWizard().getNavigator().setCancelButton("Close");
        } else if (this.tablePanel == null) {
            super.doFinish();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.finishButton.isEnabled()) {
            Boolean obj;
            boolean colValue;
            int row;
            Object value;
            if (e != null && e.getColumn() == -1) {
                if (this.tableModel.getFilteredData().size() > 0) {
                    this.finishButton.setEnabled(true);
                }
                this.getWizard().getNavigator().setCancelButton("Cancel");
            } else if (e != null && e.getColumn() == this.tableModel.VFC_COLUMN && (value = this.tableModel.getValueAt(row = e.getFirstRow(), e.getColumn())) instanceof Boolean && (colValue = (obj = (Boolean)value).booleanValue())) {
                if (this.tableModel.getFilteredData().size() > 0) {
                    this.finishButton.setEnabled(true);
                }
                this.getWizard().getNavigator().setCancelButton("Cancel");
            }
        } else if (this.tableModel.getFilteredData().size() == 0) {
            this.finishButton.setEnabled(false);
        }
    }
}

