/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.IntProperties;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.ContextController;
import com.cisco.dcbu.sm.client.gui.FatalDiscoveryException;
import com.cisco.dcbu.sm.client.gui.NewOpenDialogIf;
import com.cisco.dcbu.sm.client.gui.OpenFabricThread;
import com.cisco.dcbu.sm.client.gui.OpenLanThread;
import com.cisco.dcbu.sm.client.gui.OpenThreadIf;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.LanBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.licmgr.LicenseCapabilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AddFabricDialog
extends JDialog
implements ActionListener,
ChangeListener,
ItemListener {
    static final String FABRIC_HISTORY_FILENAME = "smlastopen_3_2.properties";
    static final String FABRIC_CDP_HISTORY_FILENAME = "cdp_smlastopen_3_2.properties";
    static final int MAX_HISTORY = 30;
    protected static final int LAN_NAME = 0;
    protected static final int LAN_STATUS = 1;
    protected static final int SEED_SWITCH = 2;
    protected static final int SNMP_V3 = 3;
    protected static final int SNMP_V3_PARAMS = 4;
    protected static final int USERNAME = 5;
    protected static final int PASSWORD = 6;
    protected static final int COMMUNITY = 7;
    public static final int SERVER = 8;
    private final String[] _inputLabels = new String[]{"LAN Name:", "LAN Status:", "Seed Switch:", "Use SNMPv3:", "Auth-Privacy:", "User Name:", "Password:", "Community:", "Server:"};
    private JLabel[] _labels;
    protected JComponent[] _inputs;
    JButton _discButton;
    private JButton _cancelButton;
    private JButton _options;
    private NewOpenDialogIf _openDialog;
    JLabel _statusLabel = new JLabel("");
    private Vector _fabricHistory;
    private Vector _cdpFabricHistory;
    private DefaultComboBoxModel _fcHistoryCBModel;
    private DefaultComboBoxModel _cdpHistoryCBModel;
    private List<String> _serverIpList;
    Dimension _preferredSize = null;
    OpenThreadIf _discoverThread = null;
    private Logger _logger = Logger.getLogger(this.getClass());
    private String _host = null;
    private JPanel radioPanel = new JPanel();
    private JLabel radioLabel = new JLabel("Discovery Mode:");
    private JRadioButton cdpDiscRadio = new JRadioButton("Ethernet (CDP)");
    private JRadioButton fcDiscRadio = new JRadioButton("Fibre Channel");
    private ButtonGroup discButtonGroup = new ButtonGroup();
    private JLabel limitCDPLabel = new JLabel("Limit Discovery by:");
    private JLabel maxHopsLabel = new JLabel("Max Hops:");
    private FieldPanel maxHopsField = new FieldPanel(4, 3, 0, 20);
    private JRadioButton subnetRadioButton = new JRadioButton("Subnet:");
    private KTextField subnetTextField = new KTextField(20);
    private JLabel maskLabel = new JLabel("Mask:");
    private KTextField maskTextField = new KTextField(25);
    private JRadioButton ipRangeRadioButton = new JRadioButton("IP Range:");
    private KTextField ipRangeTextField = new KTextField(40);
    private JRadioButton nonRadioButton = new JRadioButton("None");
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton includedVsansRadioButton = new JRadioButton("Included VSAN List:");
    private JRadioButton excludedVsansRadioButton = new JRadioButton("Excluded VSAN List:");
    private KTextField includedVsansTextField = new KTextField(40);
    private KTextField excludedVsansTextField = new KTextField(40);
    private ButtonGroup vsanButtonGroup = new ButtonGroup();
    private boolean _wantCreateMode = true;
    private boolean _wantCDPDiscovery = false;
    private CdpSeedBase _selectedCdpSeedBase = null;
    private LanPK _selectedLanPK = null;
    private boolean _showOptions;
    private Dimension _cdpOptionsShownPreferredSize = new Dimension(410, 440);
    private Dimension _fcOptionsShownPreferredSize = new Dimension(410, 400);
    private Dimension _noOptionsShownPreferredSize = new Dimension(410, 330);
    private ClientContext _clientContext;

    public AddFabricDialog(JFrame openDialog, boolean wantCreateMode, boolean wantCDPDiscovery) {
        super((Frame)openDialog, "Discover");
        this._openDialog = (NewOpenDialogIf)((Object)openDialog);
        this._wantCreateMode = wantCreateMode;
        this._wantCDPDiscovery = wantCDPDiscovery;
        this.buildGUI();
        this.onStateChanged();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(openDialog);
    }

    public AddFabricDialog(JDialog openDialog, boolean wantCreateMode, boolean wantCDPDiscovery) {
        super((Dialog)openDialog, "Discover - DCNM-SAN");
        this._openDialog = (NewOpenDialogIf)((Object)openDialog);
        this._wantCreateMode = wantCreateMode;
        this._wantCDPDiscovery = wantCDPDiscovery;
        this.buildGUI();
        this.onStateChanged();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(openDialog);
    }

    public void setCdpSeedBase(LanPK lanPK, CdpSeedBase cdpSeedBase) {
        if (lanPK == null || cdpSeedBase == null) {
            return;
        }
        this._selectedCdpSeedBase = cdpSeedBase;
        this._selectedLanPK = lanPK;
        this.nonRadioButton.setSelected(true);
        this.setSeedIp(this._selectedCdpSeedBase.getSeedIp(), true);
        SnmpUserOpt snmpUserOpt = this._selectedCdpSeedBase.getSnmpUserOpt();
        if (snmpUserOpt != null) {
            this.setUsername(snmpUserOpt.getUsername());
            this.setSnmpV3(snmpUserOpt.isV3());
            if (snmpUserOpt.isV3()) {
                if (snmpUserOpt.getPassword() == null) {
                    this.setPassword(null);
                } else {
                    this.setPassword(snmpUserOpt.getPassword().toCharArray());
                }
            } else if (snmpUserOpt.getCommunity() == null) {
                this.setCommunity(null);
            } else {
                this.setCommunity(snmpUserOpt.getCommunity());
            }
            this.setSnmpV3Param(snmpUserOpt.getSnmpV3Security());
        }
        this.setMaxHops(this._selectedCdpSeedBase.getMaxHop());
        this.setSubnet(this._selectedCdpSeedBase.getSubnetStr(), this._selectedCdpSeedBase.getMaskStr());
        this.setIpRange(this._selectedCdpSeedBase.getIpRangeStr());
        this.cdpDiscRadio.setSelected(true);
        try {
            this.setLanName(lanPK.getName());
            boolean isManaged = ClientController.getInstance().isLanManaged(lanPK);
            if (isManaged) {
                ((JComboBox)this._inputs[1]).setModel(new DefaultComboBoxModel<String>(new String[]{"Managed", "Unmanage"}));
                this.setLanStatus("Managed");
            } else {
                ((JComboBox)this._inputs[1]).setModel(new DefaultComboBoxModel<String>(new String[]{"Unmanaged", "Manage"}));
                this.setLanStatus("Unmanaged");
            }
        }
        catch (Exception ex) {
            this._logger.warn((Object)("Failed to set CDP seed for LAN:" + lanPK + " seed:" + cdpSeedBase), (Throwable)ex);
        }
    }

    private String getLanStatus() throws Exception {
        String lanStatus = (String)((JComboBox)this._inputs[1]).getSelectedItem();
        if (lanStatus == null || lanStatus.length() == 0) {
            throw new Exception("Please select LAN status");
        }
        return lanStatus;
    }

    private void setLanStatus(String lanStatus) {
        ((JComboBox)this._inputs[1]).setSelectedItem(lanStatus);
    }

    private String getLanName() throws Exception {
        String lanName = ((JTextField)this._inputs[0]).getText().trim();
        if (lanName == null || lanName.length() == 0) {
            throw new Exception("Please enter LAN name");
        }
        return lanName;
    }

    private void setLanName(String lanName) {
        if (lanName == null) {
            ((JTextField)this._inputs[0]).setText("");
        } else {
            ((JTextField)this._inputs[0]).setText(lanName);
        }
    }

    public CdpSeedBase getCdpSeedBase() throws Exception {
        CdpSeedBase newCdpSeedBase = this._selectedCdpSeedBase.clone();
        SnmpUserOpt snmpUserOpt = new SnmpUserOpt();
        snmpUserOpt.setV3(this.isSnmpV3());
        if (this.isSnmpV3()) {
            snmpUserOpt.setAuthProtocol(this.getSnmpV3Param());
            snmpUserOpt.setUsername(this.getUsername());
            snmpUserOpt.setPassword(new String(this.getPassword()));
        } else {
            snmpUserOpt.setCommunity(this.getCommunity());
        }
        snmpUserOpt.setSnmpV3Security(this.getSnmpV3Param());
        newCdpSeedBase.setSnmpUserOpt(snmpUserOpt);
        newCdpSeedBase.setMaxHop(this.getMaxHops());
        return newCdpSeedBase;
    }

    private boolean isChanged(String first, String second) {
        if (!(first != null && first.length() != 0 || second != null && second.length() != 0)) {
            return false;
        }
        if (first == null || second == null) {
            return true;
        }
        return !first.equals(second);
    }

    private boolean isChanged(int first, int second) {
        return first != second;
    }

    private boolean isChanged(boolean first, boolean second) {
        return first != second;
    }

    private boolean isChanged(CdpSeedBase first, CdpSeedBase second) {
        if (first == null && second == null) {
            return false;
        }
        if (first == null || second == null) {
            return true;
        }
        if (first.getSnmpUserOpt() == null && second.getSnmpUserOpt() != null) {
            return true;
        }
        if (first.getSnmpUserOpt() != null && second.getSnmpUserOpt() != null) {
            if (this.isChanged(first.getSnmpUserOpt().isV3(), second.getSnmpUserOpt().isV3())) {
                return true;
            }
            if (this.isChanged(first.getSnmpUserOpt().getUsername(), second.getSnmpUserOpt().getUsername())) {
                return true;
            }
            if (this.isChanged(first.getSnmpUserOpt().getPassword(), second.getSnmpUserOpt().getPassword())) {
                return true;
            }
            if (this.isChanged(first.getSnmpUserOpt().getCommunity(), second.getSnmpUserOpt().getCommunity())) {
                return true;
            }
            if (this.isChanged(first.getSnmpUserOpt().getSnmpV3Security(), second.getSnmpUserOpt().getSnmpV3Security())) {
                return true;
            }
            if (this.isChanged(first.getMaxHop(), second.getMaxHop())) {
                return true;
            }
            if (this.isChanged(first.getSubnetStr(), second.getSubnetStr())) {
                return true;
            }
            if (this.isChanged(first.getMaskStr(), second.getMaskStr())) {
                return true;
            }
            if (this.isChanged(first.getIpRangeStr(), second.getIpRangeStr())) {
                return true;
            }
        }
        return false;
    }

    private JPanel buildOptions() {
        this.buttonGroup.add(this.subnetRadioButton);
        this.buttonGroup.add(this.ipRangeRadioButton);
        this.buttonGroup.add(this.nonRadioButton);
        this.subnetRadioButton.addActionListener(this);
        this.ipRangeRadioButton.addActionListener(this);
        this.nonRadioButton.addActionListener(this);
        this.nonRadioButton.doClick();
        this.vsanButtonGroup.add(this.includedVsansRadioButton);
        this.vsanButtonGroup.add(this.excludedVsansRadioButton);
        this.includedVsansRadioButton.addActionListener(this);
        this.excludedVsansRadioButton.addActionListener(this);
        this.excludedVsansRadioButton.doClick();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 7, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.limitCDPLabel, gbc);
        gbc.insets = new Insets(1, 25, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.maxHopsLabel, gbc);
        gbc.insets = new Insets(1, 1, 1, 2);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.maxHopsField, gbc);
        gbc.insets = new Insets(1, 20, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.subnetRadioButton, gbc);
        gbc.insets = new Insets(1, 1, 1, 2);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)this.subnetTextField, gbc);
        gbc.insets = new Insets(1, 1, 1, 2);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.maskLabel, gbc);
        gbc.insets = new Insets(1, 1, 1, 2);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.5;
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)this.maskTextField, gbc);
        gbc.insets = new Insets(1, 20, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.ipRangeRadioButton, gbc);
        gbc.insets = new Insets(1, 1, 1, 2);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)this.ipRangeTextField, gbc);
        gbc.insets = new Insets(1, 20, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.nonRadioButton, gbc);
        gbc.insets = new Insets(1, 20, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.includedVsansRadioButton, gbc);
        gbc.insets = new Insets(1, 1, 1, 2);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)this.includedVsansTextField, gbc);
        gbc.insets = new Insets(1, 20, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.excludedVsansRadioButton, gbc);
        gbc.insets = new Insets(1, 1, 1, 2);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)this.excludedVsansTextField, gbc);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildGUI() {
        JPanel inputPanel;
        this._showOptions = false;
        this._preferredSize = this._noOptionsShownPreferredSize;
        this._inputs = new JComponent[this._inputLabels.length];
        String useSNMPv3 = "";
        String authPrivacy = "";
        try {
            useSNMPv3 = ClientController.getInstance().assertSession().getServerProperty("client.discover.useSNMPv3");
            authPrivacy = ClientController.getInstance().assertSession().getServerProperty("client.discover.AuthPrivacy");
        }
        catch (RemoteException e) {
            this._logger.error((Object)e);
        }
        catch (Exception e) {
            this._logger.error((Object)e);
        }
        IntProperties intProperties = new IntProperties(ClientController.getInstance().loadPropertiesFromServer(FABRIC_HISTORY_FILENAME, false));
        this._fabricHistory = intProperties.getVector();
        if (this._fabricHistory == null) {
            this._fabricHistory = new Vector();
        }
        this._fcHistoryCBModel = new DefaultComboBoxModel(this._fabricHistory);
        intProperties = new IntProperties(ClientController.getInstance().loadPropertiesFromServer(FABRIC_CDP_HISTORY_FILENAME, false));
        this._cdpFabricHistory = intProperties.getVector();
        if (this._cdpFabricHistory == null) {
            this._cdpFabricHistory = new Vector();
        }
        this._cdpHistoryCBModel = new DefaultComboBoxModel(this._cdpFabricHistory);
        JComboBox<String> lanStatus = new JComboBox<String>(new String[]{"Managed", "Unmanaged"});
        lanStatus.setEditable(false);
        this._inputs[0] = new KTextField("");
        this._inputs[1] = lanStatus;
        JComboBox seeds = new JComboBox(this._fcHistoryCBModel);
        seeds.setEditable(true);
        this._inputs[2] = seeds;
        this._inputs[5] = new KTextField(ClientController.getInstance().getLoginDialogUserName());
        this._inputs[6] = new JPasswordField("");
        this._inputs[7] = new JPasswordField("");
        this._serverIpList = ClientController.getInstance().getActiveServerNodes();
        if (this._serverIpList == null) {
            this._serverIpList = new ArrayList<String>();
        }
        this._inputs[8] = new JComboBox<Object>(this._serverIpList.toArray());
        JCheckBox checkBox = new JCheckBox("", true);
        boolean isSnmpV3Only = false;
        try {
            String v3OnlyStr = ClientController.getInstance().assertSession().getServerProperty("snmp.v3only");
            if (v3OnlyStr != null && (isSnmpV3Only = Boolean.parseBoolean(v3OnlyStr))) {
                checkBox.setSelected(true);
                checkBox.setEnabled(false);
            }
        }
        catch (Exception e) {
            Util.errorMessage((Component)this, e);
        }
        this._inputs[3] = checkBox;
        JComboBox<String> comboBox = null;
        this._inputs[4] = comboBox = new JComboBox<String>(SnmpUserOpt.SNMP_V3_PARAMS);
        this._inputs[4].setMinimumSize(new Dimension(70, 20));
        if (useSNMPv3 != null && useSNMPv3.equalsIgnoreCase("true")) {
            checkBox.setSelected(true);
        } else if (useSNMPv3 != null && useSNMPv3.equalsIgnoreCase("false")) {
            checkBox.setSelected(false);
        }
        checkBox.addChangeListener(this);
        if (authPrivacy != null && authPrivacy.length() > 0) {
            comboBox.setSelectedItem(authPrivacy);
        }
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        this.radioPanel.add(this.fcDiscRadio);
        this.radioPanel.add(this.cdpDiscRadio);
        this.discButtonGroup.add(this.cdpDiscRadio);
        this.discButtonGroup.add(this.fcDiscRadio);
        this.cdpDiscRadio.setSelected(false);
        this.cdpDiscRadio.addItemListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        if (ClientController.showCDP()) {
            inputPanel = DialogUtil.buildPanel(new Component[]{this.radioLabel, this.radioPanel}, new int[][]{{0, 0}, {1, 0}}, 17);
            gbc.gridy = 1;
            gbc.gridx = 1;
            gbc.insets = DialogUtil.getInsets();
        } else {
            inputPanel = new JPanel(new GridBagLayout());
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.insets = DialogUtil.getInsets();
        }
        int gridyBeforeLabelAdding = gbc.gridy;
        this._labels = DialogUtil.buildLabels(this._inputLabels);
        gbc.gridwidth = 1;
        DialogUtil.buildPanel(gbc, inputPanel, this._labels, this._inputs);
        gbc.gridx = 1;
        gbc.gridy = gridyBeforeLabelAdding + 3;
        DialogUtil.extend(gbc, inputPanel, this._inputs[2]);
        if (isSnmpV3Only) {
            this._labels[3].setVisible(false);
            this._inputs[3].setVisible(false);
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        if (this._wantCreateMode) {
            this._discButton = new JButton("Discover");
            this._cancelButton = new JButton("Close");
        } else {
            this._discButton = new JButton("Apply");
            this._cancelButton = new JButton("Cancel");
        }
        this._options = new JButton("Options>>");
        this._options.setActionCommand("Options");
        this._discButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        this._options.addActionListener(this);
        buttonPanel.add(this._discButton);
        buttonPanel.add(this._options);
        buttonPanel.add(this._cancelButton);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)inputPanel, "Center");
        centerPanel.add((Component)this.buildOptions(), "South");
        this.showOptions(this._showOptions);
        main.add((Component)centerPanel, "Center");
        main.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)main, "Center");
        this._statusLabel.setOpaque(false);
        this.getContentPane().add((Component)this._statusLabel, "South");
        this.getRootPane().setDefaultButton(this._discButton);
        if (this._serverIpList == null || this._serverIpList.size() < 2) {
            this._labels[8].setVisible(false);
            this._inputs[8].setVisible(false);
        }
        if (this._wantCDPDiscovery) {
            this.cdpDiscRadio.doClick();
        } else {
            this.fcDiscRadio.doClick();
        }
        if (!this._wantCreateMode) {
            this._inputs[2].setEnabled(false);
            this._inputs[8].setEnabled(false);
            this.cdpDiscRadio.setEnabled(false);
            this.fcDiscRadio.setEnabled(false);
        }
        this.setVisibleDiscoveryMode(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.onStateChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.onStateChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String cmd = e.getActionCommand();
            char ch = cmd.charAt(0);
            if (ch == 'C') {
                this.onClose();
            } else if (ch == 'D') {
                if (!ClientController.isServerAlive()) {
                    this.setVisible(false);
                    ClientController.getInstance().closeOnEmpty();
                } else {
                    this._discButton.setEnabled(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AddFabricDialog.this.onDiscover();
                        }
                    });
                }
            } else if (ch == 'A') {
                this.onApply();
            } else if (ch == 'S') {
                this.subnetTextField.setEnabled(true);
                this.maskTextField.setEnabled(true);
                this.ipRangeTextField.setEnabled(false);
            } else if (cmd.startsWith("IP")) {
                this.subnetTextField.setEnabled(false);
                this.maskTextField.setEnabled(false);
                this.ipRangeTextField.setEnabled(true);
            } else if (ch == 'N') {
                this.subnetTextField.setEnabled(false);
                this.maskTextField.setEnabled(false);
                this.ipRangeTextField.setEnabled(false);
            } else if (cmd.startsWith("Include")) {
                this.includedVsansTextField.setEnabled(true);
                this.excludedVsansTextField.setEnabled(false);
            } else if (ch == 'E') {
                this.includedVsansTextField.setEnabled(false);
                this.excludedVsansTextField.setEnabled(true);
            } else if (ch == 'O') {
                this._showOptions = !this._showOptions;
                this.showOptions(this._showOptions);
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private void showOptions(boolean show) {
        boolean cdpVisiblity = this.cdpDiscRadio.isSelected() && show;
        boolean vsanScopeVisibility = !this.cdpDiscRadio.isSelected() && show;
        this.limitCDPLabel.setVisible(show);
        this.maxHopsLabel.setVisible(cdpVisiblity);
        this.maxHopsField.setVisible(cdpVisiblity);
        this.subnetRadioButton.setVisible(cdpVisiblity);
        this.subnetTextField.setVisible(cdpVisiblity);
        this.maskLabel.setVisible(cdpVisiblity);
        this.maskTextField.setVisible(cdpVisiblity);
        this.ipRangeRadioButton.setVisible(cdpVisiblity);
        this.ipRangeTextField.setVisible(cdpVisiblity);
        this.nonRadioButton.setVisible(cdpVisiblity);
        this.includedVsansRadioButton.setVisible(vsanScopeVisibility);
        this.includedVsansTextField.setVisible(vsanScopeVisibility);
        this.excludedVsansRadioButton.setVisible(vsanScopeVisibility);
        this.excludedVsansTextField.setVisible(vsanScopeVisibility);
        this._showOptions = show;
        if (this._showOptions) {
            this._preferredSize = cdpVisiblity ? this._cdpOptionsShownPreferredSize : this._fcOptionsShownPreferredSize;
            this._options.setText("<< Options");
        } else {
            this._preferredSize = this._noOptionsShownPreferredSize;
            this._options.setText("Options >>");
        }
        this.pack();
    }

    private void onStateChanged() {
        if (((JCheckBox)this._inputs[3]).isSelected()) {
            this._labels[5].setVisible(true);
            this._labels[6].setVisible(true);
            this._labels[7].setVisible(false);
            this._inputs[5].setVisible(true);
            this._inputs[6].setVisible(true);
            this._inputs[7].setVisible(false);
            this._labels[4].setVisible(true);
            this._inputs[4].setVisible(true);
        } else {
            this._labels[5].setVisible(false);
            this._labels[6].setVisible(false);
            this._labels[7].setVisible(true);
            this._inputs[5].setVisible(false);
            this._inputs[6].setVisible(false);
            this._inputs[7].setVisible(true);
            this._labels[4].setVisible(false);
            this._inputs[4].setVisible(false);
        }
        if (this.isCDP()) {
            ((JComboBox)this._inputs[2]).setModel(this._cdpHistoryCBModel);
            this._labels[0].setVisible(!this._wantCreateMode);
            this._inputs[0].setVisible(!this._wantCreateMode);
            this._labels[1].setVisible(!this._wantCreateMode);
            this._inputs[1].setVisible(!this._wantCreateMode);
        } else {
            ((JComboBox)this._inputs[2]).setModel(this._fcHistoryCBModel);
            this._labels[0].setVisible(false);
            this._inputs[0].setVisible(false);
            this._labels[1].setVisible(false);
            this._inputs[1].setVisible(false);
        }
        if (this._serverIpList != null && this._serverIpList.size() > 1) {
            this._labels[8].setVisible(true);
            this._inputs[8].setVisible(true);
        } else {
            this._inputs[8].setVisible(false);
            this._labels[8].setVisible(false);
        }
        this.showOptions(this._showOptions);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onApply() {
        boolean changeApplied = false;
        try {
            CdpSeedBase cdpSeedBase = this.getCdpSeedBase();
            String lanName = this.getLanName();
            if (!lanName.equalsIgnoreCase(this._selectedLanPK.getName())) {
                ClientController.getInstance().setLanName(this._selectedLanPK, lanName);
            }
            String lanStatus = this.getLanStatus();
            boolean isManaged = ClientController.getInstance().isLanManaged(this._selectedLanPK);
            if (isManaged) {
                if (lanStatus.startsWith("Unmanage")) {
                    ClientController.getInstance().closeLan(this._selectedLanPK);
                }
            } else if (lanStatus.startsWith("Manage")) {
                ClientController.getInstance().openLan(this._selectedLanPK);
            }
            if (this.isChanged(this._selectedCdpSeedBase, cdpSeedBase)) {
                this._logger.info((Object)("OpenLanThread called open() lanPK=" + this._selectedLanPK + " seedIp=" + cdpSeedBase.getSeedIp() + " maxHops=" + cdpSeedBase.getMaxHop() + " ipRange=" + cdpSeedBase.getIpRangeStr() + " subnet=" + cdpSeedBase.getSubnetStr() + " mask=" + cdpSeedBase.getMaskStr() + " snmpUserOpt=" + cdpSeedBase.getSnmpUserOpt()));
                changeApplied = ClientController.getInstance().setCdpSeed(this._selectedLanPK, cdpSeedBase);
                if (changeApplied) {
                    ClientController.getInstance().rediscoverLan(this._selectedLanPK);
                }
            }
            this.setVisible(false);
        }
        catch (Exception ex) {
            this._logger.error((Object)"Apply cdp seed and rediscover LAN failed", (Throwable)ex);
            this.setCursor(null);
            this._discButton.setEnabled(true);
            Util.errorMessage((Component)this, ex);
            this._statusLabel.setText(Util.getErrorMessage(ex));
        }
    }

    private void onDiscover() {
        this._logger.debug((Object)"AddFabricDialog onDiscover");
        InetAddress seedIp = null;
        try {
            seedIp = this.getSeedIp();
            this._host = ((JComboBox)this._inputs[2]).getSelectedItem().toString();
            if (this._discoverThread != null && !this._discoverThread.isTerminate()) {
                if (NetUtil.compareInetAddress(seedIp, this._discoverThread.getSeedIP()) == 0) {
                    return;
                }
                this._discoverThread.terminate();
                this._discoverThread = null;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this._discButton.setEnabled(false);
            FabricPK fabricPK = null;
            fabricPK = this.isCDP() ? ClientController.getInstance().lookupLanPKBySeedIp(seedIp) : ClientController.getInstance().lookupFabricPK(seedIp, this.getIncludedVsans(), this.getExcludedVsans());
            if (fabricPK != null) {
                this.fabricOpened(seedIp, fabricPK, null, null);
            } else {
                String username = this.getUsername();
                char[] password = this.getPassword();
                String community = this.getCommunity();
                boolean snmpV3 = this.isSnmpV3();
                int snmpV3Param = this.getSnmpV3Param();
                SnmpUserOpt snmpUserOpt = new SnmpUserOpt(username, String.valueOf(password), community, snmpV3Param, snmpV3);
                if (this.isCDP()) {
                    ClientController.getInstance().validateCdpSeed(seedIp, snmpUserOpt, this.getMaxHops(), this.getIpRange(), this.getSubnet(), this.getMask(), this.getServerIp());
                    boolean loadFromDb = this.isLoadFromDb();
                    this._statusLabel.setText("Discovering " + seedIp.getHostName() + " ...");
                    this._discoverThread = new OpenLanThread(seedIp, snmpUserOpt, loadFromDb, this);
                    this._discoverThread.start();
                } else {
                    ClientController.getInstance().validateSeedSwitch(seedIp, snmpUserOpt);
                    boolean loadFromDb = this.isLoadFromDb();
                    ClientController.getInstance().createSeedAndCheckVersion(seedIp, snmpUserOpt);
                    this._statusLabel.setText("Discovering " + seedIp.getHostName() + " ...");
                    this._discoverThread = new OpenFabricThread(seedIp, snmpUserOpt, loadFromDb, this);
                    this._discoverThread.start();
                }
            }
        }
        catch (Exception ex) {
            this._logger.error((Object)("Invalid seed switch:" + seedIp), (Throwable)ex);
            this.setCursor(null);
            this._discButton.setEnabled(true);
            Util.errorMessage((Component)this, ex);
            this._statusLabel.setText(Util.getErrorMessage(ex));
        }
    }

    public void setVisibleDiscoveryMode(boolean visible) {
        if (this.radioLabel != null) {
            this.radioLabel.setVisible(visible);
        }
        if (this.radioPanel != null) {
            this.radioPanel.setVisible(visible);
        }
    }

    private InetAddress getSeedIp() throws Exception {
        Object selecteItem = ((JComboBox)this._inputs[2]).getSelectedItem();
        if (selecteItem == null || selecteItem.toString().trim().length() == 0) {
            throw new Exception("Seed switch address can not be empty");
        }
        return InetAddress.getByName(selecteItem.toString().trim());
    }

    public void setSeedIp(InetAddress seedIp, boolean isForCDP) {
        this._host = seedIp.getHostAddress();
        this.setSeedIp(this._host, isForCDP);
    }

    public void setSeedIp(String host, boolean isforCDP) {
        this._host = host;
        if (isforCDP) {
            this.setCDPSeedIp(host);
        } else {
            this.setFCSeedIp(host);
        }
    }

    private void setCDPSeedIp(String host) {
        try {
            this.updateCDPHistoryVector(host);
            ((JComboBox)this._inputs[2]).setSelectedItem(this._host);
            this.saveCDPHistory();
        }
        catch (Exception ex) {
            this._logger.error((Object)"Failed to save fabric history", (Throwable)ex);
        }
    }

    private void setFCSeedIp(String host) {
        try {
            this.updateFCHistoryVector(host);
            ((JComboBox)this._inputs[2]).setSelectedItem(this._host);
            this.saveFCHistory();
        }
        catch (Exception ex) {
            this._logger.error((Object)"Failed to save fabric history", (Throwable)ex);
        }
    }

    private void updateCDPHistoryVector(String host) {
        if (!this._cdpFabricHistory.contains(this._host)) {
            if (this._cdpFabricHistory.size() == 30) {
                this._cdpFabricHistory.removeElementAt(29);
            }
        } else {
            this._cdpFabricHistory.remove(this._host);
        }
        this._cdpFabricHistory.add(0, this._host);
    }

    private void updateFCHistoryVector(String host) {
        if (!this._fabricHistory.contains(this._host)) {
            if (this._fabricHistory.size() == 30) {
                this._fabricHistory.removeElementAt(29);
            }
        } else {
            this._fabricHistory.remove(this._host);
        }
        this._fabricHistory.add(0, this._host);
    }

    private String getUsername() throws Exception {
        if (!this.isSnmpV3()) {
            return "";
        }
        String username = ((JTextField)this._inputs[5]).getText().trim();
        if (username == null || username.length() == 0) {
            throw new Exception("Please enter user name");
        }
        return username;
    }

    private void setUsername(String username) {
        if (username == null) {
            ((JTextField)this._inputs[5]).setText("");
        } else {
            ((JTextField)this._inputs[5]).setText(username);
        }
    }

    private char[] getPassword() throws Exception {
        if (!this.isSnmpV3()) {
            return new char[0];
        }
        char[] password = ((JPasswordField)this._inputs[6]).getPassword();
        if (password == null || password.length == 0) {
            throw new Exception("Please enter password");
        }
        String str = String.valueOf(password).trim();
        if (str.length() == 0) {
            throw new Exception("Password can not be empty");
        }
        return str.toCharArray();
    }

    private void setPassword(char[] password) {
        if (password == null) {
            ((JPasswordField)this._inputs[6]).setText("");
        } else {
            ((JTextField)this._inputs[6]).setText(String.valueOf(password));
        }
    }

    private String getCommunity() throws Exception {
        String community = ((JPasswordField)this._inputs[7]).getText().trim();
        if (!this.isSnmpV3() && community.length() == 0) {
            throw new Exception("Please enter community");
        }
        return community;
    }

    private void setCommunity(String community) {
        if (community == null) {
            ((JPasswordField)this._inputs[7]).setText("");
        } else {
            ((JPasswordField)this._inputs[7]).setText(community);
        }
    }

    private boolean isSnmpV3() {
        return ((JCheckBox)this._inputs[3]).isSelected();
    }

    private void setSnmpV3(boolean b) {
        ((JCheckBox)this._inputs[3]).setSelected(b);
    }

    private int getSnmpV3Param() {
        return ((JComboBox)this._inputs[4]).getSelectedIndex();
    }

    private void setSnmpV3Param(int index) {
        ((JComboBox)this._inputs[4]).setSelectedIndex(index);
    }

    private boolean isLoadFromDb() {
        return true;
    }

    public boolean isCDP() {
        return this.cdpDiscRadio.isSelected();
    }

    public int getMaxHops() {
        return this.maxHopsField.getInt();
    }

    public void setMaxHops(int maxHops) {
        this.maxHopsField.setText(Integer.toString(maxHops));
    }

    public String getSubnet() {
        if (!this.subnetRadioButton.isSelected()) {
            return null;
        }
        return this.subnetTextField.getText();
    }

    public String getMask() {
        if (!this.subnetRadioButton.isSelected()) {
            return null;
        }
        return this.maskTextField.getText();
    }

    public void setSubnet(String subnet, String mask) {
        if (!(subnet != null && subnet.trim().length() != 0 || mask != null && mask.trim().length() != 0)) {
            this.subnetRadioButton.setSelected(false);
            this.subnetTextField.setText("");
            this.maskTextField.setText("");
            return;
        }
        this.subnetTextField.setText(subnet);
        this.maskTextField.setText(mask);
        if (subnet == null || subnet.trim().length() == 0) {
            this.subnetRadioButton.setSelected(false);
        } else {
            this.subnetRadioButton.setSelected(true);
        }
    }

    public String getIpRange() {
        if (!this.ipRangeRadioButton.isSelected()) {
            return null;
        }
        return this.ipRangeTextField.getText();
    }

    public void setIpRange(String ipRange) {
        if (ipRange == null || ipRange.trim().length() == 0) {
            this.ipRangeRadioButton.setSelected(false);
            this.ipRangeTextField.setText("");
            return;
        }
        this.ipRangeRadioButton.setSelected(true);
        this.ipRangeTextField.setText(ipRange);
    }

    public String getServerIp() {
        JComboBox svrChoice = (JComboBox)this._inputs[8];
        if (!svrChoice.isVisible()) {
            return null;
        }
        return this._serverIpList.get(svrChoice.getSelectedIndex());
    }

    public void validateNegativeVsans(String vsans) throws Exception {
        if ((vsans = vsans.trim()) == null || vsans.length() == 0) {
            return;
        }
        if (vsans.startsWith("-") || vsans.contains(",-") || vsans.contains(", -")) {
            throw new FatalDiscoveryException("Please enter valid VSAN list: 1 - 4093");
        }
    }

    public void validateReservedVsans(long[] vsansAsLongs) throws Exception {
        long vsanID = -1L;
        if (vsansAsLongs != null) {
            for (int i = 0; i < vsansAsLongs.length; ++i) {
                vsanID = vsansAsLongs[i];
                if (vsanID != 4094L) continue;
                throw new FatalDiscoveryException("Cannot include VSAN 4094.");
            }
        }
    }

    public void validateVsanCharSet(String vsans) throws Exception {
        if ((vsans = vsans.trim()) == null || vsans.length() == 0) {
            return;
        }
        for (int i = 0; i < vsans.length(); ++i) {
            char c = vsans.charAt(i);
            if (Character.isDigit(c) || c == ' ' || c == ',' || c == '-') continue;
            throw new FatalDiscoveryException("Please enter valid VSAN list: 1 - 4093");
        }
    }

    public String getIncludedVsans() throws Exception {
        if (!this.includedVsansRadioButton.isSelected()) {
            return null;
        }
        String includedVsans = this.includedVsansTextField.getText();
        if (includedVsans != null && includedVsans.trim().length() > 0) {
            this.validateVsanCharSet(includedVsans);
            this.validateNegativeVsans(includedVsans);
            includedVsans = SnmpLongList.toSortedString(includedVsans);
            long[] vsansAsLongs = SnmpLongList.parse(includedVsans, true);
            this.validateReservedVsans(vsansAsLongs);
            if (vsansAsLongs != null && vsansAsLongs.length > 0 && (vsansAsLongs[0] < 1L || vsansAsLongs[vsansAsLongs.length - 1] > 4093L)) {
                throw new FatalDiscoveryException("Please enter valid VSAN list: 1 - 4093");
            }
            this._logger.info((Object)("includedVsans=" + includedVsans));
        }
        if (includedVsans != null && includedVsans.trim().length() == 0) {
            return null;
        }
        return includedVsans;
    }

    public void setIncludedVsans(String includedVsans) {
        if (includedVsans == null || includedVsans.trim().length() == 0) {
            this.includedVsansRadioButton.setSelected(false);
            this.includedVsansTextField.setText("");
            return;
        }
        this.includedVsansRadioButton.setSelected(true);
        this.includedVsansTextField.setText(includedVsans);
    }

    public String getExcludedVsans() throws Exception {
        if (!this.excludedVsansRadioButton.isSelected()) {
            return null;
        }
        String excludedVsans = this.excludedVsansTextField.getText();
        if (excludedVsans != null && excludedVsans.trim().length() > 0) {
            this.validateVsanCharSet(excludedVsans);
            this.validateNegativeVsans(excludedVsans);
            excludedVsans = SnmpLongList.toSortedString(excludedVsans);
            long[] vsansAsLongs = SnmpLongList.parse(excludedVsans, true);
            if (vsansAsLongs != null && vsansAsLongs.length > 0 && (vsansAsLongs[0] < 1L || vsansAsLongs[vsansAsLongs.length - 1] > 4093L)) {
                throw new FatalDiscoveryException("Please enter valid VSAN list: 1 - 4093");
            }
            this._logger.info((Object)("excludedVsans=" + excludedVsans));
        }
        if (excludedVsans != null && excludedVsans.trim().length() == 0) {
            return null;
        }
        return excludedVsans;
    }

    public void setExcludedVsans(String excludedVsans) {
        if (excludedVsans == null || excludedVsans.trim().length() == 0) {
            this.excludedVsansRadioButton.setSelected(false);
            this.excludedVsansTextField.setText("");
            return;
        }
        this.excludedVsansRadioButton.setSelected(true);
        this.excludedVsansTextField.setText(excludedVsans);
    }

    private void onClose() {
        if (this._discoverThread != null) {
            this._discoverThread.terminate();
        }
        LanBase lanBase = null;
        try {
            lanBase = ClientController.getInstance().getLan(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (San.getInstance().getFabricCount() == 0 && this._openDialog instanceof JDialog && !((JDialog)((Object)this._openDialog)).isVisible() && lanBase == null) {
            UIActions.getInstance().closeAction();
        } else {
            this.setVisible(false);
        }
    }

    public void fabricOpened(InetAddress ip, FabricPK fabricPK, SnmpUserOpt snmpUserOpt, String error) {
        this.setCursor(null);
        this._discButton.setEnabled(true);
        this._discoverThread = null;
        if (fabricPK == null) {
            if (error != null) {
                Util.errorMessage((Component)this, error);
            }
            return;
        }
        if (snmpUserOpt == null) {
            ContextController.abortCurrentContext();
            JOptionPane.showMessageDialog(this, ip.getHostName() + " has already been discovered as " + fabricPK + ".\n" + "The original SNMP credential will be used and the version checking is skipped.");
        } else {
            String fabricName = fabricPK.toString();
            try {
                if (this.isCDP() && !fabricPK.forFabric()) {
                    fabricName = ClientController.getInstance().getLanName((LanPK)fabricPK);
                } else {
                    ModelFacadeRif modelFacade = ClientController.getInstance().assertModelFacade();
                    fabricName = modelFacade.getFabricName(fabricPK);
                }
            }
            catch (Exception e) {
                this._logger.error((Object)("Cannot get name for fabric/LAN:" + fabricPK), (Throwable)e);
            }
            JOptionPane.showMessageDialog(this, ip.getHostName() + " is discovered as " + fabricName + " (" + fabricPK + ")");
        }
        if (!this.isCDP()) {
            if (!this._openDialog.contains(fabricPK)) {
                if (snmpUserOpt == null) {
                    try {
                        snmpUserOpt = ClientController.getInstance().assertModelFacade().getSnmpUserOpt(fabricPK);
                    }
                    catch (Exception ex) {
                        this._logger.error((Object)("Failed to get SNMP info for " + fabricPK), (Throwable)ex);
                    }
                }
                boolean licensed = false;
                boolean evalLicensed = false;
                LicenseCapabilities.Features feature = null;
                feature = ClientController.getInstance().isLocal() ? LicenseCapabilities.Features.LOCAL_MULTI_OPEN : LicenseCapabilities.Features.REMOTE_MULTI_OPEN;
                try {
                    FMServerRif server = ClientController.getInstance().assertFMSConnection();
                    SessionRif sessionRif = ClientController.getInstance().getServerSession();
                    if (server != null) {
                        int licenseState = server.getFmLicensedState(fabricPK, sessionRif.getSSOToken());
                        if (licenseState == 2 || licenseState == 3) {
                            licensed = true;
                            evalLicensed = false;
                        } else if (licenseState == 5 || licenseState == 4) {
                            licensed = true;
                            evalLicensed = true;
                        }
                    }
                }
                catch (Exception ex) {
                    this._logger.error((Object)("Failed to verify license for " + fabricPK), (Throwable)ex);
                }
                this._openDialog.addFabricItem(fabricPK, snmpUserOpt, licensed, evalLicensed);
            }
        } else if (!this._openDialog.contains(fabricPK)) {
            this._openDialog.addFabricItem(fabricPK, snmpUserOpt, false, false);
        }
        try {
            if (this.isCDP()) {
                this.updateCDPHistoryVector(this._host);
            } else {
                this.updateFCHistoryVector(this._host);
            }
            this.saveFCHistory();
            this.saveCDPHistory();
        }
        catch (Exception ex) {
            this._logger.error((Object)"Failed to save fabric history", (Throwable)ex);
        }
        if (this._clientContext != null) {
            this._clientContext.setState(1);
            if (!this._clientContext.isAborted()) {
                ContextController.getInstance().reSubmitContext(this._clientContext);
            }
        }
        this.setVisible(false);
    }

    private void saveFCHistory() {
        try {
            IntProperties intProperties = new IntProperties();
            intProperties.setVector(this._fabricHistory);
            ClientController.getInstance().storePropertiesToServer(FABRIC_HISTORY_FILENAME, intProperties, "(c) Cisco Systems\n#DCNM-SAN 6.3(1)\n", false);
        }
        catch (Exception ex) {
            this._logger.error((Object)"Failed to save fabric history", (Throwable)ex);
        }
    }

    private void saveCDPHistory() {
        try {
            IntProperties intProperties = new IntProperties();
            intProperties.setVector(this._cdpFabricHistory);
            ClientController.getInstance().storePropertiesToServer(FABRIC_CDP_HISTORY_FILENAME, intProperties, "(c) Cisco Systems\n#DCNM-SAN 6.3(1)\n", false);
        }
        catch (Exception ex) {
            this._logger.error((Object)"Failed to save cdp fabric history", (Throwable)ex);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    public void setContext(ClientContext clientContext) {
        if (clientContext == null) {
            return;
        }
        this._clientContext = clientContext;
        String switchIP = clientContext.getSwitchIP();
        String userName = clientContext.getUserName();
        String password = clientContext.getPassword();
        String authPrivacy = clientContext.getAuthPrivacy();
        boolean isSnmpV3 = clientContext.isSnmpV3();
        String community = clientContext.getCommunity();
        this.setSeedIp(switchIP == null ? "" : switchIP, false);
        if (switchIP != null && switchIP.length() > 0) {
            ((JComboBox)this._inputs[2]).setEditable(false);
            ((JComboBox)this._inputs[2]).setEnabled(false);
        }
        this.setSnmpV3(isSnmpV3);
        this._logger.debug((Object)clientContext.toString());
        if (isSnmpV3) {
            this.setUsername(userName == null ? "" : userName);
            this.setPassword(password == null ? "".toCharArray() : password.toCharArray());
            this.setCommunity("");
        } else {
            this.setUsername("");
            this.setPassword("".toCharArray());
            this.setCommunity(community == null ? "" : community);
        }
        ((JComboBox)this._inputs[4]).setSelectedItem(authPrivacy == null ? "MD5" : authPrivacy);
    }

    public static boolean areAnyDiscoveryThreadsRunning() {
        if (OpenFabricThread.instance != null && OpenFabricThread.instance.isAlive()) {
            return true;
        }
        return OpenLanThread._instance != null && OpenLanThread._instance.isAlive();
    }
}

