/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.MibVariableSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FindDialog;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.event.EventLog;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataViewModelIf;
import com.cisco.dcbu.sm.client.gui.EditDialog;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmCommandDispatcher;
import com.cisco.dcbu.sm.client.gui.SmGenericTab;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapAction;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class DataView
extends JPanel
implements TableModelListener,
ListSelectionListener,
ActionListener {
    private static final int BIG = 12;
    public static boolean _ConfirmRowDeletion = true;
    public static boolean _SelectMapFrmTable = true;
    public static final int APPLY = 0;
    public static final int COMMITCFS = 1;
    public static final int REFRESH = 2;
    public static final int INSERT = 3;
    public static final int DELETE = 4;
    public static final int COPY = 5;
    public static final int PASTE = 6;
    public static final int RESET = 7;
    public static final int FIND = 8;
    public static final int EXPORT = 9;
    public static final int PRINT = 10;
    public static final int DETACH = 11;
    public static final int DETAIL = 12;
    public static final String DETAIL_BUTTON_TEXT = "Details...";
    public static final String INSERT_BUTTON_TEXT = "Create Row...";
    public static final String DELETE_BUTTON_TEXT = "Delete Row";
    static final String[][] _ButtonAttr = new String[][]{{"icons/start_list_16.gif", "Apply Changes", "A"}, {"icons/cfs_apply.gif", "Commit CFS Pending Changes", "C"}, {"icons/Refresh16.gif", "Refresh Values", "R"}, {"icons/insert_list_16.gif", "Create Row...", "I"}, {"icons/remove_list_16.gif", "Delete Row", "D"}, {"icons/Copy16.gif", "Copy  Ctrl+C", "c"}, {"icons/Paste16.gif", "Paste  Ctrl+V", "P"}, {"icons/undo.gif", "Undo Changes (In Bold)  Ctrl+Z", "u"}, {"icons/find16.gif", "Find...", "F"}, {"icons/Save16.gif", "Export to File...", "E"}, {"icons/print16.gif", "Print Table...", "p"}, {"icons/fwwn-to-pwwn.gif", "Detach Table...", "t"}, {null, "Details...", "d"}};
    JButton[] _tableButton;
    public SnmpKTable _table;
    public SnmpKTable _popupTable;
    public SmTableModel _tableModel;
    JComponent _dataPanel;
    JPanel _dataPanelContainer;
    JPanel _dataPanelButtonPanel;
    JPanel _newButtonPanel;
    JButton[] _newTableButton;
    String[][] _newButtonAttr;
    ActionListener[] _newButtonActListener;
    int _newBtnIndex = -1;
    int _newBtnLength = 0;
    JPanel _titlePanel;
    JScrollPane _tablePane;
    HeaderListener _headerListener;
    InsertDialog _insertDialog;
    EditDialog _editDialog;
    Container _newPanel;
    public SmFilter[] _filter;
    public MgmtDomainIf _mgmtDomain;
    String _editMethod;
    private String _helpTag;
    protected JDialog _dlgParent;
    protected JFrame _frmParent = BrowserFrame.getInstance();
    DataViewMouseListener _dataViewMouseListener;
    boolean isMetal = UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class;
    static final int INSETS = 2;
    DataViewModelIf _dataViewModelIf;
    FindDialog _findDialog;
    public static final String FEAURE_NOT_AVAILABLE_ERR_MSG = "This feature is not enabled by any managable switch in this context.\nIf applicable, please enable the feature in the Control tab.";
    public static final String NEED_MGMT_DOMAIN_ERR_MSG = "Please make a selection in the Logical Domains tree and try again.";

    public DataView() {
        this._tableModel = new SmTableModel();
        this.setDataViewModelIf(this._tableModel);
        this._tableModel.addTableModelListener(this);
        this._table = this.buildTable(this._tableModel);
        this._tablePane = new JScrollPane(this._table);
        this._dataViewMouseListener = new DataViewMouseListener(this._table);
        this._table.addMouseListener(this._dataViewMouseListener);
        this._dataPanelContainer = new JPanel(new BorderLayout());
        this._dataPanelContainer.setBorder(BorderFactory.createEmptyBorder());
        this._titlePanel = new JPanel(new BorderLayout());
        this._dataPanelContainer.add("Center", this._titlePanel);
        this._dataPanelButtonPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._tableButton = new JButton[_ButtonAttr.length];
        for (int i = 0; i < _ButtonAttr.length; ++i) {
            if (_ButtonAttr[i][0] != null && _ButtonAttr[i][1] != null && _ButtonAttr[i][2] != null) {
                this._tableButton[i] = Util.createButton(_ButtonAttr[i][0], _ButtonAttr[i][1], _ButtonAttr[i][2], this);
            } else if (_ButtonAttr[i][1] != null) {
                this._tableButton[i] = new JButton(_ButtonAttr[i][1]);
                this._tableButton[i].setActionCommand(_ButtonAttr[i][2]);
                this._tableButton[i].addActionListener(this);
            }
            this._dataPanelButtonPanel.add(this._tableButton[i]);
        }
        this.displayButton(1, false);
        this.displayButton(12, false);
        this.enableButton(12, false);
        this._dataPanelContainer.add("West", this._dataPanelButtonPanel);
        this.setLayout(new BorderLayout());
        this.add("North", this._dataPanelContainer);
        this.add("Center", this._tablePane);
        this.init();
    }

    void init() {
        SmCommandDispatcher.initMibVariableFormat(MibVariableFormat.class);
        SmCommandDispatcher.initMibVariableSet(MibVariableSet.class);
        try {
            Util.load(SnmpTableModel._Aliases, "/com/cisco/dcbu/lib/mds/alias.properties");
            Util.load(SnmpTableModel._Units, "/com/cisco/dcbu/lib/mds/units.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SnmpTableModel._MibVariableFormatMethods = SmCommandDispatcher._MibVariableFormatMethods;
        SnmpTableModel._MibVariableFormatClass = SmCommandDispatcher._MibVariableFormatClass;
        SnmpTableModel._MibVariableSetMethods = SmCommandDispatcher._MibVariableSetMethods;
        SnmpTableModel._MibVariableSetClass = SmCommandDispatcher._MibVariableSetClass;
    }

    public void setNewTableModel(SmTableModel newTableModel) {
        newTableModel.addTableModelListener(this);
        this._tableModel = newTableModel;
        this.setDataViewModelIf(this._tableModel);
        this._table.setModel(newTableModel);
        this._tableModel.setEditMethod(this._editMethod);
        this._headerListener.clear();
    }

    public void replaceButtonPanel(JPanel newPanel) {
        this._newButtonPanel = newPanel;
    }

    public JButton insertButton(int index, String[][] newButtonsAttr, ActionListener[] actionListeners) {
        JButton[] btns = this.insertButtons(index, newButtonsAttr, actionListeners);
        return btns == null || btns.length == 0 ? null : btns[0];
    }

    public JButton[] insertButtons(int index, String[][] newButtonsAttr, ActionListener[] actionListeners) {
        JButton[] insertedBtns = new JButton[newButtonsAttr.length];
        this._newBtnIndex = index;
        this._newBtnLength = newButtonsAttr.length;
        this._newButtonPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._newTableButton = new JButton[_ButtonAttr.length + newButtonsAttr.length];
        this._newButtonAttr = new String[this._newTableButton.length][3];
        this._newButtonActListener = new ActionListener[this._newTableButton.length];
        int numBtnsAdd = 0;
        for (int i = 0; i < _ButtonAttr.length; ++i) {
            if (i == index) {
                for (int j = 0; j < newButtonsAttr.length; ++j) {
                    if (newButtonsAttr[j][0] != null && newButtonsAttr[j][1] != null && newButtonsAttr[j][2] != null) {
                        this._newTableButton[numBtnsAdd] = Util.createButton(newButtonsAttr[j][0], newButtonsAttr[j][1], newButtonsAttr[j][2], actionListeners[j]);
                    } else if (newButtonsAttr[j][1] != null) {
                        this._newTableButton[numBtnsAdd] = new JButton(newButtonsAttr[j][1]);
                        if (actionListeners[j] != null) {
                            this._newTableButton[numBtnsAdd].addActionListener(actionListeners[j]);
                        }
                    }
                    insertedBtns[j] = this._newTableButton[numBtnsAdd];
                    this._newButtonAttr[numBtnsAdd][0] = newButtonsAttr[j][0];
                    this._newButtonAttr[numBtnsAdd][1] = newButtonsAttr[j][1];
                    this._newButtonAttr[numBtnsAdd][2] = newButtonsAttr[j][2];
                    this._newButtonActListener[numBtnsAdd] = actionListeners[j];
                    this._newButtonPanel.add(this._newTableButton[numBtnsAdd]);
                    ++numBtnsAdd;
                }
            }
            this._newTableButton[numBtnsAdd] = Util.createButton(_ButtonAttr[i][0], _ButtonAttr[i][1], _ButtonAttr[i][2], this);
            this._newButtonAttr[numBtnsAdd][0] = _ButtonAttr[i][0];
            this._newButtonAttr[numBtnsAdd][1] = _ButtonAttr[i][1];
            this._newButtonAttr[numBtnsAdd][2] = _ButtonAttr[i][2];
            this._newButtonPanel.add(this._newTableButton[numBtnsAdd]);
            ++numBtnsAdd;
        }
        return insertedBtns;
    }

    public JButton replaceButton(int index, String[] replaceButtonAttri, ActionListener actionListener) {
        this._newButtonPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._newTableButton = new JButton[_ButtonAttr.length];
        this._newButtonAttr = new String[this._newTableButton.length][3];
        this._newButtonActListener = new ActionListener[this._newTableButton.length];
        JButton replacedBtn = null;
        for (int i = 0; i < _ButtonAttr.length; ++i) {
            if (i == index) {
                this._newTableButton[i] = replaceButtonAttri[0] != null && replaceButtonAttri[1] != null && replaceButtonAttri[2] != null ? Util.createButton(replaceButtonAttri[0], replaceButtonAttri[1], replaceButtonAttri[2], actionListener) : new JButton(replaceButtonAttri[1]);
                this._newButtonAttr[i][0] = replaceButtonAttri[0];
                this._newButtonAttr[i][1] = replaceButtonAttri[1];
                this._newButtonAttr[i][2] = replaceButtonAttri[2];
                this._newButtonActListener[i] = actionListener;
                this._newButtonPanel.add(this._newTableButton[i]);
                replacedBtn = Util.createButton(_ButtonAttr[i][0], _ButtonAttr[i][1], _ButtonAttr[i][2], this);
                continue;
            }
            this._newTableButton[i] = Util.createButton(_ButtonAttr[i][0], _ButtonAttr[i][1], _ButtonAttr[i][2], this);
            this._newButtonAttr[i][0] = _ButtonAttr[i][0];
            this._newButtonAttr[i][1] = _ButtonAttr[i][1];
            this._newButtonAttr[i][2] = _ButtonAttr[i][2];
            this._newButtonPanel.add(this._newTableButton[i]);
        }
        return replacedBtn;
    }

    public void replaceTablePanel(Container newPanel) {
        if (null != this._newPanel) {
            this.remove(this._newPanel);
            this._newPanel = null;
        } else {
            this.remove(this._tablePane);
        }
        this.add("Center", newPanel);
        this._newPanel = newPanel;
        this._newPanel.repaint();
    }

    public SmGenericTab getTabPanel() {
        if (this._newPanel instanceof SmGenericTab) {
            return (SmGenericTab)((Object)this._newPanel);
        }
        return null;
    }

    public String getSelectedTabTitle() {
        SmGenericTab tabPane = this.getTabPanel();
        if (tabPane == null) {
            return null;
        }
        return tabPane.getTitleAt(tabPane.getSelectedIndex());
    }

    public void revertToTablePanel() {
        if (null != this._newPanel) {
            this.remove(this._newPanel);
            this.add("Center", this._tablePane);
            this._newPanel = null;
        }
        this._tablePane.getViewport().setView(this._table);
        this._tablePane.validate();
    }

    public void setLabel(String label) {
        if (this._frmParent != null && this._frmParent instanceof BrowserFrame) {
            ((BrowserFrame)this._frmParent).setDataPanelTitle(label);
        }
    }

    public String getPanelTitle() {
        String title = null;
        title = this._frmParent != null && this._frmParent instanceof BrowserFrame ? ((BrowserFrame)this._frmParent).getDataPanelTitle() : "";
        return title;
    }

    public void showTitle(String label, String method) {
        this.setLabel(label + (method.equals("-") ? "" : method));
        this._dataPanelContainer.removeAll();
        this._dataPanelContainer.add("Center", this._titlePanel);
        this.revertToTablePanel();
        this._tablePane.getViewport().setView(null);
        this._tablePane.validate();
    }

    public void updateView(String label, boolean bIsViewTable) {
        this.setLabel(label);
        if (bIsViewTable) {
            this.revertToTablePanel();
        }
        this.resetToolBarPanel();
        this._table.setChangeListener(this.getButton(0));
        this._tablePane.validate();
    }

    void resetToolBarPanel() {
        this._dataPanelContainer.removeAll();
        this._dataPanelContainer.add("Center", this._titlePanel);
        if (this._newButtonPanel != null) {
            this._dataPanelContainer.add("West", this._newButtonPanel);
        } else {
            this._dataPanelContainer.add("West", this._dataPanelButtonPanel);
        }
        this._dataPanelContainer.validate();
        this._dataPanelContainer.updateUI();
    }

    public void resetView() {
        this.cleanup();
        this.setLabel("");
        this.revertToTablePanel();
        this.setNewTableModel(new SmTableModel());
        Component cmp = this._tablePane.getViewport().getView();
        if (cmp != null) {
            this._tablePane.getViewport().remove(cmp);
        }
        this._dataPanelContainer.removeAll();
        this._dataPanelContainer.validate();
        this._dataPanelContainer.updateUI();
        this._dataPanelContainer.add("Center", this._titlePanel);
    }

    public void modelReset() {
        this._newButtonPanel = null;
        this._newTableButton = null;
        this._newBtnIndex = -1;
        this._newBtnLength = 0;
        this._newButtonAttr = null;
        this._newButtonActListener = null;
        this._dataViewMouseListener._popupMenu = null;
    }

    public void cleanup() {
        this.cleanup(false);
    }

    public void cleanup(boolean changeTab) {
        if (this._insertDialog != null && !changeTab) {
            this._insertDialog.dispose();
            this._insertDialog = null;
        }
        if (this._editDialog != null) {
            this._editDialog.dispose();
            this._editDialog = null;
        }
        if (this._dataViewModelIf != null) {
            this._dataViewModelIf.cleanup();
        }
        if (this._findDialog != null) {
            this._findDialog.dispose();
        }
    }

    public void resetPhysicalTreeChange() {
        this._dataViewModelIf = null;
        this._filter = null;
    }

    public void enableButton(int index, boolean enabled) {
        JButton b = this.getButton(index);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public void displayButton(int index, boolean show) {
        JButton b = this.getButton(index);
        if (b != null) {
            b.setVisible(show);
        }
    }

    public void setButtonNewToolTip(int index, String newToolTip) {
        JButton b = this.getButton(index);
        if (b != null) {
            b.setToolTipText(newToolTip);
        }
    }

    public void setButtonNewText(int index, String newText) {
        JButton b = this.getButton(index);
        if (b != null) {
            b.setText(newText);
        }
    }

    protected JButton getButton(int index) {
        if (this._newButtonPanel != null && this._newTableButton != null) {
            if (index > this._newTableButton.length) {
                return null;
            }
            if (this._newBtnIndex != -1) {
                return this._newTableButton[this._newBtnIndex > index ? index : index + this._newBtnLength];
            }
            return this._newTableButton[index];
        }
        if (index > this._tableButton.length) {
            return null;
        }
        return this._tableButton[index];
    }

    public JPanel getDefaultButtonPanel() {
        return this._dataPanelButtonPanel;
    }

    public JPanel getButtonPanel() {
        return this._newButtonPanel == null ? this._dataPanelButtonPanel : this._newButtonPanel;
    }

    public static final String[][] getDefaultButtons() {
        return _ButtonAttr;
    }

    public void setButtonText(int index, String text) {
        JButton btn = this.getButton(index);
        if (btn != null) {
            btn.setText(text);
        }
    }

    protected void delete() throws Exception {
        this.delete(this._table);
    }

    protected void delete(SnmpKTable table) throws Exception {
        int[] selected;
        SmTableModel tableModel;
        if (table == null) {
            table = this._table;
        }
        if ((tableModel = (SmTableModel)table.getModel()).deleteRowsAction(selected = table.getSelectedRows())) {
            for (int i = selected.length - 1; i >= 0; --i) {
                if (!tableModel.removeRow(selected[i])) continue;
                tableModel.getData().removeElementAt(selected[i]);
            }
            tableModel.fireTableRowsDeleted(selected[0], selected[selected.length - 1]);
            this.enableButton(4, false);
            int nOfRowsDel = selected.length;
            BrowserFrame.getInstance().setStatus(nOfRowsDel + " row" + (nOfRowsDel > 1 ? "s" : "") + " deleted.");
            tableModel.postDeleteRowsAction();
            if (this._dlgParent != null) {
                Dimension d = this._table.calcPreferredSize();
                if (this._newPanel instanceof SmGenericTab) {
                    d.height = d.height + (this.isMetal ? 10 : 8);
                    d.width = d.width + (this.isMetal ? 4 : 2);
                }
                this._tablePane.setPreferredSize(d);
                this._tablePane.invalidate();
                this._dlgParent.pack();
            }
        }
    }

    public void setRowStatus(int[] rowStatus, int insertValue, int deleteValue, String[] indexVars) {
        this._tableModel.setRowStatus(rowStatus, insertValue, deleteValue, indexVars);
        this.displayButton(3, true);
        this.enableButton(3, true);
        this.displayButton(4, true);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean enable = e != null && (e.getType() == 0 || e.getType() == 1 || e.getType() == -1) && this._tableModel.isEditable() && this._tableModel.isChanged();
        this.enableButton(0, this._tableModel.enableApplyOnChange(enable, e));
        this.enableButton(7, enable);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean selected = this._tableModel.getRowCount() > 0 && this._table.getSelectedRowCount() > 0;
        this.enableButton(5, selected);
        this.enableButton(6, selected);
        this.enableButton(12, this._tableModel.enableDetailButton(this._table));
        if (this._tableModel._rowStatus != null) {
            this.enableButton(4, this._tableModel.enableDeleteButton(this._table));
        }
        if (selected && _SelectMapFrmTable && !e.getValueIsAdjusting()) {
            this._tableModel.selectionAction(this._table);
        }
        this._tableModel.tableSelectionChanged(selected, this._table);
    }

    public void displayTable() {
        if (MibVariableFormat._IfIndexIf == null) {
            ClientController.reInitMibVariableFormat();
        }
        if (this._tablePane.getViewport().getView() == null) {
            this._tablePane.getViewport().setView(this._table);
            this._tablePane.validate();
        }
        this._tableModel.fireTableDataChanged();
        if (this._tableModel.getCheckForEmptyColumns()) {
            this.checkForEmptyColumns();
        }
        if (this._tableModel.getHeaders() != null) {
            this._table.getTableHeader().resizeAndRepaint();
            this._tableModel.calcColWidth(this._table);
        }
        this._table.repaint();
        if (this._dlgParent != null) {
            Dimension d = this._table.calcPreferredSize();
            if (this._newPanel instanceof SmGenericTab) {
                d.height = d.height + (this.isMetal ? 10 : 8);
                d.width = d.width + (this.isMetal ? 4 : 2);
            }
            int insets = this.isMetal ? 3 : 5;
            this._tablePane.setPreferredSize(new Dimension(d.width + 2 * insets, d.height + 2 * insets));
            this._tablePane.invalidate();
            this._dlgParent.pack();
        }
        this.enableButton(0, this._tableModel.ApplyBtnOn());
        if (this._tableModel.RefreshBtnOn()) {
            this.displayButton(2, true);
            this.enableButton(2, true);
        } else {
            this.displayButton(2, false);
        }
        this.enableButton(7, false);
        if (this._tableModel._rowStatus != null) {
            this.enableButton(4, false);
        }
        this.enableButton(12, false);
        this.enableButton(5, false);
        this.enableButton(6, false);
        this.enableButton(11, true);
    }

    public void buildTable(String[] vars, String[] prefixes, int index, boolean isScalar, String editInfo) {
        this.buildTable(vars, prefixes, index, isScalar, new SmTableModel(), editInfo);
    }

    public void buildTable(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this.buildTable(vars, prefixes, index, isScalar, new SmTableModel());
    }

    public void buildTable(String[] vars, String[] prefixes, int index, boolean isScalar, SmTableModel tableModel, String editInfo) {
        this._editMethod = editInfo;
        this.setNewTableModel(tableModel);
        this.buildTableInfo(vars, prefixes, index, isScalar);
    }

    public void buildTable(String[] vars, String[] prefixes, int index, boolean isScalar, SmTableModel tableModel) {
        this._editMethod = null;
        this.setNewTableModel(tableModel);
        this.buildTableInfo(vars, prefixes, index, isScalar);
    }

    public void buildTableInfo(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._table.resetFixedWidths();
        this._tableModel.setAttr(vars, prefixes, index, isScalar);
        this._tableModel._validateVbl = false;
        this._tableModel.fireTableStructureChanged();
        this._tableModel.setCellEditor(this._table);
        this._tableModel.setSpecialAttr();
        this.getButton(0).setVisible(this._tableModel.isEditable());
        this.displayButton(1, this._tableModel.showCfsButton());
        this.getButton(6).setVisible(this._tableModel.isEditable());
        this.getButton(7).setVisible(this._tableModel.isEditable());
        this.getButton(3).setVisible(false);
        this.getButton(4).setVisible(false);
        this.displayButton(12, this._tableModel.showDetailButton());
    }

    public void setValidateVbl(boolean validate) {
        this._tableModel._validateVbl = validate;
    }

    public void setValidateGETEntireVbl(boolean validateGETEntireVbl) {
        this._tableModel._validateGETEntireVbl = validateGETEntireVbl;
    }

    public void setValidateInsertRowVbl(String validSwVerGreaterThanEqual) {
        this._tableModel._validateInsertRowVblSwVerGreaterThanEqual = validSwVerGreaterThanEqual;
    }

    public void setWizSignature(String wizSig) {
        this._tableModel._wizSignature = wizSig;
    }

    public void refreshWizardOwner(String activeWizSig) {
        if (this._tableModel._wizSignature != null && activeWizSig.equals(this._tableModel._wizSignature)) {
            this.refresh(this._table);
        }
    }

    public void tableStructureChanged() {
        this._tableModel.fireTableStructureChanged();
        this._tableModel.setCellEditor(this._table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchTable(MgmtDomainIf mgmtDomain, boolean isScalar) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Array d = this._tableModel.getTableVars(mgmtDomain, isScalar);
            this.setTableData(d);
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchTable(SnmpPeer[] peers, boolean isScalar) {
        try {
            if (peers == null) {
                peers = this._tableModel.getWrkingPeers();
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Array d = isScalar ? this._tableModel.getVars(peers) : this._tableModel.getTableVars(peers);
            this.setTableData(d);
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.error((Object)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchTable(SmFilter[] invoker) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Array d = this._tableModel.getTableVars(invoker);
            this.setTableData(d);
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setTableData(Array d) {
        String statusMsg;
        String timeouts;
        String livePeers;
        this._tableModel.setData(d);
        StringBuffer status = new StringBuffer();
        if (d != null) {
            status.append(this._tableModel.getProgressStatus());
        }
        if ((livePeers = this._tableModel.getQueriedPeers()) != null && status.length() != 0) {
            status.append(", ");
            status.append(livePeers);
        }
        if ((timeouts = this._tableModel.getTimeouts()) != null && status.length() != 0) {
            status.append(", ");
            status.append(timeouts);
        }
        if ((statusMsg = this._tableModel.getStatusUpdate()) != null && status.length() != 0) {
            status.append(", ");
            status.append(statusMsg);
        }
        BrowserFrame.getInstance().setStatus(status.length() == 0 ? " " : status.toString());
    }

    protected SnmpKTable buildTable(SnmpTableModel model) {
        SnmpKTable table = new SnmpKTable(model);
        table.getSelectionModel().addListSelectionListener(this);
        table.setAutoResizeMode(0);
        this._headerListener = new HeaderListener();
        table.getTableHeader().addMouseListener(this._headerListener);
        table.setSortable(true);
        return table;
    }

    private boolean isTableVisible() {
        return true;
    }

    public void print() throws PrinterException {
        this.print(this._table);
    }

    public void print(SnmpKTable table) throws PrinterException {
        if (table == null) {
            table = this._table;
        }
        if (this.isTableVisible()) {
            table.print("DCNM-SAN");
        }
    }

    public void export() {
        this.export(this._table);
    }

    public void export(SnmpKTable table) {
        if (table == null) {
            table = this._table;
        }
        if (!this.isTableVisible()) {
            return;
        }
        String title = this.getPanelTitle();
        title = title != null ? title.replace('/', '-') + ".txt" : "*.txt";
        String fName = Util.getFileName(BrowserFrame.getInstance(), "Export Table" + ClientController.getInstance().getDialogTitlePostfix(), title, 1, null, true);
        if (fName != null) {
            table.export(fName);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block19: {
            char ch = ((AbstractButton)e.getSource()).getActionCommand().charAt(0);
            SnmpKTable table = this._table;
            if (table == null) {
                table = this._popupTable;
            }
            SmTableModel tableModel = (SmTableModel)table.getModel();
            try {
                switch (ch) {
                    case 'A': {
                        this.apply();
                        break;
                    }
                    case 'C': {
                        tableModel.commitCfs();
                        break;
                    }
                    case 'I': {
                        this.insert(table);
                        break;
                    }
                    case 'D': {
                        if (table.isEditing()) {
                            table.editingStopped(null);
                        }
                        this.delete(table);
                        break;
                    }
                    case 'F': {
                        this.find(table);
                        break;
                    }
                    case 'd': {
                        this.details();
                        break;
                    }
                    case 'c': {
                        table.copy();
                        break;
                    }
                    case 'P': {
                        table.paste();
                        break;
                    }
                    case 'u': {
                        tableModel.undo();
                        this.enableButton(0, false);
                        this.enableButton(7, false);
                        break;
                    }
                    case 'E': {
                        this.export(table);
                        break;
                    }
                    case 'p': {
                        this.print(table);
                        break;
                    }
                    case 'R': {
                        this.refresh(table);
                        break;
                    }
                    case 't': {
                        this.detach(table);
                    }
                }
            }
            catch (Exception ex) {
                BrowserFrame.getInstance();
                BrowserFrame.getDataView().setCursor(Cursor.getDefaultCursor());
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block19;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void apply() throws Exception {
        if (this._table.isEditing()) {
            this._table.editingStopped(null);
        }
        if (this._tableModel.applyChangesAction()) {
            this._tableModel.resetChanges(false);
        }
    }

    public void insert() throws Exception {
        this.insert(this._table);
    }

    public void insert(SnmpKTable table) throws Exception {
        if (table == null) {
            table = this._table;
        }
        SmTableModel tableModel = (SmTableModel)table.getModel();
        if (this._insertDialog != null && this._insertDialog.isVisible() && tableModel.isMyInsertDlg()) {
            this._insertDialog.toFront();
        } else {
            SnmpPeer[] peers;
            if (this._insertDialog != null) {
                this._insertDialog.dispose();
            }
            if ((peers = tableModel.getWrkingPeers()) != null) {
                this._insertDialog = new InsertDialog(BrowserFrame.getInstance(), peers, tableModel);
                String title = this.getInsertDlgTitle();
                this._insertDialog.setTitle(title);
                this._insertDialog.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), table, this._insertDialog.getSize()));
                this._insertDialog.setVisible(true);
            } else {
                if (ClientController.getInstance().getSelectedDomain() == null) {
                    throw new Exception(NEED_MGMT_DOMAIN_ERR_MSG);
                }
                throw new Exception(FEAURE_NOT_AVAILABLE_ERR_MSG);
            }
        }
    }

    public void find(SnmpKTable table) throws Exception {
        if (this._findDialog != null) {
            this._findDialog.dispose();
        }
        this._findDialog = this.getDlgParent() == null ? new FindDialog(this.getFrmParent(), null, (KTable)table) : new FindDialog(this.getDlgParent(), null, (KTable)table);
        this._findDialog.setTitle("Find");
        this._findDialog.setVisible(true);
    }

    public String getInsertDlgTitle() {
        String title = this._tableModel.getInsertTitle(this._table);
        if (title == null) {
            title = this.getPanelTitle() + "/";
            if (this._newPanel instanceof SmGenericTab) {
                title = title + ((SmGenericTab)((Object)this._newPanel)).getTitleAt(((SmGenericTab)((Object)this._newPanel)).getSelectedIndex());
            }
            title = title + " - Create";
            String detail = this._tableModel.getInsertTitleDetail(this._table);
            if (detail != null) {
                title = title + detail;
            }
        }
        return title;
    }

    public SnmpKTable detach(SnmpKTable table) {
        SmTableModel tableModel = (SmTableModel)table.getModel();
        String tabTitle = null;
        Container com = table.getParent().getParent().getParent();
        if (com instanceof JPanel) {
            com = com.getParent();
        }
        tabTitle = com instanceof JTabbedPane ? "/" + ((JTabbedPane)com).getTitleAt(((JTabbedPane)com).getSelectedIndex()) : "";
        JDialog dialog = new JDialog((Frame)BrowserFrame.getInstance(), this.getPanelTitle() + tabTitle);
        JPanel main = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                Insets i = this.getInsets();
                d.setSize(d.getWidth() + (double)(1 * (i.left + i.right)), d.getHeight() + (double)(i.top + i.bottom));
                return d;
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        SnmpKTable newTable = new SnmpKTable(tableModel){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        newTable.setAutoResizeMode(0);
        newTable.setAutoscrolls(true);
        newTable.getTableHeader().addMouseListener(new HeaderListener());
        newTable.setSortable(true);
        newTable.addMouseListener(new DataViewMouseListener(newTable));
        TableColumnModel ocm = this._table.getColumnModel();
        TableColumnModel cm = newTable.getColumnModel();
        int ocolumnCount = this._table.getColumnCount();
        int j = ocolumnCount - 1;
        for (int i = newTable.getColumnCount() - 1; i >= 0; --i) {
            String oldValue;
            String newValue = (String)cm.getColumn(i).getHeaderValue();
            for (j = 0; j < ocolumnCount && !GenUtil.equals(newValue, oldValue = (String)ocm.getColumn(j).getHeaderValue()); ++j) {
            }
            if (j < ocolumnCount) {
                Object obj = this._table.getValueAt(0, j);
                if (obj != null && Boolean.TRUE.getClass().equals(obj.getClass())) {
                    cm.getColumn(i).setCellRenderer(new DefaultTableCellRenderer());
                    continue;
                }
                cm.getColumn(i).setCellRenderer(ocm.getColumn(j).getCellRenderer());
                continue;
            }
            newTable.removeColumn(cm.getColumn(i));
        }
        newTable.calcPreferredSize();
        newTable.setPreferredSize(table.getPreferredSize());
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)newTable, "Center");
        tablePanel.add((Component)newTable.getTableHeader(), "North");
        JScrollPane sp = new JScrollPane(newTable){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = this.getViewport().getComponent(0).getPreferredSize();
                return d;
            }
        };
        panel.add(sp);
        main.setBorder(DialogUtil._Margin);
        main.add((Component)panel, "Center");
        String[] bLabels = new String[]{"Close"};
        JButton[] buttons = DialogUtil.buildButtons(bLabels, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton btn = (JButton)e.getSource();
                JDialog dialog = Util.getDialogAncestor(btn);
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.getRootPane().setDefaultButton(buttons[0]);
        JPanel buttonStatusPanel = new JPanel(new BorderLayout());
        int rows = this._tableModel.getRowCount();
        JLabel status = new JLabel("" + rows + " row" + (rows > 1 ? "s" : "") + " - created at : " + EventLog.getCurrentTime());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)status, "West");
        buttonStatusPanel.add((Component)statusPanel, "Center");
        buttonStatusPanel.add((Component)buttons[0], "East");
        buttonStatusPanel.setBorder(DialogUtil._Margin);
        main.add((Component)buttonStatusPanel, "South");
        dialog.getContentPane().add(main);
        dialog.pack();
        dialog.setLocationRelativeTo(BrowserFrame.getInstance());
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        return newTable;
    }

    public void checkForEmptyColumns() {
        this.checkForEmptyColumns(this._table, true);
    }

    public void checkForEmptyColumns(SnmpKTable table, boolean editable) {
        int j;
        SmTableModel tableModel = (SmTableModel)table.getModel();
        Array data = tableModel.getData();
        if (data == null || data.size() == 0) {
            return;
        }
        int numColumns = table.getColumnCount();
        boolean[] columnEditable = tableModel.getEditable();
        boolean[] columnDataExists = new boolean[((Object[])data.elementAt(0)).length];
        String strVal = null;
        for (j = 0; j < numColumns; ++j) {
            columnDataExists[j] = false;
        }
        for (int i = 0; i < data.size(); ++i) {
            Object[] obj = (Object[])data.elementAt(i);
            if (obj == null) continue;
            for (int j2 = 0; j2 < obj.length; ++j2) {
                if (!columnDataExists[j2] && !tableModel.isEmptyColumnHidable(j2)) {
                    columnDataExists[j2] = true;
                    continue;
                }
                if (columnDataExists[j2] || obj[j2] == null || (strVal = obj[j2].toString()) == null || strVal.length() == 0) continue;
                columnDataExists[j2] = true;
            }
        }
        for (j = numColumns - 1; j >= 0; --j) {
            int c = table.convertColumnIndexToModel(j);
            if (c < 0 || columnDataExists[c] || editable && columnEditable != null && columnEditable[c]) continue;
            table.removeColumn(table.getColumnModel().getColumn(j));
        }
    }

    public void refresh() {
        this.refresh(this._table);
    }

    public void refresh(SnmpKTable table) {
        if (table == null) {
            table = this._table;
        }
        SmTableModel tableModel = (SmTableModel)table.getModel();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (table.isEditing()) {
                table.editingCanceled(null);
            }
            this._headerListener.reset(table);
            table.getSelectionModel().clearSelection();
            BrowserFrame.getInstance().setStatus(" ");
            tableModel.refresh();
            if (this._filter != null && this._filter.length != 0) {
                this.fetchTable(this._filter);
            } else if (this._mgmtDomain != null) {
                this.fetchTable(this._mgmtDomain, tableModel._isScalar);
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.displayTable();
        }
        catch (Exception e) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void details() throws Exception {
        SnmpKTable table = this._table;
        if (table == null) {
            table = this._popupTable;
        }
        SmTableModel tableModel = (SmTableModel)table.getModel();
        if (this._editDialog == null) {
            this._editDialog = new EditDialog(BrowserFrame.getInstance(), tableModel.getWrkingPeers(), this._editMethod, tableModel, table);
            this._editDialog.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), table, this._editDialog.getSize()));
        }
        String tabTitle = null;
        Container com = table.getParent().getParent().getParent();
        if (com instanceof JPanel) {
            com = com.getParent();
        }
        tabTitle = com instanceof JTabbedPane ? "/" + ((JTabbedPane)com).getTitleAt(((JTabbedPane)com).getSelectedIndex()) : "";
        this._editDialog.setTitle(this.getPanelTitle() + tabTitle + " Details");
        this._editDialog.get();
        this._editDialog.display();
    }

    public ArrayList<Object> getSelectedRowDataObject() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this._table == null) {
            return arrayList;
        }
        int[] selectedRowIndices = this._table.getSelectedRows();
        if (selectedRowIndices == null || selectedRowIndices.length == 0) {
            return arrayList;
        }
        SmTableModel tableModel = (SmTableModel)this._table.getModel();
        if (tableModel == null) {
            return arrayList;
        }
        Array tableModelData = tableModel.getData();
        if (tableModelData == null) {
            return arrayList;
        }
        int row = 0;
        Object[] rowData = null;
        Object rowDataObject = null;
        for (int i = 0; i < selectedRowIndices.length; ++i) {
            try {
                row = selectedRowIndices[i];
                rowData = (Object[])tableModelData.elementAt(row);
                if (rowData == null || (rowDataObject = rowData[rowData.length - 1]) == null) continue;
                arrayList.add(rowDataObject);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return arrayList;
    }

    JPopupMenu buildPopupMenu() {
        int i;
        JPopupMenu popupMenu = new JPopupMenu();
        String[][] popupAttri = this._newButtonAttr != null ? this._newButtonAttr : _ButtonAttr;
        for (i = 0; i < popupAttri.length; ++i) {
            ActionListener listener = null;
            listener = this._newButtonActListener == null ? this : (this._newButtonActListener[i] == null ? this : this._newButtonActListener[i]);
            popupMenu.add(Util.createMenuItem(popupAttri[i][1], popupAttri[i][2], listener));
        }
        if (this._tableModel != null) {
            int leadIndex = this._tableModel.getLeadSelectionIndex(this._table);
            this._tableModel.setLeadIndex(leadIndex);
            JMenuItem[] mapMenuItems = this._tableModel.getMapMenuItems();
            if (mapMenuItems != null && mapMenuItems.length > 0) {
                popupMenu.add(new JSeparator());
                for (int i2 = 0; i2 < mapMenuItems.length; ++i2) {
                    if (mapMenuItems[i2] != null) {
                        popupMenu.add(mapMenuItems[i2]);
                        continue;
                    }
                    popupMenu.add(new JSeparator());
                }
            }
        }
        block4: for (i = 1; i < popupMenu.getComponentCount(); ++i) {
            try {
                JMenuItem mi;
                ActionListener[] al;
                if (!(popupMenu.getComponent(i) instanceof JMenuItem) || (al = (mi = (JMenuItem)popupMenu.getComponent(i)).getActionListeners()) == null) continue;
                for (int j = 0; j < al.length; ++j) {
                    if (al[j] == null || !(al[j] instanceof MapAction)) continue;
                    ((MapAction)al[j]).validate(mi, SmMap.getSelectedMap());
                    continue block4;
                }
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return popupMenu;
    }

    void setPopupContext(JPopupMenu popupMenu, boolean detached) {
        JButton[] popupBtn = this._newTableButton != null ? this._newTableButton : this._tableButton;
        for (int i = 0; i < popupBtn.length; ++i) {
            String menu;
            boolean isTableBtnVisble = popupBtn[i].isVisible();
            if (!isTableBtnVisble) {
                ((JMenuItem)popupMenu.getComponent(i)).setVisible(isTableBtnVisble);
                continue;
            }
            if (detached && !(menu = ((JMenuItem)popupMenu.getComponent(i)).getText()).equals(_ButtonAttr[10][1]) && !menu.equals(_ButtonAttr[9][1])) {
                ((JMenuItem)popupMenu.getComponent(i)).setVisible(false);
                continue;
            }
            boolean enable = popupBtn[i].isEnabled() && isTableBtnVisble;
            ((JMenuItem)popupMenu.getComponent(i)).setEnabled(enable);
        }
    }

    public static boolean getConfirmRowDel() {
        return _ConfirmRowDeletion;
    }

    public void setDlgParent(JDialog parent) {
        this._dlgParent = parent;
    }

    public JDialog getDlgParent() {
        return this._dlgParent;
    }

    public JFrame getFrmParent() {
        return this._frmParent;
    }

    public void setHelpTag(String helpTag) {
        this._helpTag = helpTag;
    }

    public String getHelpTag() {
        return this._helpTag;
    }

    public InsertDialog getInsertDlg() {
        return this._insertDialog;
    }

    public void setRefreshChangedRow(boolean refreshChangedRow) {
        this._tableModel.setRefreshChangedRow(refreshChangedRow);
    }

    public void setDataViewModelIf(DataViewModelIf dataViewModelIf) {
        this._dataViewModelIf = dataViewModelIf;
    }

    public void setAllowAddRemoveColumn(boolean on) {
        if (this._headerListener != null) {
            this._headerListener.setAllowAddRemoveColumn(on);
        }
    }

    public void setSortable(boolean sortable) {
        if (this._headerListener != null) {
            this._headerListener.setSortable(sortable);
        }
    }

    public boolean getSortable() {
        if (this._headerListener != null) {
            return this._headerListener.getSortable();
        }
        return false;
    }

    public DataViewModelIf getDataViewModelIf() {
        return this._dataViewModelIf;
    }

    class DataViewMouseListener
    extends MouseAdapter {
        JPopupMenu _popupMenu;
        SnmpKTable _table;

        DataViewMouseListener(SnmpKTable table) {
            this._table = table;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.checkPopup(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.checkPopup(me);
        }

        private void checkPopup(MouseEvent me) {
            if (me.isPopupTrigger()) {
                int rowNumber;
                if (this._table != null && (rowNumber = this._table.rowAtPoint(new Point(me.getX(), me.getY()))) >= 0 && !this._table.isRowSelected(rowNumber)) {
                    this._table.addRowSelectionInterval(rowNumber, rowNumber);
                }
                this._popupMenu = DataView.this.buildPopupMenu();
                DataView.this.setPopupContext(this._popupMenu, this._table != DataView.this._table);
                DataView.this._popupTable = this._table;
                this._popupMenu.show(this._table, me.getX(), me.getY());
            }
        }
    }
}

