/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.ManageFabricThreadListenerIf;
import com.cisco.dcbu.sm.common.type.LanPK;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ManageLanThread
extends Thread {
    private List<LanPK> _lanList = new ArrayList<LanPK>();
    private boolean _keepWaiting = true;
    private boolean _doneAddingLans = false;
    private Component _component = null;
    private ManageFabricThreadListenerIf _listener = null;
    private Logger _logger = Logger.getLogger(this.getClass());

    public void addLan(LanPK pk) {
        this._logger.debug((Object)("ManageLanThread addLan() " + pk));
        this._lanList.add(pk);
    }

    public void removeLan(LanPK pk) {
        this._logger.debug((Object)("ManageLanThread removeLan() " + pk));
        this._lanList.remove(pk);
    }

    public void removeAllLans() {
        this._logger.debug((Object)"ManageLanThread removeAllLans() ");
        this._lanList.clear();
    }

    public void setComponent(Component component) {
        this._logger.debug((Object)"ManageLanThread setComponent()");
        this._component = component;
    }

    public void setListener(ManageFabricThreadListenerIf listener) {
        this._listener = listener;
    }

    public void doneAddingLans() {
        this._logger.debug((Object)"ManageLanThread doneAddingLans()");
        this._doneAddingLans = true;
    }

    @Override
    public void run() {
        this._logger.debug((Object)"ManageLanThread run()");
        this._keepWaiting = true;
        if (this._component != null) {
            this._logger.debug((Object)"ManageLanThread run() setCursor WAIT_CURSOR");
            this._component.setCursor(Cursor.getPredefinedCursor(3));
        }
        long time = System.currentTimeMillis();
        int j = 0;
        while (this._keepWaiting || !this._doneAddingLans) {
            try {
                ManageLanThread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this._logger.debug((Object)("ManageLanThread run() " + ++j));
            if (this._lanList.isEmpty()) {
                this._keepWaiting = false;
                continue;
            }
            for (int i = this._lanList.size() - 1; i >= 0; --i) {
                LanPK pk = this._lanList.get(i);
                if (pk == null) continue;
                try {
                    if (!ClientController.getInstance().isLanManaged(pk)) continue;
                    this.removeLan(pk);
                    if (this._listener == null) continue;
                    this._logger.debug((Object)"ManageLanThread run() handleFinished");
                    this._listener.handleFinished(pk);
                    if (this._component == null) continue;
                    this._logger.debug((Object)"ManageLanThread run() setCursor null");
                    this._component.setCursor(null);
                    continue;
                }
                catch (Exception e) {
                    this._logger.error((Object)e.getMessage(), (Throwable)e);
                    this.removeLan(pk);
                    if (this._listener == null) continue;
                    this._logger.debug((Object)"ManageLanThread run() handleFinished");
                    this._listener.handleFinished(pk);
                }
            }
            if (this._lanList.isEmpty()) {
                this._keepWaiting = false;
                continue;
            }
            if (System.currentTimeMillis() - time <= 60000L) continue;
            int retVal = JOptionPane.showConfirmDialog(this._component, "LAN discovery has not finished. Keep waiting?", "Keep waiting?", 0);
            if (retVal == 0) {
                time = System.currentTimeMillis();
                continue;
            }
            this._keepWaiting = false;
        }
        if (this._component != null) {
            this._logger.debug((Object)"ManageLanThread run() setCursor null");
            this._component.setCursor(null);
        }
    }
}

