/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.NewOpenDialogIf;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MoveFabricDialog
extends JDialog
implements ActionListener {
    private NewOpenDialogIf _openDialog;
    private List<String> serverIpList;
    private Logger _logger = Logger.getLogger(this.getClass());
    private JLabel[] _labels;
    protected JComponent[] _inputs;
    private static final int FABRIC_LIST = 0;
    private static final int SERVERS = 1;
    private final String[] _inputLabels = new String[]{"Fabrics/LANs To Move:", "Move To Server:"};
    private JButton _moveButton;
    private JButton _cancelButton;
    List<FabricPK> _fabricPksToMove;

    public MoveFabricDialog(JFrame openDialog, List<FabricPK> fabricPks) {
        super((Frame)openDialog, "Move Fabric/LAN - DCNM-SAN");
        this._openDialog = (NewOpenDialogIf)((Object)openDialog);
        this._fabricPksToMove = fabricPks;
        this.setDefaultCloseOperation(2);
        try {
            this.buildGUI();
            this.setModal(true);
            this.pack();
            this.setLocationRelativeTo(openDialog);
        }
        catch (Exception ex) {
            this._logger.error((Object)"move dialog not opened - exception", (Throwable)ex);
            Util.errorMessage((Component)openDialog, ex);
        }
    }

    public MoveFabricDialog(JDialog openDialog, List<FabricPK> fabricPks) {
        super((Dialog)openDialog, "Move Fabric/LAN - DCNM-SAN");
        this._openDialog = (NewOpenDialogIf)((Object)openDialog);
        this._fabricPksToMove = fabricPks;
        this.setDefaultCloseOperation(2);
        try {
            this.buildGUI();
            this.setModal(true);
            this.pack();
            this.setLocationRelativeTo(openDialog);
        }
        catch (Exception ex) {
            this._logger.error((Object)"move dialog not opened - exception", (Throwable)ex);
            Util.errorMessage((Component)openDialog, ex);
        }
    }

    private void buildGUI() throws Exception {
        this._inputs = new JComponent[this._inputLabels.length];
        JList<Object> fabricList = new JList<Object>(this._fabricPksToMove.toArray());
        fabricList.setEnabled(false);
        JScrollPane listScroller = new JScrollPane(fabricList);
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setVerticalScrollBarPolicy(22);
        this._inputs[0] = listScroller;
        this.serverIpList = ClientController.getInstance().getServerNodes();
        if (this.serverIpList == null) {
            throw new Exception("Unable to get the list of servers. List was null.");
        }
        if (this.serverIpList.size() == 1) {
            throw new Exception("Move is not allowed with only one server.");
        }
        JComboBox<Object> serversCombo = new JComboBox<Object>(this.serverIpList.toArray());
        serversCombo.setEditable(false);
        this._inputs[1] = serversCombo;
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        this._labels = DialogUtil.buildLabels(this._inputLabels);
        JPanel inputPanel = DialogUtil.buildPanel(this._labels, this._inputs);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        this._moveButton = new JButton("Move");
        this._moveButton.addActionListener(this);
        buttonPanel.add(this._moveButton);
        this._cancelButton = new JButton("Close");
        this._cancelButton.addActionListener(this);
        buttonPanel.add(this._cancelButton);
        main.add((Component)inputPanel, "Center");
        main.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)main, "Center");
        this.getRootPane().setDefaultButton(this._moveButton);
    }

    private void onClose() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String cmd = e.getActionCommand();
            char ch = cmd.charAt(0);
            if (ch == 'C') {
                this.onClose();
            } else if (ch == 'M') {
                this._moveButton.setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MoveFabricDialog.this.onMove();
                    }
                });
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private void onMove() {
        try {
            String toServer = ((JComboBox)this._inputs[1]).getSelectedItem().toString();
            toServer = this.serverIpList.get(((JComboBox)this._inputs[1]).getSelectedIndex());
            this.setCursor(Cursor.getPredefinedCursor(3));
            this._moveButton.setEnabled(false);
            SessionRif sessionRif = ClientController.getInstance().getServerSession();
            FMServerRif localServer = ClientController.getInstance().assertFMSConnection();
            FMServerRif remoteToServerRif = ClientController.getInstance().getRemoteFMServer(toServer);
            HashedArrayList<FabricPK> skipList = new HashedArrayList<FabricPK>();
            for (FabricPK nextFab : this._fabricPksToMove) {
                String existingServerIp = localServer.getServerForFabric(nextFab);
                if (existingServerIp == null) {
                    throw new Exception("Move aborted, unable to get the existing server IP address\nfor fabric:" + nextFab + ", please remove this fabric from the move list.");
                }
                if (!existingServerIp.equals(toServer)) continue;
                ((ArrayList)skipList).add(nextFab);
            }
            if (!skipList.isEmpty()) {
                Object[] msgAndList = new Object[2];
                msgAndList[0] = new String("Move for the following fabrics will be skipped as their \"from\" and \"to\" servers are the same:");
                JList<Object> displayList = new JList<Object>(skipList.toArray());
                JScrollPane scrPan = new JScrollPane(displayList);
                msgAndList[1] = scrPan;
                JOptionPane.showMessageDialog(this, msgAndList, "Fabric Move", 1);
            }
            int numSuccessfulMoves = 0;
            for (FabricPK nextFab : this._fabricPksToMove) {
                FMServerRif remoteFromServerRif;
                if (((ArrayList)skipList).contains(nextFab)) continue;
                if (nextFab instanceof LanPK) {
                    if (remoteToServerRif.hasHostedLan(sessionRif.getSSOToken())) {
                        throw new Exception("Cannot move the LAN to the server already hosting another LAN");
                    }
                    remoteFromServerRif = null;
                    try {
                        remoteFromServerRif = ClientController.getInstance().getFMServerFor(nextFab);
                        if (remoteFromServerRif == null) {
                            this._logger.warn((Object)("Cannot contact to the original server hosting LAN with LAN PK:" + nextFab + " remoteFromServerRif == null"));
                        }
                    }
                    catch (Exception ex) {
                        this._logger.warn((Object)("Cannot contact to the original server hosting LAN with LAN PK:" + nextFab), (Throwable)ex);
                    }
                    if (remoteFromServerRif != null) {
                        remoteFromServerRif.unHostLan((LanPK)nextFab, sessionRif.getSSOToken());
                    } else {
                        remoteToServerRif.unHostLan((LanPK)nextFab, sessionRif.getSSOToken());
                    }
                    remoteToServerRif.hostLan((LanPK)nextFab, sessionRif.getSSOToken());
                } else {
                    remoteFromServerRif = ClientController.getInstance().getFMServerFor(nextFab);
                    remoteFromServerRif.moveFabric(nextFab, true, sessionRif.getSSOToken());
                    remoteToServerRif.moveFabric(nextFab, false, sessionRif.getSSOToken());
                }
                ++numSuccessfulMoves;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (numSuccessfulMoves > 0) {
                JOptionPane.showMessageDialog(this, "Move Complete.", "Fabric/LAN Move", -1);
            }
            this.onClose();
        }
        catch (Exception ex) {
            this._logger.error((Object)"problem during move fabric", (Throwable)ex);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this._moveButton.setEnabled(true);
            Util.errorMessage((Component)this, ex);
        }
    }
}

