/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.common.type.FabricPK;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

class SanMapListener
implements PropertyChangeListener {
    private Logger _logger = Logger.getLogger(this.getClass());

    SanMapListener() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object obj = event.getSource();
        BrowserFrame.showServerStatus(true);
        if (obj == null) {
            return;
        }
        String prop = event.getPropertyName();
        if (prop == null || prop.equals("")) {
            return;
        }
        if (prop.equals("name") && event.getSource() instanceof Fabric) {
            BrowserFrame.getInstance().renameFabric((Fabric)event.getSource(), (String)event.getOldValue());
        }
        if (event.getSource() instanceof San && prop.equals("endOfEvents")) {
            String title;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("BrowserFrame: recieved end of event = " + event));
            }
            if ((title = BrowserFrame.getInstance().getDataPanelTitle()) == null || title.length() == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrowserFrame.getInstance().update();
                        SmCommand.sanMemberReport(BrowserFrame.getDataView(), "SAN", San.getInstance(), null, null, null);
                    }
                });
            }
        } else if (prop.equals("fabricAdded") || prop.equals("fabricAddedForResync")) {
            Fabric fabric;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("BrowserFrame: recieved fabric added event = " + event));
            }
            if ((fabric = (Fabric)event.getNewValue()) != null && BrowserFrame.getInstance().getTopologyWindow(fabric) == null) {
                BrowserFrame.getInstance().addFabric(fabric);
                BrowserFrame.getInstance().resetAllFabricMap();
            }
        } else if (prop.equals("fabricRemoved") || prop.equals("fabricRemovedForResync")) {
            FabricPK[] fs;
            Fabric fabric;
            boolean isResync = prop.equals("fabricRemovedForResync");
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("BrowserFrame: recieved fabric removed event = " + event));
            }
            if ((fabric = (Fabric)event.getOldValue()) != null && BrowserFrame.getInstance().getTopologyWindow(fabric) != null) {
                BrowserFrame.getInstance().removeFabric((FabricPK)fabric.getPK(), isResync);
            }
            if ((fs = San.getInstance().getFabricPKs()) == null || fs.length != 1) {
                BrowserFrame.getInstance().resetAllFabricMap();
            }
        } else if (prop.equals("resync")) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("BrowserFrame: recieved fabric resync event = " + event));
            }
            BrowserFrame.getInstance().resyncAllFabricMaps();
            BrowserFrame.getInstance().updateLan();
        }
    }
}

