/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.AsyncCallback;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public class SmCfsUtil {
    private static SmCfsUtil _Instance;
    HashMap _feature2Master = new HashMap();
    HashMap _feature2Peers2CfsState = new HashMap();
    static AsyncCallback _AsyncCallback;
    public static final int VIEW_CFG_FROM_ACTIVE = 1;
    public static final int VIEW_CFG_FROM_PENDING = 2;
    public static final int ACTION_ENABLE = 2;
    public static final int ACTION_DISABLE = 3;
    public static final int ACTION_COMMIT = 4;
    public static final int ACTION_ABORT = 5;
    public static final int ACTION_CLEAR = 6;
    public static final int ACTION_RESULT_NONE = 1;
    public static final int ACTION_RESULT_SUCCESS = 2;
    public static final int ACTION_RESULT_FAILED = 3;
    public static final int ACTION_RESULT_INPROGRESS = 4;
    public static final int CFS_OPER_STATUS_UNKNOWN = 1;
    public static final int CFS_OPER_STATUS_ENABLED = 2;
    public static final int CFS_OPER_STATUS_DISABLED = 3;
    public static final int[] _cfsFeatureOpActionOid;
    public static final int[] _cfsFeatureOpScopeTypeOid;
    public static final int[] _cfsFeatureOpScopeValOid;
    public static final int[] _cfsFeatureOpShowCfgOptionOid;
    public static final int[] _cfsFeatureOpLastActionOid;
    public static final int[] _cfsFeatureOpLastActionResultOid;
    public static final int[] _cfsFeatureOpLastFailureReasonOid;
    public static final int[] _cfsFeatureOpExtShowCfgOptionOid;
    public static final int[] _cfsFeatureOpExtLastActionOid;
    public static final int[] _cfsFeatureOpExtLastActionResultOid;
    public static final int[] _cfsFeatureOpExtLastFailureReasonOid;
    public static final int[] _cfsPendingConfOwnerAddrTypeOid;
    public static final int[] _ccfsPendingConfOwnerAddrOid;
    public static final int[] _cfsPendingConfOwnerIDOid;
    public static final String[] CFS_FEATURE_LIST;
    public static boolean _PromptCFSWarning;

    public static SmCfsUtil getInstance() {
        if (_Instance == null) {
            _Instance = new SmCfsUtil();
        }
        return _Instance;
    }

    private SmCfsUtil() {
    }

    public void addMaster(String feature, SnmpPeer master) {
        this._feature2Master.put(feature, master);
    }

    public void removeMaster(String feature) {
        this._feature2Master.remove(feature);
    }

    public SnmpPeer getMaster(String feature) {
        return (SnmpPeer)this._feature2Master.get(feature);
    }

    public int[] getFeatureIndex(String featureName, SnmpPeer peer) {
        if (featureName.equalsIgnoreCase("port-security") && SmCfsUtil.isN5KOrN7K(peer.getAddress().getHostAddress())) {
            featureName = "fc-port-security";
        }
        byte[] b = featureName.getBytes();
        int[] featureindex = new int[b.length + 1];
        featureindex[0] = b.length;
        for (int i = 0; i < b.length; ++i) {
            featureindex[i + 1] = b[i] & 0xFF;
        }
        return featureindex;
    }

    public static boolean isN5KOrN7K(String swIP) {
        try {
            InetAddress iAdd = InetAddress.getByName(swIP);
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(iAdd);
            if (sw == null) {
                return false;
            }
            if (sw.isN5K() || sw.isN7K()) {
                return true;
            }
        }
        catch (UnknownHostException exx) {
            return false;
        }
        return false;
    }

    public void addFeaturePeerCfsState(String feature, SnmpPeer peer, int state) {
        HashMap<SnmpPeer, Integer> peers2CfsState = (HashMap<SnmpPeer, Integer>)this._feature2Peers2CfsState.get(feature);
        if (peers2CfsState == null) {
            peers2CfsState = new HashMap<SnmpPeer, Integer>();
            this._feature2Peers2CfsState.put(feature, peers2CfsState);
        }
        peers2CfsState.put(peer, new Integer(state));
    }

    public int getPeerCfsState(String feature, SnmpPeer peer) {
        Integer intState;
        HashMap peers2CfsState = (HashMap)this._feature2Peers2CfsState.get(feature);
        if (peers2CfsState != null && (intState = (Integer)peers2CfsState.get(peer)) != null) {
            return intState;
        }
        return 1;
    }

    public void processCfs(SmTableModel table, String feature, Vsan cfsVsan, int viewFrom) throws SnmpException {
        if (feature != null) {
            SnmpPeer master;
            String lookupIndex = feature;
            if (cfsVsan != null) {
                lookupIndex = feature + Integer.toString(cfsVsan.getVsanId());
            }
            if ((master = (SnmpPeer)this._feature2Master.get(lookupIndex)) != null) {
                int[] oid;
                int[] index;
                if (cfsVsan != null) {
                    int[] featureIndex = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                    int vsanId = cfsVsan.getVsanId();
                    byte[] b = SnmpIntList.valueOf(new int[]{vsanId});
                    int[] vsanValIndex = SnmpString.valueOf(b, true);
                    index = new int[featureIndex.length + b.length + 2];
                    System.arraycopy(featureIndex, 0, index, 0, featureIndex.length);
                    index[featureIndex.length] = 2;
                    System.arraycopy(vsanValIndex, 0, index, featureIndex.length + 1, vsanValIndex.length);
                    oid = _cfsFeatureOpExtShowCfgOptionOid;
                } else {
                    index = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                    oid = _cfsFeatureOpShowCfgOptionOid;
                }
                VarBindList vbl = new VarBindList();
                vbl.add(new SnmpVarBind(new SnmpOID(oid, index), new SnmpInt(viewFrom)));
                SnmpPDU pdu = new SnmpPDU(-93, vbl);
                pdu.setIgnoreSetCount(true);
                master.set(pdu);
                if (table != null && table.getCfsPanel() != null) {
                    table.getCfsPanel().getButton(viewFrom == 1 ? 0 : 1).setSelected(true);
                }
            }
        }
    }

    public void setCfsAction(SmTableModel table, String feature, Vsan cfsVsan, int action) throws SnmpException {
        if (feature != null) {
            int[] lastFailureRsnOid;
            int[] lastActionRstOid;
            int[] viewOid;
            int[] index;
            String lookupIndex = feature;
            if (cfsVsan != null) {
                lookupIndex = feature + Integer.toString(cfsVsan.getVsanId());
            }
            SnmpPeer master = (SnmpPeer)this._feature2Master.get(lookupIndex);
            byte[] vsanB = new byte[]{};
            if (cfsVsan != null) {
                int[] featureIndex = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                int vsanId = cfsVsan.getVsanId();
                vsanB = SnmpIntList.valueOf(new int[]{vsanId});
                int[] vsanValIndex = SnmpString.valueOf(vsanB, true);
                index = new int[featureIndex.length + vsanB.length + 2];
                System.arraycopy(featureIndex, 0, index, 0, featureIndex.length);
                index[featureIndex.length] = 2;
                System.arraycopy(vsanValIndex, 0, index, featureIndex.length + 1, vsanValIndex.length);
                viewOid = _cfsFeatureOpExtShowCfgOptionOid;
                lastActionRstOid = _cfsFeatureOpExtLastActionResultOid;
                lastFailureRsnOid = _cfsFeatureOpExtLastFailureReasonOid;
            } else {
                index = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                viewOid = _cfsFeatureOpShowCfgOptionOid;
                lastActionRstOid = _cfsFeatureOpLastActionResultOid;
                lastFailureRsnOid = _cfsFeatureOpLastFailureReasonOid;
            }
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(_cfsFeatureOpActionOid, this.getFeatureIndex(feature, master)), new SnmpInt(action)));
            if ((action == 4 || action == 5 || action == 6) && cfsVsan != null) {
                vbl.add(new SnmpVarBind(new SnmpOID(_cfsFeatureOpScopeTypeOid, this.getFeatureIndex(feature, master)), new SnmpInt(2)));
                vbl.add(new SnmpVarBind(new SnmpOID(_cfsFeatureOpScopeValOid, this.getFeatureIndex(feature, master)), new SnmpString(vsanB)));
            }
            SnmpPDU pdu = new SnmpPDU(-93, vbl);
            master.set(pdu);
            int result = 4;
            String failureReason = "";
            SnmpPDU monitor = new SnmpPDU(-96, new VarBindList());
            monitor.addVar(new SnmpOID(lastActionRstOid, index));
            monitor.addVar(new SnmpOID(lastFailureRsnOid, index));
            SnmpPDU resp = null;
            int numTrys = 0;
            while (result == 4 && numTrys < 15) {
                resp = master.set(monitor);
                result = resp.getVariables().intValue(0);
                failureReason = resp.getVariables().stringValue(1);
                if (result == 3 || result == 2) break;
                ++numTrys;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
            if (result == 2) {
                String actCmd = "Committed";
                if (action == 5) {
                    actCmd = "Aborted";
                } else if (action == 6) {
                    actCmd = "Cleared";
                }
                BrowserFrame.getInstance().setStatus("CFS(" + feature + "):" + actCmd);
                vbl = new VarBindList();
                pdu = new SnmpPDU(-93, vbl);
                vbl.add(new SnmpVarBind(new SnmpOID(viewOid, index), new SnmpInt(1)));
                master.set(pdu);
                if (table != null && table.getCfsPanel() != null) {
                    table.getCfsPanel().getButton(0).setSelected(true);
                }
            } else if (result == 3) {
                throw new SnmpException(failureReason);
            }
        }
    }

    public int getCfsView(String feature, Vsan cfsVsan) throws SnmpException {
        if (feature != null) {
            SnmpPeer master;
            String lookupIndex = feature;
            if (cfsVsan != null) {
                lookupIndex = feature + Integer.toString(cfsVsan.getVsanId());
            }
            if ((master = (SnmpPeer)this._feature2Master.get(lookupIndex)) != null) {
                int[] oid;
                int[] index;
                if (cfsVsan != null) {
                    int[] featureIndex = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                    int vsanId = cfsVsan.getVsanId();
                    byte[] b = SnmpIntList.valueOf(new int[]{vsanId});
                    int[] vsanValIndex = SnmpString.valueOf(b, true);
                    index = new int[featureIndex.length + b.length + 2];
                    System.arraycopy(featureIndex, 0, index, 0, featureIndex.length);
                    index[featureIndex.length] = 2;
                    System.arraycopy(vsanValIndex, 0, index, featureIndex.length + 1, vsanValIndex.length);
                    oid = _cfsFeatureOpExtShowCfgOptionOid;
                } else {
                    index = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                    oid = _cfsFeatureOpShowCfgOptionOid;
                }
                VarBindList vbl = new VarBindList();
                vbl.add(new SnmpVarBind(new SnmpOID(oid, index)));
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                SnmpPDU resp = master.send(pdu);
                return resp.getVariables().intValue(0);
            }
        }
        return -1;
    }

    public boolean isCfsPending(String feature, Vsan cfsVsan) throws SnmpException {
        if (feature != null) {
            SnmpPeer master;
            String lookupIndex = feature;
            if (cfsVsan != null) {
                lookupIndex = feature + Integer.toString(cfsVsan.getVsanId());
            }
            if ((master = (SnmpPeer)this._feature2Master.get(lookupIndex)) != null) {
                int[] index;
                if (cfsVsan != null) {
                    int[] featureIndex = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                    int vsanId = cfsVsan.getVsanId();
                    byte[] b = SnmpIntList.valueOf(new int[]{vsanId});
                    int[] vsanValIndex = SnmpString.valueOf(b, true);
                    index = new int[featureIndex.length + b.length + 2];
                    System.arraycopy(featureIndex, 0, index, 0, featureIndex.length);
                    index[featureIndex.length] = 2;
                    System.arraycopy(vsanValIndex, 0, index, featureIndex.length + 1, vsanValIndex.length);
                } else {
                    index = SmCfsUtil.getInstance().getFeatureIndex(feature, master);
                }
                VarBindList vbl = new VarBindList();
                vbl.add(new SnmpVarBind(new SnmpOID(_cfsPendingConfOwnerAddrTypeOid, index)));
                vbl.add(new SnmpVarBind(new SnmpOID(_ccfsPendingConfOwnerAddrOid, index)));
                vbl.add(new SnmpVarBind(new SnmpOID(_cfsPendingConfOwnerIDOid, index)));
                SnmpPDU resp = SnmpFetch.getBulk(master, 5 * vbl.size(), vbl);
                vbl = resp.getVariables();
                String ipAddress = "";
                for (int m = 0; m < resp.getVariables().size(); m += 3) {
                    int type = vbl.intValue(m);
                    if (type == 1) {
                        ipAddress = SnmpIpAddress.toString(vbl.byteValue(m + 1));
                        try {
                            if (master.getAddress().equals(InetAddress.getByAddress(vbl.byteValue(m + 1)))) {
                                return true;
                            }
                        }
                        catch (UnknownHostException ex) {}
                        continue;
                    }
                    SnmpString lockDns = new SnmpString(vbl.byteValue(m + 1));
                    ipAddress = lockDns.toString();
                    try {
                        InetAddress addr = InetAddress.getByName(ipAddress);
                        if (!addr.equals(master.getAddress())) continue;
                        return true;
                    }
                    catch (UnknownHostException ex) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    static {
        _AsyncCallback = new AsyncCallback();
        _cfsFeatureOpActionOid = MibNode.get("cfsFeatureOpAction").getOid();
        _cfsFeatureOpScopeTypeOid = MibNode.get("cfsFeatureOpScopeType").getOid();
        _cfsFeatureOpScopeValOid = MibNode.get("cfsFeatureOpScopeVal").getOid();
        _cfsFeatureOpShowCfgOptionOid = MibNode.get("cfsFeatureOpShowCfgOption").getOid();
        _cfsFeatureOpLastActionOid = MibNode.get("cfsFeatureOpLastAction").getOid();
        _cfsFeatureOpLastActionResultOid = MibNode.get("cfsFeatureOpLastActionResult").getOid();
        _cfsFeatureOpLastFailureReasonOid = MibNode.get("cfsFeatureOpLastFailureReason").getOid();
        _cfsFeatureOpExtShowCfgOptionOid = MibNode.get("cfsFeatureOpExtShowCfgOption").getOid();
        _cfsFeatureOpExtLastActionOid = MibNode.get("cfsFeatureOpExtLastAction").getOid();
        _cfsFeatureOpExtLastActionResultOid = MibNode.get("cfsFeatureOpExtLastActionResult").getOid();
        _cfsFeatureOpExtLastFailureReasonOid = MibNode.get("cfsFeatureOpExtLastFailureReason").getOid();
        _cfsPendingConfOwnerAddrTypeOid = MibNode.get("cfsPendingConfOwnerAddrType").getOid();
        _ccfsPendingConfOwnerAddrOid = MibNode.get("cfsPendingConfOwnerAddr").getOid();
        _cfsPendingConfOwnerIDOid = MibNode.get("cfsPendingConfOwnerID").getOid();
        CFS_FEATURE_LIST = new String[]{"ivr", "ntp", "dpvm", "isns", "role", "vsan", "radius", "tacacs", "syslogd", "callhome", "device-alias", "port-security"};
        _PromptCFSWarning = true;
    }
}

