/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.IntHashMap;
import java.util.ArrayList;

public class SmFeatureCtrlUtil {
    private static SmFeatureCtrlUtil _Instance;
    IntHashMap _feature2Peers = new IntHashMap();

    public static SmFeatureCtrlUtil getInstance() {
        if (_Instance == null) {
            _Instance = new SmFeatureCtrlUtil();
        }
        return _Instance;
    }

    private SmFeatureCtrlUtil() {
    }

    public void addPeer(int featureIndex, SnmpPeer peer) {
        ArrayList<SnmpPeer> peers = (ArrayList<SnmpPeer>)this._feature2Peers.get(featureIndex);
        if (peers == null) {
            peers = new ArrayList<SnmpPeer>();
            this._feature2Peers.put(featureIndex, peers);
        }
        if (!peers.contains(peer)) {
            peers.add(peer);
        }
    }

    public void removePeer(int featureIndex, SnmpPeer peer) {
        ArrayList peers = (ArrayList)this._feature2Peers.get(featureIndex);
        if (peers != null && peers.contains(peer)) {
            peers.remove(peer);
        }
    }

    public void clearPeer(int featureIndex) {
        this._feature2Peers.remove(featureIndex);
    }

    public SnmpPeer[] getPeers(int featureIndex) {
        ArrayList peers = this.getPeerList(featureIndex);
        if (peers == null) {
            return null;
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    public ArrayList getPeerList(int featureIndex) {
        return (ArrayList)this._feature2Peers.get(featureIndex);
    }
}

