/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshDumpAdv;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.SM;
import com.cisco.dcbu.sm.client.aaa.AAAWizard;
import com.cisco.dcbu.sm.client.cat.CatDialog;
import com.cisco.dcbu.sm.client.cat.PingDialog;
import com.cisco.dcbu.sm.client.cat.RdlDialog;
import com.cisco.dcbu.sm.client.cfs.callhome.CallHomeWizard;
import com.cisco.dcbu.sm.client.cfs.dpvm.DPVMConfigWizard;
import com.cisco.dcbu.sm.client.cfs.ps.PortSecurityWizard;
import com.cisco.dcbu.sm.client.datamig.DataMigWizard;
import com.cisco.dcbu.sm.client.dialogs.SmRmonAlarmHCTableModel;
import com.cisco.dcbu.sm.client.dmmsewizard.DmmPreWizard;
import com.cisco.dcbu.sm.client.dmmsewizard.SePreWizard;
import com.cisco.dcbu.sm.client.event.EventLog;
import com.cisco.dcbu.sm.client.fa.wizard.FAMoveWizard;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigWizard;
import com.cisco.dcbu.sm.client.fa.wizard.FAReplaceWizard;
import com.cisco.dcbu.sm.client.fa.wizard.FAWizard;
import com.cisco.dcbu.sm.client.fc.FabricChecker;
import com.cisco.dcbu.sm.client.fcip.FcipWizard;
import com.cisco.dcbu.sm.client.fcoe.wizard.FCoEConfigurationWizard;
import com.cisco.dcbu.sm.client.gui.AddFabricDialog;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.ControlPanel;
import com.cisco.dcbu.sm.client.gui.ControlPanelFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.LoginFrame;
import com.cisco.dcbu.sm.client.gui.SmCloseListenerIf;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.gui.tools.FlashChecker;
import com.cisco.dcbu.sm.client.gui.tools.FlowConfigWizard;
import com.cisco.dcbu.sm.client.gui.tools.FlowLoadBalance;
import com.cisco.dcbu.sm.client.gui.tools.HealthAnalysis;
import com.cisco.dcbu.sm.client.gui.tools.IpFilterWizard;
import com.cisco.dcbu.sm.client.gui.tools.LunDiscovery;
import com.cisco.dcbu.sm.client.gui.tools.RunCLICommands;
import com.cisco.dcbu.sm.client.gui.tools.ShowTechSupport;
import com.cisco.dcbu.sm.client.gui.tools.SubnetSweep;
import com.cisco.dcbu.sm.client.hostcom.HostCommisioningWizard;
import com.cisco.dcbu.sm.client.ioa.IOADialog;
import com.cisco.dcbu.sm.client.iscsi.IscsiWizard;
import com.cisco.dcbu.sm.client.license.LicenseWizard;
import com.cisco.dcbu.sm.client.linksecurity.LinkSecurityWizard;
import com.cisco.dcbu.sm.client.logicaltree.VsanTree;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeAction;
import com.cisco.dcbu.sm.client.logicaltree.ZoneSetTreeNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.map.actions.CopyAction;
import com.cisco.dcbu.sm.client.map.actions.DMMapAction;
import com.cisco.dcbu.sm.client.map.actions.FcspAction;
import com.cisco.dcbu.sm.client.map.actions.HighlightAction;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.map.actions.LoginMapAction;
import com.cisco.dcbu.sm.client.map.actions.MiscMapActions;
import com.cisco.dcbu.sm.client.map.actions.OverViewMapAction;
import com.cisco.dcbu.sm.client.map.actions.ZoomMapAction;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.npv.NPVUtil;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.NpvCFSSetup;
import com.cisco.dcbu.sm.client.npv.wizard.NpvSetupWizard;
import com.cisco.dcbu.sm.client.npv.wizard.TESetupWizard;
import com.cisco.dcbu.sm.client.portchnl.PChnlWizard;
import com.cisco.dcbu.sm.client.pref.PrefDialogSM;
import com.cisco.dcbu.sm.client.qos.QosConfigWizard;
import com.cisco.dcbu.sm.client.rmon.RmonWizard;
import com.cisco.dcbu.sm.client.se.SecureEraseWizard;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import com.cisco.dcbu.sm.client.zm.common.SmIvrZoneSwitch;
import com.cisco.dcbu.sm.client.zm.common.TracePortPath;
import com.cisco.dcbu.sm.client.zm.merge.ZMergeDialog;
import com.cisco.dcbu.sm.client.zm.migrate.Main;
import com.cisco.dcbu.sm.client.zm.zoneconfig.EnableIVRDlg;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialog;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneMerge;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneMergeReport;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.licmgr.LicenseCapabilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class UIActions
implements ActionListener {
    private static UIActions _Instance;
    Array _closeActionListeners;
    IOADialog _ioaDialog;
    ZoneDialog _zoneDialog;
    ZoneDialog _ivrZoneDialog;
    ZoneMerge _zoneMerge;
    ZoneMergeReport _zoneMergeReportDialog;
    FabricChecker _fabricChecker;
    CatDialog _catDialog;
    HealthAnalysis _healthCheckDlg;
    ShowTechSupport _showTechSupportDlg;
    RunCLICommands _runCliCommands;
    FlashChecker _flashChecker;
    TracePortPath _tracePath;
    HostCommisioningWizard _hostprovision;
    PortSecurityWizard _portSecurityWiz;
    private Logger _logger = Logger.getLogger(this.getClass());
    LunDiscovery _lunDiscoverDlg;
    private SwitchButton _mButton;
    private boolean _cancel;
    private JDialog _dialog;
    private HashMap<String, SnmpPeer> _changedPeers = new HashMap();
    private int _perspectiveVariant;
    final int WEB_SERVER_SCHEME = 0;
    final int WEB_SERVER_PORT = 1;

    private UIActions() {
        this._closeActionListeners = new Array();
    }

    public static UIActions getInstance() {
        if (_Instance == null) {
            _Instance = new UIActions();
        }
        return _Instance;
    }

    public void open(ActionEvent e) {
        this.quitWithoutSavingConfig(false);
        if (this._cancel) {
            if (!ClientController.getInstance().isServerActive()) {
                JOptionPane.showMessageDialog(null, "Server is not active. You need to login first.");
                LoginFrame.getInstance().setVisible(true);
            } else {
                try {
                    SmMap.SaveAll();
                    ClientController.getInstance().showOpenDialog();
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                }
            }
        }
    }

    public void resync(ActionEvent e) {
        this.quitWithoutSavingConfig(false);
        if (this._cancel) {
            if (!ClientController.getInstance().isServerActive()) {
                JOptionPane.showMessageDialog(null, "Server is not active. You need to login first.");
                LoginFrame.getInstance().setVisible(true);
            } else {
                try {
                    if (ClientController.getInstance().startResync()) {
                        SmMap.SaveAll();
                        ControlPanel.resync();
                    }
                }
                catch (Exception ex) {
                    ClientController.getInstance().setResyncComplete();
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                }
            }
        }
    }

    public void discoverNewFabric(ActionEvent e) {
        String switchIP = null;
        System.out.println("UIActions.discoverNewFabric context.getSwitchIP()=" + switchIP);
        boolean wantCDPDiscovery = false;
        AddFabricDialog d = new AddFabricDialog(ControlPanelFrame.getInstance(false), true, wantCDPDiscovery);
        Object source = e.getSource();
        if (source != null && source instanceof ClientContext) {
            d.setContext((ClientContext)source);
        }
        d.setVisible(true);
    }

    public void discoverLuns(ActionEvent e) {
        try {
            ClientController.getInstance().rediscover(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    public void rediscover(ActionEvent e) {
        try {
            ClientController.getInstance().rediscover();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    public void locateSwitches(ActionEvent e) {
        new SubnetSweep(BrowserFrame.getInstance()).setVisible(true);
    }

    public void preferences(ActionEvent e) {
        PrefDialogSM _prefDlg = PrefDialogSM.getInstance(BrowserFrame.getInstance(), "DCNM-SAN");
        _prefDlg.setVisible(true);
    }

    public void exportTable(ActionEvent e) {
        BrowserFrame.getDataView().export();
    }

    public void printTable(ActionEvent e) {
        try {
            BrowserFrame.getDataView().print();
        }
        catch (PrinterException ex) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
        }
    }

    public void printMap(ActionEvent e) {
        MiscMapActions.getInstance().print();
    }

    public void saveMap(ActionEvent e) {
        MiscMapActions.getInstance().save();
    }

    public void exportToVisio(ActionEvent e) {
        MiscMapActions.getInstance().export2Visio(false);
    }

    public void exportToVisioWithLinkLabels(ActionEvent e) {
        MiscMapActions.getInstance().export2Visio(true);
    }

    public void serverExportToVisio(ActionEvent e) {
        MiscMapActions.getInstance().serverExport2Visio(false);
    }

    public void serverExportToVisioWithLinkLabels(ActionEvent e) {
        MiscMapActions.getInstance().serverExport2Visio(true);
    }

    public void refreshMap(ActionEvent e) {
        MiscMapActions.getInstance().refreshMap();
    }

    private void showSingleFabricErrorMessage() {
        JOptionPane.showMessageDialog(BrowserFrame.getInstance(), "This operation is valid for single fabric selection.", "Error", 0);
    }

    public void loadBalance(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        new FlowLoadBalance(BrowserFrame.getInstance()).setVisible(true);
    }

    public void exit(ActionEvent e) {
        this.closeAction();
    }

    public void mapCopy(ActionEvent e) {
        CopyAction.getInstance().copy();
    }

    public void legend(ActionEvent e) {
        MiscMapActions.getInstance().legend();
    }

    public void filter(ActionEvent e) {
        MiscMapActions.getInstance().filter();
    }

    public void mapFind(ActionEvent e) {
        MiscMapActions.getInstance().find();
    }

    public void resetJIDELayout(ActionEvent e) {
        BrowserFrame.getInstance().resetJIDELayout();
    }

    public void selectNextView(ActionEvent e) {
        BrowserFrame.getInstance().selectNextView();
    }

    public void selectPreviousView(ActionEvent e) {
        BrowserFrame.getInstance().selectPreviousView();
    }

    public void selectPerspectiveMode(ActionEvent e) {
        String perspectiveName = ((JMenuItem)e.getSource()).getText();
        int variant = this.getPerspectiveVariant(perspectiveName);
        if (variant == this._perspectiveVariant && UIControls.getInstance().getPerspectiveName().equals(perspectiveName)) {
            return;
        }
        ClientController.getInstance().getPerspective(perspectiveName, variant);
        this._perspectiveVariant = variant;
        UIControls.getInstance().setPerspectiveView(perspectiveName, variant, true);
        this.updateSimpleModeDisplay(true);
    }

    public void cancelLayout(ActionEvent e) {
        LayoutAction.getInstance().actionPerformed(e);
    }

    public void springLayout(ActionEvent e) {
        LayoutAction.getInstance().actionPerformed(e);
    }

    public void quickLayout(ActionEvent e) {
        LayoutAction.getInstance().actionPerformed(e);
    }

    public void clearHighlight(ActionEvent e) {
        HighlightAction.getInstance().clearHighlight();
    }

    public void eventClear(ActionEvent e) {
        EventLog.getInstance().clear();
    }

    public void eventRemove(ActionEvent e) {
        EventLog.getInstance().remove();
    }

    public void logCopy(ActionEvent e) {
        BrowserFrame.getLog().copy();
    }

    public void logClear(ActionEvent e) {
        BrowserFrame.getLog().setText(null);
        System.gc();
    }

    public void logStats(ActionEvent e) throws Exception {
        ClientController.getSnmpSession();
        DefaultLogger._DefLogger.debug((Object)SnmpSession.getStatsInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logExport(ActionEvent e) throws Exception {
        String fName = Util.getFileName(BrowserFrame.getInstance(), "Export Log - DCNM-SAN", ClientController.getInstance().getFabric().getName() + "_log.txt", 1, null, true);
        if (fName != null) {
            try (FileWriter out = null;){
                out = new FileWriter(fName);
                BrowserFrame.getLog().write(out);
                out.close();
            }
        }
    }

    public void createVsan(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        DataView dv = BrowserFrame.getDataView();
        dv._filter = null;
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        if (mgmtDomain.isVsan() || mgmtDomain.isZone()) {
            mgmtDomain = ClientController.getInstance().getFabric();
        }
        SmCommand.vsanTableOnly(BrowserFrame.getDataView(), mgmtDomain.getPath('/') + "/VSAN Attributes", mgmtDomain, null, null, null);
        dv.insert();
    }

    public void licenseInstall(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        new LicenseWizard(BrowserFrame.getInstance(), ClientController.getInstance().getSelectedDomain().getSnmpPeers()).setVisible(true);
    }

    public void ioaManager(ActionEvent e) throws Exception {
        if (SM._FmStandalone) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "IOA Manager is not supported in stand alone mode.");
        } else {
            if (!this.validateSANDomain()) {
                return;
            }
            this.invokeIOAMgr();
        }
    }

    public void editIvrOrRegularZones(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTree.getInstance().invokeZoneMgr(VsanTree.getInstance().isIvrNode(VsanTree.getInstance().getSelectionPath()));
    }

    public void editZones(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTree.getInstance().invokeZoneMgr(false);
    }

    public void editIvrZones(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTree.getInstance().invokeZoneMgr(true);
    }

    public void wizardZonesOnContext(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            ZoneMemWizard.launchIvrWizard(BrowserFrame.getInstance(), ClientController.getInstance().getFabric(), null, null);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void ivrWizardZones(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            ZoneMemWizard.launchIvrWizard(BrowserFrame.getInstance(), ClientController.getInstance().getFabric(), null, null);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    public void deactivateIvrZoneset(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTree.getInstance().invokeDeactivateZnst(true);
    }

    public void deactivateZoneset(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTree.getInstance().invokeDeactivateZnst(false);
    }

    public void copyZoneset(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTree.getInstance().invokeCopyZnst(false);
    }

    public void copyIvrZoneset(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTree.getInstance().invokeCopyZnst(true);
    }

    public void copyActiveTopology(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        VsanTreeAction.getInstance().copyIvrTopology();
    }

    public void mergeZoneset(ActionEvent e) throws Exception {
        SnmpPeer[] peerLst;
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        Vsan v = VsanTree.getInstance().getCurVsan();
        if (null == v) {
            v = ClientController.getInstance().getFabric().getVsans()[0];
        }
        if ((peerLst = v.getSnmpPeers(true, true)).length == 0) {
            throw new SnmpException("No switches are available");
        }
        this.invokeZoneMerge(null, v);
    }

    public void fabricChecker(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        Fabric f = ClientController.getInstance().getFabric();
        if (f == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(f)) {
            return;
        }
        if (this._fabricChecker != null) {
            this._fabricChecker.dispose();
            this._fabricChecker = null;
        }
        this._fabricChecker = new FabricChecker(BrowserFrame.getInstance(), f.getSnmpPeers());
        this._fabricChecker.setVisible(true);
    }

    public void createPortChannel(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        PChnlWizard.createPortChannel(BrowserFrame.getInstance(), false);
    }

    public void fcoeConfigWizard(ActionEvent e) {
        try {
            FCoEConfigurationWizard.getInstance(BrowserFrame.getInstance());
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    private SnmpPeer[] getSnmpPeersForSelectedDomain(boolean needQuail) {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        Switch[] switches = ClientController.getInstance().getSelectedDomain().getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                if (!sw.isMDS() && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
                peers.add(sw.getPeer());
            }
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    public void upgradeWizard(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        UpgradeWizard wiz = new UpgradeWizard(BrowserFrame.getInstance(), this.getSnmpPeersForSelectedDomain(true));
        wiz.setVisible(true);
    }

    public void upgradeTest(ActionEvent e) {
        UpgradeWizard wiz = new UpgradeWizard(BrowserFrame.getInstance(), ClientController.getInstance().getSelectedDomain().getSnmpPeers(true));
        wiz.setVisible(true);
    }

    public void createRmonFromTop(ActionEvent e) throws Exception {
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        DataView dv = BrowserFrame.getDataView();
        dv._filter = null;
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        SmCommand.rmonTab(BrowserFrame.getDataView(), mgmtDomain.getPath('/') + "/RMON", mgmtDomain, null, "rmonAlarmsHC", null);
        this.createRmon(e);
    }

    public void createRmon(ActionEvent e) {
        BrowserFrame.getInstance();
        SmTableModel tableModel = BrowserFrame.getDataView()._tableModel;
        boolean isRmon64TableModel = tableModel != null && tableModel instanceof SmRmonAlarmHCTableModel;
        RmonWizard wiz = new RmonWizard(BrowserFrame.getInstance(), ClientController.getInstance().getSelectedDomain(), isRmon64TableModel ? tableModel.getData() : null);
        wiz.setVisible(true);
    }

    public void sanextensiontunerWizard(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        if (!AttributesAction.getSharedInstance().isSelectedSingleFcipLink()) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select a valid FCIP link from the map.");
            return;
        }
        AttributesAction.getSharedInstance().invokeSanExtTuner();
    }

    public void ipFilterWizard(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        Switch[] sws = ClientController.getInstance().getFabric().getSwitches();
        ArrayList<Switch> newSwList = new ArrayList<Switch>();
        for (Switch sw : sws) {
            boolean notSupported = false;
            for (int modelType : FRUConstants.getAllN7KTypes()) {
                if (modelType != sw.getModelType()) continue;
                notSupported = true;
                break;
            }
            if (notSupported) continue;
            newSwList.add(sw);
        }
        new IpFilterWizard(BrowserFrame.getInstance(), newSwList.toArray(new Switch[newSwList.size()])).setVisible(true);
    }

    public void qosWizard(ActionEvent e) {
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        new QosConfigWizard(BrowserFrame.getInstance()).setVisible(true);
    }

    public void flowConfig(ActionEvent e) {
        block4: {
            try {
                if (ClientController.getInstance().getFabric() == null) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select a fabric node");
                    return;
                }
                if (ClientController.getInstance().checkInstallLicense(LicenseCapabilities.Features.PM)) {
                    new FlowConfigWizard(BrowserFrame.getInstance()).setVisible(true);
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                if (!SnmpSession.isTrace()) break block4;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void createFCIPTunnel(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        try {
            new FcipWizard(BrowserFrame.getInstance()).setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchPortSecurityWizard(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            if (this._portSecurityWiz != null) {
                this._portSecurityWiz.dispose();
                this._portSecurityWiz = null;
            }
            this._portSecurityWiz = VsanTree.getInstance().invokePortSecurityWizard();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchDpvmWizard(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            new DPVMConfigWizard(BrowserFrame.getInstance()).setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchCallHomeWizard(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            new CallHomeWizard(BrowserFrame.getInstance()).setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchAAAWizard(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            new AAAWizard(BrowserFrame.getInstance()).setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void zoneMerge(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        if (this._zoneMergeReportDialog != null) {
            this._zoneMergeReportDialog.dispose();
        }
        ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
        SnmpPeer[] peers = null;
        peers = new SnmpPeer[2];
        int swIndex = 0;
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                Switch sw1;
                Object ob = ((TopologyNode)nodes.get(i)).getModel();
                if (ob instanceof Switch && (sw1 = (Switch)ob).isMDS() && sw1.isManageable()) {
                    peers[swIndex++] = ((Switch)ob).getPeer();
                }
                if (swIndex == peers.length) break;
            }
        }
        this._zoneMergeReportDialog = new ZoneMergeReport(BrowserFrame.getInstance(), San.getInstance().getSnmpPeers(false, true));
        this._zoneMergeReportDialog.setPeers(peers[0], peers[1]);
        this._zoneMergeReportDialog.setVisible(true);
    }

    public void connectivity(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        if (this._catDialog != null) {
            this._catDialog.dispose();
            this._catDialog = null;
        }
        this._catDialog = new CatDialog(BrowserFrame.getInstance());
        this._catDialog.setVisible(true);
    }

    public void serverPurge(ActionEvent e) throws Exception {
        if (!ClientController.getInstance().isServerActive()) {
            ClientController.showServerDown();
            return;
        }
        try {
            MiscMapActions.getInstance().purgeFabric((Fabric)null);
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void serverAdmin(ActionEvent e) throws Exception {
        ControlPanelFrame controlPanelFrame = ControlPanelFrame.getInstance();
        controlPanelFrame.showTab("Fabrics");
        controlPanelFrame.setLocationRelativeTo(BrowserFrame.getInstance());
        if (e != null && ((AbstractButton)e.getSource()).getX() > 5) {
            controlPanelFrame.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (AbstractButton)e.getSource(), controlPanelFrame.getSize()));
        }
        controlPanelFrame.setVisible(true);
        controlPanelFrame.toFront();
    }

    public void health(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        if (this._healthCheckDlg == null) {
            this._healthCheckDlg = new HealthAnalysis(BrowserFrame.getInstance());
        }
        this._healthCheckDlg.setVisible(true);
    }

    public void elementManager(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        DMMapAction.getInstance().deviceManager();
    }

    public void cli(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        LoginMapAction.getInstance().cli();
    }

    public void techSupport(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (this._showTechSupportDlg != null) {
            this._showTechSupportDlg.dispose();
            this._showTechSupportDlg = null;
        }
        this._showTechSupportDlg = new ShowTechSupport(BrowserFrame.getInstance());
        this._showTechSupportDlg.setVisible(true);
    }

    public void runCli(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (this._runCliCommands != null) {
            this._runCliCommands.dispose();
            this._runCliCommands = null;
        }
        this._runCliCommands = new RunCLICommands(BrowserFrame.getInstance());
        this._runCliCommands.setVisible(true);
    }

    public void checkFlash(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (this._flashChecker != null) {
            this._flashChecker.dispose();
            this._flashChecker = null;
        }
        this._flashChecker = new FlashChecker(BrowserFrame.getInstance());
        this._flashChecker.setVisible(true);
    }

    public void zoneMigrate(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        Main app = Main.getInstance(ClientCache.getLocation(), BrowserFrame.getInstance());
        app.showDialog();
    }

    public void mergeZones(ActionEvent e) {
        ZMergeDialog app = new ZMergeDialog(ClientCache.getLocation(), BrowserFrame.getInstance());
        app.showDialog();
    }

    public void islStatistics(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        SmCommand.islStatistics(BrowserFrame.getDataView(), "ISL Real-Time Performance", ClientController.getInstance().getSelectedDomain(), null, null, null);
    }

    public void copyCfg(ActionEvent e) {
        SmCommand.copyCfg(BrowserFrame.getDataView(), ClientController.getInstance().getSelectedDomain().getPath('/') + "/Copy Configuration", ClientController.getInstance().getSelectedDomain(), null, null, null);
    }

    public void userManager(ActionEvent e) {
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        SmCommand.snmpSecurityTab(BrowserFrame.getDataView(), "Users and Roles", null, null, null, null);
    }

    public void zoomIn(ActionEvent e) {
        ZoomMapAction.getInstance().zoom("zoomIn");
    }

    public void zoomOut(ActionEvent e) {
        ZoomMapAction.getInstance().zoom("zoomOut");
    }

    public void zoomToFit(ActionEvent e) {
        ZoomMapAction.getInstance().zoom("zoomFit");
    }

    public void toggleOverView(ActionEvent e) {
        OverViewMapAction.getInstance().toggleOverView();
    }

    public void toggleGrid(ActionEvent e) {
        MiscMapActions.toggleGrid();
    }

    public void defaultAction(ActionEvent e) {
        VsanTree._invokeDefaultCommand = !VsanTree._invokeDefaultCommand;
    }

    public void traceroute(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (!this.validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
            return;
        }
        RdlDialog rdl = new RdlDialog(BrowserFrame.getInstance());
        rdl.setVisible(true);
    }

    public void findpath(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        if (this._tracePath != null) {
            this._tracePath.dispose();
            this._tracePath = null;
        }
        TracePortPath _tracePath = new TracePortPath(BrowserFrame.getInstance(), ClientController.getInstance().getFabric(), null, null);
        _tracePath.setVisible(true);
    }

    public void hostprovisioning(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            if (this._hostprovision != null) {
                this._hostprovision.dispose();
                this._hostprovision = null;
            }
            this._hostprovision = VsanTree.getInstance().invokeHostProvisioningWizard();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void DMWizServer(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        this.dmWiz(-86);
    }

    public void DMWizStorage(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        this.dmWiz(-69);
    }

    public void dmWiz(int dmType) {
        try {
            if (!ClientController.getInstance().isSanDMMCapable()) {
                throw new Exception("Unable to start wizard: cannot find any DMM provisioned card on a switch running minimum supported NX-OS version 6.2(1).");
            }
            DataMigWizard wiz = new DataMigWizard(BrowserFrame.getInstance(), dmType);
            wiz.setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void seWizard(ActionEvent e) throws SnmpException {
        try {
            SecureEraseWizard wiz = new SecureEraseWizard(BrowserFrame.getInstance());
            wiz.setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void ping(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            PingDialog pdl = new PingDialog(BrowserFrame.getInstance(), true);
            pdl.setVisible(true);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void lunDiscover(ActionEvent e) throws Exception {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        this._lunDiscoverDlg = new LunDiscovery(BrowserFrame.getInstance());
        this._lunDiscoverDlg.setVisible(true);
    }

    public void pmReport(ActionEvent e) throws IOException {
        block8: {
            String server = ClientController.getInstance().getServer();
            try {
                if (ClientController.getInstance().checkInstallLicense(LicenseCapabilities.Features.PM)) {
                    SessionRif sess = ClientController.getInstance().assertSession();
                    ArrayList<String> webProperties = sess.getWebServerConfig();
                    int port = Integer.parseInt(webProperties.get(1));
                    if (port == -1) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "DCNM-SAN Web Services is not running on the Server : " + server);
                    } else {
                        if (server.indexOf(58) != -1) {
                            server = '[' + server + ']';
                        }
                        String username = ClientController.getInstance().getFMUsername();
                        String token = sess.getSSOToken(username);
                        token = URLEncoder.encode(token, "UTF-8");
                        String url = (Boolean.valueOf(webProperties.get(0)) != false ? "https" : "http") + "://" + ClientController.getInstance().getServer() + ":" + Integer.parseInt(webProperties.get(1)) + "/s300.do?token=" + token;
                        ExternalTools.displayURLs(new String[]{url}, new String[]{"FMWeb"});
                    }
                    break block8;
                }
                Util.errorMessage((Component)BrowserFrame.getInstance(), "This feature requires a DCNM-SAN Server license");
                return;
            }
            catch (RemoteException ex) {
                if (ex.getCause() != null) {
                    String msg = ex.getCause().getCause() == null ? ex.getCause().getMessage() : ex.getCause().getCause().getMessage();
                    Util.errorMessage((Component)BrowserFrame.getInstance(), server + ":" + msg);
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), server + ":" + ex);
            }
        }
    }

    public void helpContents(ActionEvent e) throws Exception {
        String path;
        String helpTopic = BrowserFrame.getDataView().getHelpTag();
        if (helpTopic == null || helpTopic.equals("")) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Help on topic " + helpTopic + " can't be found");
            return;
        }
        helpTopic = helpTopic.toLowerCase();
        ClientController cController = ClientController.getInstance();
        if (ClientController.getInstance().isLocal()) {
            DefaultLogger._DefLogger.info((Object)"Get help from local machine");
            path = ClientCache.getInstallLocation();
        } else {
            DefaultLogger._DefLogger.info((Object)"Get help from web server");
            ArrayList<String> webProperties = cController.assertSession().getWebServerConfig();
            path = (Boolean.valueOf(webProperties.get(0)) != false ? "https" : "http") + "://" + cController.getServer() + ":" + Integer.parseInt(webProperties.get(1));
        }
        String htmlFile = helpTopic + ".html";
        DefaultLogger._DefLogger.info((Object)("Open: " + path + File.separator + "help" + File.separator + "fmhelp" + File.separator + htmlFile));
        ExternalTools.openURL(path + File.separator + "help" + File.separator + "fmhelp" + File.separator + htmlFile);
    }

    public void helpOnlineSupport(ActionEvent e) throws Exception {
        ExternalTools.openURL("http://www.cisco.com");
    }

    public void helpManual(ActionEvent e) throws Exception {
        ExternalTools.openURL("http://www.cisco.com/en/US/products/ps9369/tsd_products_support_series_home.html ");
    }

    public void helpAbout(ActionEvent e) {
        StringBuffer sb = new StringBuffer(232);
        sb.append("DCNM-SAN 6.3(1)");
        sb.append("\nBuilt time: 2014.04.17 16:31:43 PDT");
        sb.append("\nType: " + (SM._FmStandalone ? "DCNM-SAN StandAlone" : "Client-Server"));
        sb.append("\n\nJVM: ");
        sb.append(System.getProperty("java.vendor"));
        sb.append(", ");
        sb.append(System.getProperty("java.version"));
        sb.append("\nPath: ");
        sb.append(System.getProperty("java.home"));
        sb.append("\nHome: ");
        sb.append(System.getProperty("user.home"));
        sb.append("\nSystem User: ");
        sb.append(System.getProperty("user.name"));
        sb.append("\nOS: ");
        sb.append(System.getProperty("os.name"));
        sb.append(", ");
        sb.append(System.getProperty("os.arch"));
        sb.append(", ");
        sb.append(System.getProperty("os.version"));
        sb.append("\n\n(c) 2002-2013 Cisco Systems, Inc");
        JOptionPane.showMessageDialog(BrowserFrame.getInstance(), sb.toString(), "About", 1, Util.loadIcon("icons/logo.gif"));
    }

    public void addCloseActionListener(SmCloseListenerIf listener) {
        this._closeActionListeners.addElement(listener);
    }

    public void closeAction() {
        try {
            if (!BrowserFrame.hasInstance()) {
                try {
                    String msg = null;
                    msg = SM._FmStandalone ? "Closing connection..." : "Closing server connection...";
                    this._logger.info((Object)msg);
                    ClientController.getInstance().closeServerConnection();
                }
                catch (Exception ex) {
                    this._logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                try {
                    this._logger.info((Object)"Closing SNMP connection...");
                    if (ClientController.getSnmpSession() != null) {
                        ClientController.getSnmpSession().close();
                    }
                }
                catch (Exception ex) {
                    this._logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                try {
                    this._logger.info((Object)"Closing Vsh connection...");
                    Vsh.close();
                }
                catch (Exception ex) {
                    this._logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                LogManager.shutdown();
                System.exit(0);
            }
            if (BrowserFrame.getInstance().isVisible()) {
                this.quitWithoutSavingConfig(true);
                if (!this._cancel) {
                    this._logger.info((Object)"Exit aborted due to quitWithoutSavingConfig().");
                    return;
                }
                if (!this.checkAndSaveFabricInfo()) {
                    this._logger.info((Object)"Exit aborted due to checkAndSaveFabricInfo().");
                    return;
                }
            }
        }
        catch (Exception ex) {
            this._logger.error((Object)("UIActions.closeAction() " + ex.getMessage()));
            LogManager.shutdown();
            System.exit(0);
        }
        BrowserFrame.getInstance().setLongTermStatus("Logging off...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Timer exitTimer = new Timer();
                exitTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        UIActions.this._logger.info((Object)"Exiting.  Server failed to respond in 60 seconds.");
                        LogManager.shutdown();
                        System.exit(0);
                    }
                }, 60000L);
                try {
                    Dimension d = BrowserFrame.getInstance().getContentPane().getSize();
                    d = BrowserFrame.getInstance().getSize();
                    ClientController.getInstance().setClientProperty("PreferredSize", d.getWidth() + "," + d.getHeight());
                    BrowserFrame.getInstance().setLongTermStatus("Saving client properties...");
                    UIActions.this._logger.info((Object)"Saving client properties...");
                    ClientController.getInstance().saveClientProperties();
                    BrowserFrame.getInstance().setLongTermStatus("Saving Frame layout properties...");
                    UIActions.this._logger.info((Object)"Saving Frame layout properties...");
                    BrowserFrame.getInstance().saveJIDELayout();
                    BrowserFrame.getInstance().setLongTermStatus("SmMap.SaveAll(2)...");
                    UIActions.this._logger.info((Object)"SmMap.SaveAll(2)...");
                    SmMap.SaveAll();
                }
                catch (Exception ex) {
                    UIActions.this._logger.error((Object)("UIActions.closeAction() run() " + ex.getMessage()));
                }
                BrowserFrame.getInstance().setLongTermStatus("Setting exit timer...");
                UIActions.this._logger.info((Object)"Setting exit timer...");
                LogoffAndCloseThread logoffAndCloseThread = new LogoffAndCloseThread();
                logoffAndCloseThread.start();
            }
        });
    }

    public void exportEnclosures(ActionEvent e) {
        int selectedValue;
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        Object fabrics = null;
        Enclosure[] enc = new Enclosure[]{};
        String defaultFileName = null;
        if (mgmtDomain instanceof San) {
            enc = ((San)mgmtDomain).getEnclosures();
            defaultFileName = "San";
            selectedValue = JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "This will export the enclosures for all fabrics in the SAN.\nWould you like to continue?", "Export Enclosures", 0);
            if (selectedValue == 1) {
                return;
            }
        } else if (mgmtDomain instanceof Fabric) {
            enc = ((Fabric)mgmtDomain).getEnclosures();
            defaultFileName = ((Fabric)mgmtDomain).getName();
            selectedValue = JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "This will only export the enclosures from the selected fabric - " + (Fabric)mgmtDomain + ".\nWould you like to continue?", "Export Enclosures", 0);
            if (selectedValue == 1) {
                return;
            }
        } else {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "The selected element does not support enclosure export.\nPlease select a Fabric or the SAN element.");
            return;
        }
        if (enc == null || enc.length == 0) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "No Enclosures Defined");
        } else {
            String fName = Util.getFileName(BrowserFrame.getInstance(), "Export Enclosures - DCNM-SAN", defaultFileName + "_enc.txt", 1, ClientCache.getLocation(), true);
            if (fName != null) {
                try {
                    int num = ClientController.getInstance().getFabric().exportEnclosures(fName, enc);
                    BrowserFrame.getInstance().setStatus(num + " Exported");
                    if (num == 0) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "No enclosures to export.\nEnclosure has to be either\n   - Created by User, or \n   - Contains IP Address, or\n   - Associated with an Element Manager");
                    }
                }
                catch (IOException ex) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                }
            }
        }
    }

    public void importEnclosures(ActionEvent e) throws IOException, UnknownHostException {
        int selectedValue;
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        Fabric[] fabrics = null;
        if (mgmtDomain instanceof San) {
            fabrics = ((San)mgmtDomain).getFabrics();
            selectedValue = JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "This will import the enclosures to all fabrics in the SAN.\nWould you like to continue?", "Import Enclosures", 0);
            if (selectedValue == 1) {
                return;
            }
        } else if (mgmtDomain instanceof Fabric) {
            fabrics = new Fabric[]{mgmtDomain.getFabric()};
            selectedValue = JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "This will only import the enclosures to the selected fabric - " + fabrics[0] + ".\nWould you like to continue?", "Import Enclosures", 0);
            if (selectedValue == 1) {
                return;
            }
        } else {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "The selected element does not support enclosure import.\nPlease select a Fabric or the SAN element.");
            return;
        }
        JFileChooser f = null;
        String directory = ClientCache.getLocation();
        f = directory != null ? new JFileChooser(directory) : new JFileChooser();
        f.setDialogTitle("Import Enclosures - DCNM-SAN");
        f.setDialogType(0);
        f.setMultiSelectionEnabled(false);
        f.addChoosableFileFilter(new EnclosureFileFilter());
        f.setFileSelectionMode(0);
        f.showOpenDialog(BrowserFrame.getInstance());
        File fileName = f.getSelectedFile();
        String fName = null;
        if (fileName != null) {
            fName = fileName.getAbsolutePath();
        }
        if (fName != null && fabrics != null) {
            try {
                for (int i = 0; i < fabrics.length; ++i) {
                    int num = fabrics[i].importEnclosures(fName);
                    BrowserFrame.getInstance().setStatus(fabrics[i].toString() + " " + num + " Imported");
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
            }
        }
    }

    public void testFlexAttachUtil(ActionEvent e) {
        try {
            NPVUtil.main(null);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    void invokeZoneMerge(String port, Vsan v) throws SnmpException {
        if (null != this._zoneMerge) {
            this._zoneMerge.dispose();
        }
        this._zoneMerge = new ZoneMerge(BrowserFrame.getInstance(), v, null);
        this._zoneMerge.setVisible(true);
    }

    public void invokeZoneMerge(String port, Vsan v, SnmpPeer peer) throws SnmpException {
        if (null != this._zoneMerge) {
            this._zoneMerge.dispose();
        }
        this._zoneMerge = new ZoneMerge(BrowserFrame.getInstance(), v, port, peer);
        this._zoneMerge.setVisible(true);
    }

    public ZoneDialog invokeZoneMgr(Vsan v, boolean visible) throws SnmpException {
        ZoneDialog dlg;
        ZoneDialog zoneDialog = dlg = v != null ? this._zoneDialog : this._ivrZoneDialog;
        if (null != dlg) {
            if (dlg.isVisible()) {
                dlg.setVisible(false);
                dlg.dispose();
            }
            dlg = null;
        }
        ArrayList ivrEnabledPeers = null;
        ArrayList ivrCapabledList = null;
        if (v == null) {
            ivrCapabledList = SmIvrZoneSwitch.discoverSwitchProperties(ClientController.getInstance().getFabric());
            if (ivrCapabledList == null || ivrCapabledList.size() == 0) {
                throw new SnmpException("There are no IVR capable switches in Fabric.");
            }
            ivrEnabledPeers = IvrZoneSwitch.getIvrPeers(ivrCapabledList, true);
            if (ivrEnabledPeers.size() == 0) {
                EnableIVRDlg ivrDlg = new EnableIVRDlg(BrowserFrame.getInstance());
                ivrDlg.setVisible(true);
                if (ivrDlg.getSelectedPeer() == null) {
                    return null;
                }
                IvrZoneSwitch.setSwitchIvrState(ivrDlg.getSelectedPeer(), true, ivrCapabledList);
            }
        }
        dlg = new ZoneDialog(BrowserFrame.getInstance(), v, ivrCapabledList);
        if (v != null) {
            this._zoneDialog = dlg;
        } else {
            Object o;
            this._ivrZoneDialog = dlg;
            TreePath tpt = VsanTree.getInstance().getSelectionPath();
            if (tpt != null && (o = tpt.getLastPathComponent()) instanceof ZoneSetTreeNode) {
                this._ivrZoneDialog.setRegionID(((ZoneSetTreeNode)o).getRegionId());
            }
        }
        dlg.setVisible(visible);
        return dlg;
    }

    public IOADialog invokeIOAMgr() {
        ClientController ctrl;
        Fabric fabric;
        IOADialog dlg = this._ioaDialog;
        if (null != dlg) {
            if (dlg.isVisible()) {
                dlg.hide();
                dlg.dispose();
            }
            dlg = null;
        }
        if ((fabric = (ctrl = ClientController.getInstance()).getFabric()) == null) {
            fabric = BrowserFrame.getInstance().getFirstFabric();
        }
        FabricPK pk = null;
        if (fabric != null) {
            pk = (FabricPK)fabric.getPK();
        }
        if (pk == null) {
            return null;
        }
        this._ioaDialog = dlg = new IOADialog(BrowserFrame.getInstance(), pk);
        dlg.setVisible(true);
        return dlg;
    }

    public void dispose() {
        JDialog[] dialogs = new JDialog[]{this._zoneMergeReportDialog, this._fabricChecker, this._catDialog, this._zoneDialog, this._ivrZoneDialog, this._zoneMerge, this._showTechSupportDlg, this._healthCheckDlg, this._runCliCommands, this._flashChecker, this._tracePath, this._portSecurityWiz};
        for (int i = 0; i < dialogs.length; ++i) {
            try {
                if (dialogs[i] == null || !dialogs[i].isVisible()) continue;
                dialogs[i].setVisible(false);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this._zoneMergeReportDialog = null;
        this._fabricChecker = null;
        this._catDialog = null;
        this._zoneDialog = null;
        this._ivrZoneDialog = null;
        this._zoneMerge = null;
        this._showTechSupportDlg = null;
        this._healthCheckDlg = null;
        this._runCliCommands = null;
        this._flashChecker = null;
        this._tracePath = null;
        this._portSecurityWiz = null;
        if (this._closeActionListeners != null) {
            this._closeActionListeners.clear();
        }
        Vsh.close();
        try {
            BrowserFrame frame = BrowserFrame.getInstance();
            Window[] wins = frame.getOwnedWindows();
            for (int i = 0; i < wins.length; ++i) {
                JDialog dlg;
                String title;
                if (!(wins[i] instanceof JDialog) || (title = (dlg = (JDialog)wins[i]).getTitle()).indexOf("Open Fabric") != -1) continue;
                try {
                    if (dlg.isVisible()) {
                        dlg.setVisible(false);
                    }
                    dlg.dispose();
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void namedLayout(ActionEvent e) {
        SmMap map = SmMap.getSelectedMap();
        String oldLayout = map.getLayoutName();
        String newLayout = ((AbstractButton)e.getSource()).getText();
        if (oldLayout == null || !oldLayout.equals(newLayout)) {
            map.save();
            map.setLayoutName(newLayout);
            map.load();
            ZoomMapAction mapZoom = ZoomMapAction.getInstance();
            mapZoom.zoom("");
        }
    }

    public boolean checkAndSaveFabricInfo() {
        boolean toSaveMap;
        if (!ClientController.getInstance().isServerActive()) {
            return true;
        }
        boolean bl = toSaveMap = !SmMap.isAutoSaveLayout();
        if (toSaveMap) {
            Object[] possibleValues = new Object[]{"Yes", "Always", "No"};
            int result = JOptionPane.showOptionDialog(BrowserFrame.getInstance(), "Do you want to save map layout?", "Save Layout Data - DCNM-SAN", -1, 2, null, possibleValues, possibleValues[2]);
            if (result == -1) {
                return false;
            }
            if (result == 2) {
                return true;
            }
            if (result == 1) {
                SmMap.setAutoSaveLayout(true);
            } else {
                SmMap.setAutoSaveLayout(false);
            }
            toSaveMap = SmMap.isAutoSaveLayout();
            if (!toSaveMap) {
                SmMap.setAutoSaveLayout(true);
            }
            this._logger.info((Object)"SmMap.SaveAll(1)...");
            SmMap.SaveAll();
            if (!toSaveMap) {
                SmMap.setAutoSaveLayout(false);
            }
        }
        return true;
    }

    void quitWithoutSavingConfig(boolean isExit) {
        this._cancel = true;
        this._changedPeers.clear();
        SnmpPeer[] peers = San.getInstance().getSnmpPeers();
        if (peers != null) {
            for (int i = 0; i < peers.length; ++i) {
                DefaultLogger._DefLogger.debug((Object)(" SAVE CONFIG = peer " + peers[i].toString() + " numsets = " + peers[i].getNumSets()));
                if (peers[i].getNumSets() == 0) continue;
                this._changedPeers.put(peers[i].toString(), peers[i]);
            }
        }
        if (peers != null && BrowserFrame.mdsInFabric(San.getInstance().getSwitches()) && this._changedPeers.size() > 0) {
            this._dialog = new JDialog(BrowserFrame.getInstance(), "Save Configuration", true);
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(DialogUtil._Margin);
            this._dialog.setPreferredSize(new Dimension(500, 200));
            this._dialog.setMinimumSize(new Dimension(500, 200));
            JLabel label = new JLabel("<html>You have made changes that may change the running configuration on some switches.<br>Unless you save those changes to startup configuration, you may lose them on reboot.<br>Save changes in the Copy Configuration table?</html>", Util.loadIcon("icons/Warn.gif"), 0);
            label.setBorder(DialogUtil._Margin);
            main.add((Component)label, "West");
            String[] bLabels = new String[]{"Yes", "No", "Cancel"};
            JPanel btnPanel = new JPanel(new FlowLayout(1, 6, 3));
            JButton[] buttons = DialogUtil.buildButtons(bLabels, (ActionListener)this);
            for (int i = 0; i < buttons.length; ++i) {
                btnPanel.add(buttons[i]);
            }
            JMenu menu = new JMenu();
            this._mButton = new SwitchButton(menu, "Config Differences...");
            this._mButton.buildMenu(this._changedPeers.keySet().toArray(new String[0]));
            btnPanel.add(this._mButton);
            main.add((Component)btnPanel, "South");
            this._dialog.add(main);
            this._dialog.setLocationRelativeTo(BrowserFrame.getInstance());
            this._dialog.pack();
            this._dialog.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            String cmd = ((AbstractButton)e.getSource()).getActionCommand();
            switch (cmd.charAt(0)) {
                case 'Y': {
                    if (this._changedPeers.size() > 0) {
                        this._cancel = false;
                        ArrayList<SmFilter> filters = new ArrayList<SmFilter>();
                        for (SnmpPeer peer : this._changedPeers.values()) {
                            filters.add(new SmFilter(peer, null));
                        }
                        SmCommand.copyCfgSelect(BrowserFrame.getDataView(), "Copy Configuration", null, filters.toArray(new SmFilter[0]), null, null);
                        try {
                            BrowserFrame.getDataView()._tableModel.applyChangesAction();
                        }
                        catch (Exception ex) {
                            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                        }
                    }
                    this._dialog.dispose();
                    break;
                }
                case 'N': {
                    this._cancel = true;
                    this._dialog.dispose();
                    break;
                }
                case 'C': {
                    this._cancel = false;
                    this._dialog.dispose();
                }
            }
        }
    }

    public void iscsiwizard(ActionEvent e) throws SnmpException {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            IscsiWizard rdl = new IscsiWizard(BrowserFrame.getInstance());
            rdl.setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchNpvCFSSetup(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            NpvClientHelper cHelper = NpvClientHelper.getInstance();
            Fabric fab = ClientController.getInstance().getFabric();
            List<Switch> allSwList = cHelper.getSwitches(fab);
            List<Switch> npvDevices = cHelper.getStaticCfsNpvEnabledDevices(allSwList);
            if (npvDevices.size() == 0) {
                JOptionPane.showMessageDialog(BrowserFrame.getInstance(), "No static CFS capable switches found in the fabric: " + fab + ". \nSwitches must be NPV enabled and running a minimum version of 3.4(1).", "CFS Static Peer List Launch", 0);
            } else {
                NpvCFSSetup npvCfsDialog = new NpvCFSSetup(BrowserFrame.getInstance(), npvDevices);
                if (npvCfsDialog.isVisible()) {
                    npvCfsDialog.toFront();
                } else {
                    npvCfsDialog.setVisible(true);
                }
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchNpvWizard(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            NpvSetupWizard.createInstance(BrowserFrame.getInstance());
            NpvSetupWizard npvWizard = NpvSetupWizard.getInstance();
            if (npvWizard.isVisible()) {
                npvWizard.toFront();
            } else {
                npvWizard.startModule();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchTEWizard(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            TESetupWizard.createInstance(BrowserFrame.getInstance());
            TESetupWizard teWizard = TESetupWizard.getInstance();
            if (teWizard.isVisible()) {
                teWizard.toFront();
            } else {
                teWizard.startModule();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchESPLinkSecurityWizard(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        if (ClientController.getInstance().getFabric() == null) {
            this.showSingleFabricErrorMessage();
            return;
        }
        try {
            LinkSecurityWizard lsWizard = LinkSecurityWizard.createInstance(BrowserFrame.getInstance(), null);
            if (lsWizard != null && lsWizard.isVisible()) {
                lsWizard.toFront();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchFcspAction(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        FcspAction thread = new FcspAction(null);
        thread.start();
    }

    public void launchDmmPreconfigWizard(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            DmmPreWizard dmmWizard = DmmPreWizard.createInstance(BrowserFrame.getInstance());
            if (dmmWizard != null && dmmWizard.isVisible()) {
                dmmWizard.toFront();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void launchSePreconfigWizard(ActionEvent e) {
        try {
            SePreWizard seWizard = SePreWizard.createInstance(BrowserFrame.getInstance());
            if (seWizard != null && seWizard.isVisible()) {
                seWizard.toFront();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void faPreConfig(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            FAWizard wizard = FAPreConfigWizard.getInstance(BrowserFrame.getInstance());
            if (wizard.isVisible()) {
                wizard.toFront();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void faMove(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            FAWizard wizard = FAMoveWizard.getInstance(BrowserFrame.getInstance());
            if (wizard.isVisible()) {
                wizard.toFront();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void faReplace(ActionEvent e) {
        if (!this.validateSANDomain()) {
            return;
        }
        try {
            FAWizard wizard = FAReplaceWizard.getInstance(BrowserFrame.getInstance());
            if (wizard.isVisible()) {
                wizard.toFront();
            }
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    public void toggleSimpleMode(ActionEvent e) {
        if (!ClientController.getInstance().isServerActive()) {
            JOptionPane.showMessageDialog(null, "Server is not active. You need to login first.");
            LoginFrame.getInstance().setVisible(true);
        } else {
            JComboBox perspectiveControl = (JComboBox)e.getSource();
            Object object = perspectiveControl.getSelectedItem();
            boolean updateAll = e.getActionCommand().equalsIgnoreCase(UIControls.ACTION_CMD);
            String perspectiveName = (String)object;
            int variant = this.getPerspectiveVariant(perspectiveName);
            if (variant == this._perspectiveVariant && UIControls.getInstance().getPerspectiveName().equals(perspectiveName)) {
                return;
            }
            ClientController.getInstance().getPerspective(perspectiveName, variant);
            this._perspectiveVariant = variant;
            UIControls.getInstance().setPerspectiveView(perspectiveName, variant, false);
            this.updateSimpleModeDisplay(updateAll);
        }
    }

    private int getPerspectiveVariant(String perspectiveName) {
        MgmtDomainIf mgmtDomain;
        int variant = 0;
        if (perspectiveName != null && (perspectiveName.equals("simple") || perspectiveName.equals("advanced")) && (mgmtDomain = ClientController.getInstance().getSelectedDomain()) != null) {
            Switch[] switches = null;
            if (mgmtDomain.isSan()) {
                switches = mgmtDomain.getSwitches();
            } else if (mgmtDomain.getFabric() != null) {
                switches = mgmtDomain.getFabric().getSwitches();
            }
        }
        return variant;
    }

    public void updateSimpleModeDisplay() {
        this.updateSimpleModeDisplay(true);
    }

    public void updateSimpleModeDisplay(boolean updateAll) {
        BrowserFrame.getInstance().updatePerspectiveView();
        if (updateAll) {
            BrowserFrame.getInstance().rebuildLogicalTree();
            BrowserFrame.getInstance().update();
            BrowserFrame.getInstance().setSanPhysicalTreeEnable(VsanTree.getInstance().getFabricCount() > 0);
            MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
            if (mgmtDomain == null || mgmtDomain.isSan()) {
                SmCommand.sanMemberReport(BrowserFrame.getDataView(), "SAN", mgmtDomain, null, null, null);
            } else {
                SmCommand.vsanMemberReport(BrowserFrame.getDataView(), mgmtDomain.getPath(), mgmtDomain, null, null, null);
            }
        }
        SmMap.resetPopups();
    }

    public boolean isLANDomains() {
        MgmtDomainIf selDomain = ClientController.getInstance().getSelectedDomain();
        return selDomain != null && (selDomain.isLAN() || selDomain.isVlan());
    }

    public boolean validateSANDomain() {
        if (this.isLANDomains()) {
            JOptionPane.showMessageDialog(BrowserFrame.getInstance(), "This operation is valid for SAN domains.", "Error", 0);
            return false;
        }
        return true;
    }

    public boolean validateAtLeastOneMDSSupport(Fabric fa) {
        SnmpPeer[] peers;
        if (fa != null && ((peers = fa.getSnmpPeers()) == null || peers.length == 0)) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "No switches are available for this feature.");
            return false;
        }
        return true;
    }

    class EnclosureFileFilter
    extends FileFilter {
        EnclosureFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name != null && name.contains("_enc.txt");
        }

        @Override
        public String getDescription() {
            return "*_enc.txt";
        }
    }

    class SwitchButton
    extends MenuButton {
        public SwitchButton(JMenu menu, String name) {
            super(menu, name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                String[] cmds = new String[]{"Show running diff\n"};
                try {
                    SnmpPeer peer = (SnmpPeer)UIActions.this._changedPeers.get(((JMenuItem)e.getSource()).getText());
                    VshDumpAdv showRunningDiff = new VshDumpAdv(BrowserFrame.getInstance(), peer.toString() + " Show Running and Startup Config Differences", cmds, peer);
                    showRunningDiff.setModal(true);
                    showRunningDiff.showDialog(peer, "Show Running and Startup Config Differences");
                }
                catch (IOException ex) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                    ex.printStackTrace();
                }
            } else {
                super.actionPerformed(e);
            }
        }
    }

    class LogoffAndCloseThread
    extends Thread {
        LogoffAndCloseThread() {
        }

        public void setLongTermStatus(String message) {
            if (message == null) {
                message = "";
            }
            BrowserFrame.getInstance().setLongTermStatus(message);
        }

        @Override
        public void run() {
            BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            try {
                String msg = null;
                msg = SM._FmStandalone ? "Closing connection..." : "Closing server connection...";
                UIActions.this._logger.info((Object)msg);
                this.setLongTermStatus(msg);
                ClientController.getInstance().closeServerConnection();
            }
            catch (Exception ex) {
                UIActions.this._logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                UIActions.this._logger.info((Object)"Closing SNMP connection...");
                this.setLongTermStatus("Closing SNMP connection...");
                if (ClientController.getSnmpSession() != null) {
                    ClientController.getSnmpSession().close();
                }
            }
            catch (Exception ex) {
                UIActions.this._logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                UIActions.this._logger.info((Object)"Closing Vsh connection...");
                this.setLongTermStatus("Closing Vsh connection...");
                Vsh.close();
            }
            catch (Exception ex) {
                UIActions.this._logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            LogManager.shutdown();
            System.exit(0);
        }
    }
}

