/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.tools;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmPortSetCellEditor;
import com.cisco.dcbu.sm.client.gui.tools.CreateAcl;
import com.cisco.dcbu.sm.client.gui.tools.IpFilterAction;
import com.cisco.dcbu.sm.client.gui.tools.IpFilterWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

class SelectSwitches
extends WizardPanel {
    static final String[] HEADERS = new String[]{"Select", "Switch", "Model", "Interface"};
    static final int SELECT_COL = 0;
    static final int SWITCH_COL = 1;
    static final int MODEL_COL = 2;
    static final int INTERFACE_COL = 3;
    SnmpKTable _table;
    KTableModel _tableModel;
    KTextField _ifName;

    public SelectSwitches(IpFilterWizard wizard) {
        super("2 of 2: Apply IP ACL List", "Select switch(es) and specify an IP interface that you want to apply this filter for inbound traffic. Remember you can only have one filter active on an interface. IPv6 ACLs can only apply to IPv6 capable switches.", wizard, IpFilterWizard._Image);
        JPanel center = new JPanel(new BorderLayout());
        Array data = new Array();
        this.loadSwitches(data, wizard._switches);
        this._tableModel = new SnmpTableModel();
        this._tableModel.setData(data);
        this._tableModel.setHeaders(HEADERS);
        this._tableModel.setEditable(new boolean[]{true, false, false, true});
        this._table = new SnmpSelectAllTable(this._tableModel);
        this._table.setPreferredSize(this._table.calcPreferredSize());
        this._table.addPopupMenu();
        JScrollPane sp = new JScrollPane(this._table);
        PortEditorFilter pEditorFilter = new PortEditorFilter(new int[]{2});
        pEditorFilter.setLogicalIfFilter(new int[]{5});
        SmPortSetCellEditor pcCellEditor = new SmPortSetCellEditor(this._table, true, pEditorFilter);
        pcCellEditor.setAllowLogicalIf(true);
        pcCellEditor.setPeerCol(1);
        pcCellEditor._portSetEditor.setShowIfPrefix(true);
        this._table.getColumnModel().getColumn(3).setCellEditor(pcCellEditor);
        center.add("Center", sp);
        this.add("Center", center);
        JPanel south = new JPanel(new FlowLayout(0));
        JLabel switchCountLabel = new JLabel("Switches: " + data.size());
        south.add(switchCountLabel);
        this.add("South", south);
    }

    private void loadSwitches(Array data, Switch[] sw) {
        for (int i = 0; i < sw.length; ++i) {
            if (!sw[i].isMDS() || sw[i].isN5K() || sw[i].getPeer() == null || !sw[i].isVersionGreaterThanEqual("1.2(0)")) continue;
            Object[] row = new Object[HEADERS.length + 1];
            row[0] = Boolean.TRUE;
            row[1] = sw[i];
            row[2] = sw[i].getModel();
            row[3] = "mgmt0";
            data.addElement(row);
        }
    }

    @Override
    public void doFinish() {
        block16: {
            if (this._table.isEditing()) {
                this._table.editingStopped(null);
            }
            HashMap<SnmpPeer, Integer> peers2If = new HashMap<SnmpPeer, Integer>();
            ArrayList<SnmpPeer> peerInvalidIf = new ArrayList<SnmpPeer>();
            Array data = this._tableModel.getData();
            for (int i = 0; i < data.size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                if (!((Boolean)row[0]).booleanValue()) continue;
                String ifStr = (String)row[3];
                try {
                    if (ifStr.length() != 0) {
                        int ifIndex = ((Switch)row[1]).nameToIfIndex(ifStr);
                        if (ifIndex == 0) {
                            peerInvalidIf.add(((Switch)row[1]).getPeer());
                            continue;
                        }
                        peers2If.put(((Switch)row[1]).getPeer(), new Integer(ifIndex));
                        continue;
                    }
                    peerInvalidIf.add(((Switch)row[1]).getPeer());
                    continue;
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, ex);
                    return;
                }
            }
            if (peerInvalidIf.size() != 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("Please enter an interface for the following selected switches:\n");
                for (int i = 0; i < peerInvalidIf.size(); ++i) {
                    buf.append(((SnmpPeer)peerInvalidIf.get(i)).toString() + "\n");
                }
                Util.errorMessage((Component)this, buf.toString());
            } else if (peers2If.size() == 0) {
                Util.errorMessage((Component)this, "Please select a switch");
            } else {
                CreateAcl acl = ((IpFilterWizard)this.getWizard())._createAcl;
                int type = acl._ipV6.isSelected() ? 2 : 1;
                SnmpPeer[] peers = peers2If.keySet().toArray(new SnmpPeer[peers2If.size()]);
                Array<SnmpPeer> _peers_prior3_0 = new Array<SnmpPeer>();
                Array<SnmpPeer> _peers_3_0_onwards = new Array<SnmpPeer>();
                boolean isIPv6 = type == 2;
                for (int i = 0; i < peers.length; ++i) {
                    ClientController.getInstance();
                    Switch sw = ClientController.findFabricSwitchByIpAddress(peers[i].getAddress());
                    if (!sw.isMDS()) continue;
                    if (sw.isVersionGreaterThan("3.0(0)")) {
                        _peers_3_0_onwards.addElement(peers[i]);
                        continue;
                    }
                    _peers_prior3_0.addElement(peers[i]);
                    if (!isIPv6) continue;
                    peers2If.remove(peers[i]);
                }
                try {
                    new IpFilterAction(peers2If, acl._name.getText(), type, acl._tableModel.getData());
                    this.getWizard().dispose();
                    BrowserFrame.getDataView().refreshWizardOwner("IPACL");
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, ex);
                }
                catch (Error ex) {
                    Util.errorMessage((Component)this, ex.getMessage());
                    if (!SnmpSession.isTrace()) break block16;
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    class SnmpSelectAllTable
    extends SnmpKTable
    implements ActionListener {
        KTableModel _model;
        String[][] _menuItems;

        public SnmpSelectAllTable(KTableModel model) {
            super(model);
            this._menuItems = new String[][]{{"Select All", "A"}, {"Select None", "N"}};
            this._model = model;
        }

        @Override
        protected void buildPopupMenu() {
            this._popup = new JPopupMenu();
            for (int i = 0; i < this._menuItems.length; ++i) {
                this._popup.add(Util.createMenuItem(this._menuItems[i][0], this._menuItems[i][1], this));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().charAt(0) == 'A' || e.getActionCommand().charAt(0) == 'N') {
                boolean none = e.getActionCommand().charAt(0) == 'N';
                this.setSelectionAll(none ? Boolean.FALSE : Boolean.TRUE);
            } else {
                super.actionPerformed(e);
            }
        }

        void setSelectionAll(Object value) {
            for (int i = 0; i < SelectSwitches.this._table.getRowCount(); ++i) {
                SelectSwitches.this._table.setValueAt(value, i, 0);
            }
        }
    }
}

