/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.tools;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpCommunity;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.tools.SortableInetAddress;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SubnetSweep
extends JDialog
implements ActionListener,
SnmpCallbackIf {
    private static final String[] COL_LABELS = new String[]{"Address", "WWN", "Name", "Description"};
    private JComponent[] _values;
    private int _nReqs;
    private int _initialReqs;
    private KTable _table;
    private KTableModel _model;
    private Array _data;
    private JLabel _status;
    boolean _andiamoOnly;
    boolean _N5KOnly;
    private JButton[] _buttons;
    private JScrollPane _sp;
    static final int[] _fcFeElementNameExpOid = new int[]{1, 3, 6, 1, 3, 42, 2, 1, 1, 2};
    static final int[] _fcFeElementNameOid = new int[]{1, 3, 6, 1, 2, 1, 75, 1, 1, 2};
    static final int[] _fcQlogicWwwn = new int[]{1, 3, 6, 1, 3, 94, 1, 6, 1, 1, 16};
    private static final int IPADDR_COL = 0;
    private static final int WWN_COL = 1;
    private static final int NAME_COL = 2;
    private static final int DESCRP_COL = 3;

    public SubnetSweep(JFrame parent) {
        super((Frame)parent, "Locate Switches - DCNM-SAN");
        String[] labels = new String[]{"Comma Separated Subnet(s):", "Community:", null, null, null};
        this._values = new JComponent[labels.length];
        this._values[0] = new KTextField();
        try {
            SnmpPeer peer = ClientController.getInstance().getFabric().getSeedPeer();
            InetAddress addr = peer.getAddress();
            if (addr != null) {
                String subnet = addr.getHostAddress();
                ((JTextField)this._values[0]).setText(subnet.substring(0, subnet.lastIndexOf(46)) + ".[1-254]");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this._values[1] = new KTextField("public");
        this._values[2] = new JCheckBox("Display Cisco MDS Only");
        this._values[3] = new JCheckBox("Display Cisco Nexus 5000 family Only");
        this._values[4] = new DialogSeparator("Results");
        JPanel fields = DialogUtil.buildPanel(DialogUtil.buildLabels(labels), this._values);
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", fields);
        this._data = new Array();
        this._model = new KTableModel();
        this._model.setData(this._data);
        this._model.setHeaders(COL_LABELS);
        this._table = new KTable(this._model);
        this._table.getTableHeader().addMouseListener(new HeaderListener());
        this._table.setSortable(true);
        this._table.addPopupMenu();
        this._table.setCellSelectionEnabled(true);
        this._sp = new JScrollPane(this._table);
        this._sp.setPreferredSize(new Dimension(500, 200));
        p.add("Center", this._sp);
        this._status = new JLabel(" ");
        String[] bLabels = new String[]{"Search", "Close"};
        this._buttons = DialogUtil.buildButtons(bLabels, (ActionListener)this);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)p, DialogUtil.buildStatusPanel(this._buttons, this._status));
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            switch (((JButton)e.getSource()).getActionCommand().charAt(0)) {
                case 'S': {
                    this._data.clear();
                    this._andiamoOnly = ((JCheckBox)this._values[2]).isSelected();
                    this._N5KOnly = ((JCheckBox)this._values[3]).isSelected();
                    this._buttons[0].setEnabled(false);
                    this._model.fireTableDataChanged();
                    String string = ((JTextField)this._values[0]).getText();
                    ClientController.getInstance();
                    this.search(string, ClientController.getSnmpSession(), ((JTextField)this._values[1]).getText());
                    return;
                }
                case 'C': {
                    this.dispose();
                    return;
                }
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
            this._buttons[0].setEnabled(true);
        }
    }

    private void search(String search, SnmpSession session, String comm) throws Exception {
        if (search.trim().length() == 0 || comm.trim().length() == 0) {
            throw new Exception("Please supply search string and community");
        }
        this._nReqs = 0;
        StringTokenizer st = new StringTokenizer(search, ", ");
        VarBindList vbl = new VarBindList(6);
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("sysObjectID").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("sysName").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("sysDescr").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(_fcFeElementNameExpOid)));
        vbl.add(new SnmpVarBind(new SnmpOID(_fcFeElementNameOid)));
        vbl.add(new SnmpVarBind(new SnmpOID(_fcQlogicWwwn)));
        this._initialReqs = 0;
        this._nReqs = 0;
        while (st.hasMoreTokens()) {
            String subnet = st.nextToken();
            int pos = subnet.indexOf(91);
            if (pos == -1) {
                SnmpPDU pdu = this.createPdu(vbl, InetAddress.getByName(subnet), comm);
                ++this._nReqs;
                ++this._initialReqs;
                session.send(pdu, this);
                continue;
            }
            int delim = subnet.indexOf(45);
            int start = Integer.parseInt(subnet.substring(++pos, delim));
            int end = Integer.parseInt(subnet.substring(delim + 1, subnet.length() - 1));
            if (start < 1 || end > 254 || start > end) {
                throw new Exception("bad search: " + subnet);
            }
            subnet = subnet.substring(0, pos - 1);
            for (int i = start; i <= end; ++i) {
                SnmpPDU pdu = this.createPdu(vbl, InetAddress.getByName(subnet + i), comm);
                ++this._nReqs;
                ++this._initialReqs;
                session.send(pdu, this);
            }
        }
    }

    private SnmpPDU createPdu(VarBindList vbl, InetAddress addr, String readCommunity) {
        SnmpPDU pdu = new SnmpPDU(-95, vbl);
        pdu.setAddress(addr);
        pdu.setPort(161);
        pdu.setVersion(1);
        if (readCommunity == null) {
            pdu.setCommunity(SnmpCommunity.getRead(addr));
        } else {
            pdu.setCommunity(readCommunity);
        }
        pdu.setRetries(0);
        pdu.setTimeout(SnmpPeer._Timeout);
        return pdu;
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        --this._nReqs;
        this._status.setText(this._initialReqs - this._nReqs + "/" + this._initialReqs + " addresses checked...");
        if (!timedOut && pdu.getError() == 0) {
            if (this._andiamoOnly || this._N5KOnly) {
                if (this.isCandidate((SnmpOID)pdu.getVar(0))) {
                    this.addRow(pdu);
                }
            } else {
                this.addRow(pdu);
            }
        }
        if (this._nReqs % 100 == 0 || this._nReqs == 0) {
            SwingUtilities.invokeLater(new UpdateTable());
        }
        if (this._nReqs == 0 && session != null) {
            this._status.setText(this._data.size() + " device(s) found");
        }
    }

    private void addRow(SnmpPDU pdu) {
        String prefix;
        for (int i = 0; i < this._data.size(); ++i) {
            try {
                if (!((Object[])this._data.elementAt(i))[0].equals(pdu.getAddress().getHostAddress())) continue;
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Object[] row = new Object[COL_LABELS.length];
        row[0] = new SortableInetAddress(pdu.getAddress());
        row[2] = pdu.getVar(1);
        row[3] = pdu.getVar(2);
        SnmpVar wwnExpVar = null;
        SnmpVar wwnVar = null;
        SnmpVar wwnQlogic = null;
        if (pdu.getVariables().getVb(3).getOid().startsWith(_fcFeElementNameExpOid)) {
            wwnExpVar = pdu.getVar(3);
        }
        if (pdu.getVariables().getVb(4).getOid().startsWith(_fcFeElementNameOid)) {
            wwnVar = pdu.getVar(4);
        }
        if (pdu.getVariables().getVb(5).getOid().startsWith(_fcQlogicWwwn)) {
            wwnQlogic = pdu.getVar(5);
        }
        SnmpVar genWwnVar = null;
        if (wwnVar != null && wwnVar.getType() != 5) {
            genWwnVar = wwnVar;
        } else if (wwnExpVar != null && wwnExpVar.getType() != 5) {
            genWwnVar = wwnExpVar;
        }
        byte[] b = null;
        if (genWwnVar != null) {
            b = ((SnmpString)genWwnVar).getValue();
        } else if (wwnQlogic != null) {
            try {
                byte[] all = ((SnmpString)wwnQlogic).getValue();
                b = new byte[8];
                System.arraycopy(all, 0, b, 0, 8);
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
        row[1] = b != null ? ((prefix = WwnDictionary.getVendor(b)) != null ? prefix + " " + SnmpString.toHexString(b) : SnmpString.toHexString(b)) : "n/a";
        this._data.addElement(row);
    }

    private boolean isCandidate(SnmpOID sysObjectId) {
        boolean flag = sysObjectId.startsWith(Switch.MDS_OBJECT_ID);
        if (flag) {
            int[] oid = sysObjectId.getValue();
            int chassisType = oid[oid.length - 1];
            boolean isN5K = false;
            if (FRUConstants.isN5K(chassisType)) {
                isN5K = true;
            }
            flag = this._andiamoOnly && !isN5K || this._N5KOnly && isN5K;
        }
        return flag;
    }

    class UpdateTable
    implements Runnable {
        UpdateTable() {
        }

        @Override
        public void run() {
            SubnetSweep.this._table.setAutoResizeMode(0);
            SubnetSweep.this._sp.setPreferredSize(SubnetSweep.this._table.calcPreferredSize());
            SubnetSweep.this._table.getTableHeader().resizeAndRepaint();
            SubnetSweep.this._model.fireTableDataChanged();
            SubnetSweep.this._buttons[0].setEnabled(true);
        }
    }
}

