/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.hostcom;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneActivationAction;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.TextOutputDialog;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.MultiRowTable;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.tools.FlowConfigWizard;
import com.cisco.dcbu.sm.client.hostcom.HostCommisioningWizard;
import com.cisco.dcbu.sm.client.hostcom.VshActionHandlerPanel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneAction;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DecommisionZone
extends VshActionHandlerPanel
implements ActionListener {
    MultiRowTable zoneTable;
    KTableModel tblModel = new KTableModel();
    SmZoneAction _zoneAction;
    protected FieldPanel _zoneSetField;
    private TextOutputDialog _logDialog;
    private boolean hostRmvlModsActvZnst;
    protected JCheckBox _removeFlow;
    Array flows;

    public DecommisionZone(JWizard wiz, String title, ImageIcon image) {
        super(title, "The Host wwn will be removed from following zones. Resulting single member or empty zones will be removed", wiz, image);
        this.tblModel.setHeaders(new String[]{"Zone", "Members", "WWN"});
        this.zoneTable = new MultiRowTable(this.tblModel);
        this._zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
        this._zoneSetField = new FieldPanel(22);
        this._zoneSetField.setFont(ChangedCellRenderer.getNormalFont());
        this._zoneSetField.setEnabled(false);
        this._removeFlow = new JCheckBox("Remove Flow(s) after Deactivation", true);
        JScrollPane sp = new JScrollPane(this.zoneTable);
        JPanel pnl1 = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"Active ZoneSet", null}), new JComponent[]{this._zoneSetField, this._removeFlow});
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)pnl1, "North");
        pnl.add((Component)sp, "Center");
        this.add((Component)pnl, "Center");
        JPanel dtlBtnPnl = this.buildShowDetailsButtonPnl(this);
        pnl.add((Component)dtlBtnPnl, "South");
        this.detailBtn[0].setVisible(false);
        this.detailBtn[1].setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        char ch = evt.getActionCommand().charAt(0);
        switch (ch) {
            case 'S': {
                this.initLogDialog();
                this._logDialog.getTextArea().setText("Action Details (NO CONFIGURATION WILL BE CHANGED): \n");
                this.finishAction(true);
                break;
            }
            case 'C': {
                if (this._logDialog == null || !this._logDialog.isVisible()) break;
                this._logDialog.getTextArea().setText("");
            }
        }
    }

    private void showDetails() {
    }

    @Override
    public boolean refresh() {
        Thread th = new Thread(new RefreshAction(this));
        th.start();
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        return true;
    }

    @Override
    protected void runFinished() {
        this.getWizard().setStatus("");
    }

    protected boolean continueIfZoneSetModefied(boolean showOnly) {
        if (this._zoneAction.isActiveLocalZonesetModified()) {
            if (showOnly) {
                this._logDialog.log("The Active zoneset and local zoneset to be activated on switch " + this._zoneAction.getSwitch() + " differ. \nPlease ensure these are identical and rerun the wizard.");
            } else {
                JOptionPane.showMessageDialog(this.getWizard(), "The Active zoneset and local zoneset to be activated on switch " + this._zoneAction.getSwitch() + " differ. \nPlease ensure these are identical and rerun the wizard.", this.getWizard().getTitle(), 2);
            }
            return false;
        }
        return true;
    }

    private void initLogDialog() {
        if (this._logDialog == null || !this._logDialog.isVisible()) {
            this._logDialog = new TextOutputDialog(this.getWizard(), "Commission/Decommission Host Log" + ClientController.getInstance().getDialogFabricTitlePostfix());
            this._logDialog.setVisible(true);
        }
    }

    private void finishAction(boolean showOnly) {
        if (!this.continueIfZoneSetModefied(showOnly)) {
            return;
        }
        Boolean skipZoning = (Boolean)this.getModelValue("SKIP_ZONING");
        Array tblData = this.tblModel.getData();
        String selHostStr = (String)this.getWizard().getModelValue("HOST_PORT");
        Wwn selHost = new Wwn(selHostStr);
        Vsan vv = (Vsan)this.getWizard().getModelValue("VSAN");
        ClientController.getInstance();
        EndPort ep = ClientController.findFabricEndPortByWwn(selHost, vv.getVsanId());
        ArrayList<ArrayList> flowsWtHosEp = new ArrayList<ArrayList>();
        if (ep != null) {
            Switch realSw = FlowConfigWizard.getRealSwitch(ep, vv);
            int[] modules = null;
            try {
                modules = FlowConfigWizard.getSrcModules(realSw, ep);
            }
            catch (SnmpException ex) {
                DefaultLogger._DefLogger.warn((Object)"Error getting source modules: ", (Throwable)ex);
            }
            for (int m = 0; m < modules.length; ++m) {
                if (ep == null) continue;
                flowsWtHosEp.add(FlowConfigWizard.getExitingFlowIndices(this.flows, ep.getFcIdNum(vv.getVsanId())));
            }
        }
        HostCommisioningWizard cfr_ignored_0 = (HostCommisioningWizard)this.getWizard();
        if (!HostCommisioningWizard.isDPVMConfigNeeded(this.getWizard())) {
            HostCommisioningWizard cfr_ignored_1 = (HostCommisioningWizard)this.getWizard();
            if (!(HostCommisioningWizard.isDAConfigNeeded(this.getWizard()) || !skipZoning.booleanValue() && tblData.size() != 0 || flowsWtHosEp != null && flowsWtHosEp.size() != 0)) {
                if (showOnly) {
                    this._logDialog.log("No change to Device Alias, DPVM,  \nzoning configuration or Flows is required.");
                } else {
                    JOptionPane.showMessageDialog(this.getWizard(), "No change to Device Alias, DPVM,  \nzoning configuration or Flows is required.", this.getWizard().getTitle(), 1);
                    return;
                }
            }
        }
        if (!skipZoning.booleanValue()) {
            ZoneSet activeZs = this._zoneAction.getActiveZoneSet();
            this.hostRmvlModsActvZnst = false;
            if (activeZs != null) {
                ArrayList zsMembers = this._zoneAction.getZoneSetMembers(this._zoneAction.getActiveLocalZoneSet());
                for (int i = 0; i < tblData.size(); ++i) {
                    Object[] row = (Object[])tblData.elementAt(i);
                    Zone zn = (Zone)row[0];
                    if (!zsMembers.contains(zn)) continue;
                    this.hostRmvlModsActvZnst = true;
                    break;
                }
            }
            if (!this.hostRmvlModsActvZnst) {
                if (showOnly) {
                    this._logDialog.log("The deletion of selected Host from the local zones will not modify active zoneset " + (activeZs != null ? activeZs.getZoneName() : "") + ", so no reactivation of zoneset is required.\n" + (activeZs == null ? "No Active zoneset is present. " : ""));
                } else if (JOptionPane.showConfirmDialog(this.getWizard(), "The deletion of selected Host from the local zones will not modify active zoneset " + (activeZs != null ? activeZs.getZoneName() : "") + ", so no reactivation of zoneset is required.\n" + (activeZs == null ? "No Active zoneset is present. " : "") + "Continue?", this.getWizard().getTitle(), 0, 2) != 0) {
                    return;
                }
            }
        }
        this.initLogDialog();
        VshActionHandlerPanel.VshAction act = new VshActionHandlerPanel.VshAction((VshActionHandlerPanel)this, (VshActionHandlerPanel)this, new Object[]{false, null});
        if (showOnly) {
            try {
                this.runAction(true);
            }
            catch (Exception exx) {}
        } else {
            Thread th = new Thread(act);
            this.getWizard().setStatus("Verifying current configuration...");
            th.start();
            this.getWizard().getNavigator().getNextBtn().setEnabled(false);
            this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        }
    }

    @Override
    public void doFinish() {
        this.finishAction(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAction(boolean infoOnly) throws SnmpException, IOException {
        Switch cacheSw = (Switch)this.getWizard().getModelValue("ZONE_PEER");
        String selHostStr = (String)this.getWizard().getModelValue("HOST_PORT");
        Wwn selHost = new Wwn(selHostStr);
        VshBase vsh = null;
        boolean pollOutcome = true;
        try {
            SnmpPeer prr = cacheSw.getSnmpPeer();
            if (!infoOnly) {
                vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
                if (!this.getWizard().isVisible()) {
                    return;
                }
                if (vsh == null) {
                    throw new IOException("unable to open session to switch " + cacheSw);
                }
            }
            JTextArea zoneDetails = this._logDialog != null && this._logDialog.isVisible() ? this._logDialog.getTextArea() : new JTextArea();
            ((HostCommisioningWizard)this.getWizard()).runCLIActions(zoneDetails, vsh, infoOnly);
            Array tblData = this.tblModel.getData();
            if (tblData.size() > 0) {
                if (!infoOnly) {
                    vsh.send("end \n");
                    DefaultLogger._DefLogger.debug((Object)"end \n");
                } else if (zoneDetails != null) {
                    zoneDetails.append("end \n");
                }
                String defPrompt = "";
                StringBuffer result = new StringBuffer();
                if (!infoOnly) {
                    vsh.readPrompt();
                    defPrompt = vsh.getPrompt();
                    defPrompt = defPrompt.substring(0, defPrompt.indexOf("#"));
                    this.getWizard().setStatus("Command:conf t\n");
                    if (!this.getWizard().isVisible()) {
                        return;
                    }
                    vsh.send("conf t\n");
                    vsh.expect(defPrompt + "(config)#", result);
                } else {
                    zoneDetails.append("conf t\n");
                }
                int removedZones = 0;
                for (int i = 0; i < tblData.size(); ++i) {
                    Object[] row = (Object[])tblData.elementAt(i);
                    Zone zn = (Zone)row[0];
                    ArrayList znMems = (ArrayList)row[1];
                    result.setLength(0);
                    if (znMems.size() == 2) {
                        result.setLength(0);
                        if (!this.getWizard().isVisible()) {
                            return;
                        }
                        this.getWizard().setStatus("Removing zone:no zone name " + zn.getZoneName() + " vsan " + zn.getZoneVsanId() + "\n");
                        ++removedZones;
                        if (!infoOnly) {
                            vsh.send("no zone name " + zn.getZoneName() + " vsan " + zn.getZoneVsanId() + "\n");
                            vsh.expect(defPrompt + "(config)#", result);
                            DefaultLogger._DefLogger.info((Object)("Result:" + result));
                            this._logDialog.log(result.toString());
                            continue;
                        }
                        zoneDetails.append("no zone name " + zn.getZoneName() + " vsan " + zn.getZoneVsanId() + "\n");
                        continue;
                    }
                }
                this.activateCommit(vsh, defPrompt, removedZones, infoOnly);
                if (!infoOnly) {
                    pollOutcome = this.pollResult();
                    result.setLength(0);
                    vsh.send("end\n");
                    vsh.expect(defPrompt + "#", result);
                    DefaultLogger._DefLogger.info((Object)result);
                    this._logDialog.log(result.toString());
                } else {
                    zoneDetails.append("Snmp:Poll for Activation result\n");
                }
            }
            if (pollOutcome && this._removeFlow.isSelected()) {
                Vsan vv = (Vsan)this.getWizard().getModelValue("VSAN");
                ClientController.getInstance();
                EndPort ep = ClientController.findFabricEndPortByWwn(selHost, vv.getVsanId());
                if (ep != null) {
                    Switch realSw = FlowConfigWizard.getRealSwitch(ep, vv);
                    StringBuffer moreInfo = new StringBuffer();
                    int[] modules = FlowConfigWizard.getSrcModules(realSw, ep);
                    VarBindList vbl = this.buildFlowDeletionPDU(this.flows, ep.getFcIdNum(vv.getVsanId()), modules, moreInfo, vv.getVsanId());
                    String moduleList = "";
                    if (modules != null && modules.length > 0) {
                        for (int m = 0; m < modules.length; ++m) {
                            moduleList = moduleList + " " + (modules[m] - 21);
                        }
                    }
                    if (vbl.size() == 0) {
                        this._logDialog.log("Finished:No flow is currently configured for " + ep);
                        this.getWizard().setStatus("Finished:No flow is currently configured for " + ep);
                    } else {
                        this._logDialog.log("Removing the Host " + ep + " from flow from switch " + realSw + (moduleList.length() > 0 ? " for modules " + moduleList : ""));
                        this._logDialog.log("and " + moreInfo.toString());
                        this.getWizard().setStatus("Removing the Host " + ep + " from flow...");
                        if (!infoOnly) {
                            SnmpFetch.set(realSw.getPeer(), vbl);
                        }
                        this._logDialog.log("Finished");
                        this.getWizard().setStatus("Finished");
                    }
                } else {
                    DefaultLogger._DefLogger.info((Object)"Host not present in Fabric. Cannot remove from flow...");
                    if (!infoOnly) {
                        this.getWizard().setStatus("Host not present in Fabric. Cannot remove from flow...");
                    }
                    this._logDialog.log("Host not present in Fabric. Cannot remove from flow...");
                }
            }
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
        }
    }

    private VarBindList buildFlowDeletionPDU(Array flows, int selHostFcid, int[] modules, StringBuffer moreInfo, int vsanId) {
        VarBindList vbl = new VarBindList();
        for (int m = 0; m < modules.length; ++m) {
            int[] flowInfo;
            int i;
            ArrayList list = FlowConfigWizard.getExitingFlowIndices(flows, selHostFcid);
            for (i = 0; i < list.size(); ++i) {
                flowInfo = (int[])list.get(i);
                FlowConfigWizard.buildDeleteFlowVbl(vbl, flowInfo[0], modules[m]);
            }
            if (moreInfo == null) continue;
            for (i = 0; i < list.size(); ++i) {
                flowInfo = (int[])list.get(i);
                ClientController.getInstance();
                EndPort epp = ClientController.findFabricEndPortByVsanFcId(vsanId, flowInfo[1]);
                if (moreInfo.length() > 0) {
                    moreInfo.append(", ");
                }
                moreInfo.append(epp != null ? epp : "0x" + Integer.toHexString(flowInfo[1]));
            }
        }
        return vbl;
    }

    private boolean pollResult() throws SnmpException {
        if (!this.getWizard().isVisible()) {
            return false;
        }
        int vsanId = ((Vsan)this.getWizard().getModelValue("VSAN")).getVsanId();
        int activateResult = 5;
        VarBindList resp = null;
        while (activateResult == 5) {
            if (!this.getWizard().isVisible()) {
                return false;
            }
            VarBindList vb = new VarBindList();
            vb.add(ZoneActivationAction.ZONESET_ACTIVATE_RESULT, vsanId);
            vb.add(ZoneActivationAction.ZONESET_FAIL_CAUSE, vsanId);
            vb.add(ZoneActivationAction.ZONESET_DOMAIN_ID, vsanId);
            this.getWizard().setStatus("Checking for Activation status...");
            DefaultLogger._DefLogger.info((Object)"Checking for Activation status...");
            resp = this._zoneAction.getSwitch().getPeer().set(new SnmpPDU(-96, vb)).getVariables();
            activateResult = resp.intValue(0);
        }
        if (activateResult == 1) {
            this.getWizard().setStatus("Succesfully Activated " + this._zoneAction.getActiveLocalZoneSet());
            return true;
        }
        MibEnum[] causeEnums = ZoneActivationAction._causeNode.getEnums();
        String errMsg = "Failed Activation, Reason:" + (resp != null ? MibEnum.getLabel(causeEnums, resp.intValue(1)) : "Unknown");
        this.getWizard().setStatus(errMsg);
        DefaultLogger._DefLogger.info((Object)errMsg);
        return false;
    }

    private void activateCommit(VshBase vsh, String defPrompt, int removedZones, boolean infoOnly) throws SnmpException, IOException {
        StringBuffer result = new StringBuffer();
        int vsanId = ((Vsan)this.getWizard().getModelValue("VSAN")).getVsanId();
        if (!this.getWizard().isVisible()) {
            return;
        }
        result.setLength(0);
        Boolean skipZoning = (Boolean)this.getModelValue("SKIP_ZONING");
        if (!skipZoning.booleanValue() && this.hostRmvlModsActvZnst) {
            boolean activateZs;
            if (!this.getWizard().isVisible()) {
                return;
            }
            ZoneSet lclAcZs = this._zoneAction.getActiveLocalZoneSet();
            ArrayList lclZns = this._zoneAction.getZoneSetMembers(lclAcZs);
            boolean bl = activateZs = lclZns != null && lclZns.size() > removedZones;
            if (!infoOnly) {
                this.getWizard().setStatus((activateZs ? "Activating " : "Deactivating ") + "zoneset " + this._zoneAction.getActiveLocalZoneSet() + "...");
                vsh.send((activateZs ? "" : "no ") + "zoneset activate name " + this._zoneAction.getActiveLocalZoneSet().getZoneName() + " vsan " + vsanId + "\n");
                vsh.expect(defPrompt + "(config)#", result);
                DefaultLogger._DefLogger.info((Object)result);
                this._logDialog.log(result.toString());
                result.setLength(0);
            } else {
                this._logDialog.log((activateZs ? "" : "no ") + "zoneset activate name " + this._zoneAction.getActiveLocalZoneSet().getZoneName() + " vsan " + vsanId + "\n");
            }
        }
        if (this._zoneAction.isEnhanced()) {
            if (!this.getWizard().isVisible()) {
                return;
            }
            if (!infoOnly) {
                this.getWizard().setStatus("Committing changes...");
                vsh.send("zone commit vsan " + vsanId + "\n");
                vsh.expect(defPrompt + "(config)#", result);
                DefaultLogger._DefLogger.info((Object)result);
                this._logDialog.log(result.toString());
                if (result.indexOf("initiated") == -1) {
                    throw new SnmpException("Commit start failed");
                }
                result.setLength(0);
            } else {
                this._logDialog.log("zone commit vsan " + vsanId + "\n");
            }
        }
    }

    class RefreshAction
    implements Runnable {
        Exception actionException = null;

        RefreshAction(DecommisionZone hp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                DecommisionZone.this.detailBtn[0].setVisible(false);
                DecommisionZone.this.detailBtn[1].setVisible(false);
                DecommisionZone.this.tblModel.setData(new Array());
                DecommisionZone.this.tblModel.fireTableDataChanged();
                Switch cacheSw = (Switch)DecommisionZone.this.getWizard().getModelValue("ZONE_PEER");
                Vsan cacheVsan = (Vsan)DecommisionZone.this.getWizard().getModelValue("VSAN");
                String selHostStr = (String)DecommisionZone.this.getWizard().getModelValue("HOST_PORT");
                Wwn selHost = new Wwn(selHostStr);
                ClientController.getInstance();
                EndPort ep = ClientController.findFabricEndPortByWwn(selHost, cacheVsan.getVsanId());
                try {
                    ZoneSet zsAc;
                    DecommisionZone.this.getWizard().setCursor(Cursor.getPredefinedCursor(3));
                    if (DecommisionZone.this._zoneAction.getVsan() == null || DecommisionZone.this._zoneAction.getSwitch() == null || !DecommisionZone.this._zoneAction.getVsan().equals(cacheVsan) || !DecommisionZone.this._zoneAction.getSwitch().equals(cacheSw)) {
                        DecommisionZone.this._zoneAction.setVsanSwitch(cacheSw, cacheVsan);
                        DecommisionZone.this.getWizard().setStatus("Fetching Zones...");
                        DecommisionZone.this._zoneAction.refresh();
                    }
                    if ((zsAc = DecommisionZone.this._zoneAction.getActiveLocalZoneSet()) != null) {
                        DecommisionZone.this._zoneSetField.setText(zsAc.getZoneName());
                        DecommisionZone.this._zoneSetField.setFont(DecommisionZone.this._zoneAction.isActiveLocalZonesetModified() ? DialogSeparator.getItalicBoldFont() : ChangedCellRenderer.getItalicFont());
                    } else {
                        DecommisionZone.this._zoneSetField.setText("");
                    }
                    ArrayList allZnList = DecommisionZone.this._zoneAction.getAvailableZones();
                    ArrayList<Object[]> znLst = new ArrayList<Object[]>();
                    block4: for (int z = 0; z < allZnList.size(); ++z) {
                        Zone znn = (Zone)allZnList.get(z);
                        ArrayList znMems = DecommisionZone.this._zoneAction.getZoneMembers(znn);
                        if (znMems == null) continue;
                        for (int m = 0; m < znMems.size(); ++m) {
                            SmZoneMember zmemE = (SmZoneMember)znMems.get(m);
                            if (zmemE.getMemFormat() != 1 || !SnmpString.equals(zmemE.getMemId(), selHost.getValue())) continue;
                            znLst.add(new Object[]{znn, znMems});
                            continue block4;
                        }
                    }
                    if (znLst.size() > 0) {
                        Array<Object[]> data = new Array<Object[]>();
                        for (int zs = 0; zs < znLst.size(); ++zs) {
                            Object[] obb = new Object[4];
                            Object[] znData = (Object[])znLst.get(zs);
                            Zone znn = (Zone)znData[0];
                            ArrayList znMems = (ArrayList)znData[1];
                            ArrayList<String> zoneMembersWwn = new ArrayList<String>();
                            if (znMems != null) {
                                for (int m = 0; m < znMems.size(); ++m) {
                                    SmZoneMember zmem = (SmZoneMember)znMems.get(m);
                                    Wwn wwnP = zmem.getPortWwn(null);
                                    zoneMembersWwn.add(wwnP != null ? SnmpString.toHexString(wwnP.getValue()) : null);
                                }
                            }
                            obb[0] = znn;
                            obb[1] = znMems;
                            obb[2] = zoneMembersWwn;
                            data.addElement(obb);
                        }
                        DecommisionZone.this.tblModel.setData(data);
                        DecommisionZone.this.tblModel.fireTableDataChanged();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (DecommisionZone.this.getWizard().isVisible()) {
                                    DecommisionZone.this.zoneTable.calcPreferredSize();
                                }
                            }
                        });
                    }
                    if (ep == null) break block13;
                    DecommisionZone.this.flows = FlowConfigWizard.getExistingFlowsOnSwitch(FlowConfigWizard.getRealSwitch(ep, cacheVsan), cacheVsan.getVsanId());
                }
                catch (SnmpException ex) {
                    try {
                        this.actionException = ex;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (DecommisionZone.this.getWizard().isVisible()) {
                                    Util.errorMessage((Component)DecommisionZone.this.getWizard(), RefreshAction.this.actionException.getMessage());
                                    DecommisionZone.this.setDataValid(false);
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (DecommisionZone.this.getWizard().isVisible()) {
                                    DecommisionZone.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                                    DecommisionZone.this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                                }
                                DecommisionZone.this.getWizard().setCursor(Cursor.getDefaultCursor());
                                DecommisionZone.this.detailBtn[0].setVisible(true);
                                DecommisionZone.this.detailBtn[1].setVisible(true);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

