/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.common.model.ioa.EndDevice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FlowDirectionConfigDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 1L;
    private JButton[] _buttons;
    private EndDevice initiator;
    private EndDevice target;
    private ImageIcon pointLeft;
    private ImageIcon pointRight;
    private JButton direction;
    private JCheckBox _saveDirection;
    private boolean _saveFlag;
    private boolean _isCancelled = false;

    public FlowDirectionConfigDialog(JFrame parent, EndDevice a, EndDevice b, boolean saveDir) {
        super(parent);
        this.initiator = a;
        this.target = b;
        this._saveFlag = saveDir;
        this.pointLeft = Util.loadIcon("icons/IOA/arrow_left.png");
        this.pointRight = Util.loadIcon("icons/IOA/arrow_right.png");
        this.buildSaveConfigDialog(parent);
    }

    private void buildSaveConfigDialog(JFrame parent) {
        this.setTitle("Configure Flow");
        JComponent[] east = new JComponent[2];
        JComponent[] west = new JComponent[2];
        JComponent[] center = new JComponent[2];
        west[0] = new JLabel("<html>Site: <b>" + this.initiator.getSiteName() + "</b><P>" + this.initiator.getWwn() + "</html>");
        east[0] = new JLabel("<html>Site: <b>" + this.target.getSiteName() + "</b><P>" + this.target.getWwn() + "</html>");
        center[0] = new JLabel("Direction", 0);
        this.direction = new JButton(Util.loadIcon("icons/IOA/arrow_right.png"));
        this.direction.setToolTipText("Traffic flows from " + this.initiator.getSiteName() + " to " + this.target.getSiteName());
        this.direction.addActionListener(this);
        this.direction.setActionCommand("Direction");
        this.direction.setBorderPainted(false);
        this.direction.setContentAreaFilled(false);
        center[1] = this.direction;
        String[] btnLbl = new String[]{"Ok"};
        this._buttons = DialogUtil.buildButtons(btnLbl, (ActionListener)this);
        this._buttons[0].setActionCommand("OK");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        JPanel mainPnl = new JPanel(new BorderLayout());
        JLabel instructions = new JLabel("<html>Both devices in this flow may act as either an Initiator or Target.<P>Please select the primary flow direction by clicking on the arrow.<P><P> </html>", 0);
        mainPnl.add((Component)instructions, "North");
        JPanel middlePnl = new JPanel(new BorderLayout());
        JPanel leftPnl = new JPanel(new BorderLayout());
        JPanel dirPnl = new JPanel(new BorderLayout());
        JPanel rightPnl = new JPanel(new BorderLayout());
        leftPnl.add((Component)west[0], "Center");
        dirPnl.add((Component)center[1], "Center");
        rightPnl.add((Component)east[0], "Center");
        middlePnl.add((Component)leftPnl, "West");
        middlePnl.add((Component)dirPnl, "Center");
        middlePnl.add((Component)rightPnl, "East");
        JPanel savePanel = new JPanel();
        savePanel.setLayout(new BoxLayout(savePanel, 1));
        savePanel.add(new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(0, 20)));
        this._saveDirection = new JCheckBox("Use this direction for the rest of the Flow Group");
        this._saveDirection.setSelected(this._saveFlag);
        Font curFont = this._saveDirection.getFont();
        this._saveDirection.setFont(new Font(curFont.getFontName(), curFont.getStyle(), 11));
        this._saveDirection.addActionListener(this);
        this._saveDirection.setActionCommand("Save");
        savePanel.add(this._saveDirection);
        mainPnl.add((Component)middlePnl, "Center");
        JPanel main = new JPanel(new BorderLayout());
        Insets _MarginInsets = new Insets(8, 8, 8, 8);
        EmptyBorder _Margin = new EmptyBorder(_MarginInsets);
        main.setBorder(_Margin);
        main.add("North", mainPnl);
        main.add("Center", savePanel);
        main.add("South", buttonPanel);
        this.getContentPane().add(main);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Direction")) {
            if (this.direction.getIcon().equals(this.pointLeft)) {
                this.direction.setIcon(this.pointRight);
                this.direction.setToolTipText("Traffic flows from " + this.initiator.getSiteName() + " to " + this.target.getSiteName());
            } else {
                this.direction.setIcon(this.pointLeft);
                this.direction.setToolTipText("Traffic flows from " + this.target.getSiteName() + " to " + this.initiator.getSiteName());
            }
            this.direction.repaint();
        } else if (e.getActionCommand().equals("Save")) {
            this._saveFlag = this._saveDirection.isSelected();
        } else if (e.getActionCommand().equals("OK")) {
            if (this.direction.getIcon().equals(this.pointLeft)) {
                EndDevice x = this.initiator;
                this.initiator = this.target;
                this.target = x;
            }
            this._isCancelled = false;
            this.dispose();
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public EndDevice getInitiator() {
        return this.initiator;
    }

    public void setInitiator(EndDevice initiator) {
        this.initiator = initiator;
    }

    public EndDevice getTarget() {
        return this.target;
    }

    public void setTarget(EndDevice target) {
        this.target = target;
    }

    public boolean is_saveFlag() {
        return this._saveFlag;
    }

    public void set_saveFlag(boolean flag) {
        this._saveFlag = flag;
    }
}

