/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ioa.IOACache;
import com.cisco.dcbu.sm.client.ioa.IOADialog;
import com.cisco.dcbu.sm.client.ioa.OperationStatus;
import com.cisco.dcbu.sm.client.ioa.OperationStatusEnum;
import com.cisco.dcbu.sm.common.model.ioa.Site;
import com.cisco.dcbu.sm.common.model.ioa.Switch;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.jidesoft.utils.SwingWorker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class IOAWorkerSite
extends SwingWorker<IOACache, String>
implements ActionListener {
    private IOACache cache;
    private int currentProgress;
    private Site site;
    private IOADialog parent;
    private boolean isRemove = false;
    public static Logger _Logger = Logger.getLogger((String)"IOA");

    public IOAWorkerSite() {
    }

    public IOAWorkerSite(IOADialog parent, IOACache cache) {
        this.parent = parent;
        this.cache = cache;
        this.currentProgress = 0;
    }

    public IOAWorkerSite(IOADialog parent, IOACache cache, Site site) {
        this.parent = parent;
        this.cache = cache;
        this.currentProgress = 0;
        this.site = site;
        this.isRemove = true;
    }

    protected IOACache doInBackground() throws Exception {
        try {
            Site sitecache;
            IOARif ioa = this.cache.getIoa();
            if (ioa == null) {
                this.currentProgress = 90;
                this.updateStatus("Unable to reach DCNM-SAN Server");
                return this.cache;
            }
            if (this.isCancelled()) {
                return this.cache;
            }
            if (this.isRemove) {
                this.updateStatus("Looking up site...");
                sitecache = this.cache.getSite(this.site.getName());
                if (sitecache == null) {
                    OperationStatus errorStatus = new OperationStatus();
                    errorStatus.setStatus(OperationStatusEnum.Failure);
                    errorStatus.setDescription("An error occurred: Unknown site " + this.site.getName());
                    this.cache.setSwingWorkerStatus(errorStatus);
                    this.cache.setCustomDescription(true);
                    return this.cache;
                }
            } else {
                this.updateStatus("Adding site...");
                OperationStatus status = this.cache.addSiteToSwitch(this.cache.getSwingWorkerSiteName(), this.cache.getSwingWorkerSwitch());
                this.updateStatus("Operation completed.");
                this.showComplete();
                this.cache.setSwingWorkerStatus(status);
                return this.cache;
            }
            this.updateStatus("Removing site..");
            OperationStatus status = this.cache.removeSite(sitecache);
            this.updateStatus("Operation completed.");
            this.showComplete();
            this.cache.setSwingWorkerStatus(status);
            return this.cache;
        }
        catch (Exception e) {
            _Logger.error((Object)"IOAWorkerSite: unexpected exception", (Throwable)e);
            OperationStatus errorStatus = new OperationStatus();
            errorStatus.setStatus(OperationStatusEnum.Failure);
            errorStatus.setDescription("An unexpected error occurred, see log for details.");
            this.cache.setSwingWorkerStatus(errorStatus);
            this.cache.setCustomDescription(true);
            return this.cache;
        }
    }

    private void updateStatus(String message) {
        this.currentProgress += 33;
        if (this.currentProgress > 100) {
            this.currentProgress = 100;
        }
        this.setProgress(this.currentProgress);
        this.publish(new String[]{message});
    }

    protected void process(List<String> chunks) {
        int sz = chunks.size();
        String last = chunks.get(sz - 1);
        this.parent.progressDialog._label.setText(last);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cancel(true);
    }

    public void disappear() {
        this.parent.progressDialog.setVisible(false);
    }

    public void showComplete() {
        this.currentProgress = 100;
        this.setProgress(this.currentProgress);
    }

    String showInputDialog(String label, String defVal) {
        JOptionPane pane = new JOptionPane(label, 3, 2, null, null, null);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(defVal);
        JDialog dialog = pane.createDialog(this.parent.progressDialog, Util.getModParentTitle(Util.getFrameAncestor(this.parent.progressDialog)) + " " + label);
        pane.selectInitialValue();
        dialog.setVisible(true);
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value.toString();
    }

    private String showListSingleSelectDialog(String label, String[] list) {
        Object selectedValue = JOptionPane.showInputDialog(this.parent.progressDialog, label, "Select One", 1, null, list, list[0]);
        return (String)selectedValue;
    }

    private boolean showQueryDialog(String label) {
        int ret = JOptionPane.showConfirmDialog(this.parent.progressDialog, label, "", 0);
        return ret == 0;
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this.parent.progressDialog, message);
    }

    private ArrayList<Switch> removeUnsupportedSwitches(ArrayList<Switch> switchList) {
        ArrayList<Switch> swCandidates = new ArrayList<Switch>();
        SwitchVersion requiredVersion = new SwitchVersion("3.3(1.3)");
        for (Switch sw : switchList) {
            SwitchVersion swVersion;
            if (sw.getVersion() == null || !requiredVersion.lessThanEqual(swVersion = new SwitchVersion(sw.getVersion()))) continue;
            swCandidates.add(sw);
        }
        return swCandidates;
    }
}

