/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.iscsi;

import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.iscsi.IscsiDevice;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.DragTableModel;
import java.util.ArrayList;
import java.util.Collections;

public class StoragePortsTableModel
extends DragTableModel {
    static final String[] LABELS = new String[]{"Name", "Switch Interface", "FcId", "iSCSI Name"};
    static final int SWITCHPORT = 1;
    static final int NAME = 0;
    static final int FCID = 2;
    protected static final int ISCSI_NAME = 3;
    private Vsan _vsan;
    private Array _vsanPortList;
    private ArrayList _zonedPorts;
    private ArrayList _targets;

    public StoragePortsTableModel(Vsan v, Array vsanPortList) {
        this._vsan = v;
        this._vsanPortList = vsanPortList;
        this.setHeaders(LABELS);
    }

    public void setTargetPorts(ArrayList targets) {
        this._targets = targets;
    }

    public void updateData() {
        int headerCount = LABELS.length + 1;
        ArrayList<EndPort> memberList = this._vsan.getEndPorts(null);
        Array<Object[]> responseData = new Array<Object[]>();
        if (memberList != null) {
            for (int i = 0; i < memberList.size(); ++i) {
                Vsan v;
                EndPort zmem = memberList.get(i);
                if (!zmem.isPresent() || !zmem.isTarget() || this._zonedPorts != null && this._zonedPorts.contains(zmem) || this._vsan == null && this._vsanPortList != null && this._vsanPortList.findEquals(v = zmem.getFirstVsan()) == -1) continue;
                Object[] row = new Object[headerCount];
                row[0] = zmem;
                row[2] = zmem.getFcIdAsString();
                row[1] = EnforcedZoneMember.getSwitchPort(zmem, 1, null, this._vsan);
                this.setDeviceId(row, zmem);
                responseData.addElement(row);
            }
        }
        this.setData(responseData);
        this.sort(0, true);
    }

    protected void setDeviceId(Object[] row, EndPort ep) {
        this.setIscsiName(row, ep);
    }

    private void setIscsiName(Object[] row, EndPort ep) {
        ArrayList<String> name = new ArrayList<String>();
        if (this._targets != null) {
            for (int i = 0; i < this._targets.size(); ++i) {
                IscsiDevice dev = (IscsiDevice)this._targets.get(i);
                if (!SnmpString.equals(dev._pWWN, ep.getPortWwn().getValue()) || name.contains(dev._name)) continue;
                name.add(dev._name);
            }
        }
        Collections.sort(name);
        row[3] = name;
    }

    public Object getRowObjectForEndPort(EndPort port) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!port.equals(this.getEndPort(i))) continue;
            return this.getData().elementAt(i);
        }
        return null;
    }

    public EndPort getEndPort(int row) {
        return (EndPort)this.getValueAt(row, 0);
    }

    EndPort[] getEndPorts(int[] rows) {
        EndPort[] endPorts = new EndPort[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            endPorts[i] = this.getEndPort(rows[i]);
        }
        return endPorts;
    }

    public void setVsan(Vsan vsan) {
        this._vsan = vsan;
    }

    public void setZonedPorts(ArrayList ports) {
        this._zonedPorts = ports;
    }

    @Override
    public Object getDragObject(int row) {
        return ((Object[])this.getData().elementAt(row))[0];
    }
}

