/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic;

import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.ISLContext;
import com.cisco.dcbu.sm.client.SwitchContext;
import com.cisco.dcbu.sm.client.lic.Logger;
import com.cisco.dcbu.sm.client.lic.auth.TokenProvider;
import org.restlet.Restlet;
import org.restlet.data.Cookie;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.resource.DomRepresentation;
import org.restlet.util.Series;
import org.w3c.dom.Node;

public abstract class FMRestlet
extends Restlet {
    protected boolean isGet(Request req) {
        return req.getMethod().equals((Object)Method.GET);
    }

    protected boolean isPost(Request req) {
        return req.getMethod().equals((Object)Method.POST);
    }

    protected boolean isPut(Request req) {
        return req.getMethod().equals((Object)Method.PUT);
    }

    protected boolean isDelete(Request req) {
        return req.getMethod().equals((Object)Method.DELETE);
    }

    protected boolean isAuthorized(Request req) {
        Series cookies = req.getCookies();
        Cookie cookie = (Cookie)cookies.getFirst("token");
        if (cookie == null) {
            return false;
        }
        String token = cookie.getValue();
        if (!TokenProvider.getInstance().verifyToken(token)) {
            Logger.error("Unauthorized request from " + req.getClientInfo().getAddress());
            return false;
        }
        return true;
    }

    public ClientContext getContext(DomRepresentation dom) {
        String type = this.getNodeValue(dom, "/context/type/text()");
        if ("mds".equals(type)) {
            return this.getMDSContext(dom);
        }
        if ("isl".equals(type)) {
            return this.getISLContext(dom);
        }
        return null;
    }

    public ClientContext getMDSContext(DomRepresentation dom) {
        String ip = this.getNodeValue(dom, "/context/mds/ip/text()");
        String user = this.getNodeValue(dom, "/context/mds/user/text()");
        String password = this.getNodeValue(dom, "/context/mds/password/text()");
        String authPrivacy = this.getNodeValue(dom, "/context/mds/privacy/text()");
        String isV3 = this.getNodeValue(dom, "/context/mds/isV3/text()");
        String community = this.getNodeValue(dom, "/context/mds/community/text()");
        SwitchContext context = new SwitchContext();
        context.setPhysicalAttributeSelection("Switches");
        context.setSwitchIP(ip);
        context.setUserName(user);
        context.setPassword(password);
        context.setAuthPrivacy(authPrivacy);
        context.setUseSnmpV3(isV3);
        context.setCommunity(community);
        context.setTableSelection(ip);
        return context;
    }

    public ClientContext getISLContext(DomRepresentation dom) {
        String switchIP1 = this.getNodeValue(dom, "/context/isl/ep1/mds/ip/text()");
        String ifName1 = this.getNodeValue(dom, "/context/isl/ep1/if/name/text()");
        String switchIP2 = this.getNodeValue(dom, "/context/isl/ep2/mds/ip/text()");
        String ifName2 = this.getNodeValue(dom, "/context/isl/ep2/if/name/text()");
        String user = this.getNodeValue(dom, "/context/isl/ep1/mds/user/text()");
        String pass = this.getNodeValue(dom, "/context/isl/ep1/mds/password/text()");
        String authPrivacy = this.getNodeValue(dom, "/context/isl/ep1/mds/privacy/text()");
        String isV3 = this.getNodeValue(dom, "/context/isl/ep1/mds/isV3/text()");
        String community = this.getNodeValue(dom, "/context/isl/ep1/mds/community/text()");
        ISLContext context = new ISLContext();
        context.setUserName(user);
        context.setPassword(pass);
        context.setAuthPrivacy(authPrivacy);
        context.setUseSnmpV3(isV3);
        context.setCommunity(community);
        context.setISLActionName("interfaceAttributes");
        return context;
    }

    protected String getNodeValue(DomRepresentation dom, String node) {
        Node nodeIp = dom.getNode(node);
        String value = null;
        if (nodeIp != null) {
            value = nodeIp.getNodeValue();
        }
        return value;
    }
}

