/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic;

import com.cisco.dcbu.sm.client.lic.Logger;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import javax.net.ServerSocketFactory;

public class PortConfigurator {
    protected static boolean isFree(int port) {
        return PortConfigurator.freePort(true, port) != -1 && PortConfigurator.testServerPort(port);
    }

    public static int scanPort(int port) {
        for (int i = 0; i < 10; ++i) {
            Logger.debug("Trying " + port);
            if (PortConfigurator.isFree(port)) {
                return port;
            }
            port += new Random().nextInt(100);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean testServerPort(int port) {
        ServerSocket ss = null;
        try {
            ServerSocketFactory factory = ServerSocketFactory.getDefault();
            ss = factory.createServerSocket(port);
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException ioex) {
                    Logger.error(ioex.getMessage());
                }
            }
        }
        return true;
    }

    protected static int freePort(boolean tcp, int port) {
        int retPort = -1;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            InetSocketAddress sockAddr = new InetSocketAddress(addr, port);
            if (tcp) {
                Socket sock = new Socket();
                sock.bind(sockAddr);
                retPort = sock.getLocalPort();
                sock.close();
            } else {
                DatagramSocket dsock = new DatagramSocket(sockAddr);
                retPort = dsock.getLocalPort();
                dsock.close();
            }
        }
        catch (Exception ex) {
            retPort = -1;
        }
        return retPort;
    }
}

