/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic.discovery;

import com.cisco.dcbu.sm.client.lic.LICClient;
import com.cisco.dcbu.sm.client.lic.Logger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DCNMSender {
    private static DCNMSender instance = null;
    private InetAddress group = null;
    private MulticastSocket sender = null;

    public static synchronized DCNMSender getInstance() {
        if (instance == null) {
            instance = new DCNMSender();
        }
        return instance;
    }

    public DCNMSender() {
        try {
            this.sender = new MulticastSocket(10010);
            this.group = InetAddress.getByName("225.10.10.10");
            int ttl = Integer.parseInt("0");
            this.sender.setTimeToLive(ttl);
            this.sender.setLoopbackMode(true);
            InetAddress sock = InetAddress.getByName("127.0.0.1");
            this.sender.setNetworkInterface(NetworkInterface.getByInetAddress(sock));
            this.sender.joinGroup(this.group);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public void send() {
        try {
            String replyPort = Integer.toString(LICClient.getInstance().getRestPort());
            String tempToken = LICClient.getInstance().issueTmpToken();
            String serverIp = LICClient.getInstance().getServer();
            String str = "XXXX#" + serverIp + "#" + replyPort + "#" + tempToken;
            DatagramPacket pkt = new DatagramPacket(str.getBytes(), str.getBytes().length, this.group, 10010);
            if (this.sender != null) {
                this.sender.send(pkt);
            } else {
                Logger.error("Sender is not initialized");
            }
        }
        catch (UnknownHostException e) {
            Logger.error(e.getMessage());
        }
        catch (SocketException e) {
            Logger.error(e.getMessage());
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }
}

