/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.license;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.license.LicenseFinalPanel;
import com.cisco.dcbu.sm.client.license.LicenseWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.net.InetAddress;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class LicenseManual
extends LicenseFinalPanel
implements ActionListener,
SnmpCallbackIf {
    private static final int HOSTID = 3;
    private static final int ONBOOTFLASH = 4;
    private static final int FILE = 5;
    static final int[] ciscoFlashCopyRemotePasswordOid_pre_6_2_1 = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 10, 1, 2, 1, 1, 12};
    static int[] _spinLockOid = LicenseManual.getOids("clmLicenseConfigSpinLock");
    static int[] _licUriOid = LicenseManual.getOids("clmLicenseFileURI");
    static int[] _licNameOid = LicenseManual.getOids("clmLicenseFileTargetName");
    static int[] _licCmdOid = LicenseManual.getOids("clmLicenseConfigCommand");
    static int[] _licStatusOid = LicenseManual.getOids("clmLicenseConfigCommandStatus");
    static int[] _flashRowStatusOid = LicenseManual.getOids("ciscoFlashCopyEntryStatus");
    static int[] _flashStatusOid = LicenseManual.getOids("ciscoFlashCopyStatus");
    private static final int START_FLASH_COPY = 1;
    private static final int POLL_FLASH_COPY = 2;
    private static final int SET_REQ = 3;
    private static final int POLL_REQ = 4;
    private static final int DONE = 5;
    static LicenseFinalPanel.TableMouseListener _lsnr;
    static final String[] PROTO;
    JWizard _wizard;
    SnmpPeer[] _peers;
    static final int STATUS = 7;
    static final int INSTALL_UPDATE = 6;
    static final String INSTALL = "Install";
    static final String UPDATE = "Update";
    static final int UPDATE_LIC_CMD = 4;
    static final int INSTALL_LIC_CMD = 1;
    final String[] _cols = new String[]{"Select", "Switch", "Model", "Host ID", "On Bootflash?", "License File Name", "Install or Update?", "Status"};
    final boolean[] _attrs = new boolean[]{true, false, false, false, true, true, true, false};
    JButton _chooser;
    TFTP _tftp;
    String _localhost;
    JLabel[] _labels;
    JComponent[] _values;
    SnmpPDU _pollPdu;
    int _totalTime;
    int _state;
    int _processingRow = -1;
    int _pending;
    HeaderListener _headerListener = new HeaderListener();

    public LicenseManual(JWizard wizard, SnmpPeer[] peers) throws Exception {
        super("2 of 2: Install License File", "Enter the license file location for the selected switches.  If necessary, the file will be transfered to the switch bootflash prior to install.\nNOTE: If we cannot open TFTP port 69, you will need a local SSH server to allow scp/sftp. It is advisable to use the same username as the local user.", wizard);
        this._wizard = wizard;
        this._peers = peers;
        this.build();
    }

    @Override
    public void dispose() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        if (this._tftp != null) {
            this._tftp.stopServer();
            this._tftp = null;
        }
        this._wizard = null;
        _lsnr = null;
        super.dispose();
    }

    @Override
    public void doPrevious() {
        this._wizard.show("basePanel");
    }

    @Override
    public void doCancel() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        if (this._tftp != null) {
            this._tftp.stopServer();
            this._tftp = null;
        }
        this._wizard.setVisible(false);
    }

    @Override
    public void doFinish() {
        int j = 0;
        if (this._table.isEditing()) {
            this._table.editingStopped(null);
        }
        this.setStatus(" ");
        int[] selected = new int[this._table.getRowCount()];
        boolean local = false;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            this._model.setValueAt(new LicenseFinalPanel.Status(""), i, 7);
            boolean b = (Boolean)this._table.getValueAt(i, 0);
            if (!b) continue;
            String fileName = (String)this._table.getValueAt(i, 5);
            if (fileName.length() == 0) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please enter the license file names for all selected switches");
                return;
            }
            if (this.getLicFileName(fileName, true).length() > 32) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "License file names cannot exceed 32 characters.");
                return;
            }
            selected[j++] = i;
            b = (Boolean)this._table.getValueAt(i, 4);
            local = local || !b;
        }
        if (j == 0) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "No switch chosen");
            return;
        }
        this._rows = new int[j];
        System.arraycopy(selected, 0, this._rows, 0, j);
        if (local && this._proto > 0) {
            this._userStr = this._user.getText();
            if (this._userStr == null || this._userStr.length() == 0) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please enter a user name");
                return;
            }
            this._passStr = new String(this._pass.getPassword());
            if (this._passStr == null || this._passStr.length() == 0) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please enter a password");
                return;
            }
            this._proto = this._rbp.getSelected() + 5;
        }
        if (local && this._proto == 0) {
            try {
                if (this._tftp == null) {
                    this._tftp = TFTP.getInstance();
                    this._tftp.startServer(SnmpSession.isTrace());
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                this._tftp = null;
                return;
            }
        }
        this._wizard.getNavigator().getNextBtn().setEnabled(false);
        this._wizard.getNavigator().getBackBtn().setEnabled(false);
        this._wizard.getNavigator().getCancel().setEnabled(true);
        this.doNextRow();
    }

    private void install(SnmpPeer peer, boolean local, int row) {
        this.getData(peer, row);
        this._state = local ? 1 : 3;
        if (this._timer == null) {
            this._timer = new Timer(2000, this);
        }
        this._totalTime = 0;
        this._timer.setInitialDelay(0);
        this._timer.start();
    }

    @Override
    int getStatusCol() {
        return 7;
    }

    private void setStatus(String msg) {
        this._wizard.setStatus(msg);
    }

    private void getData(SnmpPeer peer, int row) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addVar(new SnmpOID(_spinLockOid, 0));
        try {
            SnmpPDU respPDU = peer.send(pdu);
            VarBindList vbl = respPDU.getVariables();
            SnmpVar spinLockVar = vbl.getVb(0).getVar();
            if (spinLockVar instanceof SnmpInt) {
                SnmpInt spinLock = (SnmpInt)vbl.getVb(0).getVar();
                LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._table.getValueAt(row, 7);
                status.setSpinLock(spinLock);
            } else if (spinLockVar instanceof SnmpNull) {
                DefaultLogger._DefLogger.debug((Object)("Unable to get license data - " + (SnmpNull)spinLockVar));
            }
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.debug((Object)("Unable to get license data - " + ex.getMessage()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            this._totalTime += 2;
            this.timerTick();
        } else if (e.getSource() instanceof JButton) {
            String cmd = ((JButton)e.getSource()).getText();
            switch (cmd.charAt(0)) {
                case 'C': {
                    if (this._timer != null) {
                        this._timer.stop();
                        this._timer = null;
                    }
                    if (this._tftp != null) {
                        this._tftp.stopServer();
                        this._tftp = null;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        int row = this.findRow(peer);
        if (row == -1) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), peer + " is not manageable, " + "close install dialog and reopen.");
            this._state = 5;
            this._pending = 0;
            return;
        }
        --this._pending;
        LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 7);
        if (timedOut) {
            if (this._state != 2 || this._state != 4) {
                status.setStatus("Error timeout");
            } else {
                status.setStatus("Timeout");
            }
        } else if (pdu.getError() != 0) {
            status.setStatus("Error " + SnmpException.toError(pdu.getError()));
        } else {
            VarBindList vbl = pdu.getVariables();
            int[] firstOid = vbl.getVb(0).getOid().getValue();
            if (SnmpOID.startsWith(firstOid, _hostIdOid)) {
                String hostid = vbl.stringValue(0);
                if (hostid.length() != 0) {
                    this._model.setValueAt(hostid, row, 3);
                } else {
                    status.setStatus("Error - no host id");
                }
            } else if (SnmpOID.startsWith(firstOid, _spinLockOid)) {
                SnmpInt spinLock = (SnmpInt)vbl.getVb(0).getVar();
                status.setSpinLock(spinLock);
            } else if (SnmpOID.startsWith(firstOid, _flashRowStatusOid)) {
                status.setStatus("Flash Copy Started");
            } else if (SnmpOID.startsWith(firstOid, _flashStatusOid)) {
                int flashStatus = vbl.intValue(0);
                switch (flashStatus) {
                    case 1: {
                        status.setStatus("Flash Copy InProgress");
                        break;
                    }
                    case 2: {
                        status.setStatus("Flash Copy Done");
                        status.setInProgress(false);
                        break;
                    }
                    default: {
                        status.setStatus("Error " + LicenseWizard.getEnum("ciscoFlashCopyStatus", flashStatus));
                        status.setInProgress(false);
                        break;
                    }
                }
            } else if (SnmpOID.startsWith(firstOid, _spinLockOid)) {
                status.setStatus("Installing/Updating license");
            } else if (SnmpOID.startsWith(firstOid, _licStatusOid)) {
                int licStatus = vbl.intValue(0);
                String msg = LicenseWizard.getEnum("clmLicenseConfigCommandStatus", licStatus);
                switch (licStatus) {
                    case 2: {
                        status.setStatus("Install/Update Status " + msg);
                        break;
                    }
                    case 1: {
                        status.setStatus("Success");
                        status.setInProgress(false);
                        if (this._numOfSuccessInstall != 0) break;
                        Switch s = (Switch)this._model.getValueAt(row, 1);
                        try {
                            ModelFacadeRif model = ClientController.getInstance().assertModelFacade();
                            model.rediscoverFabric((FabricPK)s.getFabric().getPK());
                            ++this._numOfSuccessInstall;
                        }
                        catch (Exception ex) {
                            DefaultLogger._DefLogger.error((Object)ex);
                        }
                        break;
                    }
                    default: {
                        status.setStatus("Error " + msg);
                        status.setInProgress(false);
                    }
                }
            }
        }
    }

    @Override
    protected void build() throws Exception {
        JPanel p = new JPanel(new BorderLayout());
        this._data = new Array();
        for (int i = 0; i < this._peers.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(this._peers[i].getAddress());
            if (!sw.isVersionGreaterThanEqual("1.3(0)") || sw.isUCS() || ((SwitchBase)sw.getBaseModelObject()).isVdc()) continue;
            this._data.addElement(new Object[]{Boolean.FALSE, sw, sw.getModel(), "", Boolean.FALSE, "", INSTALL, new LicenseFinalPanel.Status(""), null});
        }
        this._model = new SmLmTableModel();
        this._model.setData(this._data);
        this._model.setHeaders(this._cols);
        this._model.setEditable(this._attrs);
        this._table = new LicenseTable(this._model);
        this._table.setAutoResizeMode(3);
        this._table.getTableHeader().addMouseListener(this._headerListener);
        this._table.setSortable(true);
        this._table.addPopupMenu();
        TableColumnModel cm = this._table.getColumnModel();
        cm.setColumnSelectionAllowed(true);
        this._table.addMouseListener(this.getMouseListener());
        cm.getColumn(7).setCellRenderer(new MyStatusRenderer());
        this._table.setRowSelectionAllowed(true);
        cm.setColumnSelectionAllowed(true);
        this._sp = new JScrollPane(this._table);
        cm.getColumn(1).setPreferredWidth(110);
        cm.getColumn(3).setPreferredWidth(140);
        cm.getColumn(5).setPreferredWidth(200);
        cm.getColumn(5).setCellRenderer(new BaseRenderer());
        cm.getColumn(7).setPreferredWidth(150);
        JComboBox<String> installCombo = new JComboBox<String>();
        installCombo.addItem(INSTALL);
        installCombo.addItem(UPDATE);
        installCombo.setSelectedItem(INSTALL);
        DefaultCellEditor comboEditor = new DefaultCellEditor(installCombo);
        cm.getColumn(6).setCellEditor(comboEditor);
        int height = this._table.calcPreferredSize().height;
        if (height < 150) {
            height = 150;
        }
        this._sp.setPreferredSize(new Dimension(800, height));
        p.add("Center", this._sp);
        Box box = new Box(1);
        JPanel center = null;
        this._localhost = InetAddress.getLocalHost().getHostAddress();
        if (!TFTP.canStartServer()) {
            this._rbp = new RadioButtonPanel(PROTO, PROTO.length);
            this._rbp.setSelected(1);
            this._user = new KTextField(System.getProperty("user.name"), 20);
            this._pass = new JPasswordField(20);
            this._labels = DialogUtil.buildLabels(new String[]{"Protocol:", "UserName:", "Password:"});
            center = DialogUtil.buildPanel(this._labels, new JComponent[]{this._rbp, this._user, this._pass});
            this._proto = 6;
            box.add(center);
        } else {
            this._proto = 0;
        }
        this.getHostId();
        p.add("South", box);
        this.add("Center", p);
    }

    public MouseListener getMouseListener() {
        if (_lsnr == null) {
            _lsnr = new LicenseFinalPanel.TableMouseListener();
        }
        return _lsnr;
    }

    static String baseName(String uri) {
        int index;
        if (uri == null || uri.length() == 0) {
            return null;
        }
        int sep = 47;
        if (uri.lastIndexOf(sep) == -1) {
            sep = 92;
        }
        if ((index = uri.lastIndexOf(sep)) != -1) {
            uri = uri.substring(index + 1);
        }
        return uri;
    }

    void startFlashCopy(int row) {
        String srcFile;
        String server;
        SnmpPeer peer;
        LicenseFinalPanel.Status status;
        Switch sw;
        block10: {
            sw = (Switch)this._model.getValueAt(row, 1);
            status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 7);
            peer = sw.getPeer();
            if (peer == null) {
                status.setStatus("Error could not find peer");
                return;
            }
            server = this._localhost;
            String srcPath = srcFile = (String)this._model.getValueAt(row, 5);
            if (this._proto == 0) {
                srcFile = LicenseManual.baseName(srcPath);
                this._tftp.addIpAccess(peer.getAddress().getHostAddress(), "true", "true", "true");
                this._tftp.addFileMapping(srcFile, srcPath);
                try {
                    server = NetUtil.detectSourceAddress(peer.getAddress()).getHostAddress();
                }
                catch (Exception ex) {
                    if (!SnmpSession.isTrace()) break block10;
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        int[] index = new int[]{(int)(Math.random() * 2.14748364E8) + 1};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.addVar(new SnmpOID(_flashRowStatusOid, index), new SnmpInt(4));
        try {
            pdu.addVar(new SnmpOID(LicenseManual.getOids("ciscoFlashCopyServerAddress"), index), new SnmpIpAddress(server));
        }
        catch (SnmpException ex) {
            status.setStatus("Error " + ex.getMessage());
            return;
        }
        pdu.addVar(new SnmpOID(LicenseManual.getOids("ciscoFlashCopySourceName"), index), new SnmpString(LicenseManual.escapify(srcFile)));
        pdu.addVar(new SnmpOID(LicenseManual.getOids("ciscoFlashCopyDestinationName"), index), new SnmpString("bootflash:/" + this.getLicFileName(row, true)));
        pdu.addVar(new SnmpOID(LicenseManual.getOids("ciscoFlashCopyCommand"), index), new SnmpInt(1));
        if (this._proto == 0) {
            pdu.addVar(new SnmpOID(LicenseManual.getOids("ciscoFlashCopyProtocol"), index), new SnmpInt(1));
        } else {
            pdu.addVar(new SnmpOID(LicenseManual.getOids("ciscoFlashCopyProtocol"), index), new SnmpInt(this._proto));
            pdu.addVar(new SnmpOID(LicenseManual.getOids("ciscoFlashCopyRemoteUserName"), index), new SnmpString(this._userStr));
            pdu.addVar(new SnmpOID(sw.isVersionGreaterThanEqual("6.2(1)") ? LicenseManual.getOids("ciscoFlashCopyRemotePassword") : ciscoFlashCopyRemotePasswordOid_pre_6_2_1, index), new SnmpString(this._passStr));
            pdu.setVarBindMask(new int[]{pdu.getVariables().size() - 1});
        }
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.addVar(new SnmpOID(_flashStatusOid, index));
        status.setPollPdu(pollPdu);
        status.setInProgress(true);
        try {
            ++this._pending;
            status.setStatus("Flash copy started");
            peer.send(pdu, this);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    private String getLicFileName(int row, boolean isTrim) {
        String fname = (String)this._table.getValueAt(row, 5);
        return this.getLicFileName(fname, isTrim);
    }

    private int getInstallCmd(int row) {
        String cmd = (String)this._table.getValueAt(row, 6);
        if (UPDATE.equals(cmd)) {
            return 4;
        }
        return 1;
    }

    private String getLicFileName(String name, boolean isTrim) {
        if (isTrim) {
            int lIndexOf = name.lastIndexOf("/");
            if (lIndexOf == -1) {
                lIndexOf = name.lastIndexOf("\\");
            }
            return name.substring(lIndexOf + 1);
        }
        return name;
    }

    private void timerTick() {
        if (this._pending > 0) {
            return;
        }
        switch (this._state) {
            case 1: {
                if (!this.isDone(this._processingRow)) {
                    this.startFlashCopy(this._processingRow);
                }
                this._state = 2;
                break;
            }
            case 2: {
                LicenseFinalPanel.Status status;
                int copyInProgress = 0;
                if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue() && (status = (LicenseFinalPanel.Status)this._model.getValueAt(this._processingRow, 7)).inProgress()) {
                    ++copyInProgress;
                    this.pollFlashCopy(this._processingRow);
                }
                if (copyInProgress != 0) break;
                this._state = 3;
            }
            case 3: {
                this._state = 4;
                if (!this.isDone(this._processingRow)) {
                    this.installLic(this._processingRow);
                    break;
                }
            }
            case 4: {
                LicenseFinalPanel.Status status;
                int installInProgress = 0;
                if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue() && (status = (LicenseFinalPanel.Status)this._model.getValueAt(this._processingRow, 7)).inProgress()) {
                    ++installInProgress;
                    this.pollLic(this._processingRow);
                }
                if (installInProgress != 0) break;
                this._state = 5;
            }
        }
        if (this._state != 5) {
            this.setStatus("Elapsed " + this._totalTime + " secs");
        } else {
            this.doNextRow();
        }
    }

    void doNextRow() {
        if (this._rows.length == 0) {
            return;
        }
        if (this._processingRow == this._rows[this._rows.length - 1]) {
            if (this._timer != null) {
                this._timer.stop();
            }
            this._timer = null;
            if (this._tftp != null) {
                this._tftp.stopServer();
                this._tftp = null;
            }
            BrowserFrame.getDataView().refresh();
            this._wizard.getNavigator().getNextBtn().setEnabled(false);
            this._wizard.getNavigator().getBackBtn().setEnabled(false);
            this._wizard.getNavigator().getCancel().setText("Close");
            this._wizard.getNavigator().getCancel().setEnabled(true);
            return;
        }
        if (this._processingRow != -1) {
            for (int i = 0; i < this._rows.length; ++i) {
                if (this._processingRow != this._rows[i]) continue;
                this._processingRow = this._rows[i + 1];
                break;
            }
        } else {
            this._table.setEnabled(false);
            this._table.getTableHeader().removeMouseListener(this._headerListener);
            this._processingRow = this._rows[0];
        }
        boolean b = (Boolean)this._table.getValueAt(this._processingRow, 4);
        SnmpPeer switchPeer = ((Switch)this._table.getValueAt(this._processingRow, 1)).getPeer();
        this.install(switchPeer, !b, this._processingRow);
    }

    void installLic(int row) {
        Switch sw = (Switch)this._model.getValueAt(row, 1);
        LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 7);
        SnmpPeer peer = sw.getPeer();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.addVar(new SnmpOID(_spinLockOid, 0), status.getSpinLock());
        boolean isLocal = (Boolean)this._table.getValueAt(row, 4) == false;
        String URI2 = isLocal ? "bootflash:/" + this.getLicFileName(row, true) : this.getLicFileName(row, false);
        pdu.addVar(new SnmpOID(_licUriOid, 0), new SnmpString(URI2));
        pdu.addVar(new SnmpOID(_licNameOid, 0), new SnmpString(this.getLicFileName(row, true)));
        pdu.addVar(new SnmpOID(_licCmdOid, 0), new SnmpInt(this.getInstallCmd(row)));
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.addVar(new SnmpOID(_licStatusOid, 0));
        status.setPollPdu(pollPdu);
        status.setInProgress(true);
        try {
            ++this._pending;
            status.setStatus("Install/Update license");
            peer.send(pdu, this);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    static {
        PROTO = new String[]{"scp", "sftp"};
    }

    class LicenseTable
    extends SnmpKTable {
        BootCellEditor bootcellEditor;
        FileCellEditor fileCellEditor;

        public LicenseTable(KTableModel model) {
            super(model, false);
            this.bootcellEditor = new BootCellEditor();
            this.fileCellEditor = new FileCellEditor();
        }

        public LicenseTable(KTableModel model, boolean multiRow) {
            super(model, multiRow);
            this.bootcellEditor = new BootCellEditor();
            this.fileCellEditor = new FileCellEditor();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 5) {
                if (((Boolean)LicenseManual.this._model.getValueAt(row, 4)).booleanValue()) {
                    return this.bootcellEditor;
                }
                return this.fileCellEditor;
            }
            return super.getCellEditor(row, col);
        }
    }

    class MyStatusRenderer
    extends BorderCellRenderer {
        MyStatusRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                boolean b = false;
                if (LicenseManual.this._rows != null) {
                    for (int i = 0; i < LicenseManual.this._rows.length; ++i) {
                        b = b || LicenseManual.this._rows[i] == row;
                    }
                }
                if (b) {
                    String status = value.toString();
                    if (status.startsWith("Success")) {
                        this.setBackground(new Color(128, 255, 128));
                    } else if (status.trim().startsWith("Error")) {
                        this.setBackground(Color.pink);
                    } else {
                        this.setBackground(table.getBackground());
                    }
                } else {
                    this.setBackground(table.getBackground());
                }
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class FileCellEditor
    extends DefaultCellEditor {
        public FileCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String fname = Util.getFileName(BrowserFrame.getInstance(), "*.lic", 0, true);
            if (fname != null) {
                table.getModel().setValueAt(fname, row, column);
                ((KTableModel)table.getModel()).fireTableDataChanged();
            }
            return null;
        }
    }

    class BaseRenderer
    extends ChangedCellRenderer {
        BaseRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && value.toString().length() > 0) {
                int slash = value.toString().indexOf("/");
                if (slash != -1) {
                    this.setText(value.toString().substring(slash + 1));
                } else {
                    this.setText(value.toString());
                }
            }
            return c;
        }
    }

    class BootCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        HashMap _swToFlash;
        JTable _table;
        int _row;
        int _column;

        public BootCellEditor() {
            super(new JTextField());
            this._swToFlash = new HashMap();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JPopupMenu menu;
            this._table = table;
            this._row = row;
            this._column = column;
            Switch sw = (Switch)LicenseManual.this._model.getValueAt(row, 1);
            if (this._swToFlash.containsKey(sw)) {
                menu = (JPopupMenu)this._swToFlash.get(sw);
                if (menu.getComponents().length == 0) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), "No license files on bootflash");
                }
            } else {
                String[] files;
                block8: {
                    try {
                        files = this.getFiles(sw);
                        if (files == null || files.length == 0) {
                            Util.errorMessage((Component)BrowserFrame.getInstance(), "No license files on bootflash");
                            return null;
                        }
                    }
                    catch (SnmpException ex) {
                        files = new String[]{};
                        Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                        if (!SnmpSession.isTrace()) break block8;
                        DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                menu = new JPopupMenu();
                for (int j = 0; j < files.length; ++j) {
                    JMenuItem mi = new JMenuItem(files[j]);
                    menu.add(mi);
                    mi.addActionListener(this);
                }
                this._swToFlash.put(sw, menu);
            }
            Rectangle rect = table.getCellRect(row, column, false);
            if (menu.getComponents().length > 0) {
                menu.show(this._table, rect.x, rect.y);
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            this._table.getModel().setValueAt("bootflash:/" + mi.getText(), this._row, this._column);
        }

        String[] getFiles(Switch sw) throws SnmpException {
            SnmpPeer peer = sw.getPeer();
            int[] index = new int[]{1, 1};
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ciscoFlashFileName").getOid(), index)));
            vbl = SnmpFetch.getBulk(peer, vbl).getVariables();
            if (vbl.size() == 0) {
                return null;
            }
            String[] names = new String[vbl.size()];
            int num = 0;
            for (int i = 0; i < names.length; ++i) {
                String f = vbl.get(i).getVar().toString();
                if (f.startsWith("/.") || f.startsWith(".") || f.endsWith("/") || f.endsWith("/.") || f.endsWith("/..") || !f.endsWith(".lic")) continue;
                if (f.startsWith("/")) {
                    f = f.substring(1);
                }
                names[num++] = f;
            }
            String[] vals = new String[num];
            System.arraycopy(names, 0, vals, 0, num);
            return vals;
        }
    }

    class SmLmTableModel
    extends SnmpTableModel {
        SmLmTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 5 || col == 4 || col == 6) {
                return LicenseManual.this._model.getValueAt(row, 0) == null || (Boolean)LicenseManual.this._model.getValueAt(row, 0) != false;
            }
            return super.getEditable()[col];
        }

        @Override
        public boolean isCellActive(int row, int col) {
            boolean b = (Boolean)LicenseManual.this._table.getValueAt(row, 0);
            return col == 0 || b;
        }
    }
}

