/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.linksecurity.AbstractAsyncObjectTask;
import com.cisco.dcbu.sm.client.linksecurity.SaSetTask;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.wizardTask.BulkActionTableModel;
import com.cisco.dcbu.sm.client.wizardTask.ObjectActionTracker;
import com.cisco.dcbu.sm.client.wizardTask.ProgressPanel;
import com.cisco.dcbu.sm.common.dto.ESPDto;
import com.cisco.dcbu.sm.common.dto.QueueResponseBaseModelObject;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ESPSetTask
extends AbstractAsyncObjectTask {
    public static final Logger _Logger = Logger.getLogger(SaSetTask.class);
    Map<Isl, ESPDto> espData;
    Map<IslBase, Isl> baseToIslMap = new HashMap<IslBase, Isl>();

    public ESPSetTask(Integer type, String typeDisplayString, Map<Isl, ESPDto> espData, BulkActionTableModel tm, ProgressPanel progress) {
        if (type == null || espData == null || typeDisplayString == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (espData.size() < 1) {
            throw new IllegalArgumentException("ESP list cannot be empty");
        }
        this.type = type;
        this.typeDisplayString = typeDisplayString;
        this.progress = progress;
        this.tm = tm;
        this.espData = espData;
        Set<Isl> isls = espData.keySet();
        this.allSet.addAll(isls);
        this.objList.addAll(isls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Object event) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            _Logger.trace((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ", message->" + event));
            _Logger.trace((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        ESPSetTask eSPSetTask = this;
        synchronized (eSPSetTask) {
            if (event instanceof QueueResponseBaseModelObject) {
                QueueResponseBaseModelObject resp = (QueueResponseBaseModelObject)event;
                if (resp.getRequestId() == this.requestId && this.isTaskRunning()) {
                    IslBase baseObj = (IslBase)resp.getBaseModel();
                    Isl isl = this.baseToIslMap.get(baseObj);
                    SwitchBase sw = resp.getSwitchBase();
                    int result = resp.getResultValue();
                    ObjectActionTracker.Status status = ObjectActionTracker.NA;
                    String message = resp.getStatusStr();
                    Exception error = resp.getException();
                    switch (result) {
                        case 3: {
                            status = ObjectActionTracker.INPROGRESS;
                            if (message != null) break;
                            message = "In progress";
                            break;
                        }
                        case 4: {
                            status = ObjectActionTracker.ERROR;
                            if (error instanceof SnmpException && error.getMessage() != null && (error.getMessage().indexOf("Invalid Credentials") >= 0 || error.getMessage().indexOf("Privacy unsupported for this user") >= 0)) {
                                _Logger.warn((Object)(this + " got authentication error from " + sw.getIpAddress() + " SNMP"), (Throwable)error);
                                status = ObjectActionTracker.FAILED;
                                if (message == null) {
                                    message = "Switch (" + sw.getIpAddress() + ") authentication failed.";
                                }
                            }
                            if (message != null) break;
                            message = "Got error";
                            break;
                        }
                        case 1: {
                            status = ObjectActionTracker.SUCCESS;
                            if (message != null) break;
                            message = "Successful";
                            break;
                        }
                        case 6: {
                            status = ObjectActionTracker.FAILED;
                            if (message != null) break;
                            message = "Failed";
                            break;
                        }
                        case 2: {
                            status = ObjectActionTracker.FAILED;
                            if (message != null) break;
                            message = "Failed";
                            break;
                        }
                        case 5: {
                            status = ObjectActionTracker.UNKNOW;
                            if (message != null) break;
                            message = "Unknown";
                        }
                    }
                    if (status != ObjectActionTracker.NA) {
                        this.updateObjectTaskStatus(isl, status, message, error);
                    }
                    this.notifyAll();
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ", message->" + event + ": notifyAll"));
                    }
                } else {
                    _Logger.debug((Object)(this + "- onMessage unexpected: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + " received wrong response:" + event));
                }
            } else {
                _Logger.warn((Object)(this + "- onMessage unexpected: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + " received unexpected object (" + event.getClass() + "): " + event));
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " process onMessage at time:" + this.timer.getTimeDisplay()));
        }
    }

    @Override
    protected long sendRequest() throws Exception {
        HashMap<IslBase, ESPDto> data = new HashMap<IslBase, ESPDto>();
        Set<Isl> isls = this.espData.keySet();
        for (Isl nextIsl : isls) {
            IslBase nextBase = (IslBase)nextIsl.getBaseModelObject();
            this.baseToIslMap.put(nextBase, nextIsl);
            data.put(nextBase, this.espData.get(nextIsl));
        }
        long reqId = ClientController.getInstance().assertESP().setFcspESP(data, this.p2pHandler.getCommunicationObject());
        return reqId;
    }

    @Override
    protected void adjustComponents() {
        ArrayList oldObjList = new ArrayList(this.objList);
        this.objList.clear();
        int i = 0;
        for (Object obj : oldObjList) {
            if (!this.succSet.contains(obj)) {
                this.objList.add(obj);
            }
            ++i;
        }
        oldObjList.clear();
    }

    @Override
    public void closeTask() {
        super.closeTask();
        this.espData.clear();
    }
}

