/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.mds.LinkSecurityUtil;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.linksecurity.LinkSecurityWizard;
import com.cisco.dcbu.sm.client.linksecurity.SASwitchPair;
import com.cisco.dcbu.sm.client.linksecurity.SASwithPairTableModel;
import com.cisco.dcbu.sm.client.linksecurity.SATable;
import com.cisco.dcbu.sm.client.linksecurity.SAViewDialog;
import com.cisco.dcbu.sm.client.wizardTask.IntegerAsStringRenderer;
import com.cisco.dcbu.sm.client.wizardTask.LongAsStringRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class LinkSecuritySAConfigStep
extends WizardPanel
implements ActionListener {
    public static final String StepTitle = "Step 2 of 4: Create Security Associations";
    public static final String StepDesp = "This step is optional for all switch pairs that have at least one existing SA in common of which you plan to use for the configuration of the SPI for the ISLs.  The SPI(Security Parameter Index) of the SA is the unique key to identify an SA for use in later configuration.\nNote: Any SAs you create in this step can be used in the next step but won't be created until you click finish.";
    private JScrollPane _scrPanel;
    private List<SASwitchPair> _switchPairs = new ArrayList<SASwitchPair>();
    JComboBox _switchPairsBox;
    List<Integer> _allUsedSpi;
    SATable _saTable;
    SASwithPairTableModel _saTableModel;
    JTextField _spiField;
    JTextField _saltField;
    JTextField _keyField;
    JRadioButton _saAllSwitches;
    JRadioButton _saPerSwitchPair;
    JButton _viewButton;
    JButton _generate;
    JLabel[] _labels;

    public LinkSecuritySAConfigStep(LinkSecurityWizard wizard) {
        super(StepTitle, StepDesp, wizard, LinkSecurityWizard.WIZARD_ICON);
        this._switchPairs.addAll(wizard.getSwitchPairs());
        this.initialize();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public synchronized boolean refresh() {
        List<SASwitchPair> swCurrentPairs = ((LinkSecurityWizard)this.getWizard()).getSwitchPairs();
        if (!this._switchPairs.equals(swCurrentPairs)) {
            ArrayList<SASwitchPair> deletedList = new ArrayList<SASwitchPair>();
            deletedList.addAll(this._switchPairs);
            deletedList.removeAll(swCurrentPairs);
            for (SASwitchPair nextPair : deletedList) {
                this._saTableModel.deleteAllEntriesFor(nextPair);
            }
            ArrayList<SASwitchPair> addedList = new ArrayList<SASwitchPair>();
            addedList.addAll(swCurrentPairs);
            addedList.removeAll(this._switchPairs);
            this._switchPairs.removeAll(deletedList);
            this._switchPairs.addAll(addedList);
        }
        DefaultComboBoxModel<Object> selectModel = new DefaultComboBoxModel<Object>(this._switchPairs.toArray());
        this._switchPairsBox.setModel(selectModel);
        this.setNextSpi();
        return super.refresh();
    }

    private void setNextSpi() {
        Integer nextSpi = -1;
        if (this._saPerSwitchPair.isSelected()) {
            SASwitchPair selectedSwP = (SASwitchPair)this._switchPairsBox.getSelectedItem();
            nextSpi = this.getFirstCommonlyAvailableSpi(selectedSwP);
        } else {
            nextSpi = this.getFirstCommonlyAvailableSpi();
        }
        if (nextSpi != -1) {
            this._spiField.setText(nextSpi.toString());
        } else {
            this._spiField.setText("");
            Util.errorMessage((Component)this, "There are no available free SPIs for this switch pair");
        }
    }

    private Integer getFirstCommonlyAvailableSpi(SASwitchPair selectedSwP) {
        this._allUsedSpi = selectedSwP.getAllUsedSpiList();
        for (SASwitchPair nextPair : this._switchPairs) {
            if (nextPair.equals(selectedSwP) || !nextPair.getSw1().equals(selectedSwP.getSw1()) && !nextPair.getSw1().equals(selectedSwP.getSw2()) && !nextPair.getSw2().equals(selectedSwP.getSw1()) && !nextPair.getSw2().equals(selectedSwP.getSw2())) continue;
            this._allUsedSpi.addAll(nextPair.getAllUsedSpiInToCreateList());
        }
        Integer nextPossibleSpi = SASwitchPair.MIN_SPI;
        while (nextPossibleSpi <= SASwitchPair.MAX_SPI && this._allUsedSpi.size() > 0 && this._allUsedSpi.contains(nextPossibleSpi)) {
            Integer n = nextPossibleSpi;
            Integer n2 = nextPossibleSpi = Integer.valueOf(nextPossibleSpi + 1);
        }
        if (nextPossibleSpi > SASwitchPair.MAX_SPI) {
            nextPossibleSpi = new Integer("-1");
        }
        return nextPossibleSpi;
    }

    private Integer getFirstCommonlyAvailableSpi() {
        this._allUsedSpi = new ArrayList<Integer>();
        for (SASwitchPair nextPair : this._switchPairs) {
            List<Integer> nextPairUsed = nextPair.getAllUsedSpiList();
            ArrayList<Integer> noDupSpi = new ArrayList<Integer>();
            noDupSpi.addAll(nextPairUsed);
            noDupSpi.removeAll(this._allUsedSpi);
            this._allUsedSpi.addAll(noDupSpi);
        }
        Collections.sort(this._allUsedSpi);
        Integer nextPossibleSpi = SASwitchPair.MIN_SPI;
        while (nextPossibleSpi <= SASwitchPair.MAX_SPI && this._allUsedSpi.size() > 0 && this._allUsedSpi.contains(nextPossibleSpi)) {
            Integer n = nextPossibleSpi;
            Integer n2 = nextPossibleSpi = Integer.valueOf(nextPossibleSpi + 1);
        }
        if (nextPossibleSpi > SASwitchPair.MAX_SPI) {
            nextPossibleSpi = new Integer("-1");
        }
        return nextPossibleSpi;
    }

    private void generateSaltKey() {
        String keyStr = LinkSecurityUtil.generateKey();
        this._keyField.setText(keyStr);
        long saltGen = LinkSecurityUtil.generateSalt();
        this._saltField.setText(String.valueOf(saltGen));
    }

    private void clearFields() {
        this.setNextSpi();
        this._saltField.setText("");
        this._keyField.setText("");
    }

    @Override
    public void doNext() {
        ArrayList<SASwitchPair> allPairsWNoCommonSa = new ArrayList<SASwitchPair>();
        for (SASwitchPair nextPair : this._switchPairs) {
            List<Integer> commonSa = nextPair.getCommonSaAndNewSpiList();
            if (commonSa.size() >= 1) continue;
            allPairsWNoCommonSa.add(nextPair);
        }
        if (allPairsWNoCommonSa.size() > 0) {
            Object[] msgAndList = new Object[2];
            msgAndList[0] = new String("The following SwitchPairs do not have any SA's in common \nand as such you need to add at least on SA for each:");
            JList<Object> displayList = new JList<Object>(allPairsWNoCommonSa.toArray());
            JScrollPane scrPan = new JScrollPane(displayList);
            msgAndList[1] = scrPan;
            JOptionPane.showMessageDialog(this, msgAndList, "Error :FC-SP ESP Setup Wizard", 0);
            return;
        }
        ((LinkSecurityWizard)this.getWizard()).updateSwitchPairs(this._switchPairs);
        this.setDataValid(false);
        super.doNext();
    }

    private void initialize() {
        JButton[] buttons;
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this._labels = DialogUtil.buildLabels(new String[]{"Switch Pairs", "SPI", "Salt", "Key(Hex String)", "Automatically Generated"});
        Dimension labelDim = new Dimension(70, 20);
        JPanel compPanel = new JPanel();
        compPanel.setLayout(new BoxLayout(compPanel, 1));
        JPanel row0 = new JPanel(new FlowLayout(1));
        JPanel row1 = new JPanel(new FlowLayout(0));
        JPanel row2 = new JPanel(new FlowLayout(0));
        JPanel row3 = new JPanel(new FlowLayout(0));
        this._saAllSwitches = new JRadioButton("Create SA Per All Switches", true);
        this._saAllSwitches.setPreferredSize(new Dimension(200, 22));
        this._saAllSwitches.setActionCommand("allSwitches");
        this._saAllSwitches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkSecuritySAConfigStep.this._switchPairsBox.setEnabled(false);
                LinkSecuritySAConfigStep.this._viewButton.setEnabled(false);
                LinkSecuritySAConfigStep.this._labels[0].setEnabled(false);
                LinkSecuritySAConfigStep.this.clearFields();
            }
        });
        this._saPerSwitchPair = new JRadioButton("Create SA Per Switch Pairs", false);
        this._saPerSwitchPair.setPreferredSize(new Dimension(200, 22));
        this._saPerSwitchPair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkSecuritySAConfigStep.this._switchPairsBox.setEnabled(true);
                LinkSecuritySAConfigStep.this._viewButton.setEnabled(true);
                LinkSecuritySAConfigStep.this._labels[0].setEnabled(true);
                LinkSecuritySAConfigStep.this.clearFields();
            }
        });
        ButtonGroup perSaGroup = new ButtonGroup();
        perSaGroup.add(this._saAllSwitches);
        perSaGroup.add(this._saPerSwitchPair);
        row0.add(this._saAllSwitches);
        row0.add(this._saPerSwitchPair);
        compPanel.add(row0);
        this._switchPairsBox = new JComboBox<Object>(this._switchPairs.toArray());
        this._switchPairsBox.setPreferredSize(new Dimension(200, 22));
        this._switchPairsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LinkSecuritySAConfigStep.this.clearFields();
            }
        });
        this._viewButton = new JButton("View Existing SA");
        this._viewButton.setActionCommand("V");
        this._viewButton.addActionListener(this);
        this._generate = new JButton("Generate Salt/Key");
        this._generate.setActionCommand("G");
        this._generate.addActionListener(this);
        this._labels[0].setPreferredSize(labelDim);
        this._switchPairsBox.setEnabled(false);
        this._viewButton.setEnabled(false);
        this._labels[0].setEnabled(false);
        row1.add(this._labels[0]);
        row1.add(this._switchPairsBox);
        row1.add(this._viewButton);
        row1.add(this._generate);
        compPanel.add(row1);
        NumbericMaxLengthDocFilter spiDocFilter = new NumbericMaxLengthDocFilter(5);
        MaxIntegerSpiVerifier spiInputVerifier = new MaxIntegerSpiVerifier(this);
        this._spiField = new JTextField();
        ((AbstractDocument)this._spiField.getDocument()).setDocumentFilter(spiDocFilter);
        this._spiField.setInputVerifier(spiInputVerifier);
        this._spiField.setColumns(15);
        this._saltField = new JTextField();
        NumbericMaxLengthDocFilter docFilter = new NumbericMaxLengthDocFilter(10);
        ((AbstractDocument)this._saltField.getDocument()).setDocumentFilter(docFilter);
        MaxSaltInputVerifier saltInputVerifier = new MaxSaltInputVerifier(this, new Long(0L));
        this._saltField.setColumns(15);
        this._saltField.setInputVerifier(saltInputVerifier);
        this._labels[1].setPreferredSize(labelDim);
        row2.add(this._labels[1]);
        row2.add(this._spiField);
        row2.add(this._labels[4]);
        compPanel.add(row2);
        this._keyField = new JTextField(32);
        KeyInputVerifier keyInputVerifier = new KeyInputVerifier(this);
        HexStringMaxLengthDocFilter hexDocFilter = new HexStringMaxLengthDocFilter(32);
        ((AbstractDocument)this._keyField.getDocument()).setDocumentFilter(hexDocFilter);
        this._keyField.setInputVerifier(keyInputVerifier);
        this._labels[2].setPreferredSize(labelDim);
        row3.add(this._labels[2]);
        row3.add(this._saltField);
        row3.add(this._labels[3]);
        row3.add(this._keyField);
        compPanel.add(row3);
        topPanel.add(compPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        for (JButton nextButton : buttons = DialogUtil.buildButtons(new String[][]{{"Add", "A"}, {"Delete", "D"}, {"Delete All", "DA"}}, (ActionListener)this)) {
            buttonPanel.add(nextButton);
        }
        bottomPanel.add((Component)buttonPanel, "North");
        this._saTableModel = new SASwithPairTableModel(new String[]{"Switch Pairs", "SPI", "Salt", "Key"});
        this._saTableModel.setEditable(new boolean[]{false, false, false});
        this._saTable = new SATable(this._saTableModel);
        this._saTable.setColumnWidth(new int[]{20, 6, 6, 30});
        IntegerAsStringRenderer intAsStringRenderer = new IntegerAsStringRenderer();
        this._saTable.setDefaultRenderer(Integer.class, intAsStringRenderer);
        LongAsStringRenderer longAsStringRenderer = new LongAsStringRenderer();
        this._saTable.setDefaultRenderer(Long.class, longAsStringRenderer);
        this._scrPanel = new JScrollPane(this._saTable);
        bottomPanel.add((Component)this._scrPanel, "Center");
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)bottomPanel, "Center");
        this.add((Component)mainPanel, "Center");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("A")) {
            String spiText = this._spiField.getText();
            String saltText = this._saltField.getText();
            String key = this._keyField.getText();
            SASwitchPair selectedPair = (SASwitchPair)this._switchPairsBox.getSelectedItem();
            if (spiText.trim().length() == 0 || saltText.trim().length() == 0 || key.trim().length() == 0 || this._saPerSwitchPair.isSelected() && selectedPair == null) {
                Util.errorMessage((Component)this.getWizard(), new Exception("All fields must not be empty."));
                return;
            }
            Integer spi = new Integer(this._spiField.getText());
            Long salt = new Long(this._saltField.getText());
            try {
                if (this._saPerSwitchPair.isSelected()) {
                    this._saTableModel.addEntry(selectedPair, spi, salt, key);
                } else {
                    for (SASwitchPair nextPair : this._switchPairs) {
                        this._saTableModel.addEntry(nextPair, spi, salt, key);
                    }
                }
                this.clearFields();
                return;
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                return;
            }
        }
        if (cmd.equals("DA")) {
            this._saTableModel.clearAll();
            this.clearFields();
            return;
        }
        if (cmd.equals("D")) {
            int[] selectedRows = this._saTable.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                this._saTableModel.deleteRows(selectedRows);
                this.clearFields();
                return;
            }
            Util.errorMessage((Component)this, "There are no selected rows.");
            return;
        }
        if (cmd.equals("V")) {
            SASwitchPair selectedPair = (SASwitchPair)this._switchPairsBox.getSelectedItem();
            SAViewDialog viewDialog = new SAViewDialog(this.getWizard(), selectedPair);
            viewDialog.setVisible(true);
            return;
        }
        if (!cmd.equals("G")) return;
        this.generateSaltKey();
    }

    class MaxLenDocumentFilter
    extends DocumentFilter {
        int _maxLength = 100;

        public MaxLenDocumentFilter(int length) {
            this._maxLength = length;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (fb.getDocument().getLength() + text.length() - length <= this._maxLength) {
                super.replace(fb, offset, length, text, attrs);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (fb.getDocument().getLength() + string.length() <= this._maxLength) {
                super.insertString(fb, offset, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class NumbericMaxLengthDocFilter
    extends MaxLenDocumentFilter {
        public NumbericMaxLengthDocFilter(int maxlength) {
            super(maxlength);
        }

        private boolean validateNumericOnly(String text) {
            try {
                Long.parseLong(text);
                return true;
            }
            catch (NumberFormatException ne) {
                return false;
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text.trim().length() == 0 && offset == 0 && fb.getDocument().getLength() == length) {
                super.replace(fb, offset, length, text, attrs);
                return;
            }
            if (!this.validateNumericOnly(text)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.replace(fb, offset, length, text, attrs);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            if (!this.validateNumericOnly(text)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(fb, offset, text, attr);
        }
    }

    class HexStringMaxLengthDocFilter
    extends MaxLenDocumentFilter {
        public HexStringMaxLengthDocFilter(int maxlength) {
            super(maxlength);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text.trim().length() == 0 && offset == 0 && fb.getDocument().getLength() == length) {
                super.replace(fb, offset, length, text, attrs);
                return;
            }
            try {
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (Character.digit(c, 16) >= 0) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.replace(fb, offset, length, text, attrs);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            try {
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (Character.digit(c, 16) >= 0) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(fb, offset, text, attr);
        }
    }

    class MaxSaltInputVerifier
    extends InputVerifier {
        Long _maxValue = new Long("4294967295");
        Long _minValue = new Long("256");
        Component _parent;

        public MaxSaltInputVerifier(Component parent) {
            this._parent = parent;
        }

        public MaxSaltInputVerifier(Component parent, Long minValue) {
            this._parent = parent;
            this._minValue = minValue;
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            String text = tf.getText();
            try {
                if (text.trim().length() == 0) {
                    return true;
                }
                Long longValue = Long.parseLong(text);
                if (longValue <= this._maxValue) {
                    if (longValue >= this._minValue) {
                        return true;
                    }
                    Util.errorMessage(this._parent, "Min value allowed is " + this._minValue);
                } else {
                    Util.errorMessage(this._parent, "Max value allowed is " + this._maxValue);
                }
            }
            catch (NumberFormatException ne) {
                Util.errorMessage(this._parent, "Max value allowed is " + this._maxValue);
            }
            return false;
        }
    }

    class KeyInputVerifier
    extends InputVerifier {
        Component _parent;

        public KeyInputVerifier(Component parent) {
            this._parent = parent;
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            String text = tf.getText();
            if (text.trim().length() == 0) {
                return true;
            }
            if (text.trim().length() >= 32) {
                return true;
            }
            Util.errorMessage(this._parent, "Key is required to contain 32 characters.");
            return false;
        }
    }

    class MaxIntegerSpiVerifier
    extends InputVerifier {
        Integer _maxValue = new Integer(SASwitchPair.MAX_SPI);
        Integer _minValue = new Integer(SASwitchPair.MIN_SPI);
        Component _parent;

        public MaxIntegerSpiVerifier(Component parent) {
            this._parent = parent;
        }

        public MaxIntegerSpiVerifier(Component parent, Integer minValue) {
            this._parent = parent;
            this._minValue = minValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            String text = tf.getText();
            try {
                if (text.trim().length() == 0) {
                    return true;
                }
                Integer intValue = Integer.parseInt(text);
                if (intValue <= this._maxValue) {
                    if (intValue >= this._minValue) {
                        if (!LinkSecuritySAConfigStep.this._allUsedSpi.contains(intValue)) return true;
                        Util.errorMessage(this._parent, "This SPI value is already used.");
                        return false;
                    } else {
                        Util.errorMessage(this._parent, "Min SPI value allowed is " + this._minValue);
                    }
                    return false;
                } else {
                    Util.errorMessage(this._parent, "Max SPI value allowed is " + this._maxValue);
                }
                return false;
            }
            catch (NumberFormatException ne) {
                Util.errorMessage(this._parent, "Max value allowed is " + this._maxValue);
            }
            return false;
        }
    }
}

