/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.lib.ui.tree.DynamicTreeNode;
import com.cisco.dcbu.sm.client.gui.TreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.IvrVsanTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.SegmentedVsanTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.VsanTree;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeNode;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupManager;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupUnion;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.type.FabricPK;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;

public class VsanTopTreeNode
extends DynamicTreeNode {
    public VsanTopTreeNode(Fabric fabric) {
        super(fabric);
    }

    @Override
    public boolean loadChildren() {
        int childCount = 0;
        PerspectiveIf view = PerspectiveManager.getInstance().getView();
        if (view != null && view.isVisible("tree", "All VSANs")) {
            int i;
            int segCount;
            DefaultMutableTreeNode allVsans = new DefaultMutableTreeNode(new TreeCommand("All VSANs", "physicalVsanTab"));
            this.insert(allVsans, childCount++);
            int index = 0;
            if (view.isVisible("tree", "ivrAttributeTab")) {
                IvrVsanTreeNode ivrNode = new IvrVsanTreeNode(new VsanTreeCommand(this.getFabric(), null, "ivrAttributeTab"));
                allVsans.insert(ivrNode, index++);
            }
            if (view.isVisible("tree", "DPVM (Dynamic Membership)")) {
                allVsans.insert(new DefaultMutableTreeNode(new TreeCommand("DPVM (Dynamic Membership)", "dpvmManagerTab")), index++);
            }
            if (view.isVisible("tree", "Domain Manager")) {
                DefaultMutableTreeNode db = new DefaultMutableTreeNode(new TreeCommand("Domain Manager", "dmTab"));
                allVsans.insert(db, index++);
                db.insert(new DefaultMutableTreeNode(new TreeCommand("Allowed", "dmAllowedStatusTab")), 0);
            }
            if (view.isVisible("tree", "Port Security")) {
                allVsans.insert(new DefaultMutableTreeNode(new TreeCommand("Port Security", "psmStatusTab")), index++);
            }
            if (view.isVisible("tree", "Fabric Binding")) {
                allVsans.insert(new DefaultMutableTreeNode(new TreeCommand("Fabric Binding", "fabricBindStatusTab")), index++);
            }
            if (view.isVisible("tree", "SDV")) {
                allVsans.insert(new DefaultMutableTreeNode(new TreeCommand("SDV", "sdvStatusTab")), index++);
            }
            if (view.isVisible("tree", "RSCN")) {
                allVsans.insert(new DefaultMutableTreeNode(new TreeCommand("RSCN", "rscnStatusTab")), index++);
            }
            DefaultMutableTreeNode segmentedVsans = null;
            if (VsanTree.USE_SEGMENTED_VSANS_FOLDER) {
                segmentedVsans = new DefaultMutableTreeNode("Segmented VSANs");
                this.insert(segmentedVsans, childCount++);
            }
            Object[] vsanlist = null;
            short[] vsanScope = this.getFabric().getVsanScope();
            vsanlist = vsanScope != null && vsanScope.length > 0 ? this.getFabric().getVsansInScope() : this.getFabric().getVsans();
            if (vsanlist == null) {
                return false;
            }
            Arrays.sort(vsanlist);
            if (VsanTree.USE_SEGMENTED_VSANS_FOLDER) {
                for (int i2 = 0; i2 < vsanlist.length; ++i2) {
                    if (((Vsan)vsanlist[i2]).isSegmented()) continue;
                    this.insert(new VsanTreeNode(new VsanTreeCommand((Vsan)vsanlist[i2], null, "vsanMemberReport")), childCount++);
                }
                segCount = 0;
                for (i = 0; i < vsanlist.length; ++i) {
                    if (!((Vsan)vsanlist[i]).isSegmented()) continue;
                    segmentedVsans.insert(new VsanTreeNode(new VsanTreeCommand((Vsan)vsanlist[i], null, "vsanMemberReport")), segCount++);
                }
            } else {
                segmentedVsans = null;
                segCount = 0;
                for (i = 0; i < vsanlist.length; ++i) {
                    if (!((Vsan)vsanlist[i]).isSegmented()) {
                        this.insert(new VsanTreeNode(new VsanTreeCommand((Vsan)vsanlist[i], null, "vsanMemberReport")), childCount++);
                        continue;
                    }
                    if (!((Vsan)vsanlist[i]).isSegmented()) continue;
                    if (segmentedVsans == null || ((SegmentedVsanTreeNode)segmentedVsans).getId() != ((Vsan)vsanlist[i]).getId()) {
                        segCount = 0;
                        segmentedVsans = new SegmentedVsanTreeNode((Vsan)vsanlist[i]);
                        this.insert(segmentedVsans, childCount++);
                    }
                    segmentedVsans.insert(new VsanTreeNode(new VsanTreeCommand((Vsan)vsanlist[i], null, "vsanMemberReport")), segCount++);
                }
            }
        }
        DefaultMutableTreeNode groups = new DefaultMutableTreeNode("Groups");
        UserDefinedGroupUnion groupsUnion = new UserDefinedGroupUnion("Groups");
        groupsUnion.setFabric(this.getFabric());
        groups.setUserObject(groupsUnion);
        this.insert(groups, childCount++);
        Object[] ugs = UserDefinedGroupManager.getGroups((FabricPK)this.getFabric().getPK());
        if (ugs != null && ugs.length > 0) {
            Arrays.sort(ugs);
            for (int i = 0; i < ugs.length; ++i) {
                groups.insert(new DefaultMutableTreeNode(ugs[i]), i);
                groupsUnion.addGroup((UserDefinedGroup)ugs[i]);
            }
        }
        return false;
    }

    public Fabric getFabric() {
        return (Fabric)this.getUserObject();
    }
}

