/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.sm.client.map.FCoEVdcSwitchNode;
import com.cisco.dcbu.sm.client.map.ISLMapLink;
import com.cisco.dcbu.sm.client.map.LanMapFactory;
import com.cisco.dcbu.sm.client.map.MDS9216SwitchNode;
import com.cisco.dcbu.sm.client.map.MDS95xxSwitchNode;
import com.cisco.dcbu.sm.client.map.MDSN7KSwitchNode;
import com.cisco.dcbu.sm.client.map.MDSSwitchNode;
import com.cisco.dcbu.sm.client.map.MapFactoryIf;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.N5KSwitchNode;
import com.cisco.dcbu.sm.client.map.NpvMapLink;
import com.cisco.dcbu.sm.client.map.PCMapLink;
import com.cisco.dcbu.sm.client.map.PCNpvMapLink;
import com.cisco.dcbu.sm.client.map.SN5428SwitchNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DataCenterMapFactory
extends LanMapFactory
implements MapFactoryIf {
    public static Logger _Logger = Logger.getLogger(DataCenterMapFactory.class);
    private static DataCenterMapFactory _Instance;

    public static DataCenterMapFactory getInstance() {
        if (_Instance == null) {
            _Instance = new DataCenterMapFactory();
        }
        return _Instance;
    }

    protected DataCenterMapFactory() {
    }

    @Override
    public void reset() {
        AbstractLink[] aLinks;
        AbstractSwitch[] aSwitches = DataCenter.getInstance().getAbstractSwitches();
        if (aSwitches != null) {
            for (int i = 0; i < aSwitches.length; ++i) {
                aSwitches[i].setUserObject(null);
            }
        }
        if ((aLinks = DataCenter.getInstance().getAbstractLinks()) != null) {
            for (int i = 0; i < aLinks.length; ++i) {
                aLinks[i].setUserObject(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateGraph(SmMap g) {
        g.resetData();
        g.clear();
        try {
            g.setBulkAdding(true);
            this.populateSwitches(g);
            this.populateISLs(g);
            this.populateNpvLinks(g);
            this.populateEthSwitches(g);
            this.populateEthISLs(g);
            g.setBulkAdding(false);
            g.load();
        }
        finally {
            g.setBulkAdding(false);
        }
    }

    @Override
    protected void populateEthISLs(SmMap g) {
        ArrayList<EthIsl> links = DataCenter.getInstance().getEthIsls(null);
        if (links == null || links.size() == 0) {
            return;
        }
        for (int i = 0; i < links.size(); ++i) {
            try {
                if (g.getLink(links.get(i)) != null) continue;
                g.addLink(this.createLink(links.get(i)));
                continue;
            }
            catch (Exception ex) {
                _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    protected void populateEthSwitches(SmMap g) {
        EthSwitch[] ethSwitches = DataCenter.getInstance().getEthSwitches();
        if (ethSwitches != null && ethSwitches.length > 0) {
            for (int i = 0; i < ethSwitches.length; ++i) {
                try {
                    if (this.getNode(ethSwitches[i]) != null) continue;
                    g.addNode(this.createNode(ethSwitches[i]));
                    continue;
                }
                catch (Exception ex) {
                    _Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void populateSwitches(SmMap g) {
        Switch[] switches = DataCenter.getInstance().getSwitches();
        if (switches == null || switches.length == 0) {
            return;
        }
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                try {
                    if (this.getNode(switches[i]) != null) continue;
                    g.addNode(this.createNode(switches[i]));
                    continue;
                }
                catch (Exception ex) {
                    _Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void populateNpvLinks(SmMap g) {
        NpvLink[] links = DataCenter.getInstance().getNpvLinks();
        if (links == null || links.length == 0) {
            return;
        }
        for (int i = 0; i < links.length; ++i) {
            try {
                if (g.getLink(links[i]) != null) continue;
                g.addLink(this.createLink(links[i]));
                continue;
            }
            catch (Exception ex) {
                _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public MapLink createLink(NpvLink link) {
        if (link.isPortChannel()) {
            return new PCNpvMapLink(link, this);
        }
        return new NpvMapLink(link, this);
    }

    private void populateISLs(SmMap g) {
        Isl[] links = DataCenter.getInstance().getIsls();
        if (links == null || links.length == 0) {
            return;
        }
        for (int i = 0; i < links.length; ++i) {
            try {
                if (g.getLink(links[i]) != null) continue;
                g.addLink(this.createLink(links[i]));
                continue;
            }
            catch (Exception ex) {
                _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public MapLink createLink(Isl isl) {
        if (isl.isPortChannel()) {
            return new PCMapLink(isl, this);
        }
        return new ISLMapLink(isl, this);
    }

    public MapNode createNode(Switch dev) {
        SwitchNode node = null;
        node = dev.isN7K() ? (dev.isVdc() ? new FCoEVdcSwitchNode(dev) : new MDSN7KSwitchNode(dev)) : (dev.isMDS() || dev.isQuail() ? (dev.isMdsDirector() ? new MDS95xxSwitchNode(dev) : (dev.getModelType() == 380 ? new MDS9216SwitchNode(dev) : (FRUConstants.isN5K(dev.getModelType()) ? new N5KSwitchNode(dev) : new MDSSwitchNode(dev)))) : (dev.isSN5428() ? new SN5428SwitchNode(dev) : new SwitchNode(dev)));
        return node;
    }

    @Override
    public MapNode getNode(AbstractModelObject obj) {
        try {
            MapNode fcNode = this.getFCNode(obj);
            if (fcNode != null) {
                return fcNode;
            }
            return SmMap.getInstance(1).getNode(obj);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public MapNode getFCNode(AbstractModelObject obj) {
        Switch fcSwitch;
        PKIf fcSwitchPK;
        EthSwitch ethSwitch;
        PKIf ethSwitchPK;
        if (obj != null && obj instanceof EthSwitch && (ethSwitchPK = (ethSwitch = (EthSwitch)obj).getPK()) != null && (fcSwitchPK = DataCenter.getInstance().getAllCoexistSwPKs().get(ethSwitchPK)) != null && (fcSwitch = DataCenter.getInstance().findSwitchByPK((WwnKey)fcSwitchPK)) != null && fcSwitch.getUserObject() != null) {
            return (MapNode)fcSwitch.getUserObject();
        }
        return null;
    }

    @Override
    public MapLink getLink(AbstractModelObject obj) {
        try {
            return SmMap.getInstance(1).getLink(obj);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

