/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.actions.CopyAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandMultipleLinksMapAction;
import com.cisco.dcbu.sm.client.map.actions.LoginMapAction;
import com.cisco.dcbu.sm.client.map.actions.MiscMapActions;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class EthSwitchNode
extends SwitchNode {
    private Logger _logger = Logger.getLogger(this.getClass());
    private static final String ICON_NAME = "dc3.gif";
    private static final String KUBRICK_ICON_NAME = "Device_route_switch_processor_3037_";
    private static final String MDS_ICON_NAME = "mds9200.gif";
    private static final String MDS_DIRECTOR_ICON_NAME = "vegas.gif";
    private static final String KUBRICK_MDS_ICON_NAME = "Device_fibre_channel_fabric_switch_3029_";
    private static final String KUBRICK_MDS_DIRECTOR_ICON_NAME = "Device_fibre_channel_director_3027_";

    public EthSwitchNode(EthSwitch sw) {
        super(sw);
    }

    @Override
    public int getDefaultIconHeight() {
        AbstractModelObject abstractModelObject;
        BaseModelObject base;
        if (SmMap.isClassUseKubrickIcons()) {
            return EthSwitchNode.getKubrickSize();
        }
        Object model = this.getModel();
        if (model != null && model instanceof AbstractModelObject && (base = (abstractModelObject = (AbstractModelObject)model).getBaseModelObject()) != null && base instanceof AbstractSwitchBase && ((AbstractSwitchBase)base).isMDS()) {
            if (((AbstractSwitchBase)base).isMdsDirector()) {
                return 48;
            }
            return 32;
        }
        return 32;
    }

    @Override
    public String getIconName() {
        AbstractModelObject abstractModelObject;
        BaseModelObject base;
        Object model = this.getModel();
        if (model != null && model instanceof AbstractModelObject && (base = (abstractModelObject = (AbstractModelObject)model).getBaseModelObject()) != null && base instanceof AbstractSwitchBase && ((AbstractSwitchBase)base).isMDS()) {
            if (((AbstractSwitchBase)base).isMdsDirector()) {
                return MDS_DIRECTOR_ICON_NAME;
            }
            return MDS_ICON_NAME;
        }
        return ICON_NAME;
    }

    @Override
    public String getKubrickIconName() {
        AbstractModelObject abstractModelObject;
        BaseModelObject base;
        Object model = this.getModel();
        if (model != null && model instanceof AbstractModelObject && (base = (abstractModelObject = (AbstractModelObject)model).getBaseModelObject()) != null && base instanceof AbstractSwitchBase) {
            if (((AbstractSwitchBase)base).isMDS() && ((AbstractSwitchBase)base).isMdsDirector()) {
                return KUBRICK_MDS_DIRECTOR_ICON_NAME;
            }
            return KUBRICK_MDS_ICON_NAME;
        }
        return KUBRICK_ICON_NAME;
    }

    @Override
    public boolean purge() throws Exception {
        EthSwitch sw = (EthSwitch)this.getModel();
        if (sw == null) {
            return false;
        }
        this._logger.info((Object)("EthSwitchNode purge() swPK=" + sw.getPK()));
        ClientController.getInstance().purgeLanEthSwitch(sw.getLan().getLanPK(), sw.getPK());
        return true;
    }

    public static JMenuItem[] getMenuItems(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        JMenuItem[] mi = EthSwitchNode.getDeviceMenuItems(_menuItems);
        int number = 7;
        _menuItems = new JMenuItem[mi.length + number];
        int l = mi.length;
        try {
            System.arraycopy(mi, 0, _menuItems, 0, l);
        }
        catch (Exception e) {
            l = 0;
        }
        _menuItems[l++] = null;
        _menuItems[l++] = Util.createCheckBoxMenuItem("&Expand Multiple Links", "expandMultipleLinks", ExpandMultipleLinksMapAction.getInstance());
        return _menuItems;
    }

    public static JMenuItem[] getDeviceMenuItems(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        JMenuItem[] mi = MapNode.getMenuItems(_menuItems);
        _menuItems = new JMenuItem[mi.length + 7 - 3];
        int l = 0;
        _menuItems[l++] = Util.createMenuItem("Command &Line Interface", "login", "Command &Line Interface", LoginMapAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("Copy", "copy", "Copy", CopyAction.getInstance());
        if (_menuItems[l - 1] != null) {
            _menuItems[l++] = null;
        }
        _menuItems[l++] = Util.createMenuItem("Purge", "purge", "Purge", MiscMapActions.getInstance());
        try {
            System.arraycopy(mi, 0, _menuItems, l, mi.length);
        }
        catch (Exception e) {
            l = 0;
        }
        return _menuItems;
    }
}

