/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.map.HostNode;
import com.cisco.dcbu.sm.client.map.IlogLayoutServer;
import com.cisco.dcbu.sm.client.map.StorageNode;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.graphic.IlvPolylineLinkImage;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.hierarchical.IlvGroupSpreadConstraint;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.hierarchical.IlvLevelRangeConstraint;
import ilog.views.graphlayout.hierarchical.IlvNodeGroup;
import ilog.views.graphlayout.hierarchical.IlvRelativeLevelConstraint;
import ilog.views.graphlayout.hierarchical.IlvSideBySideConstraint;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class IlogHierarchicalLayoutServer
extends IlogLayoutServer {
    public static Logger _Logger = Logger.getLogger(IlogHierarchicalLayoutServer.class);
    protected IlvNodeGroup hostGroup = new IlvNodeGroup();
    protected IlvNodeGroup hostSwitchGroup = new IlvNodeGroup();
    protected IlvNodeGroup switchGroup = new IlvNodeGroup();
    protected IlvNodeGroup storageSwitchGroup = new IlvNodeGroup();
    protected IlvNodeGroup storageGroup = new IlvNodeGroup();
    protected IlvNodeGroup groupedEndNodes = new IlvNodeGroup();
    protected IlvNodeGroup commonHostGroup = new IlvNodeGroup();
    protected IlvNodeGroup commonStorageGroup = new IlvNodeGroup();
    protected HashMap<IlvGraphic, IlvNodeGroup> hostGroupHashMap = new HashMap();
    protected HashMap<IlvGraphic, IlvNodeGroup> storageGroupHashMap = new HashMap();
    protected ArrayList<IlvNodeGroup> switchGroups = new HashedArrayList<IlvNodeGroup>();
    IlvHierarchicalLayout layoutH = new IlvHierarchicalLayout();

    public IlogHierarchicalLayoutServer() {
        this.layout = this.layoutH;
        this.layoutH.attach((IlvGraphModel)this.adapter);
        this.layoutH.setFlowDirection(2);
        this.layoutH.setCoordinatesMode(1);
        this.layoutH.setIncrementalMode(false);
    }

    @Override
    public void layout(TopologyGraph topologyGraph, int divideDegree, boolean zero) throws Exception {
        this.layoutH.removeAllConstraints();
        this.nodes.clear();
        this.links.clear();
        this.hostGroup = new IlvNodeGroup();
        this.hostSwitchGroup = new IlvNodeGroup();
        this.switchGroup = new IlvNodeGroup();
        this.storageSwitchGroup = new IlvNodeGroup();
        this.storageGroup = new IlvNodeGroup();
        this.switchGroups = new HashedArrayList<IlvNodeGroup>();
        this.groupedEndNodes = new IlvNodeGroup();
        this.commonHostGroup = new IlvNodeGroup();
        this.commonStorageGroup = new IlvNodeGroup();
        this.hostGroupHashMap = new HashMap();
        this.storageGroupHashMap = new HashMap();
        this.grapher.deleteAll(false);
        this.populateGrapher(topologyGraph);
        int j = (int)Math.ceil(this.storageGroup.size() / 5) + 1;
        this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvGroupSpreadConstraint(this.storageGroup, j));
        j = (int)Math.ceil(this.hostGroup.size() / 5) + 1;
        this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvGroupSpreadConstraint(this.hostGroup, j));
        if (this.switchGroups.size() > 2) {
            this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvRelativeLevelConstraint((Object)this.switchGroups.get(0), (Object)this.switchGroups.get(1), 200.0f));
            this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvRelativeLevelConstraint((Object)(this.switchGroups.size() - 2), (Object)this.switchGroups.get(this.switchGroups.size() - 1), 100.0f));
        }
        this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvLevelRangeConstraint((Object)this.hostGroup, j++, j++));
        for (int i = 0; i < this.switchGroups.size(); ++i) {
            this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvLevelRangeConstraint((Object)this.switchGroups.get(i), j++, j++));
        }
        if (this.storageGroup.size() > 7) {
            if (this.commonStorageGroup.size() > 0) {
                this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvLevelRangeConstraint((Object)this.commonStorageGroup, j++, j++));
            }
            for (IlvNodeGroup group : this.storageGroupHashMap.values()) {
                if (group == null || group.size() <= 0) continue;
                this.addMultiLevelGroups(this.layoutH, group, j++);
            }
        } else {
            this.layoutH.addConstraint((IlvHierarchicalConstraint)new IlvLevelRangeConstraint((Object)this.storageGroup, j++, j++));
        }
        if (this.hostGroup.size() > 7 || this.storageGroup.size() > 7) {
            this.layoutH.setVerticalNodeOffset(10.0f);
        } else {
            this.layoutH.setVerticalNodeOffset(40.0f);
        }
        this.layoutH.performLayout(true, false);
        this.populateTopologyGraph(topologyGraph);
    }

    private void addMultiLevelGroups(IlvHierarchicalLayout layoutH, IlvNodeGroup bigGroup, int j) {
        if (layoutH == null || bigGroup == null || j < 0) {
            return;
        }
        IlvNodeGroup group = null;
        int i = 0;
        int g = 0;
        int newGroupSizeLimit = bigGroup.size() / 3 + 1;
        Enumeration nodeEnumeration = bigGroup.elements();
        while (nodeEnumeration.hasMoreElements()) {
            IlvGraphic endNode = (IlvGraphic)nodeEnumeration.nextElement();
            if (endNode == null) continue;
            if (++i < newGroupSizeLimit) {
                if (group == null) {
                    group = new IlvNodeGroup();
                }
                group.add((Object)endNode);
                continue;
            }
            layoutH.addConstraint((IlvHierarchicalConstraint)new IlvLevelRangeConstraint((Object)group, j++, j++));
            layoutH.addConstraint((IlvHierarchicalConstraint)new IlvSideBySideConstraint(group, (float)(10000 * g)));
            ++g;
            group = new IlvNodeGroup();
            group.add((Object)endNode);
            i = 0;
        }
        if (group != null) {
            layoutH.addConstraint((IlvHierarchicalConstraint)new IlvLevelRangeConstraint(group, j++, j++));
            layoutH.addConstraint((IlvHierarchicalConstraint)new IlvSideBySideConstraint(group, (float)(10000 * g)));
        }
    }

    @Override
    protected IlvLinkImage createLink(TopologyLink topologyLink) {
        IlvPolylineLinkImage ilvLinkImage = null;
        TopologyNode topoNode1 = (TopologyNode)topologyLink.getSourceNode();
        TopologyNode topoNode2 = (TopologyNode)topologyLink.getTargetNode();
        if (topoNode1 == null || topoNode2 == null) {
            return null;
        }
        IlvGraphic n1 = (IlvGraphic)this.nodes.get(topoNode1);
        IlvGraphic n2 = (IlvGraphic)this.nodes.get(topoNode2);
        if (n1 == null || n2 == null) {
            return null;
        }
        ilvLinkImage = topoNode1 instanceof HostNode ? new IlvPolylineLinkImage(n1, n2, true, null) : (topoNode2 instanceof HostNode ? new IlvPolylineLinkImage(n2, n1, true, null) : (topoNode1 instanceof StorageNode ? new IlvPolylineLinkImage(n2, n1, true, null) : (topoNode2 instanceof StorageNode ? new IlvPolylineLinkImage(n1, n2, true, null) : (this.hostSwitchGroup.contains((Object)n1) ? new IlvPolylineLinkImage(n1, n2, true, null) : (this.hostSwitchGroup.contains((Object)n2) ? new IlvPolylineLinkImage(n2, n1, true, null) : (this.storageSwitchGroup.contains((Object)n1) ? new IlvPolylineLinkImage(n2, n1, true, null) : (this.storageSwitchGroup.contains((Object)n2) ? new IlvPolylineLinkImage(n1, n2, true, null) : new IlvPolylineLinkImage(n1, n2, false, null))))))));
        this.links.put(topologyLink, ilvLinkImage);
        return ilvLinkImage;
    }

    @Override
    protected void populateGrapher(TopologyGraph topologyGraph) {
        for (TopologyNode topologyNode : topologyGraph.nodes()) {
            this.grapher.addNode(this.createNode(topologyNode), false);
        }
        this.assignAllNodesToGroups(topologyGraph);
        for (TopologyLink topologyLink : topologyGraph.edges()) {
            if (topologyLink == null) continue;
            IlvLinkImage ilvLinkImage = this.createLink(topologyLink);
            if (ilvLinkImage != null) {
                this.grapher.addLink(ilvLinkImage, false);
                continue;
            }
            _Logger.warn((Object)("Cannot add link " + topologyLink));
        }
    }

    protected void assignAllNodesToGroups(TopologyGraph topologyGraph) {
        this.switchGroups.clear();
        HashedArrayList<TopologyLink> switchLinks = new HashedArrayList<TopologyLink>();
        HashedArrayList<TopologyLink> storageLinks = new HashedArrayList<TopologyLink>();
        IlvNodeGroup prevSwitchGroup = new IlvNodeGroup();
        IlvNodeGroup nextSwitchGroup = new IlvNodeGroup();
        TopologyLink topologyLink2 = null;
        TopologyNode topoNode1 = null;
        TopologyNode topoNode2 = null;
        IlvGraphic n1 = null;
        IlvGraphic n2 = null;
        for (TopologyLink topologyLink2 : topologyGraph.edges()) {
            topoNode1 = (TopologyNode)topologyLink2.getSourceNode();
            topoNode2 = (TopologyNode)topologyLink2.getTargetNode();
            n1 = (IlvGraphic)this.nodes.get(topoNode1);
            n2 = (IlvGraphic)this.nodes.get(topoNode2);
            if (topoNode1 instanceof HostNode) {
                this.addNodeToGroup(n1, this.hostGroup);
                this.addNodeToGroup(n2, this.hostSwitchGroup);
                this.addNodeToGroup(n2, nextSwitchGroup);
                this.addEndNodeToGroup(n1, n2, this.hostGroupHashMap);
                continue;
            }
            if (topoNode2 instanceof HostNode) {
                this.addNodeToGroup(n2, this.hostGroup);
                this.addNodeToGroup(n1, this.hostSwitchGroup);
                this.addNodeToGroup(n1, nextSwitchGroup);
                this.addEndNodeToGroup(n2, n1, this.hostGroupHashMap);
                continue;
            }
            if (topoNode1 instanceof StorageNode) {
                this.addNodeToGroup(n1, this.storageGroup);
                this.addNodeToGroup(n2, this.storageSwitchGroup);
                ((ArrayList)storageLinks).add(topologyLink2);
                this.addEndNodeToGroup(n1, n2, this.storageGroupHashMap);
                continue;
            }
            if (topoNode2 instanceof StorageNode) {
                this.addNodeToGroup(n2, this.storageGroup);
                this.addNodeToGroup(n1, this.storageSwitchGroup);
                ((ArrayList)storageLinks).add(topologyLink2);
                this.addEndNodeToGroup(n2, n1, this.storageGroupHashMap);
                continue;
            }
            this.addNodeToGroup(n1, this.switchGroup);
            this.addNodeToGroup(n2, this.switchGroup);
            ((ArrayList)switchLinks).add(topologyLink2);
        }
        this.cleanUpEndNodeGroups(this.groupedEndNodes, this.commonHostGroup, this.hostGroupHashMap);
        this.cleanUpEndNodeGroups(this.groupedEndNodes, this.commonStorageGroup, this.storageGroupHashMap);
        for (TopologyLink topologyLink2 : switchLinks) {
            topoNode1 = (TopologyNode)topologyLink2.getSourceNode();
            topoNode2 = (TopologyNode)topologyLink2.getTargetNode();
            n1 = (IlvGraphic)this.nodes.get(topoNode1);
            n2 = (IlvGraphic)this.nodes.get(topoNode2);
            boolean inHostSwitchGroup = this.hostSwitchGroup.contains((Object)n1);
            boolean inStorageSwitchGroup = this.storageSwitchGroup.contains((Object)n1);
            boolean inSwitchGroup = this.switchGroup.contains((Object)n1);
            if (inHostSwitchGroup && inStorageSwitchGroup) {
                this.storageSwitchGroup.remove((Object)n1);
            }
            if ((inHostSwitchGroup || inStorageSwitchGroup) && inSwitchGroup) {
                this.switchGroup.remove((Object)n1);
            }
            inHostSwitchGroup = this.hostSwitchGroup.contains((Object)n2);
            inStorageSwitchGroup = this.storageSwitchGroup.contains((Object)n2);
            inSwitchGroup = this.switchGroup.contains((Object)n2);
            if (inHostSwitchGroup && inStorageSwitchGroup) {
                this.storageSwitchGroup.remove((Object)n2);
            }
            if (!inHostSwitchGroup && !inStorageSwitchGroup || !inSwitchGroup) continue;
            this.switchGroup.remove((Object)n2);
        }
        if (nextSwitchGroup.size() > 0) {
            this.switchGroups.add(nextSwitchGroup);
        }
        prevSwitchGroup = nextSwitchGroup;
        for (int attempts = 0; switchLinks.size() > 0 && attempts < 10; ++attempts) {
            HashedArrayList<TopologyLink> remainingSwitchLinks = new HashedArrayList<TopologyLink>();
            nextSwitchGroup = new IlvNodeGroup();
            for (TopologyLink topologyLink2 : switchLinks) {
                topoNode1 = (TopologyNode)topologyLink2.getSourceNode();
                topoNode2 = (TopologyNode)topologyLink2.getTargetNode();
                n1 = (IlvGraphic)this.nodes.get(topoNode1);
                n2 = (IlvGraphic)this.nodes.get(topoNode2);
                if (prevSwitchGroup.contains((Object)n1) && prevSwitchGroup.contains((Object)n2)) continue;
                if (prevSwitchGroup.contains((Object)n1)) {
                    if (this.storageSwitchGroup.contains((Object)n2)) continue;
                    this.addNodeToGroup(n2, nextSwitchGroup);
                    continue;
                }
                if (prevSwitchGroup.contains((Object)n2)) {
                    if (this.storageSwitchGroup.contains((Object)n1)) continue;
                    this.addNodeToGroup(n1, nextSwitchGroup);
                    continue;
                }
                ((ArrayList)remainingSwitchLinks).add(topologyLink2);
            }
            if (nextSwitchGroup.size() > 0) {
                this.switchGroups.add(nextSwitchGroup);
            }
            switchLinks = remainingSwitchLinks;
            prevSwitchGroup = nextSwitchGroup;
        }
        if (this.storageSwitchGroup.size() > 0) {
            this.switchGroups.add(this.storageSwitchGroup);
        }
    }

    private void addNodeToGroup(IlvGraphic node, IlvNodeGroup group) {
        if (node == null || group == null) {
            return;
        }
        if (group.contains((Object)node)) {
            return;
        }
        group.add((Object)node);
    }

    private void addEndNodeToGroup(IlvGraphic endNode, IlvGraphic switchNode, HashMap<IlvGraphic, IlvNodeGroup> hashMap) {
        if (endNode == null || switchNode == null || hashMap == null) {
            return;
        }
        IlvNodeGroup group = hashMap.get(switchNode);
        if (group == null) {
            group = new IlvNodeGroup();
            hashMap.put(switchNode, group);
        }
        if (!group.contains((Object)endNode)) {
            group.add((Object)endNode);
        }
        if (!this.groupedEndNodes.contains((Object)endNode)) {
            this.groupedEndNodes.add((Object)endNode);
        }
    }

    private void cleanUpEndNodeGroups(IlvNodeGroup groupedEndNodes, IlvNodeGroup commonEndNodesGroup, HashMap<IlvGraphic, IlvNodeGroup> hashMap) {
        if (groupedEndNodes == null || hashMap == null) {
            return;
        }
        Enumeration nodeEnumeration = groupedEndNodes.elements();
        while (nodeEnumeration.hasMoreElements()) {
            IlvGraphic endNode = (IlvGraphic)nodeEnumeration.nextElement();
            if (endNode == null) continue;
            HashedArrayList<IlvNodeGroup> groupList = new HashedArrayList<IlvNodeGroup>();
            for (IlvNodeGroup group : hashMap.values()) {
                if (group == null || !group.contains((Object)endNode)) continue;
                ((ArrayList)groupList).add(group);
            }
            if (groupList.size() <= 1) continue;
            commonEndNodesGroup.add((Object)endNode);
            for (int i = 0; i < groupList.size(); ++i) {
                ((IlvNodeGroup)groupList.get(i)).remove((Object)endNode);
            }
        }
    }
}

