/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.sm.client.map.DataCenterMapFactory;
import com.cisco.dcbu.sm.client.map.LanMapFactory;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Lan;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;

class LanMapPropertyChangeListner
implements PropertyChangeListener {
    SmMap _map;
    public static Logger _Logger = Logger.getLogger(LanMapPropertyChangeListner.class);

    public LanMapPropertyChangeListner(SmMap map) {
        this._map = map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (prop == null) return;
        if (prop.equals("")) {
            return;
        }
        if (prop.equals("endOfEvents")) {
            if (this._map._needLayout) {
                LanMapPropertyChangeListner lanMapPropertyChangeListner = this;
                if (lanMapPropertyChangeListner._map.isLayoutNewDevices()) {
                    this._map.relayout(true);
                    return;
                }
            }
            this._map.repaint(false);
            return;
        }
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof Lan) {
            if (prop.equals("ethSwitchAdded")) {
                this._map.setNeedLayout(true);
                this._map.addSwitch((EthSwitch)event.getNewValue());
                return;
            }
            if (prop.equals("ethIslAdded")) {
                this._map.addIsl((EthIsl)event.getNewValue());
                return;
            }
            if (!prop.equals("ethSwitchRemoved")) {
                if (!prop.equals("ethIslRemoved")) return;
                MapLink l = this._map.getLink((EthIsl)event.getOldValue());
                if (l == null) return;
                this._map.removeLink(l);
                return;
            }
            MapNode n = null;
            if (this._map.isDataCenterMap()) {
                n = DataCenterMapFactory.getInstance().getNode((EthSwitch)event.getOldValue());
            } else if (this._map.isLanMap()) {
                n = LanMapFactory.getInstance().getNode((EthSwitch)event.getOldValue());
            }
            if (n == null) return;
            this._map.removeNode(n);
            return;
        }
        if (!(obj instanceof AbstractSwitch)) return;
        try {
            MapNode n = LanMapFactory.getInstance().getNode((AbstractSwitch)event.getSource());
            if (n == null) return;
            n.update();
            return;
        }
        catch (Exception ex) {
            if (!_Logger.isTraceEnabled()) return;
            _Logger.trace((Object)"logEmptyCatch - switch update", (Throwable)ex);
        }
    }
}

