/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.sm.client.map.DeviceNode;
import com.cisco.dcbu.sm.client.map.EdgeMapLink;
import com.cisco.dcbu.sm.client.map.EthIslMapLink;
import com.cisco.dcbu.sm.client.map.EthN5KSwitchNode;
import com.cisco.dcbu.sm.client.map.EthSwitchNode;
import com.cisco.dcbu.sm.client.map.EthVdcSwitchNode;
import com.cisco.dcbu.sm.client.map.FCoEEdgeMapLink;
import com.cisco.dcbu.sm.client.map.FCoEVdcSwitchNode;
import com.cisco.dcbu.sm.client.map.ISLMapLink;
import com.cisco.dcbu.sm.client.map.LoopLink;
import com.cisco.dcbu.sm.client.map.LoopNode;
import com.cisco.dcbu.sm.client.map.MDSN7KSwitchNode;
import com.cisco.dcbu.sm.client.map.MDSSwitchNode;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.N5KSwitchNode;
import com.cisco.dcbu.sm.client.map.N7KSwitchNode;
import com.cisco.dcbu.sm.client.map.NpvMapLink;
import com.cisco.dcbu.sm.client.map.PCMapLink;
import com.cisco.dcbu.sm.client.map.PCNpvMapLink;
import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class MenuFactory
implements ActionListener {
    private static MenuFactory _Instance = null;
    private static HashMap<String, ActionListener[]> actionMap = null;
    public static Logger _Logger = Logger.getLogger(MenuFactory.class);

    public static MenuFactory getInstance() {
        if (_Instance == null) {
            _Instance = new MenuFactory();
        }
        return _Instance;
    }

    private MenuFactory() {
    }

    public static void initMenuHash() {
        MenuFactory.addMenuItemsToHash(MapNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(LoopNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(DeviceNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(PlatformNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(SwitchNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(EthSwitchNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(EthN5KSwitchNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(MDSSwitchNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(FCoEVdcSwitchNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(N5KSwitchNode.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(MapLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(EthIslMapLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(EdgeMapLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(ISLMapLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(LoopLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(NpvMapLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(FCoEEdgeMapLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(PCMapLink.getMenuItems(null));
        MenuFactory.addMenuItemsToHash(PCNpvMapLink.getMenuItems(null));
    }

    private static void addMenuItemsToHash(JMenuItem[] _menuItems) {
        for (int i = 0; i < _menuItems.length; ++i) {
            if (_menuItems[i] != null && _menuItems[i] instanceof JMenu) {
                MenuFactory.addMenuItemsToHash((JMenu)_menuItems[i]);
            } else if (_menuItems[i] == null || _menuItems[i].getActionCommand() == null || _menuItems[i].getActionListeners() == null) continue;
            if (actionMap.put(_menuItems[i].getActionCommand(), _menuItems[i].getActionListeners()) != null) continue;
            _Logger.debug((Object)("ACTIONMAP PUT " + _menuItems[i].getActionCommand()));
        }
    }

    private static void addMenuItemsToHash(JMenu menu) {
        if (menu == null) {
            return;
        }
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem != null && menuItem instanceof JMenu) {
                MenuFactory.addMenuItemsToHash((JMenu)menuItem);
            } else if (menuItem == null || menuItem.getActionCommand() == null || menuItem.getActionListeners() == null) continue;
            if (actionMap.put(menuItem.getActionCommand(), menuItem.getActionListeners()) != null) continue;
            _Logger.debug((Object)("ACTIONMAP put " + menuItem.getActionCommand()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        String actionCommand = e.getActionCommand();
        if (actionCommand == null) {
            return;
        }
        ActionListener[] actionListeners = actionMap.get(actionCommand);
        if (actionListeners == null || actionListeners.length == 0) {
            _Logger.warn((Object)("MenuFactory.actionPerformed() no actions found for command:" + actionCommand));
            return;
        }
        for (int i = 0; i < actionListeners.length; ++i) {
            if (actionListeners[i] == null) continue;
            actionListeners[i].actionPerformed(e);
        }
    }

    public static JMenuItem[] getMenuItems(MapNode node, JMenuItem[] _menuItems) {
        if (node instanceof N5KSwitchNode) {
            return N5KSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof FCoEVdcSwitchNode) {
            return FCoEVdcSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof EthVdcSwitchNode) {
            return EthVdcSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof MDSN7KSwitchNode) {
            return MDSN7KSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof MDSSwitchNode) {
            return MDSSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof N7KSwitchNode) {
            return N7KSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof EthN5KSwitchNode) {
            return EthN5KSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof EthSwitchNode) {
            return EthSwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof SwitchNode) {
            return SwitchNode.getMenuItems(_menuItems);
        }
        if (node instanceof PlatformNode) {
            return PlatformNode.getMenuItems(_menuItems);
        }
        if (node instanceof DeviceNode) {
            return DeviceNode.getMenuItems(_menuItems);
        }
        if (node instanceof LoopNode) {
            return LoopNode.getMenuItems(_menuItems);
        }
        if (node instanceof MapNode) {
            return MapNode.getMenuItems(_menuItems);
        }
        return null;
    }

    public static JMenuItem[] getMenuItems(MapLink link, JMenuItem[] _menuItems) {
        if (link instanceof PCNpvMapLink) {
            return PCNpvMapLink.getMenuItems(_menuItems);
        }
        if (link instanceof PCMapLink) {
            return PCMapLink.getMenuItems(_menuItems);
        }
        if (link instanceof FCoEEdgeMapLink) {
            return FCoEEdgeMapLink.getMenuItems(_menuItems);
        }
        if (link instanceof NpvMapLink) {
            return NpvMapLink.getMenuItems(_menuItems);
        }
        if (link instanceof LoopLink) {
            return LoopLink.getMenuItems(_menuItems);
        }
        if (link instanceof ISLMapLink) {
            return ISLMapLink.getMenuItems(_menuItems);
        }
        if (link instanceof EdgeMapLink) {
            return EdgeMapLink.getMenuItems(_menuItems);
        }
        if (link instanceof EthIslMapLink) {
            return EthIslMapLink.getMenuItems(_menuItems);
        }
        if (link instanceof MapLink) {
            return MapLink.getMenuItems(_menuItems);
        }
        return null;
    }

    static {
        actionMap = new HashMap();
        MenuFactory.initMenuHash();
    }
}

