/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.map.client.TopologyWindow;
import com.cisco.dcbu.lib.map.common.MultipleLinkHandler;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.map.common.TopologyNodePainter;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.ISLContext;
import com.cisco.dcbu.sm.client.SwitchContext;
import com.cisco.dcbu.sm.client.event.EventDispatcher;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.DataCenterMapFactory;
import com.cisco.dcbu.sm.client.map.DataCenterMapPropertyChangeListner;
import com.cisco.dcbu.sm.client.map.FabricNode;
import com.cisco.dcbu.sm.client.map.LanMapFactory;
import com.cisco.dcbu.sm.client.map.LanMapPropertyChangeListner;
import com.cisco.dcbu.sm.client.map.LoopNode;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapFactoryIf;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapMenus;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.MapToolPanel;
import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.map.SmFindDialog;
import com.cisco.dcbu.sm.client.map.SmMapPropertyChangeListner;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.ViewLayoutProperties;
import com.cisco.dcbu.sm.client.map.WarningNode;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.map.actions.CopyAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandLoopMapAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandMultipleLinksMapAction;
import com.cisco.dcbu.sm.client.map.actions.FilterISCSIEndDevicesMapAction;
import com.cisco.dcbu.sm.client.map.actions.FilterInitiatorEndDevicesMapAction;
import com.cisco.dcbu.sm.client.map.actions.FilterTargetEndDevicesMapAction;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.map.actions.OverViewMapAction;
import com.cisco.dcbu.sm.client.map.actions.SelectionAction;
import com.cisco.dcbu.sm.client.map.actions.ShowEndDeviceLabelsMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowEndDevicesMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowNpvSwitchesMapAction;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Hub;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupManager;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.palette.NodeLabelPalette;
import com.cisco.nm.esper.model.palette.NodePalette;
import com.cisco.nm.esper.shape.Bounds;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SmMap
extends TopologyGraph {
    static final String EMPTY_STRING = "";
    static final String SEPARATOR_STRING = "|";
    static final String EXPAND_MULTIPLE_LINKS = "ExpandMultipleLinks";
    static final String EXPAND_LOOPS = "ExpandLoops";
    static final String DISPLAY_ISCSI = "DisplayISCSI";
    static final String DISPLAY_TARGETS = "DisplayTargets";
    static final String DISPLAY_INITIATORS = "DisplayInitiators";
    static final String DISPLAY_NPV_SWITCHES = "DisplayNpvSwitches";
    public static Logger _Logger = Logger.getLogger(SmMap.class);
    public static final int SAN_MAP = 0;
    public static final int DATACENTER_MAP = 1;
    public static final int LAN_MAP = 2;
    public static final String DefaultLayoutName = "Layout_1";
    public static final String LAST_USED_FILE = "SmMapLastUsed.properties";
    private static boolean dummyNode = false;
    private MapFactoryIf _mapFactory = null;
    private Fabric _fabric = null;
    private HashMap _links = new HashMap();
    private HashMap _nodes = new HashMap();
    HashMap _enclosureNodes = new HashMap();
    Object _filter;
    private Properties _savedLayoutProperties = null;
    private boolean _collapseLoops = _ClassCollapseLoops;
    private boolean _displayISCSI = _ClassDisplayISCSI;
    private boolean _displayTargets = _ClassDisplayTargets;
    private boolean _displayInitiators = _ClassDisplayInitiators;
    private boolean _displayNpvSwitches = _ClassDisplayNpvSwitches;
    private boolean _readyForContext = false;
    private int _selectedVsanID = 0;
    private static Properties _mapLastUsedLayoutProp = null;
    private static SmMap _DataCenterMap;
    private static SmMap _LanMap;
    private static SmMap _SmMap;
    private static SmMap _PreviousMap;
    private static boolean _ClassDisplayEndDevices;
    private static boolean _ClassDisplayNodeLabels;
    private static boolean _ClassCollapseLoops;
    private static boolean _ClassCollapseMultiLinks;
    private static boolean _ClassUseKubrickIcons;
    private static int _MaxNodeLimit;
    private static boolean _ClassDisplayNpvSwitches;
    private static boolean _ClassDisplayISCSI;
    private static boolean _ClassDisplayTargets;
    private static boolean _ClassDisplayInitiators;
    private static boolean _ClassShowMinorAlarmsOnLinks;
    private static boolean _LayoutForNewDevices;
    private static boolean _IsOverridePreferences;
    private static boolean _IsAutoSaveLayout;
    private static int _DimNodeDisplayPolicy;
    private static int _GroupDimNodeDisplayPolicy;
    static SmMapPropertyChangeListner _AllSanMapListener;
    private TopologyWindow _window;
    private int _nodeSize = 8;
    private int _maxNodeWidth = 8;
    private boolean _displayed = false;
    boolean _needLayout = false;
    SmMapPropertyChangeListner _mapListener = null;

    @Override
    public int getLayoutType() {
        if (this.isRestrictedTopology()) {
            return 1;
        }
        return 0;
    }

    public static boolean hasInstance(int map) {
        switch (map) {
            case 0: {
                if (_SmMap != null) {
                    return true;
                }
            }
            case 1: {
                if (_DataCenterMap != null) {
                    return true;
                }
            }
            case 2: {
                if (_LanMap == null) break;
                return true;
            }
        }
        return false;
    }

    public static SmMap getInstance() {
        return SmMap.getInstance(0);
    }

    public static SmMap getInstance(int map) {
        switch (map) {
            case 0: {
                if (_SmMap == null) {
                    _SmMap = new SmMap("Root", MapFactory.getInstance());
                    _SmMap.setMultiEdgeCollapsed(_ClassCollapseMultiLinks);
                    JPopupMenu popup = new JPopupMenu(EMPTY_STRING);
                    popup.add(Util.createMenuItem("Attributes", "attributes", "SAN Attributes", AttributesAction.getInstance()));
                    JMenuItem mi = new JMenuItem("Expand");
                    popup.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExpandMultipleLinksMapAction.getInstance().actionPerformed(e);
                        }
                    });
                    _SmMap.setMultiEdgePopup(popup);
                    _PreviousMap = _SmMap;
                }
                return _SmMap;
            }
            case 1: {
                if (_DataCenterMap == null) {
                    _DataCenterMap = new SmMap("DataCenter", DataCenterMapFactory.getInstance());
                    _DataCenterMap.setMultiEdgeCollapsed(_ClassCollapseMultiLinks);
                    JPopupMenu popup = new JPopupMenu(EMPTY_STRING);
                    popup.add(Util.createMenuItem("Attributes", "attributes", "DataCenter Attributes", AttributesAction.getInstance()));
                    JMenuItem mi = new JMenuItem("Expand");
                    popup.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExpandMultipleLinksMapAction.getInstance().actionPerformed(e);
                        }
                    });
                    _DataCenterMap.setMultiEdgePopup(popup);
                    _PreviousMap = _DataCenterMap;
                }
                return _DataCenterMap;
            }
            case 2: {
                if (_LanMap == null) {
                    _LanMap = new SmMap("LAN", LanMapFactory.getInstance());
                    _LanMap.setMultiEdgeCollapsed(_ClassCollapseMultiLinks);
                    JPopupMenu popup = new JPopupMenu(EMPTY_STRING);
                    JMenuItem mi = new JMenuItem("Expand");
                    popup.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExpandMultipleLinksMapAction.getInstance().actionPerformed(e);
                        }
                    });
                    _LanMap.setMultiEdgePopup(popup);
                    _PreviousMap = _LanMap;
                }
                return _LanMap;
            }
        }
        return null;
    }

    SmMap(String name, MapFactoryIf mapFactory) {
        super(name);
        this._mapFactory = mapFactory;
        SmMap.setFillColor(_BgColor);
        if (!dummyNode) {
            dummyNode = true;
            System.out.println(".");
            new WarningNode("INIT");
            System.out.println(".");
        }
    }

    public static SmMap getSelectedMap() {
        block5: {
            SmMap map = null;
            try {
                map = BrowserFrame.getInstance().getSelectedMap();
                if (map != null) {
                    _PreviousMap = map;
                    return _PreviousMap;
                }
                MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
                if (mgmtDomain != null && mgmtDomain.getFabric() != null && (map = MapFactory.getInstance().getMap(mgmtDomain.getFabric())) != null) {
                    _PreviousMap = map;
                    return _PreviousMap;
                }
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) break block5;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        if (_PreviousMap == null) {
            return _SmMap;
        }
        return _PreviousMap;
    }

    public boolean isDataCenterMap() {
        return this == _DataCenterMap;
    }

    public boolean isLanMap() {
        return this == _LanMap;
    }

    public boolean isSanMap() {
        return this == _SmMap;
    }

    public void toggleOverView() {
        OverViewMapAction.getInstance().toggleOverView(this);
    }

    public boolean isOverViewDisplayed() {
        OverViewMapAction.getInstance();
        return OverViewMapAction.isOverViewDisplayed(this);
    }

    public static void setOverViewDetached(boolean detach) {
        OverViewMapAction.getInstance().setDetached(detach);
        for (SmMap map : MapFactory._FabricMaps.values()) {
            if (!map.isOverViewDisplayed()) continue;
            OverViewMapAction.getInstance().setDetached(map, detach);
        }
        if (_SmMap != null && _SmMap.isOverViewDisplayed()) {
            OverViewMapAction.getInstance().setDetached(_SmMap, detach);
        }
    }

    public int getHitCode(int x, int y, Transform transform) {
        return -1;
    }

    public MapToolPanel getToolPanel() {
        if (this._window != null && this._window.getToolPanel() != null && this._window.getToolPanel() instanceof MapToolPanel) {
            return (MapToolPanel)this._window.getToolPanel();
        }
        return null;
    }

    public JButton getLayoutButton() {
        MapToolPanel toolPanel = this.getToolPanel();
        if (toolPanel != null) {
            return toolPanel.getLayoutButton();
        }
        return MapMenus.getLayoutButton();
    }

    public JButton getRefreshButton() {
        MapToolPanel toolPanel = this.getToolPanel();
        if (toolPanel != null) {
            return toolPanel.getRefreshButton();
        }
        return MapMenus.getRefreshButton();
    }

    public JButton getSanButton() {
        MapToolPanel toolPanel = this.getToolPanel();
        if (toolPanel != null) {
            return toolPanel.getSanButton();
        }
        return MapMenus.getSanButton();
    }

    public JButton getShowHideEndDevicesButton() {
        MapToolPanel toolPanel = this.getToolPanel();
        if (toolPanel != null) {
            return toolPanel.getShowHideEndDevicesButton();
        }
        return MapMenus.getShowHideEndDevicesButton();
    }

    public JButton getDimHideVsanButton() {
        MapToolPanel toolPanel = this.getToolPanel();
        if (toolPanel != null) {
            return toolPanel.getDimHideVsanButton();
        }
        return MapMenus.getDimHideVsanButton();
    }

    public TopologyWindow getWindow() {
        if (this == _DataCenterMap) {
            if (this._window == null) {
                TopologyGraph.putClassResource((String)"ToolPanel", (Object)MapMenus.getToolPanel());
                this._window = new TopologyWindow();
                this._window.getGraphComponent().setGraph((Graph)SmMap.getInstance(1), false);
                TopologyGraph.putClassResource((String)"JPopupMenu", (Object)MapMenus.getPopup());
                this._window.registerKeyboardAction(CopyAction.getInstance(), "C", KeyStroke.getKeyStroke(67, 2), 0);
            }
            return this._window;
        }
        if (this == _LanMap) {
            if (this._window == null) {
                TopologyGraph.putClassResource((String)"ToolPanel", (Object)MapMenus.getToolPanel());
                this._window = new TopologyWindow();
                this._window.getGraphComponent().setGraph((Graph)SmMap.getInstance(2), false);
                TopologyGraph.putClassResource((String)"JPopupMenu", (Object)MapMenus.getPopup());
                this._window.registerKeyboardAction(CopyAction.getInstance(), "C", KeyStroke.getKeyStroke(67, 2), 0);
            }
            return this._window;
        }
        if (this._window == null) {
            if (this._fabric == null) {
                TopologyGraph.putClassResource((String)"ToolPanel", (Object)MapMenus.getToolPanel());
                this._window = new TopologyWindow();
                this._window.getGraphComponent().setGraph((Graph)SmMap.getInstance(), false);
                TopologyGraph.putClassResource((String)"JPopupMenu", (Object)MapMenus.getPopup());
                this._window.registerKeyboardAction(CopyAction.getInstance(), "C", KeyStroke.getKeyStroke(67, 2), 0);
            } else {
                this._window = BrowserFrame.getInstance().getTopologyWindow(this._fabric);
            }
        }
        return this._window;
    }

    public void setWindow(TopologyWindow window) {
        this._window = window;
    }

    public Fabric getFabric() {
        if (this.isDataCenterMap() || this.isLanMap()) {
            this._fabric = this.isDataCenterMap() && San.getInstance().getFabricCount() < 2 ? San.getInstance().getFabric() : this.getFabricForMapSelection();
        }
        return this._fabric;
    }

    public void setFabric(Fabric fabric) {
        this._fabric = fabric;
    }

    public Fabric getFabricForMapSelection() {
        Fabric firstFabric = null;
        ArrayList nodes = this.getSelectedNodes();
        if (nodes != null && !nodes.isEmpty()) {
            firstFabric = this.getFabricForMapNode((MapNode)nodes.get(0));
            if (nodes.size() == 1 || firstFabric == null) {
                return firstFabric;
            }
            Fabric otherFabric = null;
            for (int i = 1; i < nodes.size(); ++i) {
                otherFabric = this.getFabricForMapNode((MapNode)nodes.get(i));
                if (otherFabric != null && firstFabric.equals(otherFabric)) continue;
                return null;
            }
            return firstFabric;
        }
        ArrayList links = this.getSelectedLinks();
        if (links != null && !links.isEmpty()) {
            firstFabric = this.getFabricForMapLink((MapLink)links.get(0));
            if (links.size() == 1 || firstFabric == null) {
                return firstFabric;
            }
            Fabric otherFabric = null;
            for (int i = 1; i < links.size(); ++i) {
                otherFabric = this.getFabricForMapLink((MapLink)links.get(i));
                if (otherFabric != null && firstFabric.equals(otherFabric)) continue;
                return null;
            }
            return firstFabric;
        }
        return null;
    }

    public Fabric getFabricForMapNode(MapNode mapNode) {
        if (mapNode != null) {
            AbstractModelObject modelObject = (AbstractModelObject)mapNode.getModel();
            return modelObject.getFabric();
        }
        return null;
    }

    public Fabric getFabricForMapLink(MapLink mapLink) {
        if (mapLink != null) {
            AbstractModelObject modelObject = (AbstractModelObject)mapLink.getModel();
            return modelObject.getFabric();
        }
        return null;
    }

    public GraphComponent getGraphComponent() {
        return this.getWindow().getGraphComponent();
    }

    public MapLink addLink(MapLink l) {
        super.addLink(l);
        if (l != null && l.getModel() != null) {
            this._links.put(l.getModel(), l);
        }
        return l;
    }

    public MapLink getLink(Object obj) {
        return this.getLink(obj, true);
    }

    public MapLink getLink(Object obj, boolean subgraph) {
        if (obj == null) {
            return null;
        }
        MapLink l = (MapLink)this._links.get(obj);
        if (l != null) {
            return l;
        }
        for (SmMap tg : this.graphs()) {
            l = tg.getLink(obj, subgraph);
            if (l == null) continue;
            return l;
        }
        return null;
    }

    @Override
    public void removeLink(TopologyLink l) {
        if (l == null) {
            return;
        }
        if (l.getModel() != null) {
            this._links.remove(l.getModel());
        }
        super.removeLink(l);
    }

    @Override
    public TopologyNode addNode(TopologyNode n) {
        super.addNode(n);
        if (n.getModel() != null) {
            this._nodes.put(n.getModel(), n);
        }
        this.setNeedLayout(true);
        if (n instanceof SwitchNode) {
            ((SwitchNode)n).updateName((AbstractModelObject)n.getModel());
        }
        return n;
    }

    public MapNode getNode(Object obj) {
        return this.getNode(obj, true);
    }

    public MapNode getNode(Object obj, boolean subgraph) {
        if (obj == null) {
            return null;
        }
        MapNode n = (MapNode)this._nodes.get(obj);
        if (n != null) {
            return n;
        }
        for (SmMap tg : this.graphs()) {
            n = tg.getNode(obj, subgraph);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    @Override
    public void removeNode(TopologyNode n) {
        if (n == null) {
            return;
        }
        if (n.getModel() != null) {
            this._nodes.remove(n.getModel());
        }
        n.setModel(null);
        super.removeNode(n);
    }

    @Override
    public void replaceNode(TopologyNode oldNode, TopologyNode newNode) {
        if (oldNode == null || newNode == null) {
            return;
        }
        if (oldNode.getModel() != null) {
            this._nodes.remove(oldNode.getModel());
        }
        oldNode.setModel(null);
        super.replaceNode(oldNode, newNode);
    }

    boolean isVisible(EndPort endPort) {
        if (endPort == null) {
            return false;
        }
        if (this == SmMap.getInstance()) {
            if (!ClientController.getInstance().isRestrictedTopology()) {
                for (TopologyNode n : this.nodes()) {
                    if (n == null || !(n instanceof FabricNode)) continue;
                    return n.isExpanded();
                }
                return false;
            }
            Switch sw = San.getInstance().findSwitchByPKInRestrictedTopology(((EndPortBase)endPort.getBaseModelObject()).getSwitchPK());
            SwitchNode switchNode = (SwitchNode)sw.getUserObject();
            return switchNode != null && switchNode.isVisible() && switchNode.isExpanded();
        }
        boolean isTarget = endPort.isTarget();
        boolean isInitiator = !isTarget;
        boolean isVirtualized = endPort.isVirtualized();
        boolean isISCSI = endPort.isISCSI();
        Switch sw = endPort.getSwitch();
        Hub hub = endPort.getHub();
        try {
            SwitchNode switchNode = (SwitchNode)MapFactory.getInstance().getNode(sw);
            if (hub != null) {
                MapNode n = MapFactory.getInstance().getNode(hub);
                if (switchNode != null && n != null && n.isExpanded() && n.isVisible()) {
                    if (isTarget && isVirtualized && switchNode.isFilterOn(128L)) {
                        return true;
                    }
                    if (isTarget && isVirtualized && !switchNode.isFilterOn(128L)) {
                        return false;
                    }
                    if (isInitiator && isVirtualized && switchNode.isFilterOn(256L)) {
                        return true;
                    }
                    if (isInitiator && isVirtualized && !switchNode.isFilterOn(256L)) {
                        return false;
                    }
                    if (isTarget && isISCSI && switchNode.isFilterOn(32L)) {
                        return true;
                    }
                    if (isTarget && isISCSI && !switchNode.isFilterOn(32L)) {
                        return false;
                    }
                    if (isInitiator && isISCSI && switchNode.isFilterOn(64L)) {
                        return true;
                    }
                    if (isInitiator && isISCSI && !switchNode.isFilterOn(64L)) {
                        return false;
                    }
                    if (isTarget && !switchNode.isFilterOn(8L)) {
                        return false;
                    }
                    return !isInitiator || switchNode.isFilterOn(16L);
                }
            } else {
                MapNode n = MapFactory.getInstance().getNode(sw);
                if (switchNode != null && n != null && n.getParent() == this && n.isExpanded() && n.isVisible()) {
                    if (isTarget && isVirtualized && switchNode.isFilterOn(128L)) {
                        return true;
                    }
                    if (isTarget && isVirtualized && !switchNode.isFilterOn(128L)) {
                        return false;
                    }
                    if (isInitiator && isVirtualized && switchNode.isFilterOn(256L)) {
                        return true;
                    }
                    if (isInitiator && isVirtualized && !switchNode.isFilterOn(256L)) {
                        return false;
                    }
                    if (isTarget && isISCSI && switchNode.isFilterOn(32L)) {
                        return true;
                    }
                    if (isTarget && isISCSI && !switchNode.isFilterOn(32L)) {
                        return false;
                    }
                    if (isInitiator && isISCSI && switchNode.isFilterOn(64L)) {
                        return true;
                    }
                    if (isInitiator && isISCSI && !switchNode.isFilterOn(64L)) {
                        return false;
                    }
                    if (isTarget && !switchNode.isFilterOn(8L)) {
                        return false;
                    }
                    return !isInitiator || switchNode.isFilterOn(16L);
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void resetData() {
        block10: {
            if (this._links != null) {
                this._links.clear();
            }
            if (this._nodes != null) {
                this._nodes.clear();
            }
            this._enclosureNodes.clear();
            if (this._window != null) {
                try {
                    this.clear();
                    this._window.reset();
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) break block10;
                    _Logger.trace((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (this.isDataCenterMap()) {
            DataCenterMapFactory.getInstance().reset();
        } else if (this.isLanMap()) {
            Lan.getInstance().refresh(true);
        } else {
            MapFactory.getInstance().resetFabric(this._fabric);
        }
        if (this._savedLayoutProperties != null) {
            this._savedLayoutProperties.clear();
        }
    }

    public boolean isRestrictedTopology() {
        return this.isSanMap() && ClientController.getInstance().isRestrictedTopology();
    }

    public void relayout() {
        this.relayout(true);
        this._needLayout = false;
    }

    public void relayout(boolean fit) {
        LayoutAction.getInstance().layout((TopologyGraph)this, fit);
        this._needLayout = false;
    }

    void setNeedLayout(boolean layout) {
        if (!layout || this._savedLayoutProperties != null && this._savedLayoutProperties.size() > 0) {
            this._needLayout = layout;
        }
    }

    public void repaint(boolean fit) {
        block4: {
            try {
                if (fit) {
                    this.getWindow().repaintGraph(1);
                } else {
                    this.getWindow().repaintGraph();
                }
                JButton b = this.getRefreshButton();
                ButtonModel bm = b.getModel();
                b.setEnabled(true);
                b.setBorderPainted(false);
                bm.setArmed(false);
                bm.setPressed(false);
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) break block4;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
    }

    public void repaint() {
        if (!this._displayed) {
            this._displayed = true;
            this.repaint(true);
        } else {
            this.repaint(false);
        }
    }

    public void compactBounds() {
        if (this.isSanMap()) {
            Bounds rawbounds = this.getRawBounds(null);
            this.setBounds(rawbounds.getLeft() - 100.0, rawbounds.getBottom() - 20.0, rawbounds.getRight() + 100.0, rawbounds.getTop() + 20.0);
        } else {
            super.compactBounds();
        }
    }

    public void compactBounds(boolean visibleNodesOnly) {
        if (visibleNodesOnly) {
            double left = Double.MAX_VALUE;
            double right = Double.MIN_VALUE;
            double top = Double.MIN_VALUE;
            double bottom = Double.MAX_VALUE;
            for (MapNode n : this._nodes.values()) {
                if (!n.isVisible()) continue;
                if (n.getCenterX() < left) {
                    left = n.getCenterX();
                }
                if (n.getCenterX() > right) {
                    right = n.getCenterX();
                }
                if (n.getCenterY() < bottom) {
                    bottom = n.getCenterY();
                }
                if (!(n.getCenterY() > top)) continue;
                top = n.getCenterY();
            }
            this.setRawBounds(left - 50.0, bottom - 12.0, right + 50.0, top + 12.0);
        }
        this.compactBounds();
    }

    public static void resetPopups() {
        for (SmMap map : MapFactory._FabricMaps.values()) {
            map.resetPopup();
        }
        if (_SmMap != null) {
            _SmMap.resetPopup();
        }
        if (_DataCenterMap != null) {
            _DataCenterMap.resetPopup();
        }
        if (_LanMap != null) {
            _LanMap.resetPopup();
        }
        TopologyGraph.putClassResource((String)"ToolPanel", (Object)MapMenus.getToolPanel());
        TopologyGraph.putClassResource((String)"JPopupMenu", (Object)MapMenus.getPopup());
    }

    public void resetPopup() {
        for (MapNode n : this._nodes.values()) {
            n.setPopup(null);
        }
        for (TopologyLink l : this.edges()) {
            if (l == null || l.isDummyLink()) continue;
            l.setPopup(null);
        }
    }

    public void setPreferences() {
        ExpandLoopMapAction.getInstance().expandLoops(!_ClassCollapseLoops);
        if (_ClassDisplayEndDevices) {
            ShowEndDevicesMapAction.showEndNodes(this);
        } else {
            ShowEndDevicesMapAction.hideEndNodes(this);
        }
        if (_ClassDisplayISCSI) {
            FilterISCSIEndDevicesMapAction.showEndNodes(this);
        } else {
            FilterISCSIEndDevicesMapAction.hideEndNodes(this);
        }
        if (_ClassDisplayTargets) {
            FilterTargetEndDevicesMapAction.showEndNodes(this);
        } else {
            FilterTargetEndDevicesMapAction.hideEndNodes(this);
        }
        if (_ClassDisplayInitiators) {
            FilterInitiatorEndDevicesMapAction.showEndNodes(this);
        } else {
            FilterInitiatorEndDevicesMapAction.hideEndNodes(this);
        }
        if (!_ClassDisplayNodeLabels) {
            ShowEndDeviceLabelsMapAction.displayEndDeviceLabels(false);
        }
        SmMap.setGlobalMultiEdgeCollapsed(_ClassCollapseMultiLinks);
        this.setMultiEdgeCollapsed(_ClassCollapseMultiLinks);
        if (_ClassDisplayNpvSwitches) {
            ShowNpvSwitchesMapAction.showNpvSwitches(this);
        } else {
            ShowNpvSwitchesMapAction.hideNpvSwitches(this);
        }
    }

    @Override
    public void saveCoordinates(Transform t, PrintStream out) {
        String name = this.getPath("/");
        if (name == null || name.equals(EMPTY_STRING)) {
            name = "unknownFabric";
        }
        out.println(name);
        MapNode n2 = null;
        if (this.graphs() != null) {
            for (TopologyGraph tg : this.graphs()) {
                tg.saveCoordinates(t, out);
            }
        }
        Fabric fabric = this.getFabric();
        if (this.nodes() == null || fabric == null) {
            return;
        }
        if (t != null) {
            out.println("/SCALE, " + t.getScaleX() + "| " + t.getScaleY());
        }
        for (MapNode n2 : this._nodes.values()) {
            this.saveNode(t, out, n2);
        }
        out.println("/LINKS");
        for (TopologyLink l : this.edges()) {
            if (l == null) continue;
            try {
                if (this.isMultiEdgeCollapsed()) {
                    if (!l.isDummyLink() || l.isVisible() || !l.getFromNode().isVisible() || !l.getToNode().isVisible()) continue;
                    out.println("1|" + l.getFromNode().hashCode() + SEPARATOR_STRING + l.getToNode().hashCode());
                    continue;
                }
                if (!l.isDummyLink() || !l.isVisible()) continue;
                out.println("0|" + l.getFromNode().hashCode() + SEPARATOR_STRING + l.getToNode().hashCode());
            }
            catch (Exception e) {
                if (!_Logger.isTraceEnabled()) continue;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        out.println("//");
    }

    private void saveNode(Transform t, PrintStream out, TopologyNode n) {
        if (n == null) {
            return;
        }
        String nm = n.getText();
        if (nm == null || EMPTY_STRING.equals(nm)) {
            nm = n.toString();
        }
        if (nm == null || EMPTY_STRING.equals(nm)) {
            nm = " ";
        }
        try {
            if (t != null) {
                out.println(nm + SEPARATOR_STRING + n.hashCode() + SEPARATOR_STRING + t.xToDevice((double)((int)n.getCenterX())) + SEPARATOR_STRING + t.xToDevice((double)((int)n.getCenterY())) + SEPARATOR_STRING + n.isLocationFixed() + SEPARATOR_STRING + n.isSetExpanded() + SEPARATOR_STRING + n.isVisible());
            } else {
                out.println(nm + SEPARATOR_STRING + n.hashCode() + SEPARATOR_STRING + (int)n.getCenterX() + SEPARATOR_STRING + (int)n.getCenterY() + SEPARATOR_STRING + n.isLocationFixed() + SEPARATOR_STRING + n.isSetExpanded() + SEPARATOR_STRING + n.isVisible());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public boolean loadCoordinates(Transform t, BufferedReader in) throws IOException {
        String str;
        boolean requireLayout = true;
        int i = 0;
        TopologyNode n2 = null;
        StringTokenizer st = null;
        String[] nodeVals = new String[10];
        int count = 0;
        boolean force = false;
        boolean sgl = false;
        boolean links = false;
        boolean isMultiEdgeCollapsed = this.isMultiEdgeCollapsed();
        boolean isDisplayEndDevices = SmMap.isDisplayEndDevices();
        boolean isCollapseLoops = this.isCollapseLoops();
        boolean isDisplayNpvSwitches = this.isDisplayNpvSwitches();
        block8: while ((str = in.readLine()) != null) {
            try {
                block24: {
                    if (str == null || EMPTY_STRING.equals(str)) continue;
                    if (str.charAt(0) == '/') {
                        if (str.charAt(1) == '/') break;
                        if ("/LINKS".equals(str)) {
                            links = true;
                            continue;
                        }
                        if ("/SCALE".equals(str)) {
                            st = new StringTokenizer(str, SEPARATOR_STRING);
                            String sx = st.nextToken();
                            String sy = st.nextToken();
                            if (t == null) continue;
                            t.setScaleX(Double.parseDouble(sx));
                            t.setScaleY(Double.parseDouble(sy));
                            continue;
                        }
                        if ("/COLLAPSE_MULTIPLE_LINK".equals(str) || "/SHOW_END_NODE".equals(str) || "/EXPAND_LOOPS".equals(str) || this.graphs() == null) continue;
                        for (TopologyGraph tg : this.graphs()) {
                            if (!tg.getPath("/").equals(str) || !(sgl = tg.loadCoordinates(t, in))) continue;
                            force = true;
                        }
                        continue;
                    }
                    if (links) {
                        TopologyLink l;
                        st = new StringTokenizer(str, SEPARATOR_STRING);
                        String visible = st.nextToken();
                        String id1 = st.nextToken();
                        String id2 = st.nextToken();
                        if (id1 == null || id2 == null || (l = this.getDummyEdge(id1, id2)) == null) continue;
                        if ("1".equals(visible)) {
                            this.expandLink(l);
                            l.getFromNode().computeIsLinksExpanded();
                            l.getToNode().computeIsLinksExpanded();
                            continue;
                        }
                        this.collapseLink(l);
                        l.getFromNode().computeIsLinksExpanded();
                        l.getToNode().computeIsLinksExpanded();
                        continue;
                    }
                    st = new StringTokenizer(str, SEPARATOR_STRING);
                    i = 0;
                    try {
                        String s = st.nextToken();
                        nodeVals[i++] = s;
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) break block24;
                        _Logger.trace((Object)"logEmptyCatch - next token", (Throwable)ex);
                    }
                }
                while (st.hasMoreTokens()) {
                    nodeVals[i++] = st.nextToken();
                }
                for (TopologyNode n2 : this.nodes()) {
                    if (n2 == null) continue;
                    try {
                        String nm = n2.getText();
                        if (nm == null || EMPTY_STRING.equals(nm)) {
                            nm = n2.toString();
                        }
                        if (nm == null) {
                            nm = EMPTY_STRING;
                        }
                        if (!nodeVals[1].equals(EMPTY_STRING + n2.hashCode()) && !nm.equals(nodeVals[0])) continue;
                        requireLayout = false;
                        n2.setIconCenter(Integer.parseInt(nodeVals[2]), Integer.parseInt(nodeVals[3]));
                        this.setNodeSize((MapNode)n2);
                        if (nodeVals.length > 4 && "true".equals(nodeVals[4])) {
                            n2.setLocationFixed(true);
                        }
                        if (nodeVals.length > 5 && (n2 instanceof SwitchNode || n2 instanceof LoopNode)) {
                            if ("false".equals(nodeVals[5])) {
                                n2.setExpanded(false);
                            } else {
                                n2.setExpanded(true);
                            }
                        }
                        try {
                            ((SwitchNode)n2).setFilter(Long.parseLong(nodeVals[7]));
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.debug((Object)nfe.getMessage(), (Throwable)nfe);
                        }
                        ++count;
                        continue block8;
                    }
                    catch (NumberFormatException ex) {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            catch (Exception wex) {
                if (!_Logger.isTraceEnabled()) continue;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)wex);
            }
        }
        if (count == 1 || count < this.nodes().size() * 25 / 100) {
            requireLayout = true;
        }
        return requireLayout || force;
    }

    public void saveOnThread() {
        SaveThread saveThread = new SaveThread(this);
        saveThread.start();
    }

    public void save() {
        if (SmMap.isAutoSaveLayout()) {
            this.store(null);
        }
    }

    public void load() {
        String userDir = ClientCache.getLocation() + "db" + File.separator;
        String fileName = userDir + this.getText() + ".map";
        File f = new File(fileName);
        if (f.exists()) {
            this.loadOld(f);
            f.delete();
        } else {
            this.load(null);
        }
    }

    private void clearSwitchEndNodeVisible() {
        if (this._fabric == null) {
            return;
        }
        Switch[] sws = this._fabric.getSwitches();
        if (sws == null || sws.length == 0) {
            return;
        }
        for (int i = 0; i < sws.length; ++i) {
            SwitchNode n = (SwitchNode)MapFactory.getInstance().getNode(sws[i]);
            if (n == null || n.getParent() != this) continue;
            n._checkEndNodeVisible = true;
        }
    }

    public boolean isSaveRequired(Object newFilter) {
        String oldl = this.getLayoutName();
        Object oldFilter = this._filter;
        this._filter = newFilter;
        String newl = this.getLayoutName();
        this._filter = oldFilter;
        return oldl != newl && oldl != null && newl != null && !oldl.equals(newl);
    }

    public void setLayoutFilter(Object o) {
        block5: {
            String oldl = this.getLayoutName();
            this._filter = o;
            String newl = this.getLayoutName();
            this.clearSwitchEndNodeVisible();
            if (oldl != newl && oldl != null && newl != null && !oldl.equals(newl)) {
                boolean changePolicy = this.getDimNodeDisplayPolicy() == 2 && newl.equals(DefaultLayoutName);
                try {
                    this.load(null);
                    if (this._savedLayoutProperties == null || this._savedLayoutProperties.size() < 2) {
                        LayoutAction.getInstance().layout(this, true, changePolicy);
                        break block5;
                    }
                    this.computeNodeSize(false);
                    this.updateBounds();
                    this.compactBounds();
                    this.repaint(true);
                }
                catch (Exception ex) {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                    }
                    break block5;
                }
            }
            this.updateBounds();
            this.compactBounds();
            this.repaint(true);
        }
    }

    public Object getLayoutFilter() {
        return this._filter;
    }

    public String getLayoutFilterName() {
        if (this.isDataCenterMap()) {
            return "DataCenter";
        }
        if (this.isSanMap()) {
            return "SAN";
        }
        if (this.isLanMap()) {
            return "LAN";
        }
        if (this._filter == null) {
            return this.getFabric().getFabricName();
        }
        if (this._filter instanceof VsanPK) {
            return EMPTY_STRING + ((VsanPK)this._filter)._id;
        }
        if (this._filter instanceof GroupPK) {
            return EMPTY_STRING + ((GroupPK)this._filter).getName();
        }
        return this._filter.toString();
    }

    public ViewLayoutProperties getLayoutProperties() {
        ViewLayoutProperties vlp = ViewLayoutProperties.get(this.getLayoutFilterName());
        if (vlp == null) {
            return ViewLayoutProperties.get("FABRIC");
        }
        return vlp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateLayoutName() {
        block4: {
            try {
                this.save();
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) break block4;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        if (this._filter != null) {
            if (this.getDimNodeDisplayPolicy() == 2 && this._filter instanceof VsanPK) {
                this.setLayoutName(EMPTY_STRING + ((VsanPK)this._filter)._id);
                return;
            }
        }
        if (this._filter == null) return;
        if (this.getDimNodeDisplayPolicy() != 2) return;
        if (!(this._filter instanceof GroupPK)) return;
        this.setLayoutName(EMPTY_STRING + ((GroupPK)this._filter).getName());
    }

    public String getLayoutName() {
        String str;
        block5: {
            str = null;
            try {
                ViewLayoutProperties viewLayoutProperties = this.getLayoutProperties();
                if (viewLayoutProperties != null) {
                    str = viewLayoutProperties._layoutName;
                }
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) break block5;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        if (str == null || str.length() == 0) {
            String mapName;
            String layoutName;
            if (_mapLastUsedLayoutProp != null && (layoutName = _mapLastUsedLayoutProp.getProperty(mapName = this.isSanMap() ? "SAN" : (this.isDataCenterMap() ? "DataCenter" : (this.isLanMap() ? "LAN" : this.getFabric().getFabricName())))) != null && layoutName.trim().length() > 0) {
                return layoutName;
            }
            return DefaultLayoutName;
        }
        return str;
    }

    public void setLayoutName(String nm) {
        ViewLayoutProperties.put(this.getLayoutFilterName(), new ViewLayoutProperties(nm, this.isCollapseLoops(), this.isMultiEdgeCollapsed(), SmMap.isDisplayEndDevices(), SmMap.isOverridePreferences(), this.isDisplayISCSI(), this.isDisplayTargets(), this.isDisplayInitiators(), this.isDisplayNpvSwitches()));
        String mapName = this.isSanMap() ? "SAN" : (this.isDataCenterMap() ? "DataCenter" : (this.isLanMap() ? "LAN" : this.getFabric().getFabricName()));
        _mapLastUsedLayoutProp.setProperty(mapName, nm);
    }

    public void load(ViewLayoutProperties vlp) {
        String layout;
        String fabricName = null;
        fabricName = this.isSanMap() ? "SAN" : (this.isDataCenterMap() ? "DataCenter" : (this.isLanMap() ? "LAN" : this.getFabric().getFabricName()));
        if (fabricName == null) {
            fabricName = "NO_NAME";
        }
        if (_mapLastUsedLayoutProp == null && (_mapLastUsedLayoutProp = ClientController.getInstance().loadPropertiesFromServer(LAST_USED_FILE, false)) == null) {
            _mapLastUsedLayoutProp = new Properties();
        }
        if (vlp == null) {
            vlp = this.getLayoutProperties();
        }
        if (vlp == null || vlp._layoutName == null) {
            layout = DefaultLayoutName;
            String lastUsedLayoutName = _mapLastUsedLayoutProp.getProperty(fabricName);
            if (lastUsedLayoutName != null && lastUsedLayoutName.trim().length() != 0) {
                layout = lastUsedLayoutName;
            } else {
                _mapLastUsedLayoutProp.setProperty(fabricName, layout);
            }
        } else {
            layout = vlp._layoutName;
            _mapLastUsedLayoutProp.setProperty(fabricName, layout);
        }
        Properties prop = ClientController.getInstance().loadPropertiesFromServer(EMPTY_STRING + fabricName + "-" + layout + ".map", true, false);
        if (prop == null) {
            prop = ClientController.getInstance().loadPropertiesFromServer(EMPTY_STRING + fabricName.replace('_', ' ') + "-" + layout + ".map", true, false);
        }
        if (prop == null && (prop = this.checkOldPropertiesAndRename(ClientController.getInstance().getDeviceName(), layout)) == null && this.getFabric() != null) {
            Switch[] sws = this.getFabric().getSwitches();
            for (int i = 0; i < sws.length && (prop = this.checkOldPropertiesAndRename(sws[i].getName(), layout)) == null && (prop = this.checkOldPropertiesAndRename(sws[i].getIpAddress(), layout)) == null && (prop = this.checkOldPropertiesAndRename("Fabric " + sws[i].getIpAddress(), layout)) == null; ++i) {
            }
        }
        if (prop != null) {
            this.setProperties(vlp, prop);
        }
    }

    public Map<String, Exception> delete(String[] layouts) {
        String fabricName = null;
        fabricName = this.isSanMap() ? "SAN" : (this.isDataCenterMap() ? "DataCenter" : (this.isLanMap() ? "LAN" : this.getFabric().getFabricName()));
        HashMap<String, Exception> errors = new HashMap<String, Exception>();
        for (int i = 0; i < layouts.length; ++i) {
            try {
                ClientController.getInstance().removePropetriesFromServer(EMPTY_STRING + fabricName + "-" + layouts[i] + ".map");
                continue;
            }
            catch (Exception e) {
                errors.put(layouts[i], e);
            }
        }
        return errors;
    }

    public void delete(String layout) throws Exception {
        String fabricName = null;
        fabricName = this.isSanMap() ? "SAN" : (this.isDataCenterMap() ? "DataCenter" : (this.isLanMap() ? "LAN" : this.getFabric().getFabricName()));
        ClientController.getInstance().removePropetriesFromServer(EMPTY_STRING + fabricName + "-" + layout + ".map");
    }

    private Properties checkOldPropertiesAndRename(String oldName, String layout) {
        Properties prop = ClientController.getInstance().loadPropertiesFromServer(EMPTY_STRING + oldName + "-" + layout + ".map", false);
        if (prop != null) {
            ClientController.getInstance().renameProperties(oldName, this.getFabric().getFabricName());
        }
        return prop;
    }

    public void store() {
        if (ClientController.getInstance().isServerActive()) {
            this.store(null);
        }
    }

    public void store(ViewLayoutProperties vlp) {
        String layout;
        if (this.getNodeCount() < 2) {
            return;
        }
        String mapName = null;
        Fabric f = this.getFabric();
        if (this.isSanMap()) {
            if (ClientController.getInstance().isRestrictedTopology()) {
                return;
            }
            mapName = "SAN";
        } else {
            mapName = this.isDataCenterMap() ? "DataCenter" : (this.isLanMap() ? "LAN" : f.getFabricName());
        }
        if (mapName == null) {
            mapName = "NO_NAME";
        }
        if (vlp == null) {
            vlp = this.getLayoutProperties();
        }
        if (vlp == null || vlp._layoutName == null) {
            layout = DefaultLayoutName;
            String lastUsedLayoutName = _mapLastUsedLayoutProp.getProperty(mapName);
            if (lastUsedLayoutName != null && lastUsedLayoutName.trim().length() != 0) {
                layout = lastUsedLayoutName;
            }
        } else {
            layout = vlp._layoutName;
        }
        if (this._savedLayoutProperties == null) {
            this._savedLayoutProperties = new Properties();
        }
        for (int i = 0; i < 10 && LayoutAction.getInstance().isLayoutRunning(); ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                if (!_Logger.isTraceEnabled()) continue;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        if (!LayoutAction.getInstance().isLayoutRunning()) {
            this.getProperties(this._savedLayoutProperties);
            this._savedLayoutProperties.put(EXPAND_MULTIPLE_LINKS, Boolean.valueOf(!this.isMultiEdgeCollapsed()).toString());
            this._savedLayoutProperties.put(EXPAND_LOOPS, Boolean.valueOf(!this.isCollapseLoops()).toString());
            this._savedLayoutProperties.put(DISPLAY_NPV_SWITCHES, Boolean.valueOf(this.isDisplayNpvSwitches()).toString());
            ClientController.getInstance().storePropertiesToServer(EMPTY_STRING + mapName + "-" + layout + ".map", this._savedLayoutProperties, EMPTY_STRING, true, false);
        }
        ClientController.getInstance().storePropertiesToServer(LAST_USED_FILE, _mapLastUsedLayoutProp, EMPTY_STRING, false);
    }

    public void getAllLanProperties(Properties prop) {
        MapNode n2 = null;
        boolean show_expanded = true;
        String np = null;
        for (MapNode n2 : this._nodes.values()) {
            if (n2 == null) continue;
            try {
                np = EMPTY_STRING + (int)n2.getCenterX() + SEPARATOR_STRING + (int)n2.getCenterY() + SEPARATOR_STRING + n2.isLocationFixed() + SEPARATOR_STRING + (show_expanded ? EMPTY_STRING + n2.isSetExpanded() + SEPARATOR_STRING : SEPARATOR_STRING) + false + SEPARATOR_STRING + false + SEPARATOR_STRING + false + SEPARATOR_STRING;
                prop.put(((AbstractModelObject)n2.getModel()).getPK().toString(), np);
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) continue;
                _Logger.trace((Object)"logEmptyCatch - getAllLanProperties n.getModel()).getPK() ", (Throwable)ex);
            }
        }
    }

    public void getAllSanProperties(Properties prop) {
        Enclosure[] enclosures;
        String np;
        MapNode n;
        boolean show_expanded = true;
        Fabric[] fabrics = San.getInstance().getFabrics();
        if (fabrics != null && fabrics.length > 0) {
            for (int j = 0; j < fabrics.length; ++j) {
                n = MapFactory.getInstance().getNode(fabrics[j]);
                if (n == null) continue;
                try {
                    np = EMPTY_STRING + (int)n.getCenterX() + SEPARATOR_STRING + (int)n.getCenterY() + SEPARATOR_STRING + n.isLocationFixed() + SEPARATOR_STRING + (show_expanded ? EMPTY_STRING + n.isSetExpanded() + SEPARATOR_STRING : SEPARATOR_STRING) + false + SEPARATOR_STRING + false + SEPARATOR_STRING + false + SEPARATOR_STRING;
                    prop.put(fabrics[j].getPK().toString(), np);
                    continue;
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) continue;
                    _Logger.trace((Object)"logEmptyCatch - getAllSanProperties fabrics[j].getPK() ", (Throwable)ex);
                }
            }
        }
        if ((enclosures = San.getInstance().getEnclosures()) != null && enclosures.length > 0) {
            for (int j = 0; j < enclosures.length; ++j) {
                if (!enclosures[j].isMemberOfMultiFabrics() || (n = (MapNode)SmMap.getInstance()._enclosureNodes.get(enclosures[j].getEnclosureName())) == null) continue;
                try {
                    np = EMPTY_STRING + (int)n.getCenterX() + SEPARATOR_STRING + (int)n.getCenterY() + SEPARATOR_STRING + n.isLocationFixed() + SEPARATOR_STRING + (show_expanded ? EMPTY_STRING + n.isSetExpanded() + SEPARATOR_STRING : SEPARATOR_STRING) + false + SEPARATOR_STRING + false + SEPARATOR_STRING + false + SEPARATOR_STRING;
                    prop.put(enclosures[j].getEnclosureName(), np);
                    continue;
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) continue;
                    _Logger.trace((Object)"logEmptyCatch - enclosures[j].getEnclosureName() ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProperties(Properties prop) {
        try {
            TopologyNode.setUseVisibilityCache(true);
            TopologyNode.clearVisibilityCache();
            if (this.isSanMap()) {
                this.getAllSanProperties(prop);
                return;
            }
            if (this.isDataCenterMap() || this.isLanMap()) {
                this.getAllLanProperties(prop);
                return;
            }
            MapNode n2 = null;
            boolean show_expanded = true;
            boolean wwnenabled = WwnDictionary.isEnabled();
            if (wwnenabled) {
                WwnDictionary.setEnabled(false);
            }
            boolean linksCollapsed = this.isMultiEdgeCollapsed();
            for (MapNode n2 : this._nodes.values()) {
                ArrayList<EndPort> list;
                String np;
                AbstractModelObject model;
                if ((AbstractModelObject)n2.getModel() instanceof EndPort && ((EndPort)n2.getModel()).getEnclosure() != null || n2 instanceof SwitchNode && !n2.isVisible() && ((model = (AbstractModelObject)n2.getModel()) == null || model.isDestoryed() || model.getBaseModelObject() == null || model.getPK() == null || prop.get(model.getPK().toString()) != null)) continue;
                if (n2 instanceof SwitchNode) {
                    SwitchNode switchNode = (SwitchNode)n2;
                    np = EMPTY_STRING + (int)n2.getCenterX() + SEPARATOR_STRING + (int)n2.getCenterY() + SEPARATOR_STRING + n2.isLocationFixed() + SEPARATOR_STRING + (show_expanded ? EMPTY_STRING + n2.isSetExpanded() + SEPARATOR_STRING : SEPARATOR_STRING) + (linksCollapsed ? (n2.isLinksExpanded() ? "true|" : SEPARATOR_STRING) : (n2.isLinksExpanded() ? SEPARATOR_STRING : "false|")) + EMPTY_STRING + switchNode.getFilter() + SEPARATOR_STRING;
                } else {
                    np = EMPTY_STRING + (int)n2.getCenterX() + SEPARATOR_STRING + (int)n2.getCenterY() + SEPARATOR_STRING + n2.isLocationFixed() + SEPARATOR_STRING + (show_expanded ? EMPTY_STRING + n2.isSetExpanded() + SEPARATOR_STRING : SEPARATOR_STRING) + (linksCollapsed ? (n2.isLinksExpanded() ? "true|" : SEPARATOR_STRING) : (n2.isLinksExpanded() ? SEPARATOR_STRING : "false|")) + EMPTY_STRING + "0" + SEPARATOR_STRING;
                }
                if ((model = (AbstractModelObject)n2.getModel()) == null || !(n2 instanceof LoopNode) && (model.isDestoryed() || model.getBaseModelObject() == null || model.getPK() == null)) continue;
                prop.put(((AbstractModelObject)n2.getModel()).getPK().toString(), np);
                if (!((AbstractModelObject)n2.getModel() instanceof Enclosure) || (list = ((Enclosure)n2.getModel()).getMembers()) == null || list.size() <= 0) continue;
                for (int i = 0; i < list.size(); ++i) {
                    EndPort ep = list.get(i);
                    if (ep == null || ep.getBaseModelObject() == null || ep.getPK() == null) continue;
                    prop.put(ep.getPK().toString(), np);
                }
            }
            if (wwnenabled) {
                WwnDictionary.setEnabled(true);
            }
        }
        finally {
            TopologyNode.setUseVisibilityCache(false);
            TopologyNode.clearVisibilityCache();
        }
    }

    public boolean isVsanFilter() {
        return this._filter != null && this._filter instanceof VsanPK;
    }

    public boolean isGroupFilter() {
        return this._filter != null && this._filter instanceof GroupPK;
    }

    public void setLanProperties(ViewLayoutProperties vlp, Properties prop) {
        boolean expLinks;
        MapNode n2 = null;
        boolean defaultLayout = vlp == null ? true : DefaultLayoutName.equals(vlp._layoutName);
        boolean override = SmMap.isOverridePreferences() || this.isVsanFilter() || this.isGroupFilter();
        boolean wwnenabled = WwnDictionary.isEnabled();
        boolean bl = expLinks = !this.isMultiEdgeCollapsed();
        boolean expLoops = vlp == null || defaultLayout || !SmMap.isOverridePreferences() ? !this.isCollapseLoops() : !vlp._collapseLoops;
        long filter = -1L;
        for (MapNode n2 : this._nodes.values()) {
            String key = n2.getModel() instanceof Fabric ? ((Fabric)n2.getModel()).getPK().toString() : ((AbstractModelObject)n2.getModel()).getPK().toString();
            String np = (String)prop.get(key);
            if (np == null || np.length() == 0) continue;
            if (n2 instanceof LoopNode || n2 instanceof SwitchNode) {
                this.setProperties(n2, np, expLoops, defaultLayout || override, filter);
                continue;
            }
            if (np == null) continue;
            this.setProperties(n2, np, true, true, filter);
        }
        if (wwnenabled) {
            WwnDictionary.setEnabled(true);
        }
        this.setMultiEdgeCollapsed(!expLinks);
    }

    public void setProperties(ViewLayoutProperties vlp, Properties prop) {
        String np;
        String key;
        boolean endDev;
        boolean expLinks;
        Fabric fabric = this.getFabric();
        this._savedLayoutProperties = prop;
        if (this.isDataCenterMap() || this.isLanMap() || this.isSanMap()) {
            this.setLanProperties(vlp, prop);
            return;
        }
        MapNode n2 = null;
        boolean defaultLayout = vlp == null ? true : DefaultLayoutName.equals(vlp._layoutName);
        boolean override = SmMap.isOverridePreferences() || this.isVsanFilter() || this.isGroupFilter();
        boolean wwnenabled = WwnDictionary.isEnabled();
        String b = (String)this._savedLayoutProperties.get(EXPAND_MULTIPLE_LINKS);
        boolean bl = expLinks = !this.isMultiEdgeCollapsed();
        if (b != null && b.length() > 0) {
            if (b.equals("true")) {
                if (vlp != null) {
                    vlp._collapseMultipleLinks = false;
                }
                expLinks = true;
            } else {
                if (vlp != null) {
                    vlp._collapseMultipleLinks = true;
                }
                expLinks = false;
            }
        } else {
            expLinks = vlp == null || defaultLayout || !SmMap.isOverridePreferences() ? !this.isMultiEdgeCollapsed() : !vlp._collapseMultipleLinks;
        }
        b = (String)this._savedLayoutProperties.get(EXPAND_LOOPS);
        if (b != null && b.length() > 0) {
            if (b.equals("true")) {
                this.setCollapseLoops(false);
                if (vlp != null) {
                    vlp._collapseLoops = false;
                }
            } else {
                this.setCollapseLoops(true);
                if (vlp != null) {
                    vlp._collapseLoops = true;
                }
            }
        }
        if ((b = (String)this._savedLayoutProperties.get(DISPLAY_NPV_SWITCHES)) != null && b.length() > 0) {
            if (b.equals("true")) {
                this.setDisplayNpvSwitches(true);
                if (vlp != null) {
                    vlp._displayNpvSwitches = true;
                }
            } else {
                this.setDisplayNpvSwitches(false);
                if (vlp != null) {
                    vlp._displayNpvSwitches = false;
                }
            }
        }
        if (wwnenabled) {
            WwnDictionary.setEnabled(false);
        }
        boolean bl2 = endDev = vlp == null || defaultLayout || !SmMap.isOverridePreferences() ? SmMap.isDisplayEndDevices() : vlp._showEndDevices;
        boolean expLoops = vlp == null || defaultLayout || !SmMap.isOverridePreferences() ? !this.isCollapseLoops() : !vlp._collapseLoops;
        long filter = -1L;
        Switch[] sws = fabric.getSwitches();
        if (sws != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                n2 = MapFactory.getInstance().getNode(sws[i]);
                if (sws[i] == null || sws[i].getPK() == null) continue;
                key = sws[i].getPK().toString();
                np = (String)prop.get(key);
                if (n2 == null) continue;
                this.setProperties(n2, np, endDev, defaultLayout || override, -1L);
            }
        }
        for (MapNode n2 : this._nodes.values()) {
            Enclosure encl;
            ArrayList<EndPort> l;
            key = ((AbstractModelObject)n2.getModel()).getPK().toString();
            np = (String)prop.get(key);
            if (np == null || np.length() == 0 || n2 instanceof SwitchNode) continue;
            if (n2 instanceof LoopNode) {
                this.setProperties(n2, np, expLoops, defaultLayout || override, filter);
                continue;
            }
            if (np != null) {
                this.setProperties(n2, np, true, true, filter);
                continue;
            }
            if (np == null && n2.getModel() != null && n2.getModel() instanceof Enclosure && (l = (encl = (Enclosure)n2.getModel()).getMembers()) != null && l.size() > 0) {
                for (int i = 0; i < l.size() && (np = (String)prop.get(l.get(i).getPK().toString())) == null; ++i) {
                }
            }
            this.setProperties(n2, np, true, true, filter);
        }
        if (wwnenabled) {
            WwnDictionary.setEnabled(true);
        }
        this.setMultiEdgeCollapsed(!expLinks);
    }

    void computeNodeSize(boolean positionAlso) {
        int th;
        int lw;
        Rectangle rect;
        double t;
        double l;
        double sy;
        double sx;
        double y;
        double x;
        int n;
        block29: {
            n = 0;
            int mapWidth = this.getWindow().getGraphComponent().getWidth() - 10;
            int mapHeight = this.getWindow().getGraphComponent().getHeight() - 10;
            n = (this.nodes() != null ? this.nodes().size() : 0) + (this.graphs() != null ? this.graphs().size() : 0) * 5;
            try {
                Switch[] switches;
                Fabric f = this.getFabric();
                if (f != null && (switches = f.getSwitches()) != null) {
                    n += switches.length;
                }
            }
            catch (Exception ex1) {
                _Logger.warn((Object)ex1.getMessage(), (Throwable)ex1);
            }
            x = 0.0;
            y = 0.0;
            sx = 1.0;
            sy = 1.0;
            l = 10000.0;
            double r = -10000.0;
            double b = -10000.0;
            t = 10000.0;
            Transform ident = new Transform();
            rect = null;
            lw = 0;
            int rw = 0;
            th = 0;
            int bh = 0;
            this._maxNodeWidth = 8;
            for (TopologyNode node : this.nodes()) {
                node.setUserObject(null);
                if (!node.isVisible()) {
                    --n;
                    continue;
                }
                rect = null;
                x = node.getIconCenterX();
                y = node.getIconCenterY();
                if (x <= 0.0 && y <= 0.0) continue;
                if (x < l) {
                    l = x;
                    if (rect == null) {
                        rect = node.getPaintBounds(ident, rect);
                    }
                    lw = (int)rect.getWidth();
                }
                if (x > r) {
                    r = x;
                    if (rect == null) {
                        rect = node.getPaintBounds(ident, rect);
                    }
                    rw = (int)rect.getWidth();
                }
                if (y < t) {
                    t = y;
                    if (rect == null) {
                        rect = node.getPaintBounds(ident, rect);
                    }
                    th = (int)rect.getHeight();
                }
                if (y > b) {
                    b = y;
                    if (rect == null) {
                        rect = node.getPaintBounds(ident, rect);
                    }
                    bh = (int)rect.getHeight();
                }
                try {
                    TopologyNodePainter np = (TopologyNodePainter)node.getPainter();
                    if (np.getImageWidth() <= this._maxNodeWidth) continue;
                    this._maxNodeWidth = np.getImageWidth();
                }
                catch (Exception e) {}
            }
            if (n != 0) {
                n = mapWidth * mapHeight / 130 / n;
            }
            if (n > 32) {
                n = 32;
            } else if (n < 8) {
                n = 8;
            }
            x = r - l;
            y = b - t;
            int ins = Math.min(80, mapWidth / 10);
            if (lw > ins) {
                lw = ins;
            }
            if (rw > ins) {
                rw = ins;
            }
            if (th > ins) {
                th = ins;
            }
            if (bh > ins) {
                bh = ins;
            }
            sx = (double)(mapWidth - lw / 2 - rw / 2) / x;
            sx = (double)((int)(1000.0 * sx)) / 1000.0;
            sy = (double)(mapHeight - th / 2 - bh / 2) / y;
            sy = (double)((int)(1000.0 * sy)) / 1000.0;
            try {
                int fs = 11;
                if (n < 32) {
                    fs = (n + 3) / 5 + 4;
                }
                Font font = new Font("sans-serif", 0, fs);
                NodePalette.INSTANCE.setFont(font);
                NodeLabelPalette.INSTANCE.setFont(font);
            }
            catch (Exception e) {
                if (!_Logger.isTraceEnabled()) break block29;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        if (rect == null) {
            rect = new Rectangle(0, 0, 0, 0);
        } else {
            rect.setRect(0.0, 0.0, 0.0, 0.0);
        }
        this._nodeSize = n;
        for (MapNode node : this.nodes()) {
            x = (double)(lw / 2) + (node.getIconCenterX() - l) * sx;
            y = (double)(th / 2) + (node.getIconCenterY() - t) * sy;
            this.setNodeSize(node);
            if (!positionAlso) continue;
            node.setIconCenter((double)((int)x) + rect.getWidth() / 2.0, (double)((int)y) + rect.getHeight() / 2.0);
        }
    }

    void setNodeSize(MapNode node) {
        int n = this._nodeSize;
        try {
            TopologyNodePainter np = (TopologyNodePainter)node.getPainter();
            int nn = (n + 1) * np.getImageWidth() / this._maxNodeWidth;
            if (nn == 0) {
                nn = n * 3 / 4;
            } else if (nn < 8) {
                nn = 8;
            }
            node.setIconSize(nn, nn);
        }
        catch (Exception e) {
            node.setIconSize(n * 3 / 4, n * 3 / 4);
        }
    }

    public void setProperties(MapNode node, String prop, boolean expand, boolean override, long defaultFilter) {
        if (node == null) {
            return;
        }
        if (prop == null) {
            node.setIconCenter(0.0, 0.0);
            node.setLocationFixed(false);
            node.setExpanded(expand);
            node.setFilter(defaultFilter);
            this.setNodeSize(node);
            return;
        }
        StringTokenizer st = new StringTokenizer(prop, SEPARATOR_STRING);
        String x = st.hasMoreTokens() ? st.nextToken().trim() : null;
        String y = st.hasMoreTokens() ? st.nextToken().trim() : null;
        String fixed = st.hasMoreTokens() ? st.nextToken().trim() : null;
        String expanded = st.hasMoreTokens() ? st.nextToken().trim() : null;
        String expandLinks = EMPTY_STRING;
        if (st.countTokens() >= 4) {
            expandLinks = st.hasMoreTokens() ? st.nextToken().trim() : null;
        }
        String filters = st.hasMoreTokens() ? st.nextToken().trim() : null;
        String[] splitString = prop.split(SEPARATOR_STRING);
        if (x != null && y != null) {
            try {
                node.setIconCenter(Integer.parseInt(x), Integer.parseInt(y));
            }
            catch (Exception ex) {
                node.setIconCenter(0.0, 0.0);
            }
        } else {
            node.setIconCenter(0.0, 0.0);
        }
        this.setNodeSize(node);
        if (fixed != null && fixed.equals("true")) {
            node.setLocationFixed(true);
        } else {
            node.setLocationFixed(false);
        }
        if (override && expanded != null && expanded.length() > 0) {
            if (expanded.equals("true")) {
                node.setExpanded(true);
            } else {
                node.setExpanded(false);
            }
        } else {
            node.setExpanded(expand);
        }
        try {
            node.setFilter(defaultFilter);
            if (node instanceof SwitchNode && filters != null) {
                node.setFilter(Long.parseLong(filters));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (override && expandLinks != null && expandLinks.length() > 0) {
            if (expandLinks.equals("true")) {
                if (this.isMultiEdgeCollapsed()) {
                    node.setLinksExpanded(true);
                }
            } else if (!this.isMultiEdgeCollapsed()) {
                node.setLinksExpanded(false);
            }
        }
    }

    private void loadOld(File f) {
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            in.readLine();
            this.loadCoordinates(this._window.getGraphComponent().getTransform(), in);
        }
        catch (IOException ex) {
            _Logger.error((Object)("topology> io error loading saved file, " + ex.getMessage()));
        }
    }

    public static MapNode getSwitchNode(MapNode node, MapLink l) {
        return (MapNode)SmMap.getSwitchNode((TopologyNode)node, (TopologyLink)l);
    }

    public static TopologyNode getSwitchNode(TopologyNode node, TopologyLink l) {
        if (node == null || l == null) {
            return null;
        }
        TopologyNode other = null;
        TopologyNode n = null;
        other = (TopologyNode)l.getSourceNode();
        if (other == node) {
            other = (TopologyNode)l.getTargetNode();
        }
        if (other instanceof LoopNode) {
            TopologyLink li;
            Iterator itr1 = other.inedges();
            while (itr1.hasNext()) {
                li = (TopologyLink)itr1.next();
                if (li == l || (n = SmMap.getSwitchNode(other, li)) == null) continue;
                return n;
            }
            Iterator itr2 = other.outedges();
            while (itr2.hasNext()) {
                li = (TopologyLink)itr2.next();
                if (li == l || (n = SmMap.getSwitchNode(other, li)) == null) continue;
                return n;
            }
        } else if (other instanceof SwitchNode) {
            return other;
        }
        return null;
    }

    public static ArrayList getSwitchNodes(TopologyNode node) {
        return SmMap.getSwitchNodes(node, null);
    }

    public static ArrayList getSwitchNodes(TopologyNode node, ArrayList list) {
        TopologyLink l;
        if (list == null) {
            list = new HashedArrayList<TopologyNode>();
        }
        TopologyNode n = null;
        Iterator itr1 = node.inedges();
        while (itr1.hasNext()) {
            l = (TopologyLink)itr1.next();
            n = SmMap.getSwitchNode(node, l);
            if (n == null || ((ArrayList)list).contains(n)) continue;
            ((ArrayList)list).add(n);
        }
        Iterator itr2 = node.outedges();
        while (itr2.hasNext()) {
            l = (TopologyLink)itr2.next();
            n = SmMap.getSwitchNode(node, l);
            if (n == null || ((ArrayList)list).contains(n)) continue;
            ((ArrayList)list).add(n);
        }
        return list;
    }

    public static boolean hasEndNodeNeighbors(TopologyNode node) {
        ArrayList list = node.getNeighbors(null);
        for (int i = 0; i < list.size(); ++i) {
            TopologyNode n = (TopologyNode)list.get(i);
            if (n instanceof SwitchNode) continue;
            return true;
        }
        return false;
    }

    public static void RepaintAll() {
        SmMap[] maps = MapFactory.getMaps();
        if (maps != null && maps.length > 0) {
            for (int i = 0; i < maps.length; ++i) {
                maps[i].repaint();
            }
        }
        if (SmMap.hasInstance(1)) {
            SmMap.getInstance(1).repaint();
        }
        if (SmMap.hasInstance(2)) {
            SmMap.getInstance(2).repaint();
        }
    }

    public static void ClearAll() {
        block6: {
            try {
                SmMap.getInstance().clearAll();
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) break block6;
                _Logger.trace((Object)"logEmptyCatch - ClearAll 1", (Throwable)ex);
            }
        }
        SmMap[] maps = MapFactory.getMaps();
        if (maps != null && maps.length > 0) {
            for (int i = 0; i < maps.length; ++i) {
                try {
                    maps[i].clearAll();
                    continue;
                }
                catch (Exception ex1) {
                    if (!_Logger.isTraceEnabled()) continue;
                    _Logger.trace((Object)"logEmptyCatch - ClearAll 2", (Throwable)ex1);
                }
            }
        }
    }

    @Override
    public void clearAll() {
        super.clearAll();
        this.updateBounds();
        this.repaint(false);
    }

    public void fabricDiscovered(Fabric fabric) {
        this._fabric = fabric;
        this.setText(this._fabric == null ? "SAN" : fabric.getName());
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SmMap map;
                    String[] layouts;
                    BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                    long lastTime = System.currentTimeMillis();
                    4 v0 = this;
                    boolean layoutNew = v0.SmMap.this.isLayoutNewDevices();
                    if (layoutNew) {
                        SmMap.setLayoutNewDevices(false);
                    }
                    if (SmMap.this.isDataCenterMap()) {
                        SmMap.this.setText("DataCenter");
                        DataCenterMapFactory.getInstance().populateGraph(SmMap.this);
                        DataCenter.getInstance().addPropertyChangeListener(new DataCenterMapPropertyChangeListner(SmMap.this));
                    } else if (SmMap.this.isLanMap()) {
                        SmMap.this.setText("LAN");
                        LanMapFactory.getInstance().populateGraph(SmMap.this);
                        Lan.getInstance().addPropertyChangeListener(new LanMapPropertyChangeListner(SmMap.this));
                    } else {
                        MapFactory.getInstance().populateGraph(SmMap.this._fabric, SmMap.this);
                    }
                    if (layoutNew) {
                        SmMap.setLayoutNewDevices(layoutNew);
                    }
                    if (_Logger.isInfoEnabled()) {
                        _Logger.info((Object)("time to populateGraph " + (System.currentTimeMillis() - lastTime) + " millisecs " + SmMap.this.getText()));
                    }
                    if (SmMap.this._fabric != null && !SmMap.this.isDataCenterMap()) {
                        if (SmMap.this._mapListener == null) {
                            SmMap.this._mapListener = new SmMapPropertyChangeListner(SmMap.this);
                        }
                        SmMap.this._fabric.addPropertyChangeListener(SmMap.this._mapListener);
                    } else if (_AllSanMapListener == null) {
                        _AllSanMapListener = new SmMapPropertyChangeListner(SmMap.getInstance());
                        San.getInstance().addPropertyChangeListener(_AllSanMapListener);
                    }
                    if (SmMap.this._fabric != null && (layouts = ClientController.getInstance().getLayouts((FabricPK)SmMap.this._fabric.getPK())) != null && layouts.length > 0) {
                        for (int k = 0; k < layouts.length; ++k) {
                            ViewLayoutProperties.put(layouts[k], new ViewLayoutProperties(layouts[k], SmMap.this.isCollapseLoops(), SmMap.this.isMultiEdgeCollapsed(), SmMap.isDisplayEndDevices(), SmMap.isOverridePreferences(), SmMap.this.isDisplayISCSI(), SmMap.isClassDisplayTargets(), SmMap.isClassDisplayInitiators(), SmMap.isClassDisplayNpvSwitches()));
                        }
                    }
                    if ((map = SmMap.this)._savedLayoutProperties == null || map._savedLayoutProperties.size() < 2 || SmMap.this.foundMultipleNodesAtOrigin()) {
                        if (map.nodes() != null && map.nodes().size() > SmMap.getMapNodeLimit()) {
                            lastTime = System.currentTimeMillis();
                            ShowEndDevicesMapAction.hideEndNodes(map);
                            if (_Logger.isInfoEnabled()) {
                                _Logger.info((Object)("time to hideEndNodes " + (System.currentTimeMillis() - lastTime) + " millisecs " + SmMap.this.getText()));
                            }
                        }
                        lastTime = System.currentTimeMillis();
                        map.relayout(true);
                        if (_Logger.isInfoEnabled()) {
                            _Logger.info((Object)("time to relayout " + (System.currentTimeMillis() - lastTime) + " millisecs " + SmMap.this.getText()));
                        }
                    } else {
                        lastTime = System.currentTimeMillis();
                        SmMap.this.computeNodeSize(true);
                        if (_Logger.isInfoEnabled()) {
                            _Logger.info((Object)("time to computeNodeSize " + (System.currentTimeMillis() - lastTime) + " millisecs " + SmMap.this.getText()));
                        }
                        lastTime = System.currentTimeMillis();
                        SmMap.this.updateBounds();
                        if (_Logger.isInfoEnabled()) {
                            _Logger.info((Object)("time to updateBounds " + (System.currentTimeMillis() - lastTime) + " millisecs " + SmMap.this.getText()));
                        }
                        lastTime = System.currentTimeMillis();
                        SmMap.this.compactBounds();
                        if (_Logger.isInfoEnabled()) {
                            _Logger.info((Object)("time to compactBounds " + (System.currentTimeMillis() - lastTime) + " millisecs " + SmMap.this.getText()));
                        }
                        lastTime = System.currentTimeMillis();
                        map.repaint(true);
                        if (_Logger.isInfoEnabled()) {
                            _Logger.info((Object)("time to repaint " + (System.currentTimeMillis() - lastTime) + " millisecs " + SmMap.this.getText()));
                        }
                    }
                    SmMap.this.setReadyForEvents();
                    SmMap.this.setReadyForContext(true);
                }
                finally {
                    BrowserFrame.getInstance().setCursor(null);
                }
            }
        });
    }

    protected boolean foundMultipleNodesAtOrigin() {
        SmMap map = this;
        if (!(map.isLanMap() || map.isDataCenterMap() || map.isSanMap())) {
            return false;
        }
        HashedArrayList<TopologyNode> visibleNodesAtOrigin = new HashedArrayList<TopologyNode>();
        for (TopologyNode node : this.nodes()) {
            if (node == null || !node.isVisible() || node.getX() > 64 || node.getY() > 64) continue;
            ((ArrayList)visibleNodesAtOrigin).add(node);
            if (!_Logger.isInfoEnabled()) continue;
            _Logger.info((Object)("foundMultipleNodesAtOrigin  map=" + map.getName() + "  node=" + node.getName()));
        }
        return visibleNodesAtOrigin.size() > 1;
    }

    protected boolean hasVisibleNodesAtOrigin() {
        return false;
    }

    MapNode addSwitchNode(MapNode n) {
        double sf;
        block8: {
            AbstractSwitch sw = (AbstractSwitch)((SwitchNode)n).getModel();
            this.addNode(n);
            this.loadCoordinates(n, WwnDictionary.isEnabled());
            if (this.isVsanFilter()) {
                Vsan vsan = this._fabric.getVsansByPK((VsanPK)this._filter);
                if (vsan != null && !sw.isMemberOfVsan(vsan)) {
                    n.setDimmed(true);
                }
            } else if (this.isGroupFilter()) {
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup g = UserDefinedGroupManager.getGroup((GroupPK)this._filter);
                if (g != null && !g.exists(sw)) {
                    n.setDimmed(true);
                }
            }
            sf = 1.0;
            try {
                sf = Math.abs(Math.min(this.getGraphComponent().getTransform().getScaleX(), this.getGraphComponent().getTransform().getScaleY()));
            }
            catch (Exception ex1) {
                if (!_Logger.isTraceEnabled()) break block8;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex1);
            }
        }
        for (MapNode n1 : this.nodes()) {
            if (!(n1 instanceof SwitchNode) || !n1.isVisible()) continue;
            n.setIconSize(n1.getIconWidth() * sf, n1.getIconHeight() * sf);
            this.setNodeSize(n);
            break;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    MapNode addSwitch(EthSwitch sw) {
        MapNode n;
        if (sw == null) {
            return null;
        }
        if (this.isDataCenterMap()) {
            n = DataCenterMapFactory.getInstance().getNode(sw);
            if (n == null) {
                n = DataCenterMapFactory.getInstance().createNode(sw);
                this.addNode(n);
                this.loadCoordinates(n, WwnDictionary.isEnabled());
                return this.addSwitchNode(n);
            }
            n.update();
            return n;
        }
        if (!this.isLanMap()) return null;
        n = LanMapFactory.getInstance().getNode(sw);
        if (n == null) {
            n = LanMapFactory.getInstance().createNode(sw);
            this.addNode(n);
            this.loadCoordinates(n, WwnDictionary.isEnabled());
            return this.addSwitchNode(n);
        }
        n.update();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    MapNode addSwitch(Switch sw) {
        MapNode n;
        if (sw == null) return null;
        if (!this.isDataCenterMap()) {
            if (this._fabric == null) return null;
            if (!sw.getFabric().equals(this._fabric)) {
                return null;
            }
        }
        if (this.isDataCenterMap()) {
            n = DataCenterMapFactory.getInstance().getNode(sw);
            if (n == null) {
                n = DataCenterMapFactory.getInstance().createNode(sw);
                this.addNode(n);
                this.loadCoordinates(n, WwnDictionary.isEnabled());
                return this.addSwitchNode(n);
            }
            n.update();
            return n;
        }
        n = MapFactory.getInstance().getNode(sw);
        if (n == null) {
            n = MapFactory.getInstance().createNode(this._fabric, sw);
            this.addNode(n);
            this.loadCoordinates(n, WwnDictionary.isEnabled());
            return this.addSwitchNode(n);
        }
        n.update();
        return n;
    }

    private void setReadyForEvents() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventDispatcher.setClientInited(true);
            }
        });
    }

    MapLink addIsl(Isl isl) {
        if (isl == null || !this.isDataCenterMap() && (this._fabric == null || !isl.getFabric().equals(this._fabric))) {
            return null;
        }
        MapLink l = this.getLink(isl);
        if (l != null) {
            l.update();
            return l;
        }
        if (this.isDataCenterMap()) {
            l = DataCenterMapFactory.getInstance().createLink(isl);
            this.addLink(l);
        } else {
            l = MapFactory.getInstance().createLink(this._fabric, isl);
            this.addLink(l);
        }
        if (this.isVsanFilter()) {
            Vsan vsan = this._fabric.getVsansByPK((VsanPK)this._filter);
            if (vsan != null && !isl.isMemberOfVsan(vsan)) {
                l.setDimmed(true);
            }
        } else if (this.isGroupFilter()) {
            UserDefinedGroupManager.getInstance();
            UserDefinedGroup g = UserDefinedGroupManager.getGroup((GroupPK)this._filter);
            if (g != null && !g.exists(isl.getSwitch1()) && !g.exists(isl.getSwitch2())) {
                l.setDimmed(true);
            }
        }
        if (l != null) {
            MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
        }
        return l;
    }

    MapLink addIsl(EthIsl isl) {
        if (isl == null) {
            return null;
        }
        MapLink l = this.getLink(isl);
        if (l != null) {
            l.update();
            return l;
        }
        if (this.isDataCenterMap()) {
            l = DataCenterMapFactory.getInstance().createLink(isl);
            this.addLink(l);
        } else if (this.isLanMap()) {
            l = LanMapFactory.getInstance().createLink(isl);
            this.addLink(l);
        } else {
            return null;
        }
        if (l != null) {
            MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
        }
        return l;
    }

    MapLink addNpvLink(NpvLink npvLink) {
        if (npvLink == null || !this.isDataCenterMap() && (this._fabric == null || !npvLink.getFabric().equals(this._fabric))) {
            return null;
        }
        MapLink l = this.getLink(npvLink);
        if (l != null) {
            l.update();
            return l;
        }
        if (this.isDataCenterMap()) {
            l = DataCenterMapFactory.getInstance().createLink(npvLink);
            this.addLink(l);
        } else {
            l = MapFactory.getInstance().createLink(this._fabric, npvLink);
            this.addLink(l);
        }
        if (this.isVsanFilter()) {
            Vsan vsan = this._fabric.getVsansByPK((VsanPK)this._filter);
            if (vsan != null && !npvLink.isMemberOfVsan(vsan)) {
                l.setDimmed(true);
            }
        } else if (this.isGroupFilter()) {
            UserDefinedGroupManager.getInstance();
            UserDefinedGroup g = UserDefinedGroupManager.getGroup((GroupPK)this._filter);
            if (g != null && !g.exists(npvLink.getCoreSwitch()) && !g.exists(npvLink.getEdgeSwitch())) {
                l.setDimmed(true);
            }
        }
        if (l != null) {
            MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
        }
        return l;
    }

    MapNode addEndPort(EndPort ep) {
        MapLink l;
        Vsan vsan;
        MapNode n;
        block40: {
            MapNode n12;
            UserDefinedGroup group;
            block39: {
                Enclosure enclosure;
                if (ep == null || ep.getSwitch() == null || this._fabric == null || !ep.getFabric().equals(this._fabric)) {
                    return null;
                }
                n = MapFactory.getInstance().getNode(ep);
                boolean wwnenabled = WwnDictionary.isEnabled();
                double sf = 1.0;
                vsan = null;
                group = null;
                if (this.isVsanFilter()) {
                    vsan = this._fabric.getVsansByPK((VsanPK)this._filter);
                } else if (this.isGroupFilter()) {
                    UserDefinedGroupManager.getInstance();
                    group = UserDefinedGroupManager.getGroup((GroupPK)this._filter);
                }
                if (n == null) {
                    block38: {
                        try {
                            sf = Math.abs(Math.min(this.getGraphComponent().getTransform().getScaleX(), this.getGraphComponent().getTransform().getScaleY()));
                        }
                        catch (Exception ex1) {
                            if (!_Logger.isTraceEnabled()) break block38;
                            _Logger.trace((Object)"logEmptyCatch - addEndPort 1", (Throwable)ex1);
                        }
                    }
                    try {
                        n = MapFactory.getInstance().createNode(this._fabric, ep);
                        if (n == null) {
                            return null;
                        }
                        this.addNode(n);
                        this.loadEndPortCoordinates(n, ep, wwnenabled);
                        enclosure = ep.getEnclosure();
                        if (vsan != null && (enclosure == null ? !ep.isMemberOfVsan(vsan) : !enclosure.isMemberOfVsan(vsan))) {
                            n.setDimmed(true);
                        } else if (group != null && !group.exists(ep.getSwitch()) && (enclosure == null ? !ep.isMemberOfGroup(group) : !enclosure.isMemberOfGroup(group))) {
                            n.setDimmed(true);
                        }
                        for (MapNode n12 : this.nodes()) {
                            if (!(n12 instanceof PlatformNode) || !n12.isVisible()) continue;
                            n.setIconSize(n12.getIconWidth() * sf, n12.getIconHeight() * sf);
                            this.setNodeSize(n);
                        }
                        break block39;
                    }
                    catch (Exception ex) {
                        if (_Logger.isTraceEnabled()) {
                            _Logger.trace((Object)"logEmptyCatch - addEndPort 2", (Throwable)ex);
                        }
                        break block39;
                    }
                }
                enclosure = ep.getEnclosure();
                if (vsan != null && (enclosure == null ? !ep.isMemberOfVsan(vsan) : !enclosure.isMemberOfVsan(vsan))) {
                    n.setDimmed(true);
                } else if (group != null && !group.exists(ep.getSwitch()) && (enclosure == null ? !ep.isMemberOfGroup(group) : !enclosure.isMemberOfGroup(group))) {
                    n.setDimmed(true);
                } else {
                    n.setDimmed(false);
                }
                n.update();
            }
            if (ep.getHub() != null) {
                try {
                    n12 = MapFactory.getInstance().getNode(ep.getHub());
                    if (n12 == null) {
                        n12 = MapFactory.getInstance().createNode(this._fabric, ep.getHub());
                        this.addNode(n12);
                        this.loadCoordinates(n12, WwnDictionary.isEnabled());
                    } else {
                        n12.update();
                    }
                    MapLink ll = this.getLink(ep.getHub());
                    if (vsan != null && !ep.getHub().isMemberOfVsan(vsan)) {
                        n12.setDimmed(true);
                        if (ll != null) {
                            ll.setDimmed(true);
                        }
                    } else if (group != null && !group.exists(ep.getSwitch()) && !ep.getHub().isMemberOfGroup(group)) {
                        n.setDimmed(true);
                        if (ll != null) {
                            ll.setDimmed(true);
                        }
                    } else {
                        n12.setDimmed(false);
                        if (ll != null) {
                            ll.setDimmed(false);
                        }
                    }
                    break block40;
                }
                catch (Exception e) {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)"logEmptyCatch - addEndPort 3", (Throwable)e);
                    }
                    break block40;
                }
            }
            if (n != null && !n.isVisible() && (n12 = MapFactory.getInstance().getNode(ep.getSwitch())) != null && n12.isExpanded() && n12.isVisible()) {
                ArrayList list = ((SwitchNode)n12).getVisibleEndNodes(null);
                if (list != null && list.size() > 0) {
                    n.setVisible(true);
                } else {
                    n12.setExpanded(false);
                }
            }
        }
        if ((l = this.getLink(ep, true)) != null) {
            this.removeLink(l);
        }
        l = MapFactory.getInstance().createLink(this._fabric, ep);
        this.addLink(l);
        if (vsan != null && !ep.isMemberOfVsan(vsan)) {
            l.setDimmed(true);
        }
        if (l.hasDummyLink()) {
            MultipleLinkHandler.getInstance().handle(l.getSourceNode(), l.getTargetNode());
        }
        return n;
    }

    private boolean loadCoordinates(MapNode n, boolean wwnenabled) {
        block6: {
            if (this._savedLayoutProperties != null) {
                try {
                    AbstractModelObject obj = (AbstractModelObject)n.getModel();
                    if (wwnenabled) {
                        WwnDictionary.setEnabled(false);
                    }
                    String key = obj.getPK().toString();
                    key = (String)this._savedLayoutProperties.get(key);
                    this.setProperties(n, key, true, true, -1L);
                    if (wwnenabled) {
                        WwnDictionary.setEnabled(true);
                    }
                    if (key != null && key.length() > 0) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) break block6;
                    _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                }
            }
        }
        return false;
    }

    private boolean loadEndPortCoordinates(MapNode n, EndPort ep, boolean wwnenabled) {
        block9: {
            if (this._savedLayoutProperties != null) {
                try {
                    ArrayList<EndPort> eps;
                    Enclosure enclosure;
                    String key;
                    if (wwnenabled) {
                        WwnDictionary.setEnabled(false);
                    }
                    String string = key = (enclosure = ep.getEnclosure()) == null ? (String)this._savedLayoutProperties.get(ep.getPK().toString()) : (String)this._savedLayoutProperties.get(enclosure.getPK().toString());
                    if (key == null && enclosure != null && (eps = enclosure.getMembers()) != null && eps.size() > 0) {
                        for (int j = 0; j < eps.size(); ++j) {
                            EndPort e = eps.get(j);
                            key = (String)this._savedLayoutProperties.get(e.getPK().toString());
                            if (key == null || key.length() == 0) {
                                key = (String)this._savedLayoutProperties.get(e.getNodeWwn().toString());
                            }
                            if (key != null && key.length() > 0) break;
                        }
                    }
                    this.setProperties(n, key, true, true, -1L);
                    if (wwnenabled) {
                        WwnDictionary.setEnabled(true);
                    }
                    if (key != null && key.length() > 0) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) break block9;
                    _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                }
            }
        }
        return false;
    }

    public void updateEnclsoures(EndPort ep, Enclosure oldEnclosure) {
        boolean wwnenabled;
        double y;
        double x;
        MapNode n;
        block40: {
            n = null;
            x = 0.0;
            y = 0.0;
            boolean remove = false;
            wwnenabled = WwnDictionary.isEnabled();
            if (oldEnclosure != null) {
                n = this.getEnclosureNode(oldEnclosure);
                if (oldEnclosure.getMemberCount() == 0) {
                    x = n == null ? 0.0 : n.getCenterX();
                    y = n == null ? 0.0 : n.getCenterY();
                    remove = true;
                    if (ep != null && ep.getFabric() != null && ep.getFabric().getSan() != null) {
                        ep.getFabric().getSan().removeEnclosure(oldEnclosure.getPK());
                    }
                } else {
                    n = null;
                }
                MapLink l = this.getLink(ep, true);
                try {
                    if (l != null) {
                        this.removeLink(l);
                    }
                }
                catch (Exception ex1) {
                    _Logger.warn((Object)ex1.getMessage(), (Throwable)ex1);
                }
                try {
                    if (n != null && remove) {
                        this.removeNode(n);
                        this._enclosureNodes.remove(oldEnclosure.getEnclosureName());
                    }
                    break block40;
                }
                catch (Exception ex) {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)"logEmptyCatch - remove node 1", (Throwable)ex);
                    }
                    break block40;
                }
            }
            n = (MapNode)ep.getUserObject();
            x = n == null ? 0.0 : n.getCenterX();
            y = n == null ? 0.0 : n.getCenterY();
            ep.setUserObject(null);
            MapLink l = this.getLink(ep, true);
            if (l != null) {
                try {
                    this.removeLink(l);
                }
                catch (Exception ex2) {
                    _Logger.warn((Object)ex2.getMessage(), (Throwable)ex2);
                }
            }
            if (n != null) {
                try {
                    this.removeNode(n);
                }
                catch (Exception ex3) {
                    if (!_Logger.isTraceEnabled()) break block40;
                    _Logger.trace((Object)"logEmptyCatch - remove node 2", (Throwable)ex3);
                }
            }
        }
        Vsan vsan = null;
        UserDefinedGroup group = null;
        if (this.isVsanFilter()) {
            vsan = this._fabric.getVsansByPK((VsanPK)this._filter);
        } else if (this.isGroupFilter()) {
            UserDefinedGroupManager.getInstance();
            group = UserDefinedGroupManager.getGroup((GroupPK)this._filter);
        }
        Enclosure enclosure = ep.getEnclosure();
        if (enclosure != null && (n = this.getEnclosureNode(enclosure)) != null) {
            MapLink l2 = this.getLink(ep, true);
            if (l2 == null) {
                l2 = this.addLink(MapFactory.getInstance().createLink(ep.getFabric(), ep));
                if (vsan != null && !ep.isMemberOfVsan(vsan)) {
                    l2.setDimmed(true);
                } else if (group != null && !group.exists(ep.getSwitchNoAdd()) && !ep.isMemberOfGroup(group)) {
                    l2.setDimmed(true);
                }
                if (l2.hasDummyLink()) {
                    MultipleLinkHandler.getInstance().handle(l2.getSourceNode(), l2.getTargetNode());
                }
                if (vsan != null && enclosure != null) {
                    if (enclosure.isMemberOfVsan(vsan)) {
                        n.setDimmed(false);
                    } else {
                        n.setDimmed(true);
                    }
                }
            }
            n.update();
            return;
        }
        if (ep.getSwitchNoAdd() != null) {
            n = MapFactory.getInstance().createNode(ep.getFabric(), ep);
        }
        if (n == null) {
            return;
        }
        if (this.loadEndPortCoordinates(n, ep, wwnenabled)) {
            x = 0.0;
            y = 0.0;
        }
        if (n.getParent() == null) {
            this.addNode(n);
        }
        MapLink l2 = this.addLink(MapFactory.getInstance().createLink(ep.getFabric(), ep));
        if (vsan != null && (enclosure == null ? !ep.isMemberOfVsan(vsan) : !enclosure.isMemberOfVsan(vsan))) {
            n.setDimmed(true);
        } else if (group != null && !group.exists(ep.getSwitchNoAdd()) && (enclosure == null ? !ep.isMemberOfGroup(group) : !enclosure.isMemberOfGroup(group))) {
            n.setDimmed(true);
        } else {
            n.setDimmed(false);
        }
        if (vsan != null && !ep.isMemberOfVsan(vsan)) {
            l2.setDimmed(true);
        }
        if (x != 0.0 || y != 0.0) {
            n.setIconCenter(x, y);
            this.setNodeSize(n);
        }
        n.update();
        if (l2.hasDummyLink()) {
            MultipleLinkHandler.getInstance().handle(l2.getSourceNode(), l2.getTargetNode());
        }
    }

    public static boolean isClassDisplayISCSI() {
        return _ClassDisplayISCSI;
    }

    public static void setClassDisplayISCSI(boolean d) {
        _ClassDisplayISCSI = d;
    }

    public static boolean isClassDisplayTargets() {
        return _ClassDisplayTargets;
    }

    public static void setClassDisplayTargets(boolean d) {
        _ClassDisplayTargets = d;
    }

    public static boolean isClassDisplayInitiators() {
        return _ClassDisplayInitiators;
    }

    public static void setClassDisplayInitiators(boolean d) {
        _ClassDisplayInitiators = d;
    }

    public static boolean isClassUseKubrickIcons() {
        return _ClassUseKubrickIcons;
    }

    public static void setClassUseKubrickIcons(boolean u, boolean doRepaint) {
        _ClassUseKubrickIcons = u;
        if (!doRepaint) {
            return;
        }
        SmMap[] maps = MapFactory.getMaps();
        if (maps != null && maps.length > 0) {
            for (int i = 0; i < maps.length; ++i) {
                maps[i].repaint();
            }
        }
    }

    public static boolean isDisplayEndDevices() {
        return _ClassDisplayEndDevices;
    }

    public static void setDisplayEndDevices(boolean d) {
        _ClassDisplayEndDevices = d;
    }

    public static void setDisplayMinorAlarmsOnLinks(boolean showMinorAlarmsOnLinks, boolean doRepaint) {
        _ClassShowMinorAlarmsOnLinks = TopologyLink._showMinorAlarmsOnLinks = showMinorAlarmsOnLinks;
        if (!doRepaint) {
            return;
        }
        SmMap[] maps = MapFactory.getMaps();
        if (maps != null && maps.length > 0) {
            for (int i = 0; i < maps.length; ++i) {
                maps[i].repaint();
            }
        }
        if (_DataCenterMap != null) {
            _DataCenterMap.repaint();
        }
        if (_LanMap != null) {
            _LanMap.repaint();
        }
    }

    public static boolean isDisplayMinorAlarmsOnLinks() {
        return _ClassShowMinorAlarmsOnLinks;
    }

    public static boolean isDisplayNodeLabels() {
        return _ClassDisplayNodeLabels;
    }

    public static void setDisplayNodeLabels(boolean d) {
        _ClassDisplayNodeLabels = d;
    }

    public static boolean isOverridePreferences() {
        return _IsOverridePreferences;
    }

    public static void setOverridePreferences(boolean pref) {
        _IsOverridePreferences = pref;
    }

    public static boolean isAutoSaveLayout() {
        return _IsAutoSaveLayout;
    }

    public static void setAutoSaveLayout(boolean pref) {
        _IsAutoSaveLayout = pref;
    }

    public boolean isDisplayNpvSwitches() {
        return this._displayNpvSwitches;
    }

    public void setDisplayNpvSwitches(boolean displayNpvSwitches) {
        this._displayNpvSwitches = displayNpvSwitches;
    }

    public boolean isCollapseLoops() {
        return this._collapseLoops;
    }

    public void setCollapseLoops(boolean collapseLoops) {
        this._collapseLoops = collapseLoops;
    }

    public boolean isDisplayISCSI() {
        return this._displayISCSI;
    }

    public void setDisplayISCSI(boolean displayISCSI) {
        this._displayISCSI = displayISCSI;
    }

    public boolean isDisplayTargets() {
        return this._displayTargets;
    }

    public void setDisplayTargets(boolean displayTargets) {
        this._displayTargets = displayTargets;
    }

    public boolean isDisplayInitiators() {
        return this._displayInitiators;
    }

    public void setDisplayInitiators(boolean displayInitiators) {
        this._displayInitiators = displayInitiators;
    }

    @Override
    public boolean supportAutoScaling() {
        return !SmMap.isClassUseKubrickIcons();
    }

    public void setSelectedVsanID(int vsanID) {
        this._selectedVsanID = vsanID;
        for (MapNode n : this._nodes.values()) {
            if (n == null || !(n instanceof SwitchNode)) continue;
            ((SwitchNode)n).update();
        }
    }

    public int getSelectedVsanID() {
        return this._selectedVsanID;
    }

    public static void setDisplayDomainIdAsD(int showDomainIdAs) {
        SwitchNode.setDisplayDomainIdAsD(showDomainIdAs);
        SmMap.getSelectedMap().setSelectedVsanID(SmMap.getSelectedMap()._selectedVsanID);
    }

    public static boolean isClassLoopsCollapsed() {
        return _ClassCollapseLoops;
    }

    public static void setClassLoopsCollapsed(boolean c) {
        _ClassCollapseLoops = c;
    }

    public static boolean isClassMultiLinksCollapsed() {
        return _ClassCollapseMultiLinks;
    }

    public static void setClassMultiLinksCollapsed(boolean c) {
        _ClassCollapseMultiLinks = c;
        if (_SmMap != null) {
            _SmMap.setMultiEdgeCollapsed(c);
        }
        if (_DataCenterMap != null) {
            _DataCenterMap.setMultiEdgeCollapsed(c);
        }
        if (_LanMap != null) {
            _LanMap.setMultiEdgeCollapsed(c);
        }
    }

    public static int getDimNodeDisplayPolicy() {
        return _DimNodeDisplayPolicy;
    }

    public static int getGroupDimNodeDisplayPolicy() {
        return _GroupDimNodeDisplayPolicy;
    }

    public static void setDimNodeDisplayPolicy(int dimPolicy) {
        _DimNodeDisplayPolicy = dimPolicy;
        TopologyNode.setGlobalDimPolicy(dimPolicy);
    }

    public static void setGroupDimNodeDisplayPolicy(int dimPolicy) {
        _GroupDimNodeDisplayPolicy = dimPolicy;
        TopologyNode.setGlobalGroupDimPolicy(dimPolicy);
    }

    public static boolean isLayoutNewDevices() {
        return _LayoutForNewDevices;
    }

    public static void setLayoutNewDevices(boolean c) {
        _LayoutForNewDevices = c;
    }

    public static int getMapNodeLimit() {
        return _MaxNodeLimit;
    }

    public static void setMapNodeLimit(int maxNodeLimit) {
        if (maxNodeLimit < 200 || maxNodeLimit > 300) {
            return;
        }
        _MaxNodeLimit = maxNodeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            block11: {
                TopologyNode.setUseVisibilityCache(true);
                TopologyNode.clearVisibilityCache();
                if (_PreviousMap == this) {
                    _PreviousMap = null;
                }
                super.destroy();
                if (this._fabric != null) {
                    this._fabric.removePropertyChangeListener(this._mapListener);
                }
                this._fabric = null;
                if (this._links != null) {
                    this._links.clear();
                }
                if (this._nodes != null) {
                    this._nodes.clear();
                }
                if (this._enclosureNodes != null) {
                    this._enclosureNodes.clear();
                }
                this._filter = null;
                this._savedLayoutProperties = null;
                if (this._window != null) {
                    try {
                        this._window.destroy();
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) break block11;
                        _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                    }
                }
            }
            this._window = null;
        }
        finally {
            TopologyNode.setUseVisibilityCache(false);
            TopologyNode.clearVisibilityCache();
        }
    }

    public MapNode getEnclosureNode(Enclosure encl) {
        if (encl == null || encl.getEnclosureName() == null) {
            return null;
        }
        return (MapNode)this._enclosureNodes.get(encl.getEnclosureName());
    }

    public static void SaveAll() {
        if (_SmMap != null) {
            _SmMap.save();
        }
        if (_DataCenterMap != null) {
            _DataCenterMap.save();
        }
        if (_LanMap != null) {
            _LanMap.save();
        }
        for (SmMap map : MapFactory._FabricMaps.values()) {
            map.save();
        }
    }

    public static void ClearSelection() {
        _SmMap.clearSelection();
        if (_DataCenterMap != null) {
            _DataCenterMap.clearSelection();
        }
        if (_LanMap != null) {
            _LanMap.clearSelection();
        }
        for (SmMap map : MapFactory._FabricMaps.values()) {
            map.clearSelection();
        }
    }

    public void setContext(ClientContext context) {
        if (context == null) {
            return;
        }
        if (context instanceof SwitchContext) {
            SwitchContext switchContext = (SwitchContext)context;
            _Logger.debug((Object)("SmMap.setContext context.getSwitchArrayList()=" + switchContext.getSwitchArrayList().size()));
            if (switchContext.getSwitchArrayList() != null) {
                SmMap.findSwitchesByIpAddresses(switchContext.getSwitchArrayList());
            }
        } else if (context instanceof ISLContext) {
            ISLContext islContext = (ISLContext)context;
            _Logger.debug((Object)("SmMap.setContext context.getSwitchIntKeys()=" + islContext.getSwitch1ArrayList().size()));
            if (islContext.getSwitch1ArrayList() != null) {
                SmMap.findISLsBySwitchIntKey(islContext.getSwitch1ArrayList(), islContext.getIfName1ArrayList());
            }
        }
    }

    public static void findSwitchesByIpAddresses(ArrayList ipAddresses) {
        SmFindDialog.findSwitchesByIpAddresses(ipAddresses);
    }

    public static void findISLsBySwitchIntKey(ArrayList<String> switch1ArrayList, ArrayList<String> ifName1ArrayList) {
        if (switch1ArrayList == null || switch1ArrayList.size() == 0) {
            return;
        }
        if (ifName1ArrayList == null || ifName1ArrayList.size() == 0) {
            return;
        }
        if (switch1ArrayList.size() != ifName1ArrayList.size()) {
            return;
        }
        Fabric fabric = SmMap.getSelectedMap().getFabric();
        if (fabric == null) {
            return;
        }
        Switch sw = null;
        Isl isl = null;
        MapLink link = null;
        HashedArrayList<MapLink> links = new HashedArrayList<MapLink>();
        for (int i = 0; i < switch1ArrayList.size(); ++i) {
            String switchIP = switch1ArrayList.get(i);
            if (switchIP == null) continue;
            try {
                sw = fabric.findSwitchByIpAddress(InetAddress.getByName(switchIP));
            }
            catch (UnknownHostException e) {
                continue;
            }
            isl = fabric.findIslBySwitchIfIndex(sw, sw.nameToIfIndex(ifName1ArrayList.get(i)));
            link = SmMap.getSelectedMap().getLink(isl);
            if (link == null) continue;
            ((ArrayList)links).add(link);
        }
        if (links != null && links.size() > 0) {
            SelectionAction.getInstance().setObjects(new HashedArrayList(), links);
            SelectionAction.getInstance().execute();
        }
    }

    public void setReadyForContext(boolean readyForContext) {
        this._readyForContext = readyForContext;
        if (readyForContext) {
            _Logger.debug((Object)("setReadyForContext readyForContext=" + readyForContext + " map=" + this.getName()));
        }
    }

    public boolean isReadyForContext() {
        return this._readyForContext;
    }

    public static boolean areAllMapsReadyForContext() {
        _Logger.debug((Object)"areAllMapsReadyForContext  IN");
        if (_SmMap != null && !_SmMap.isReadyForContext()) {
            _Logger.debug((Object)"areAllMapsReadyForContext  NOT SAN");
            return false;
        }
        for (SmMap map : MapFactory._FabricMaps.values()) {
            _Logger.debug((Object)("areAllMapsReadyForContext map=" + map.getName() + " " + map.isReadyForContext()));
            if (map == null || map.isReadyForContext()) continue;
            _Logger.debug((Object)("areAllMapsReadyForContext  NOT " + map.getName()));
            return false;
        }
        _Logger.debug((Object)"areAllMapsReadyForContext OUT readyForContext=true");
        return true;
    }

    public MapFactoryIf getMapFactory() {
        return this._mapFactory;
    }

    public static boolean isClassDisplayNpvSwitches() {
        return _ClassDisplayNpvSwitches;
    }

    public static void setClassDisplayNpvSwitches(boolean display) {
        _ClassDisplayNpvSwitches = display;
    }

    static {
        _ClassDisplayEndDevices = true;
        _ClassDisplayNodeLabels = true;
        _ClassCollapseLoops = true;
        _ClassCollapseMultiLinks = true;
        _ClassUseKubrickIcons = true;
        _MaxNodeLimit = 200;
        _ClassDisplayNpvSwitches = true;
        _ClassDisplayISCSI = false;
        _ClassDisplayTargets = true;
        _ClassDisplayInitiators = true;
        _ClassShowMinorAlarmsOnLinks = true;
        _LayoutForNewDevices = false;
        _IsOverridePreferences = true;
        _IsAutoSaveLayout = true;
        _DimNodeDisplayPolicy = TopologyNode.getGlobalDimPolicy();
        _GroupDimNodeDisplayPolicy = TopologyNode.getGlobalGroupDimPolicy();
        _AllSanMapListener = null;
    }

    class SaveThread
    extends Thread {
        private SmMap map;

        public SaveThread(SmMap map) {
            super("SmMap SaveThread");
            this.map = null;
            this.map = map;
        }

        @Override
        public void run() {
            if (this.map == null) {
                return;
            }
            try {
                this.map.save();
            }
            catch (Exception e) {
                _Logger.debug((Object)("SaveThread: Layout not saved: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

