/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.LoopNode;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ExpandMultipleLinksMapAction
extends MapActionAdapter {
    private static ExpandMultipleLinksMapAction _Instance = null;
    public static Logger _Logger = Logger.getLogger(ExpandMultipleLinksMapAction.class);

    public static ExpandMultipleLinksMapAction getInstance() {
        if (_Instance == null) {
            _Instance = new ExpandMultipleLinksMapAction();
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        long fStart = System.currentTimeMillis();
        try {
            BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            TopologyNode.setUseVisibilityCache(true);
            TopologyNode.clearVisibilityCache();
            boolean expand = false;
            SmMap map = SmMap.getSelectedMap();
            try {
                expand = ((JCheckBoxMenuItem)e.getSource()).getState();
            }
            catch (ClassCastException cce) {
                ArrayList links = map.getSelectedLinks();
                if (links != null && links.size() > 0) {
                    expand = false;
                    for (TopologyLink l : links) {
                        if (!l.hasDummyLink() || !map.getDummyEdge(l).isVisible()) continue;
                        expand = true;
                    }
                }
                ArrayList nodes = map.getSelectedNodes();
                if (nodes != null && nodes.size() > 0) {
                    expand = true;
                    for (TopologyNode n : nodes) {
                        if (!n.isLinksExpanded()) continue;
                        expand = false;
                    }
                }
                expand = true;
                for (TopologyLink l : map.edges()) {
                    if (l.getFromNode() instanceof LoopNode || l.getToNode() instanceof LoopNode || !l.isDummyLink() || !l.getFromNode().isVisible() || !l.getToNode().isVisible() || l.isVisible()) continue;
                    expand = false;
                }
            }
            catch (Exception ex) {
                expand = SmMap.isClassMultiLinksCollapsed();
            }
            this.expandMultipleLinks(expand, true);
            map.repaint(false);
        }
        finally {
            TopologyNode.setUseVisibilityCache(false);
            TopologyNode.clearVisibilityCache();
        }
        long fStop = System.currentTimeMillis();
        StringBuffer result = new StringBuffer();
        result.append(fStop - fStart);
        result.append(" ms");
        _Logger.info((Object)("time in ExpandMultipleLinksMapAction.actionPerformed() method - " + result.toString()));
        BrowserFrame.getInstance().setCursor(null);
    }

    public void expandMultipleLinks(boolean allMaps, boolean expand, boolean doRepaint) {
        if (allMaps) {
            SmMap[] maps;
            SmMap.setClassMultiLinksCollapsed(!expand);
            Object object = maps = allMaps ? MapFactory.getMaps() : null;
            if (maps != null && maps.length > 0) {
                for (int i = 0; i < maps.length; ++i) {
                    this.expandMultipleLinks(maps[i], expand, doRepaint);
                }
            }
        } else {
            this.expandMultipleLinks(expand, doRepaint);
        }
    }

    public void expandMultipleLinks(boolean expand, boolean doRepaint) {
        SmMap map = SmMap.getSelectedMap();
        this.expandMultipleLinks(map, expand, doRepaint);
        SmMap.getSelectedMap().updateLayoutName();
    }

    public void expandMultipleLinks(SmMap map, boolean expand, boolean doRepaint) {
        ArrayList nodes = map.getSelectedNodes();
        Iterator itr = null;
        if (nodes.size() == 0) {
            ArrayList links = map.getSelectedLinks();
            if (links == null || links.size() == 0) {
                itr = map.edges().iterator();
                map.setMultiEdgeCollapsedState(!expand);
            } else {
                itr = links.iterator();
            }
            if (itr.hasNext()) {
                while (itr.hasNext()) {
                    try {
                        TopologyLink l = (TopologyLink)itr.next();
                        if (!l.isDummyLink() && !l.hasDummyLink()) continue;
                        l = map.getDummyEdge(l);
                        if (expand) {
                            map.expandLink(l);
                            continue;
                        }
                        map.collapseLink(l);
                    }
                    catch (Exception ex) {
                        _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                    }
                }
            } else if (!map.isVsanFilter()) {
                map.setMultiEdgeCollapsed(!expand);
            }
            if (doRepaint) {
                map.repaint();
            }
            return;
        }
        itr = nodes.iterator();
        this.expandMultipleLinks(expand, itr, doRepaint);
    }

    public void expandMultipleLinks(boolean expand, Iterator nodes, boolean doRepaint) {
        while (nodes.hasNext()) {
            TopologyNode n = (TopologyNode)nodes.next();
            n.setLinksExpanded(expand);
        }
        if (doRepaint) {
            SmMap.getSelectedMap().repaint();
        }
    }

    @Override
    public void validate(JMenuItem mi, TopologyGraph gragh) {
        SmMap map = SmMap.getSelectedMap();
        ArrayList nodes = map.getSelectedNodes();
        if (nodes.size() == 0) {
            mi.setEnabled(true);
            ((JCheckBoxMenuItem)mi).setState(!map.isMultiEdgeCollapsed());
            return;
        }
        boolean hasMultiEdges = false;
        boolean state = true;
        for (TopologyNode n : nodes) {
            if (!n.hasMultipleLinks()) continue;
            hasMultiEdges = true;
            if (n.isLinksExpanded()) continue;
            state = false;
            break;
        }
        if (!hasMultiEdges) {
            mi.setEnabled(false);
            ((JCheckBoxMenuItem)mi).setState(false);
        } else {
            mi.setEnabled(true);
            ((JCheckBoxMenuItem)mi).setState(state);
        }
    }
}

