/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.client.TopologyWindow;
import com.cisco.dcbu.lib.map.common.ImageMaker;
import com.cisco.dcbu.lib.map.common.MapProperties;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigurationHelper;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fcoe.wizard.FCoEConfigurationWizard;
import com.cisco.dcbu.sm.client.gui.AddFabricDialog;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.ControlPanelFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.map.EthIslMapLink;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapMenus;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmFindDialog;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SmMapFilterDialog;
import com.cisco.dcbu.sm.client.map.SmMapLegendDialog;
import com.cisco.dcbu.sm.client.map.StorageNode;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.VisioExportAdapter;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.portchnl.PChnlActions;
import com.cisco.dcbu.sm.client.portchnl.PChnlWizard;
import com.cisco.dcbu.sm.common.rif.SanException;
import com.cisco.dcbu.sm.common.rif.TopologyRemote;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.GraphPrintJobAttributes;
import com.cisco.nm.esper.action.PrintAction;
import com.cisco.nm.esper.model.palette.GridPalette;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MiscMapActions
extends MapActionAdapter {
    private static MiscMapActions _Instance = null;
    static PrintAction _printAction = null;
    public static Logger _Logger = Logger.getLogger(MiscMapActions.class);

    public static MiscMapActions getInstance() {
        if (_Instance == null) {
            _Instance = new MiscMapActions();
        }
        return _Instance;
    }

    public static boolean isGridEnabled() {
        SmMap map = SmMap.getSelectedMap();
        if (map == null) {
            map = SmMap.getInstance();
        }
        GraphComponent gc = map.getGraphComponent();
        GridPalette palette = gc.getTransform().getGridPalette();
        return palette.isEnabled();
    }

    public static void toggleGrid() {
        GraphComponent gc;
        GridPalette palette;
        SmMap map = SmMap.getSelectedMap();
        if (map == null) {
            map = SmMap.getInstance();
        }
        TopologyWindow.setGridEnabled(!(palette = (gc = map.getGraphComponent()).getTransform().getGridPalette()).isEnabled());
        palette.setEnabled(!palette.isEnabled());
        map.repaint();
    }

    public static void setGridEnabled(final boolean enable) {
        TopologyWindow.setGridEnabled(enable);
        if (!BrowserFrame.hasInstance()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        GraphComponent gc;
                        SmMap map = SmMap.getSelectedMap();
                        if (map == null) {
                            map = SmMap.getInstance();
                        }
                        if ((gc = map.getGraphComponent()) == null) {
                            return;
                        }
                        GridPalette palette = gc.getTransform().getGridPalette();
                        palette.setEnabled(enable);
                        map.repaint();
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) break block4;
                        _Logger.trace((Object)"logEmptyCatch - setGridEnabled", (Throwable)ex);
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == null || cmd.length() == 0) {
            return;
        }
        if ("grid".equals(cmd)) {
            MiscMapActions.toggleGrid();
        } else if ("save".equals(cmd)) {
            MiscMapActions.getInstance().save();
        } else if ("exportToVisio".equals(cmd)) {
            MiscMapActions.getInstance().export2Visio(false);
        } else if ("exportToVisioWithLinkLabels".equals(cmd)) {
            MiscMapActions.getInstance().export2Visio(true);
        } else if ("print".equals(cmd)) {
            this.print();
        } else if (cmd.equals("authenticateSwitches")) {
            this.authenticateSwitches();
        } else if (cmd.equals("purgeFabric")) {
            if (!ClientController.getInstance().isServerActive()) {
                ClientController.showServerDown();
                return;
            }
            this.purge(true);
        } else if (cmd.startsWith("purge")) {
            if (!ClientController.getInstance().isServerActive()) {
                ClientController.showServerDown();
                return;
            }
            this.purge(false);
        } else if (cmd.startsWith("createFCoE")) {
            ArrayList selectedLinks = SmMap.getSelectedMap().getSelectedLinks();
            if (selectedLinks != null && selectedLinks.size() > 0) {
                HashedArrayList<EthIsl> ethIsls = new HashedArrayList<EthIsl>();
                for (int i = 0; i < selectedLinks.size(); ++i) {
                    Object link = selectedLinks.get(i);
                    if (link == null || !(link instanceof EthIslMapLink)) continue;
                    ((ArrayList)ethIsls).add((EthIsl)((EthIslMapLink)link).getModel());
                }
                if (ethIsls.size() > 0) {
                    try {
                        FCoEConfigurationWizard.getInstance(BrowserFrame.getInstance(), ethIsls);
                    }
                    catch (Exception ex) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "Failed to launch FCoE Wizard. Reason : " + ex.getMessage());
                    }
                } else {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), "No Eth Isl link selected.");
                }
            }
        } else {
            if (cmd.startsWith("discoverMore")) {
                AbstractSwitch abstractSwitch;
                String ipAddress;
                SwitchNode switchNode;
                Object model;
                Object node;
                Dialog d = null;
                ArrayList selectedNodes = SmMap.getSelectedMap().getSelectedNodes();
                if (selectedNodes != null && selectedNodes.size() > 0 && (node = selectedNodes.get(0)) != null && node instanceof SwitchNode && (model = (switchNode = (SwitchNode)node).getModel()) != null && model instanceof AbstractSwitch && (ipAddress = (abstractSwitch = (AbstractSwitch)model).getIpAddress()) != null && ipAddress.length() > 0) {
                    d = new AddFabricDialog(ControlPanelFrame.getInstance(), true, abstractSwitch.isFcObject());
                    ((AddFabricDialog)d).setSeedIp(ipAddress, abstractSwitch.isFcObject());
                    if (abstractSwitch.isFcObject()) {
                        d.setTitle("Discover CDP Neighbors - DCNM-SAN");
                        ((AddFabricDialog)d).setVisibleDiscoveryMode(false);
                    } else {
                        d.setTitle("Discover FC Neighbors - DCNM-SAN");
                        ((AddFabricDialog)d).setVisibleDiscoveryMode(false);
                    }
                }
                if (d != null) {
                    d.setVisible(true);
                }
                return;
            }
            if ("refreshMap".equals(cmd)) {
                JButton b = null;
                SmMap m = SmMap.getSelectedMap();
                if (m != null) {
                    b = m.getRefreshButton();
                } else {
                    MapMenus.getInstance();
                    b = MapMenus.getRefreshButton();
                }
                b.setEnabled(false);
                ButtonModel bm = b.getModel();
                b.setBorderPainted(true);
                bm.setArmed(true);
                bm.setPressed(true);
                try {
                    this.refreshMap();
                }
                catch (Exception ex) {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                    }
                }
            } else if ("editPortChannel".equals(cmd)) {
                PChnlWizard.createPortChannel(BrowserFrame.getInstance(), true);
            } else if ("disablePortChannelLnk".equals(cmd)) {
                PChnlActions.disablePchnlMember(BrowserFrame.getInstance());
            } else if ("findDevice".equals(cmd)) {
                this.find();
            } else if ("legend".equals(cmd)) {
                this.legend();
            } else if ("filter".equals(cmd)) {
                this.filter();
            } else if ("lunReport".equals(cmd)) {
                this.lunReport();
            } else if ("sanMap".equals(cmd)) {
                this.sanMap();
            } else {
                _Logger.error((Object)("NYI: " + e.getActionCommand()));
            }
        }
    }

    @Override
    public void validate(JMenuItem menuitem, TopologyGraph g) {
        block29: {
            String cmd = menuitem.getText();
            if (cmd == null || cmd.length() == 0) {
                return;
            }
            try {
                if (cmd.indexOf("Enclosure") != -1) {
                    menuitem.setEnabled(false);
                } else {
                    if ("Grid".equals(cmd)) {
                        ((JCheckBoxMenuItem)menuitem).setState(MiscMapActions.isGridEnabled());
                        return;
                    }
                    if (cmd.startsWith("Highlight")) {
                        menuitem.setEnabled(false);
                    } else if (cmd.startsWith("Quiesce and Disable Member...")) {
                        Object ob;
                        SmMap map = SmMap.getSelectedMap();
                        ArrayList links = map.getSelectedLinks();
                        boolean exists = false;
                        if (links != null && links.size() == 1 && links.get(0) instanceof TopologyLink && (ob = ((TopologyLink)links.get(0)).getModel()) instanceof Isl && ((Isl)ob).isPortChannel()) {
                            Switch sw1 = ((Isl)ob).getSwitch1();
                            Switch sw2 = ((Isl)ob).getSwitch2();
                            exists = sw1.isVersionGreaterThanEqual("1.3(4)") && sw1.isVersionLessThan("2.0(0)") || sw2.isVersionGreaterThanEqual("1.3(4)") && sw2.isVersionLessThan("2.0(0)");
                        }
                        menuitem.setEnabled(exists);
                    } else if (cmd.equals("Purge")) {
                        AbstractModelObject obj;
                        ActionListener n;
                        SmMap selectedMap = SmMap.getSelectedMap();
                        if (selectedMap != null && selectedMap.isSanMap()) {
                            menuitem.setEnabled(false);
                            return;
                        }
                        menuitem.setEnabled(false);
                        Iterator itr = g.getSelectedNodes().iterator();
                        while (itr.hasNext()) {
                            try {
                                n = (MapNode)itr.next();
                                if (n instanceof SwitchNode) {
                                    menuitem.setEnabled(true);
                                    return;
                                }
                                obj = (AbstractModelObject)((TopologyNode)((Object)n)).getModel();
                                if (obj.isPresent()) continue;
                                menuitem.setEnabled(true);
                                return;
                            }
                            catch (Exception ex) {
                                if (!_Logger.isTraceEnabled()) continue;
                                _Logger.trace((Object)"logEmptyCatch - Purge selected nodes", (Throwable)ex);
                            }
                        }
                        itr = g.getSelectedLinks().iterator();
                        while (itr.hasNext()) {
                            try {
                                n = (MapLink)itr.next();
                                if (((TopologyLink)((Object)n)).getModel() == null || (obj = (AbstractModelObject)((TopologyLink)((Object)n)).getModel()).isPresent()) continue;
                                menuitem.setEnabled(true);
                                return;
                            }
                            catch (Exception ex) {
                                if (!_Logger.isTraceEnabled()) continue;
                                _Logger.trace((Object)"logEmptyCatch - Purge selected links", (Throwable)ex);
                            }
                        }
                    } else if (cmd.startsWith("Create FCoE")) {
                        SmMap map = SmMap.getSelectedMap();
                        ArrayList links = map.getSelectedLinks();
                        boolean exists = false;
                        if (links != null && !links.isEmpty()) {
                            for (int i = 0; i < links.size(); ++i) {
                                Object ob;
                                if (!(links.get(i) instanceof EthIslMapLink) || !((ob = ((EthIslMapLink)links.get(i)).getModel()) instanceof EthIsl)) continue;
                                AbstractSwitch sw1 = ((EthIsl)ob).getSwitch1();
                                AbstractSwitch sw2 = ((EthIsl)ob).getSwitch2();
                                boolean bl = exists = ((EthIslMapLink)links.get(i)).isPresent() && FCoEConfigurationHelper.isVeSupported(sw1) && FCoEConfigurationHelper.isVeSupported(sw2);
                                if (exists) break;
                            }
                        }
                        menuitem.setEnabled(exists);
                    } else {
                        if (cmd.startsWith("Discover CDP Neighbors...") || cmd.startsWith("Discover FC Neighbors...")) {
                            if (ClientController.getInstance().isAdmin()) {
                                menuitem.setEnabled(true);
                                return;
                            }
                            menuitem.setEnabled(false);
                            return;
                        }
                        if (cmd.startsWith("Filter")) {
                            SmMap selectedMap = SmMap.getSelectedMap();
                            if (selectedMap != null && (selectedMap.isDataCenterMap() || selectedMap.isLanMap())) {
                                menuitem.setEnabled(false);
                                return;
                            }
                            menuitem.setEnabled(true);
                            return;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!_Logger.isTraceEnabled()) break block29;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
    }

    public void find() {
        SmFindDialog fd = SmFindDialog.getInstance();
        fd.setVisible(true);
    }

    public void legend() {
        SmMapLegendDialog dialog = SmMapLegendDialog.getInstance();
        dialog.setVisible(true);
    }

    public void filter() {
        SmMapFilterDialog dialog = SmMapFilterDialog.getInstance();
        dialog.setVisible(true);
    }

    public void lunReport() {
        HashedArrayList<AbstractModelObject> eps = new HashedArrayList<AbstractModelObject>();
        Iterator itr = SmMap.getSelectedMap().getSelectedNodes().iterator();
        while (itr.hasNext()) {
            try {
                StorageNode n = (StorageNode)itr.next();
                AbstractModelObject obj = (AbstractModelObject)n.getModel();
                if (obj == null) continue;
                if (obj instanceof Enclosure) {
                    ArrayList<EndPort> list = ((Enclosure)obj).getMembers();
                    if (list == null) continue;
                    ((ArrayList)eps).addAll(list);
                    continue;
                }
                if (!(obj instanceof EndPort)) continue;
                ((ArrayList)eps).add(obj);
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) continue;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        String title = "Luns for Selected Devices...";
        DataView dv = BrowserFrame.getDataView();
        SmCommand.storageTab(dv, title, null, null, "lunReport", eps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(boolean purgeFabric) {
        try {
            BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            SmMap map = SmMap.getSelectedMap();
            if (map == null) {
                map = SmMap.getInstance();
            }
            ArrayList nodes = map.getSelectedNodes();
            ArrayList edges = map.getSelectedLinks();
            if (purgeFabric || nodes.size() == 0 && edges.size() == 0) {
                this.purgeFabric(map.getFabric());
            } else {
                int i;
                for (i = 0; i < nodes.size(); ++i) {
                    MapNode n = (MapNode)nodes.get(i);
                    n.purge();
                }
                for (i = 0; i < edges.size(); ++i) {
                    MapLink l = (MapLink)edges.get(i);
                    l.purge();
                }
            }
            BrowserFrame.getInstance().setStatus("Purge requested");
        }
        catch (Exception e) {
            BrowserFrame.getInstance().setCursor(null);
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Action cannot be performed:\n" + Util.getErrorMessage(e));
        }
        finally {
            BrowserFrame.getInstance().setCursor(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeFabric(Fabric fabric) {
        block31: {
            block30: {
                if (fabric == null) {
                    SmMap map = SmMap.getSelectedMap();
                    if (map != null) {
                        if (map.isDataCenterMap()) {
                            try {
                                BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                                LanPK lanPK = ClientController.getInstance().getCurrentLanPK();
                                this.purgeLan(lanPK);
                            }
                            catch (Exception e) {
                                BrowserFrame.getInstance().setCursor(null);
                                Util.errorMessage((Component)BrowserFrame.getInstance(), e);
                            }
                            finally {
                                BrowserFrame.getInstance().setCursor(null);
                            }
                        } else if (map.isLanMap()) {
                            try {
                                BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                                LanPK lanPK = ClientController.getInstance().getCurrentLanPK();
                                this.purgeLan(lanPK);
                            }
                            catch (Exception e) {
                                BrowserFrame.getInstance().setCursor(null);
                                Util.errorMessage((Component)BrowserFrame.getInstance(), e);
                            }
                            finally {
                                BrowserFrame.getInstance().setCursor(null);
                            }
                            return;
                        }
                    }
                    if (map == null) {
                        map = SmMap.getInstance();
                    }
                    fabric = map.getFabric();
                }
                if (fabric != null) break block30;
                Fabric[] fs = San.getInstance().getFabrics();
                if (fs == null || fs.length <= 0) break block31;
                for (int i = 0; i < fs.length; ++i) {
                    try {
                        BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                        this.purgeFabric((FabricPK)fs[i].getPK());
                        continue;
                    }
                    catch (Exception ex) {
                        BrowserFrame.getInstance().setCursor(null);
                        Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                        continue;
                    }
                    finally {
                        BrowserFrame.getInstance().setCursor(null);
                    }
                }
                break block31;
            }
            try {
                BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                this.purgeFabric((FabricPK)fabric.getPK());
            }
            catch (SanException ex) {
                BrowserFrame.getInstance().setCursor(null);
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
            }
            catch (Exception ex) {
                BrowserFrame.getInstance().setCursor(null);
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
            }
            finally {
                BrowserFrame.getInstance().setCursor(null);
            }
        }
    }

    public void purgeFabric(FabricPK fabricPK) throws Exception {
        ClientController.getInstance().assertModelFacade().purgeAll(fabricPK);
        BrowserFrame.getInstance().setStatus("Purge requested");
    }

    public void purgeLan(LanPK lanPK) throws RemoteException, Exception {
        _Logger.info((Object)("MiscMapActions purgeLan()  lanPK=" + lanPK));
        ClientController.getInstance().purgeLanDowns(lanPK);
        BrowserFrame.getInstance().setStatus("Purge LAN requested");
    }

    public void print() {
        block5: {
            try {
                SmMap map;
                if (_printAction == null) {
                    _printAction = new PrintAction();
                    map = SmMap.getSelectedMap();
                    if (map == null) {
                        map = SmMap.getInstance();
                    }
                    _printAction.setGraphComponent(map.getGraphComponent());
                    GraphPrintJobAttributes atts = _printAction.getGraphPrintJobAttributes();
                    atts.setLeftMargin(20);
                    atts.setRightMargin(20);
                }
                if ((map = SmMap.getSelectedMap()) == null) {
                    map = SmMap.getInstance();
                }
                ActionEvent e = new ActionEvent(map.getWindow(), 0, "printPage");
                _printAction.actionPerformed(e);
            }
            catch (Exception e) {
                if (!_Logger.isTraceEnabled()) break block5;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
    }

    public void refreshMap() {
        SmMap m = SmMap.getSelectedMap();
        if (m == null) {
            m = SmMap.getInstance();
        }
        Fabric f = m.getFabric();
        boolean saved = false;
        SmMap.getSelectedMap().updateLayoutName();
        if (!LayoutAction.getInstance().isLayoutRunning()) {
            m.save();
            saved = true;
        }
        for (int i = 0; i < 10 && LayoutAction.getInstance().isLayoutRunning(); ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                if (!_Logger.isTraceEnabled()) continue;
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        if (!LayoutAction.getInstance().isLayoutRunning()) {
            if (!saved) {
                m.save();
            }
        } else {
            LayoutAction.getInstance().cancel();
        }
        m.resetData();
        m.fabricDiscovered(f);
    }

    public void sanMap() {
        ClientController cc = ClientController.getInstance();
        San.getInstance().setRestrictedTopologyPathType(San.getInstance().getRestrictedTopologyPathType() + 1);
        cc.restrictTopology(true);
    }

    public void save() {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        String name = mgmtDomain != null ? mgmtDomain.getName() : "SAN";
        String fName = Util.getFileName((JFrame)BrowserFrame.getInstance(), name + ".jpg", "*.jpg", 1, true);
        if (fName == null) {
            return;
        }
        String extension = Util.getFileExtension(fName);
        File f = extension == null || !extension.equals("jpeg") && !extension.equals("jpg") ? new File(fName + ".jpg") : new File(fName);
        boolean redo = false;
        boolean writable = true;
        if (!f.exists()) {
            try {
                if (!f.createNewFile()) {
                    writable = false;
                }
            }
            catch (Exception ex) {
                writable = false;
            }
        } else if (!f.canWrite()) {
            writable = false;
        }
        if (!writable) {
            String msg = "Can't write file: " + f.getAbsolutePath();
            _Logger.error((Object)msg);
            JOptionPane.showMessageDialog(BrowserFrame.getInstance(), msg, "Can't write...", 0);
            redo = true;
        }
        if (redo) {
            this.save();
            return;
        }
        MapProperties mapProperties = new MapProperties();
        mapProperties.setLayoutRequired(false);
        SmMap map = SmMap.getSelectedMap();
        if (map == null) {
            map = SmMap.getInstance();
        }
        ImageMaker.createImage(f, null, map, mapProperties);
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Saved map image to file :" + fName));
        }
    }

    public void save(Fabric fabric, File f) {
        MapProperties mapProperties = new MapProperties();
        mapProperties.setLayoutRequired(false);
        SmMap map = MapFactory.getInstance().getMap(fabric);
        if (map == null) {
            map = SmMap.getSelectedMap();
        }
        ImageMaker.createImage(f, null, map, mapProperties);
    }

    public void save(File f) {
        SmMap map = SmMap.getSelectedMap();
        Fabric fabric = null;
        if (map != null) {
            fabric = map.getFabric();
        }
        if (fabric == null) {
            ClientController.getInstance().getFabric();
        }
        this.save(fabric, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverExport2Visio(boolean exportLinkLabels) {
        FabricPK fabricPK;
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        String name = null;
        int vsanID = -1;
        String groupName = null;
        long groupDBID = -1L;
        if (mgmtDomain != null && mgmtDomain.isDataCenter()) {
            String result = null;
            try {
                BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                TopologyRemote topologyManager = ClientController.getInstance().getTopolgyRif();
                result = topologyManager.createVisioMapForDataCenter("C:\\temp\\visio" + String.valueOf(new Date().getTime()) + ".vdx", "admin", exportLinkLabels, !SmMap.isClassMultiLinksCollapsed());
            }
            catch (Exception e) {
                _Logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                BrowserFrame.getInstance().setCursor(null);
            }
            return;
        }
        if (mgmtDomain != null && (mgmtDomain.isLAN() || mgmtDomain.isVlan())) {
            String result = null;
            try {
                BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                TopologyRemote topologyManager = ClientController.getInstance().getTopolgyRif();
                result = topologyManager.createVisioMapForLan("C:\\temp\\visio" + String.valueOf(new Date().getTime()) + ".vdx", "admin", exportLinkLabels, !SmMap.isClassMultiLinksCollapsed());
            }
            catch (Exception e) {
                _Logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                BrowserFrame.getInstance().setCursor(null);
            }
            return;
        }
        if (mgmtDomain != null && mgmtDomain.getFabric() != null) {
            name = mgmtDomain.getName();
            if (mgmtDomain instanceof Vsan) {
                vsanID = ((Vsan)mgmtDomain).getId();
            } else if (mgmtDomain instanceof UserDefinedGroup) {
                groupName = ((UserDefinedGroup)mgmtDomain).getName();
                groupDBID = ((UserDefinedGroup)mgmtDomain).getBaseObject().getDBID();
            }
        } else {
            name = "SAN";
        }
        String userName = "admin";
        int fabricID = -1;
        Fabric fabric = ClientController.getInstance().getFabric();
        if (fabric != null && (fabricPK = (FabricPK)fabric.getPK()) != null) {
            fabricID = fabricPK._fid;
        }
        String result = null;
        try {
            BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            TopologyRemote topologyManager = ClientController.getInstance().getTopolgyRif();
            result = groupDBID > 0L ? topologyManager.createVisioMapForGroup("C:\\temp\\visio" + String.valueOf(new Date().getTime()) + ".vdx", userName, groupDBID, exportLinkLabels, !SmMap.isClassMultiLinksCollapsed(), SmMap.isDisplayEndDevices()) : (vsanID > -1 ? topologyManager.createVisioMap("C:\\temp\\visio" + String.valueOf(new Date().getTime()) + ".vdx", userName, fabricID, vsanID, exportLinkLabels, !SmMap.isClassMultiLinksCollapsed(), SmMap.isDisplayEndDevices()) : topologyManager.createVisioMap("C:\\temp\\visio" + String.valueOf(new Date().getTime()) + ".vdx", userName, fabricID, exportLinkLabels, !SmMap.isClassMultiLinksCollapsed(), SmMap.isDisplayEndDevices()));
        }
        catch (Exception e) {
            _Logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            BrowserFrame.getInstance().setCursor(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void export2Visio(boolean exportLinkLabels) {
        mgmtDomain = ClientController.getInstance().getSelectedDomain();
        name = mgmtDomain != null ? (mgmtDomain.isDataCenter() ? "DataCenter" : (mgmtDomain.isLAN() || mgmtDomain.isVlan() ? "LAN" : (mgmtDomain.isSan() ? San.getInstance().getRestrictedTopologyName() : (mgmtDomain.getFabric() != null ? mgmtDomain.getName() : "SAN")))) : "SAN";
        fName = Util.getFileName(BrowserFrame.getInstance(), name + ".vdx", 1, true);
        if (fName == null) {
            return;
        }
        extension = Util.getFileExtension(fName);
        f = extension == null || extension.equals("vdx") == false ? new File(fName + ".vdx") : new File(fName);
        redo = false;
        writable = true;
        errmsg = null;
        if (!f.exists()) {
            try {
                if (!f.createNewFile()) {
                    writable = false;
                }
            }
            catch (Exception ex) {
                errmsg = "\n" + ex.getMessage();
                writable = false;
            }
        } else if (f.canWrite()) {
            fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.close();
            }
            catch (FileNotFoundException ex2) {
                errmsg = "\n" + ex2.getMessage();
                writable = false;
            }
            catch (IOException ex3) {
                if (!MiscMapActions._Logger.isTraceEnabled()) ** GOTO lbl44
                MiscMapActions._Logger.trace((Object)"logEmptyCatch", (Throwable)ex3);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    MiscMapActions._Logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            writable = false;
        }
        if (!writable) {
            msg = "Can't write file: " + (errmsg == null ? "" : errmsg);
            MiscMapActions._Logger.error((Object)msg);
            JOptionPane.showMessageDialog(BrowserFrame.getInstance(), msg, "Can't write...", 0);
            redo = true;
        }
        if (redo) {
            this.export2Visio(exportLinkLabels);
            return;
        }
        mapProperties = new MapProperties();
        mapProperties.setLayoutRequired(false);
        map = SmMap.getSelectedMap();
        if (map == null) {
            map = SmMap.getInstance();
        }
        try {
            BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            new VisioExportAdapter(f, (TopologyGraph)map, exportLinkLabels).exportToVisio();
            if (MiscMapActions._Logger.isTraceEnabled()) {
                MiscMapActions._Logger.trace((Object)("Exported Visio map to file :" + fName));
            }
        }
        catch (Exception ex1) {
            MiscMapActions._Logger.error((Object)ex1.getMessage(), (Throwable)ex1);
            if (MiscMapActions._Logger.isTraceEnabled()) {
                MiscMapActions._Logger.trace((Object)ex1.getMessage(), (Throwable)ex1);
            }
        }
        finally {
            BrowserFrame.getInstance().setCursor(null);
        }
    }

    public void authenticateSwitches() {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        if (mgmtDomain != null && mgmtDomain.isFabric()) {
            Fabric f = (Fabric)mgmtDomain;
            f.authenticateAllSwitches(false);
        }
    }
}

