/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.sm.client.map.FabricNode;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ShowEndDeviceLabelsMapAction
extends MapActionAdapter {
    private static ShowEndDeviceLabelsMapAction _Instance = null;
    public static Logger _Logger = Logger.getLogger(ShowEndDeviceLabelsMapAction.class);

    public static ShowEndDeviceLabelsMapAction getInstance() {
        if (_Instance == null) {
            _Instance = new ShowEndDeviceLabelsMapAction();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SmMap map = SmMap.getSelectedMap();
        try {
            map.updateLayoutName();
        }
        catch (Exception ex1) {
            _Logger.trace((Object)"logEmptyCatch - updateLayoutName", (Throwable)ex1);
        }
        ArrayList nodes = map.getSelectedNodes();
        boolean show = false;
        try {
            show = ((JCheckBoxMenuItem)e.getSource()).getState();
        }
        catch (ClassCastException cce) {
            show = nodes.size() == 0 ? !map.isDisplayNodeLabels() : !((TopologyNode)nodes.get(nodes.size() - 1)).isNodeLabelDisplayed();
        }
        catch (Exception ex) {
            _Logger.trace((Object)"logEmptyCatch - getSource", (Throwable)ex);
        }
        if (nodes.size() == 0) {
            SmMap.setDisplayNodeLabels(show);
            ShowEndDeviceLabelsMapAction.setEndDeviceLabels(map, show);
            map.repaint();
            return;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (n instanceof SwitchNode) continue;
            n.setNodeLabelDisplayed(show);
        }
        map.repaint();
    }

    public static void displayEndDeviceLabels(boolean allMaps, boolean d, boolean doRepaint) {
        if (allMaps) {
            SmMap[] maps;
            SmMap.setDisplayNodeLabels(d);
            ShowEndDeviceLabelsMapAction.displayEndDeviceLabels(SmMap.getInstance(), d, doRepaint);
            Object object = maps = allMaps ? MapFactory.getMaps() : null;
            if (maps != null && maps.length > 0) {
                for (int i = 0; i < maps.length; ++i) {
                    ShowEndDeviceLabelsMapAction.displayEndDeviceLabels(maps[i], d, doRepaint);
                }
            }
        } else {
            ShowEndDeviceLabelsMapAction.displayEndDeviceLabels(SmMap.getSelectedMap(), d, doRepaint);
        }
    }

    public static void displayEndDeviceLabels(boolean d) {
        SmMap map = SmMap.getSelectedMap();
        ShowEndDeviceLabelsMapAction.displayEndDeviceLabels(map, d, true);
    }

    public static void displayEndDeviceLabels(SmMap map, boolean d, boolean doRepaint) {
        ShowEndDeviceLabelsMapAction.setEndDeviceLabels(map, d);
        if (doRepaint) {
            map.repaint();
        }
    }

    public static void setEndDeviceLabels(TopologyGraph tg, boolean display) {
        if (tg == null) {
            tg = SmMap.getSelectedMap();
        }
        TopologyNode n2 = null;
        for (TopologyNode n2 : tg.nodes()) {
            if (n2 == null) continue;
            try {
                if (n2 instanceof SwitchNode || n2 instanceof FabricNode) continue;
                n2.setNodeLabelDisplayed(display);
            }
            catch (Exception ex) {
                _Logger.error((Object)("ShowEndDeviceLabelsMapAction.setEndDeviceLabels() " + ex.getMessage()));
            }
        }
        if (tg.graphs() != null) {
            for (TopologyGraph g : tg.graphs()) {
                ShowEndDeviceLabelsMapAction.setEndDeviceLabels(g, display);
            }
        }
    }

    @Override
    public void validate(JMenuItem menuItem, TopologyGraph g) {
        SmMap map = SmMap.getSelectedMap();
        if (map != null && (map.isDataCenterMap() || map.isLanMap())) {
            menuItem.setEnabled(false);
            ((JCheckBoxMenuItem)menuItem).setState(false);
            return;
        }
        ArrayList nodes = map.getSelectedNodes();
        boolean state = map.isDisplayNodeLabels();
        if (nodes.size() != 0) {
            state = ((TopologyNode)nodes.get(nodes.size() - 1)).isNodeLabelDisplayed();
        }
        menuItem.setEnabled(true);
        ((JCheckBoxMenuItem)menuItem).setState(state);
    }
}

