/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractMgmtDomain
implements MgmtDomainIf {
    public static final String[] LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t", "\n\t\t\t\t\t"};
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected ArrayList<PropertyChangeEvent> _propertyChangeEventList = new HashedArrayList<PropertyChangeEvent>();
    protected ArrayList<SmFilter> _filters = null;
    protected boolean _filtersSet;
    protected Logger _logger = LogManager.getLogger(this.getClass());

    @Override
    public abstract SnmpPeer[] getSnmpPeers();

    @Override
    public abstract SnmpPeer[] getSnmpPeers(boolean var1);

    @Override
    public SnmpPeer[] getSnmpPeers(int filter) {
        HashedArrayList<SnmpPeer> peers = new HashedArrayList<SnmpPeer>();
        int includeN7k = filter & 1;
        for (Switch sw : this.getSwitches()) {
            if (sw == null || sw.isN7K() && includeN7k == 0) continue;
            ((ArrayList)peers).add(sw.getPeer());
        }
        return peers.toArray(new SnmpPeer[0]);
    }

    @Override
    public AbstractSwitch[] getAbstractSwitches() {
        int i;
        EthSwitch[] ethSwitchList;
        Switch[] switchList = this.getSwitches();
        if (switchList == null) {
            switchList = new Switch[]{};
        }
        if ((ethSwitchList = this.getEthSwitches()) == null) {
            ethSwitchList = new EthSwitch[]{};
        }
        HashedArrayList<AbstractSwitch> abstractSwitchList = new HashedArrayList<AbstractSwitch>(switchList.length + ethSwitchList.length);
        if (switchList != null) {
            for (i = 0; i < switchList.length; ++i) {
                ((ArrayList)abstractSwitchList).add(switchList[i]);
            }
        }
        if (ethSwitchList != null) {
            for (i = 0; i < ethSwitchList.length; ++i) {
                ((ArrayList)abstractSwitchList).add(ethSwitchList[i]);
            }
        }
        return abstractSwitchList.toArray(new AbstractSwitch[abstractSwitchList.size()]);
    }

    @Override
    public Switch[] getSwitches() {
        return new Switch[0];
    }

    @Override
    public EthSwitch[] getEthSwitches() {
        return new EthSwitch[0];
    }

    @Override
    public Switch[] getFCoESwitches() {
        HashedArrayList<Switch> fcoeSwitches = new HashedArrayList<Switch>();
        Switch[] switches = this.getSwitches();
        if (switches != null) {
            for (Switch sw : switches) {
                if (!sw.isFcoeCapable()) continue;
                ((ArrayList)fcoeSwitches).add(sw);
            }
        }
        return fcoeSwitches.toArray(new Switch[fcoeSwitches.size()]);
    }

    @Override
    public AbstractLink[] getAbstractLinks() {
        ArrayList<AbstractLink> isls = this.getAbstractLinks(null);
        return isls.toArray(new AbstractLink[isls.size()]);
    }

    @Override
    public ArrayList<AbstractLink> getAbstractLinks(ArrayList<AbstractLink> isls) {
        if (isls == null) {
            isls = new HashedArrayList<AbstractLink>();
        }
        ArrayList<Isl> islList = this.getIsls(null);
        ArrayList<NpvLink> npvLinkList = this.getNpvLinks(null);
        ArrayList<EthIsl> ethIslList = this.getEthIsls(null);
        if (isls == null) {
            isls = new HashedArrayList<AbstractLink>(isls.size() + npvLinkList.size() + ethIslList.size());
        }
        if (islList != null) {
            isls.addAll(islList);
        }
        if (npvLinkList != null) {
            isls.addAll(npvLinkList);
        }
        if (ethIslList != null) {
            isls.addAll(ethIslList);
        }
        return isls;
    }

    @Override
    public Isl[] getIsls() {
        ArrayList<Isl> isls = this.getIsls(null);
        if (isls == null) {
            return new Isl[0];
        }
        return isls.toArray(new Isl[isls.size()]);
    }

    @Override
    public abstract ArrayList<Isl> getIsls(ArrayList<Isl> var1);

    @Override
    public EthIsl[] getEthIsls() {
        ArrayList<EthIsl> isls = this.getEthIsls(null);
        return isls.toArray(new EthIsl[isls.size()]);
    }

    @Override
    public ArrayList<EthIsl> getEthIsls(ArrayList<EthIsl> isls) {
        return new HashedArrayList<EthIsl>(0);
    }

    @Override
    public NpvLink[] getFilteredNpvLinks(MgmtDomainIf.NpvLinkFilter filter) {
        ArrayList<NpvLink> npvLinks = this.getNpvs(null, filter);
        return npvLinks.toArray(new NpvLink[npvLinks.size()]);
    }

    private ArrayList<NpvLink> getNpvs(ArrayList<NpvLink> results, MgmtDomainIf.NpvLinkFilter filter) {
        if (results == null) {
            results = new HashedArrayList<NpvLink>();
        }
        ArrayList<NpvLink> allNpvLinks = this.getNpvLinks(null);
        NpvLink npvLink = null;
        Iterator<NpvLink> it = allNpvLinks.iterator();
        switch (filter) {
            case ALL: {
                return allNpvLinks;
            }
            case F_CHANNEL: {
                while (it.hasNext()) {
                    npvLink = it.next();
                    if (!npvLink.isPortChannel()) continue;
                    results.add(npvLink);
                }
                break;
            }
            case NON_F_CHANNEL: {
                while (it.hasNext()) {
                    npvLink = it.next();
                    if (npvLink.isPortChannel()) continue;
                    results.add(npvLink);
                }
                break;
            }
        }
        return results;
    }

    @Override
    public NpvLink[] getNpvLinks() {
        ArrayList<NpvLink> npvLinks = this.getNpvLinks(null);
        return npvLinks.toArray(new NpvLink[npvLinks.size()]);
    }

    @Override
    public abstract ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> var1);

    @Override
    public abstract EndPort[] getEndPorts();

    @Override
    public abstract ArrayList<EndPort> getEndPortsAsList();

    @Override
    public abstract EndPort[] getEndPorts(boolean var1);

    @Override
    public abstract ArrayList<EndPort> getEndPorts(ArrayList<EndPort> var1, boolean var2);

    @Override
    public abstract String getName();

    public String dumpSwitches(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        Switch[] sws = this.getSwitches();
        sb.append(LIL[level]).append("Num of Switches: ").append(sws.length);
        if (sws == null) {
            return sb.toString();
        }
        for (int i = 0; i < sws.length; ++i) {
            sb.append(LIL[level]).append(sws[i].getDetails());
            sb.append("; IVR ").append(sws[i].isIvrEnabled() ? "enabled" : "disabled");
            sb.append(this.dumpCards(inDetail, level + 1, sws[i]));
        }
        return sb.toString();
    }

    public String dumpCards(boolean inDetail, int level, Switch sw) {
        StringBuffer sb = new StringBuffer();
        if (sw == null) {
            return sb.toString();
        }
        Card[] cards = sw.getCards();
        Card card = null;
        if (cards != null) {
            sb.append(LIL[level]).append("Num of Cards: ").append(cards.length);
            for (int i = 0; i < cards.length; ++i) {
                card = cards[i];
                sb.append(LIL[level + 0]).append("Slot: ").append(card.getSlotId()).append(", Type: ").append(card.getModelName()).append(", ").append(card.getType()).append(", Name: ").append(card.getName()).append(", Num of Ports: ").append(card.getNumPorts()).append(", HwRev: ").append(card.getHardwareRevision()).append(", SwRev: ").append(card.getSoftwareRevision()).append(", SerialNo: ").append(card.getSerialNumber()).append(", AssetID: ").append(card.getAssetId()).append(", DMM State: ").append(card.getDmmState()).append(", Power OperStatus: ").append(card.getPowerOperStatus()).append(", OperStatus: ").append(card.getOperStatus() == 2 ? "up" : "down");
            }
        } else {
            sb.append(LIL[level]).append("Num of Cards: 0");
        }
        return sb.toString();
    }

    public String dumpIsls(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        Isl[] isls = this.getIsls();
        sb.append(LIL[level]).append("Num of ISLs: ").append(isls.length);
        if (isls == null) {
            return sb.toString();
        }
        for (int i = 0; i < isls.length; ++i) {
            sb.append(LIL[level]).append(isls[i].toString(false, true));
        }
        return sb.toString();
    }

    public String dumpEthIsls(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        EthIsl[] ethIsls = this.getEthIsls();
        if (ethIsls != null) {
            sb.append(LIL[level]).append("Num of Ethernet ISLs: ").append(ethIsls.length);
            if (ethIsls == null) {
                return sb.toString();
            }
            for (int i = 0; i < ethIsls.length; ++i) {
                sb.append(LIL[level]).append(ethIsls[i].toString());
            }
        } else {
            sb.append(LIL[level]).append("Num of Ethernet ISLs: 0");
        }
        return sb.toString();
    }

    public String dumpEthSwitches(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        EthSwitch[] ethSwitches = this.getEthSwitches();
        if (ethSwitches != null) {
            sb.append(LIL[level]).append("Num of Ethernet Switches: ").append(ethSwitches.length);
            for (int i = 0; i < ethSwitches.length; ++i) {
                sb.append(LIL[level]).append(ethSwitches[i]._ethSwitchBase.print(true, true));
            }
        } else {
            sb.append(LIL[level]).append("Num of Ethernet Switches: 0");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String dumpNpvLinks(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        NpvLink[] npvls = this.getNpvLinks();
        sb.append(LIL[level]).append("Num of NP Links: ").append(npvls.length);
        if (npvls == null) {
            return sb.toString();
        }
        for (NpvLink npvl : npvls) {
            sb.append(LIL[level]).append(npvl.toString());
        }
        return sb.toString();
    }

    public String dumpEndPorts(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        EndPort[] eps = this.getEndPorts();
        sb.append(LIL[level]).append("Num of NxPorts: ").append(eps.length);
        if (eps == null) {
            return sb.toString();
        }
        for (int i = 0; i < eps.length; ++i) {
            sb.append(LIL[level]).append(eps[i].getDetails());
            if (eps[i].isVirtualized()) {
                sb.append(", isVirtualized");
            }
            if (eps[i].getSymNodeName() == null) continue;
            sb.append("; ").append(eps[i].getSymNodeName());
        }
        return sb.toString();
    }

    public String dumpFCPorts(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        Switch[] sws = this.getSwitches();
        sb.append(LIL[level]).append("Num of Switches: ").append(sws.length);
        if (sws == null) {
            return sb.toString();
        }
        for (int i = 0; i < sws.length; ++i) {
            ArrayList<Integer> list;
            Set<Integer> keySet;
            sb.append(LIL[level]).append(sws[i].getDetails());
            Map<Integer, FcPortBase> fcPortMap = sws[i].getFCPortMap();
            if (fcPortMap == null || fcPortMap.isEmpty() || (keySet = fcPortMap.keySet()) == null || keySet.isEmpty() || (list = new ArrayList<Integer>(keySet)) == null || list.isEmpty()) continue;
            Collections.sort(list);
            for (int j = 0; j < list.size(); ++j) {
                FcPortBase portBase;
                Integer k = list.get(j);
                if (k == null || (portBase = fcPortMap.get(k)) == null) continue;
                sb.append(LIL[level + 1]).append(portBase.toString());
            }
        }
        return sb.toString();
    }

    protected abstract boolean inited();

    public String toString() {
        return this.getName();
    }

    @Override
    public PKIf getPK() {
        return null;
    }

    @Override
    public Fabric getFabric() {
        return null;
    }

    @Override
    public boolean isSan() {
        return false;
    }

    @Override
    public boolean isCustomDefined() {
        return false;
    }

    @Override
    public boolean isFabric() {
        return false;
    }

    @Override
    public boolean isVsan() {
        return false;
    }

    @Override
    public boolean isZone() {
        return false;
    }

    @Override
    public boolean isEthernet() {
        return this.isLAN() || this.isDataCenter() || this.isVlan();
    }

    @Override
    public boolean isLAN() {
        return false;
    }

    @Override
    public boolean isDataCenter() {
        return false;
    }

    @Override
    public boolean isVlan() {
        return false;
    }

    @Override
    public MgmtDomainIf getParent() {
        return null;
    }

    @Override
    public String getPath(char separator) {
        return "";
    }

    @Override
    public String getPath() {
        return this.getPath('/');
    }

    @Override
    public int getVsanId() {
        return 0;
    }

    @Override
    public int[] getUpIfIndices(Switch sw) {
        return this.getUpIfIndices(sw, (short)4096);
    }

    @Override
    public int[] getUpIfIndices(Switch sw, short type) {
        return sw.getFabric().getUpIfIndices(sw, type);
    }

    @Override
    public SmFilter[] getFilters() {
        return this.getFilters((short)Short.MAX_VALUE, (short)0);
    }

    @Override
    public SmFilter[] getFilters(short type) {
        return this.getFilters(type, (short)0);
    }

    @Override
    public SmFilter[] getFilters(short type, short addVsanId) {
        ArrayList<SmFilter> filters = this.getFilters(null, type, addVsanId);
        return filters == null ? null : filters.toArray(new SmFilter[filters.size()]);
    }

    @Override
    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters) {
        return this.getFilters(filters, (short)Short.MAX_VALUE, (short)0);
    }

    @Override
    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters, short type) {
        return this.getFilters(filters, type, (short)0);
    }

    @Override
    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters, short type, short addVsanId) {
        return this.getFilters(filters, type, addVsanId, this);
    }

    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters, short type, short addVsanId, MgmtDomainIf domain) {
        Switch[] sws;
        if (filters == null) {
            filters = new HashedArrayList<SmFilter>();
        }
        if (this._filters != null) {
            for (int i = 0; i < this._filters.size(); ++i) {
                SmFilter filter = this._filters.get(i);
                if (filters.contains(filter)) continue;
                filters.add(filter);
            }
            return filters;
        }
        if (!this._filtersSet && (sws = domain.getSwitches()) != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                if (sws[i].getSnmpPeer() == null) continue;
                SmFilter filter = new SmFilter(sws[i].getSnmpPeer());
                if (type == 4097 && this.isVsan()) {
                    filter.setIndices(new int[][]{{this.getVsanId()}});
                } else if (type != 4097 && type != Short.MAX_VALUE && (0x1000 & type) != 0) {
                    int[] ind = domain.getUpIfIndices(sws[i], type);
                    if (ind != null && ind.length > 0) {
                        int[][] newInd = new int[ind.length][addVsanId == 0 ? 1 : 2];
                        for (int j = 0; j < ind.length; ++j) {
                            if (IfIndexUtil.isFmIfIndex(ind[j])) {
                                DefaultLogger._DefLogger.debug((Object)("AbstractMgmtDomain filter: skipping " + ind[j]));
                                continue;
                            }
                            newInd[j][addVsanId >= 0 ? 0 : 1] = ind[j];
                            if (addVsanId == 0) continue;
                            newInd[j][addVsanId >= 0 ? 1 : 0] = domain.getVsanId();
                        }
                        filter.setIndices(newInd);
                    } else {
                        if ((0x1000 & type) != 0) continue;
                        filter.setIndices(null);
                    }
                }
                if (filters.contains(filter)) continue;
                filters.add(filter);
            }
        }
        return filters;
    }

    @Override
    public void setFilters(ArrayList<SmFilter> filters) {
        this._filters = filters;
        this._filtersSet = true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void clearPropertyChangeListener() {
        PropertyChangeListener[] listeners;
        if (this._propertyChangeEventList != null) {
            this._propertyChangeEventList.clear();
        }
        if ((listeners = this.propertyChangeSupport.getPropertyChangeListeners()) != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                this.propertyChangeSupport.removePropertyChangeListener(listeners[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPropertyChangeEvent(PropertyChangeEvent event) {
        if (this.inited()) {
            ArrayList<PropertyChangeEvent> arrayList = this._propertyChangeEventList;
            synchronized (arrayList) {
                if (!this._propertyChangeEventList.contains(event)) {
                    this._propertyChangeEventList.add(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChangeEvents() {
        ArrayList<PropertyChangeEvent> arrayList = this._propertyChangeEventList;
        synchronized (arrayList) {
            if (this.inited()) {
                if (this._propertyChangeEventList.size() <= 0) {
                    return;
                }
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "endOfEvents", null, this));
                for (int i = 0; i < this._propertyChangeEventList.size(); ++i) {
                    SwingUtilities.invokeLater(new RunnableEvent(this.propertyChangeSupport, this._propertyChangeEventList.get(i)));
                }
            }
            this._propertyChangeEventList.clear();
        }
    }

    class RunnableEvent
    implements Runnable {
        PropertyChangeEvent _event;
        PropertyChangeSupport _propertyChangeSupport;

        RunnableEvent(PropertyChangeSupport propertyChangeSupport, PropertyChangeEvent event) {
            this._event = event;
            this._propertyChangeSupport = propertyChangeSupport;
        }

        @Override
        public void run() {
            try {
                this._propertyChangeSupport.firePropertyChange(this._event);
            }
            catch (Exception ex) {
                AbstractMgmtDomain.this._logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

