/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractMgmtDomain;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class CustomCollection
extends AbstractMgmtDomain {
    protected String _queryString;
    protected String _name;
    protected String _description;
    protected boolean _membershipDynamic;
    private AbstractMgmtDomain[] _collections;
    private boolean _inited;
    private ArrayList<Switch> _switches;
    private ArrayList<EndPort> _endPorts;

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        String oldName = this.getName();
        this._name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldName, name);
    }

    public String getDescription() {
        return this._description;
    }

    @Override
    protected boolean inited() {
        return this._inited;
    }

    public void setDescription(String description) {
        String oldDescription = this.getDescription();
        this._description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldDescription, description);
    }

    @Override
    public Fabric getFabric() {
        return null;
    }

    public boolean isMembershipDynamic() {
        return this._membershipDynamic;
    }

    @Override
    public boolean isCustomDefined() {
        return true;
    }

    public void setMembershipDynamic(boolean membershipDynamic) {
        boolean oldMembershipDynamic = this.isMembershipDynamic();
        this._membershipDynamic = membershipDynamic;
        this.propertyChangeSupport.firePropertyChange("membershipDynamic", oldMembershipDynamic ? Boolean.TRUE : Boolean.FALSE, membershipDynamic ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getQueryString() {
        return this._queryString;
    }

    public void setQueryString(String queryString) {
        String oldQueryString = this.getQueryString();
        this._queryString = queryString;
        this.propertyChangeSupport.firePropertyChange("queryString", oldQueryString, queryString);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setSwitches(ArrayList<Switch> sws) {
        if (sws != null) {
            for (int i = sws.size() - 1; i >= 0; --i) {
                if (sws.get(i) instanceof Switch) continue;
                sws.remove(i);
            }
        }
        this._switches = sws;
    }

    @Override
    public Switch[] getSwitches() {
        return this._switches == null ? null : this._switches.toArray(new Switch[this._switches.size()]);
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> list) {
        if (list == null) {
            list = new HashedArrayList<Isl>();
        }
        return list;
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> list) {
        if (list == null) {
            list = new HashedArrayList<NpvLink>();
        }
        return list;
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        return this._endPorts;
    }

    public void setEndPorts(ArrayList<EndPort> eps) {
        this._endPorts = eps;
    }

    @Override
    public EndPort[] getEndPorts() {
        return this._endPorts == null ? null : this._endPorts.toArray(new EndPort[this._endPorts.size()]);
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> endPorts, boolean target) {
        return this._endPorts;
    }

    @Override
    public EndPort[] getEndPorts(boolean target) {
        return this._endPorts == null ? null : this._endPorts.toArray(new EndPort[this._endPorts.size()]);
    }

    public AbstractMgmtDomain[] getCollections() {
        return this._collections;
    }

    public void setCollections(AbstractMgmtDomain[] collections) {
        this._collections = collections;
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        return this.getSnmpPeers(false);
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        HashedArrayList<SnmpPeer> list = new HashedArrayList<SnmpPeer>(this._switches.size());
        for (Switch sw : this._switches) {
            if (!sw.isMDS() && (!needQuail || !sw.isQuail()) || sw.getSysUpTime() <= 0L || sw.getSnmpPeer() == null || !sw.isPresent()) continue;
            ((ArrayList)list).add(sw.getSnmpPeer());
        }
        return list.toArray(new SnmpPeer[list.size()]);
    }

    @Override
    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters, short type, short addVsanId, MgmtDomainIf domain) {
        Switch[] sws;
        if (filters == null) {
            filters = new HashedArrayList<SmFilter>();
        }
        if (this._filters != null) {
            for (int i = 0; i < this._filters.size(); ++i) {
                SmFilter filter = (SmFilter)this._filters.get(i);
                if (filters.contains(filter)) continue;
                filters.add(filter);
            }
            return filters;
        }
        if (!this._filtersSet && (sws = domain.getSwitches()) != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                SmFilter filter;
                if (sws[i].getSnmpPeer() == null || filters.contains(filter = new SmFilter(sws[i].getSnmpPeer()))) continue;
                filters.add(filter);
            }
        }
        return filters;
    }
}

