/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.AbstractMgmtDomain;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vdc;
import com.cisco.dcbu.sm.client.model.Vlan;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.InventoryChangeEvent;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.EthIslBase;
import com.cisco.dcbu.sm.common.model.EthPortBase;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.model.LanBase;
import com.cisco.dcbu.sm.common.model.VdcBase;
import com.cisco.dcbu.sm.common.model.VlanBase;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.type.VdcSnIntKey;
import com.cisco.dcbu.sm.common.type.VlanPK;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class Lan
extends AbstractMgmtDomain {
    public static final String NAME = "LAN";
    protected boolean _inited = false;
    private static Lan _Instance = new Lan();
    private HashMap<PKIf, AbstractSwitch> _abstractSwitchByPK = new HashMap();
    private HashMap<InetAddress, AbstractSwitch> _abstractSwitchByIpAddress = new HashMap();
    private HashMap<SwitchIntKeyIf, EthIsl> _ethIslBySwitchIntKey = new HashMap();
    private HashMap<VlanPK, Vlan> _vlanByPK = new HashMap();
    private LanBase _lanBase = null;

    protected Lan() {
    }

    public static Lan getInstance() {
        return _Instance;
    }

    @Override
    public String getPath(char separator) {
        return separator + NAME;
    }

    @Override
    public boolean isLAN() {
        return true;
    }

    public LanPK getLanPK() {
        if (this._lanBase == null) {
            return null;
        }
        return this._lanBase.getPK();
    }

    public static boolean isLanOpen(LanPK lanPK) {
        return _Instance != null && lanPK != null && lanPK.equals(_Instance.getLanPK());
    }

    public void dump(String item) {
        if (!this.inited()) {
            this.refresh(false);
        }
        if (item.equals(NAME)) {
            DefaultLogger._DumpLogger.info((Object)this.dumpLan(false));
        } else if (item.equals("Switches")) {
            DefaultLogger._DumpLogger.info((Object)this.dumpEthSwitches(true, 0));
        } else if (item.equals("ISLs")) {
            DefaultLogger._DumpLogger.info((Object)this.dumpEthIsls(true, 0));
        } else if (item.equals("Hashes")) {
            DefaultLogger._DumpLogger.info((Object)this.dumpHashes());
        }
    }

    private String dumpLan(boolean inDetail) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[0]).append(this.toString());
        sb.append('\n').append(this.dumpEthSwitches(inDetail, 1));
        sb.append('\n').append(this.dumpEthIsls(inDetail, 1));
        sb.append('\n');
        return sb.toString();
    }

    public String dumpHashes() {
        Field[] flds;
        StringBuilder sb = new StringBuilder();
        for (Field field : flds = this.getClass().getDeclaredFields()) {
            try {
                Object o = field.get(this);
                if (!(o instanceof Map)) continue;
                String name = field.getName();
                Map map = (Map)o;
                sb.append('\n');
                if (name.charAt(0) == '_') {
                    sb.append(name.substring(1));
                } else {
                    sb.append(name);
                }
                sb.append(": ");
                if (map == null) {
                    sb.append("none");
                } else {
                    sb.append(map.size());
                    Set s = map.entrySet();
                    for (Map.Entry ent : s) {
                        Object value;
                        sb.append("\n\tkey=").append(ent.getKey()).append(" \tvalue=").append(ent.getValue());
                        if (!name.contains("switchByPK") && !name.contains("switchByIpAddress") || (value = ent.getValue()) == null || !(value instanceof AbstractSwitch)) continue;
                        AbstractSwitch sw = (AbstractSwitch)value;
                        sb.append(" \tpk=").append(sw.getPK()).append(" \tip=").append(sw.getInetAddress());
                    }
                }
                sb.append('\n');
            }
            catch (Exception ex) {
                this._logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return sb.toString();
    }

    public void refresh(boolean force) {
        this._inited = true;
        try {
            if (this._abstractSwitchByPK != null) {
                this._abstractSwitchByPK.clear();
            }
            if (this._abstractSwitchByIpAddress != null) {
                this._abstractSwitchByIpAddress.clear();
            }
            if (this._ethIslBySwitchIntKey != null) {
                this._ethIslBySwitchIntKey.clear();
            }
            if (this._vlanByPK != null) {
                this._vlanByPK.clear();
            }
            try {
                this._lanBase = ClientController.getInstance().getLan();
            }
            catch (Exception e) {
                this._logger.error((Object)e);
            }
            if (this._lanBase == null) {
                this._inited = false;
                return;
            }
            if (ClientController.getInstance().showLan()) {
                Collection<EthSwitchBase> ethSwitchBases = this._lanBase.getEthSwitches();
                for (EthSwitchBase sw : ethSwitchBases) {
                    if (sw == null) continue;
                    this._logger.debug((Object)("ADDING EthSwitch " + sw.getPK()));
                    this.addSwitch(sw);
                }
                Collection<EthIslBase> ethIsls = this._lanBase.getEthIsls();
                for (EthIslBase isl : ethIsls) {
                    if (isl == null) continue;
                    this._logger.debug((Object)("ADDING   EthIsl " + isl.getPK()));
                    this.addIsl(isl);
                }
                Collection<VlanBase> vlans = this._lanBase.getVlans();
                for (VlanBase nextVlan : vlans) {
                    if (nextVlan == null) continue;
                    this.addVlan(nextVlan);
                }
                Collection<EthPortBase> fcPorts = this._lanBase.getEthPorts();
                EthSwitch sw = null;
                for (EthPortBase fcPort : fcPorts) {
                    if (fcPort == null || (sw = (EthSwitch)this.findSwitchByPK(fcPort.getSwitchPK())) == null) continue;
                    sw.addEthPort(fcPort);
                }
            }
        }
        catch (Exception e) {
            this._inited = false;
            this._logger.info((Object)e);
        }
    }

    public void inventoryEventReceived(InventoryChangeEvent event) {
        HwInventoryComponent hwComp;
        Object swPK;
        if (event == null) {
            return;
        }
        if (!ClientController.getInstance().showLan()) {
            return;
        }
        InventoryComponent comp = event.getEntity();
        if (comp instanceof HwInventoryComponent && (swPK = (hwComp = (HwInventoryComponent)comp).getSwitchPK()) != null) {
            AbstractSwitch sw = this.findSwitchByPK((PKIf)swPK);
            if (sw != null) {
                if (sw instanceof EthSwitch) {
                    ((EthSwitch)sw).inventoryEventReceived(event);
                } else {
                    this._logger.info((Object)("inventoryEventReceived, rejected in LAN for FC switch as LAN expects fabrics to update inventory events for FC switches: switchPK=" + swPK));
                }
            } else {
                this._logger.info((Object)("inventoryEventReceived, rejected due to LAN not containing switch: switchPK=" + swPK));
            }
        }
    }

    private PKIf getSwitch1PK(EthIslBase _ethIslBase) {
        return _ethIslBase.getSwitch1PK();
    }

    private PKIf getSwitch2PK(EthIslBase _ethIslBase) {
        return _ethIslBase.getSwitch2PK();
    }

    private EthIsl addIsl(EthIslBase islBase) {
        EthIsl isl;
        this._logger.trace((Object)"addIsl(EthIslBase)");
        if (islBase == null) {
            return null;
        }
        PKIf switch1PK = this.getSwitch1PK(islBase);
        PKIf switch2PK = this.getSwitch2PK(islBase);
        if (switch1PK != null) {
            this.addSwitch(switch1PK);
        }
        if (switch2PK != null) {
            this.addSwitch(switch2PK);
        }
        if ((isl = new EthIsl(islBase, this)).getSwitch1() == null && isl.getSwitch2() == null) {
            this._logger.info((Object)("addIsl() isl=" + isl.getPK().toString() + " MISSING_SWITCH_BOTH_SWITCHES"), (Throwable)new NullPointerException());
            return null;
        }
        if (isl.getSwitch1() == null) {
            this._logger.error((Object)("addIsl() isl=" + isl.getPK().toString() + " switch1PK=" + switch1PK + " MISSING_SWITCH_1===" + this._abstractSwitchByPK), (Throwable)new NullPointerException());
            return null;
        }
        if (isl.getSwitch2() == null) {
            this._logger.error((Object)("addIsl() isl=" + isl.getPK().toString() + " switch2PK=" + switch2PK + " MISSING_SWITCH_2===" + this._abstractSwitchByPK), (Throwable)new NullPointerException());
            return null;
        }
        this._logger.trace((Object)("addIsl() islAdded " + islBase.toString()));
        this._logger.trace((Object)("addIsl() islAdded " + isl.toString()));
        this._ethIslBySwitchIntKey.put(islBase.getIslPK().getSwitchIntKey1(), isl);
        this._ethIslBySwitchIntKey.put(islBase.getIslPK().getSwitchIntKey2(), isl);
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "ethIslAdded", null, isl));
        return isl;
    }

    private AbstractSwitch addSwitch(AbstractSwitchBase abstractSwitch) {
        if (abstractSwitch == null) {
            this._logger.error((Object)"addSwitch() abstractSwitch == null", (Throwable)new NullPointerException());
            return null;
        }
        AbstractSwitch sw = this._abstractSwitchByPK.get(abstractSwitch.getPK());
        boolean added = false;
        if (sw == null) {
            if (abstractSwitch instanceof VdcBase) {
                sw = new Vdc((VdcBase)abstractSwitch, this);
            } else if (abstractSwitch instanceof EthSwitchBase) {
                sw = new EthSwitch((EthSwitchBase)abstractSwitch, this);
            } else {
                this._logger.error((Object)"addSwitch() abstractSwitch type not supported", (Throwable)new NullPointerException());
                return null;
            }
            added = true;
        }
        if (this._abstractSwitchByPK.get(abstractSwitch.getPK()) == null) {
            this._abstractSwitchByPK.put(abstractSwitch.getPK(), sw);
        }
        if (abstractSwitch.getPK() == null) {
            this._logger.info((Object)("addSwitch() abstractSwitch.getPK()==null" + sw), (Throwable)new NullPointerException());
        }
        this.addSwitchByIpAddress(sw);
        if (this.inited() && added) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "ethSwitchAdded", null, sw));
        }
        return sw;
    }

    private AbstractSwitch addSwitch(PKIf switchKey) {
        AbstractSwitch sw = this._abstractSwitchByPK.get(switchKey);
        if (sw == null && ClientController.getInstance().isServerActive()) {
            try {
                this._logger.debug((Object)("adding switch - " + switchKey));
                AbstractSwitchBase swBase = null;
                if (swBase == null) {
                    this._logger.debug((Object)("addSwitch " + switchKey + " swBase == null"), (Throwable)new NullPointerException());
                    return null;
                }
                sw = this.addSwitch(swBase);
                this._logger.debug((Object)("switch added for switchkey - " + switchKey + " - " + sw));
                if (sw != null && this.inited()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Lan.this.firePropertyChangeEvents();
                        }
                    });
                }
                return sw;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in addSwitch " + switchKey), (Throwable)ex);
            }
        }
        return sw;
    }

    void addEthPort(EthPortBase ethPortBase) {
        EthSwitch sw;
        if (ethPortBase != null && (sw = (EthSwitch)this.findSwitchByPK(ethPortBase.getSwitchPK())) != null) {
            sw.addEthPort(ethPortBase);
        }
    }

    EthPortBase addEthPort(SwitchIntKeyIf switchIntKey) {
        if (switchIntKey == null) {
            return null;
        }
        EthPortBase ethPortBase = this.findFCPortBySwitchIntKey(switchIntKey);
        if (ethPortBase == null) {
            EthSwitch sw = (EthSwitch)this.findSwitchByPK((PKIf)switchIntKey.getSwitchKey());
            if (sw == null) {
                return null;
            }
            try {
                List list = null;
                if (list == null) {
                    return null;
                }
                int ifIndex = switchIntKey.getIfindex();
                for (int i = 0; i < list.size(); ++i) {
                    ethPortBase = (EthPortBase)list.get(i);
                    if (ethPortBase == null || ethPortBase.getIfIndex() != ifIndex) continue;
                    this.addEthPort(ethPortBase);
                    return ethPortBase;
                }
            }
            catch (Exception e) {
                this._logger.warn((Object)e);
            }
        }
        return ethPortBase;
    }

    public AbstractSwitch findSwitchByIpAddress(InetAddress ipAddr) {
        return this._abstractSwitchByIpAddress.get(ipAddr);
    }

    public AbstractSwitch findSwitchByPK(PKIf _swpk) {
        if (_swpk == null || this._abstractSwitchByPK == null) {
            return null;
        }
        AbstractSwitch sw = this._abstractSwitchByPK.get(_swpk);
        if (sw == null) {
            sw = this.addSwitch(_swpk);
            if (this.inited() && sw != null) {
                this.firePropertyChangeEvents();
            }
        }
        return sw;
    }

    private void addSwitchByIpAddress(AbstractSwitch abstractSwitch) {
        if (abstractSwitch.getInetAddress() == null) {
            this._logger.debug((Object)("addSwitchByIpAddress() sw.getInetAddress()==null sw=" + abstractSwitch));
            return;
        }
        if (abstractSwitch.getInetAddress() != null && this._abstractSwitchByIpAddress.get(abstractSwitch.getInetAddress()) == null) {
            this._abstractSwitchByIpAddress.put(abstractSwitch.getInetAddress(), abstractSwitch);
        }
    }

    @Override
    public EthIsl[] getEthIsls() {
        ArrayList<EthIsl> isls = this.getEthIsls(null);
        return isls.toArray(new EthIsl[isls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<EthIsl> getEthIsls(ArrayList<EthIsl> isls) {
        if (isls == null) {
            isls = new HashedArrayList<EthIsl>(this._ethIslBySwitchIntKey.size() / 2);
        }
        HashSet<EthIsl> islSet = new HashSet<EthIsl>(isls);
        HashMap<SwitchIntKeyIf, EthIsl> hashMap = this._ethIslBySwitchIntKey;
        synchronized (hashMap) {
            for (EthIsl isl : this._ethIslBySwitchIntKey.values()) {
                if (islSet.contains(isl)) continue;
                isls.add(isl);
                islSet.add(isl);
            }
        }
        islSet.clear();
        return isls;
    }

    public EthIsl[] getPcEthIsls() {
        ArrayList<EthIsl> isls = this.getPcEthIsls(null);
        return isls.toArray(new EthIsl[isls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EthIsl> getPcEthIsls(ArrayList<EthIsl> pcIsls) {
        if (pcIsls == null) {
            pcIsls = new HashedArrayList<EthIsl>(this._ethIslBySwitchIntKey.size() / 2);
        }
        HashSet<EthIsl> pcSet = new HashSet<EthIsl>(pcIsls);
        HashMap<SwitchIntKeyIf, EthIsl> hashMap = this._ethIslBySwitchIntKey;
        synchronized (hashMap) {
            for (EthIsl isl : this._ethIslBySwitchIntKey.values()) {
                if (!isl.isPortChannel() || pcSet.contains(isl)) continue;
                pcIsls.add(isl);
                pcSet.add(isl);
            }
        }
        pcSet.clear();
        return pcIsls;
    }

    @Override
    public EthSwitch[] getEthSwitches() {
        HashedArrayList<EthSwitch> list = new HashedArrayList<EthSwitch>(this._abstractSwitchByPK.size());
        this.getEthSwitches(list);
        return list.size() == 0 ? new EthSwitch[]{} : list.toArray(new EthSwitch[list.size()]);
    }

    public ArrayList<EthSwitch> getEthSwitches(ArrayList<EthSwitch> list) {
        if (list == null) {
            list = new HashedArrayList<EthSwitch>(this._abstractSwitchByPK.size());
        }
        for (AbstractSwitch sw : this._abstractSwitchByPK.values()) {
            if (sw == null || !(sw instanceof EthSwitch) || list.contains(sw)) continue;
            list.add((EthSwitch)sw);
        }
        return list;
    }

    public Fabric[] getFabrics() {
        return new Fabric[0];
    }

    @Override
    public EndPort[] getEndPorts() {
        return new EndPort[0];
    }

    @Override
    public EndPort[] getEndPorts(boolean target) {
        return new EndPort[0];
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> list, boolean target) {
        return list;
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        return new HashedArrayList<EndPort>();
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> isls) {
        return new HashedArrayList<Isl>();
    }

    public Vlan[] getVlans() {
        if (this._vlanByPK == null || this._vlanByPK.size() == 0) {
            return null;
        }
        return this._vlanByPK.values().toArray(new Vlan[this._vlanByPK.size()]);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> npvLinks) {
        return new HashedArrayList<NpvLink>();
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        return new SnmpPeer[0];
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        return new SnmpPeer[0];
    }

    @Override
    public Switch[] getSwitches() {
        return new Switch[0];
    }

    @Override
    public boolean inited() {
        return this._inited;
    }

    public boolean isSeedSwitch(PKIf switchPK) {
        if (switchPK == null) {
            return false;
        }
        Collection<CdpSeedBase> cdpSeeds = this._lanBase.getCdpSeeds();
        if (cdpSeeds == null) {
            return false;
        }
        Iterator<CdpSeedBase> iterator = cdpSeeds.iterator();
        if (iterator == null) {
            return false;
        }
        while (iterator.hasNext()) {
            CdpSeedBase cdpSeed = iterator.next();
            if (!cdpSeed.isMaxHopTask()) continue;
            if (cdpSeed == null) {
                return false;
            }
            if (!switchPK.equals(cdpSeed.getSeedSwPK())) continue;
            return true;
        }
        return false;
    }

    public void lanMembersRemoved(PKIf[] removedObjects) {
        PKIf[] o = removedObjects;
        if (o == null || o.length == 0) {
            return;
        }
        AbstractModelObject obj = null;
        for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                obj = null;
                this._logger.debug((Object)("REMOVED: " + o[i]));
                if (o[i] instanceof VdcSnIntKey) {
                    obj = this.removeSwitch(((VdcSnIntKey)o[i])._swPK);
                    continue;
                }
                if (o[i] instanceof SerialNumKey || o[i] instanceof SwitchIntKeyIf) {
                    obj = this.removeSwitch(o[i]);
                    continue;
                }
                if (o[i] instanceof EthIslPK) {
                    obj = this.removeIsl((EthIslPK)o[i]);
                    continue;
                }
                if (!(o[i] instanceof VlanPK)) continue;
                obj = this.removeVlan((VlanPK)o[i]);
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    public void lanMembersPurged(PKIf[] purgedObjects) {
        this.lanMembersRemoved(purgedObjects);
    }

    private EthIsl removeIsl(EthIslPK islPK) {
        EthIsl isl = this._ethIslBySwitchIntKey.get(islPK.getSwitchIntKey1());
        if (isl != null && islPK.equals(isl.getPK())) {
            this.removeIsl(islPK.getSwitchIntKey1());
            this.removeIsl(islPK.getSwitchIntKey2());
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "ethIslRemoved", isl, null));
            }
            return isl;
        }
        return null;
    }

    private Object removeIsl(SwitchIntKeyIf switchIntKey) {
        return this._ethIslBySwitchIntKey.remove(switchIntKey);
    }

    private AbstractModelObject removeSwitch(PKIf key) {
        AbstractSwitch sw = this._abstractSwitchByPK.remove(key);
        if (sw != null) {
            if (sw.getInetAddress() != null) {
                this.removeSwitchByIpAddress(sw.getInetAddress());
            }
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "ethSwitchRemoved", sw, null));
            }
        }
        return sw;
    }

    private void removeSwitchByIpAddress(InetAddress inetAddress) {
        this._abstractSwitchByIpAddress.remove(inetAddress);
        this._logger.info((Object)("removeSwitchByIpAddress switch removed swIpAddr=" + inetAddress));
    }

    public void lanMembersAdded(BaseModelObject[] addedObjects) {
        BaseModelObject[] o = addedObjects;
        if (o == null || o.length == 0) {
            return;
        }
        AbstractModelObject obj = null;
        for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                if (o[i] instanceof EthSwitchBase) {
                    AbstractSwitch sw = this._abstractSwitchByPK.get(o[i].getPK());
                    if (sw == null) {
                        sw = this.addSwitch((EthSwitchBase)o[i]);
                    } else {
                        sw.getBaseModelObject().sync(o[i]);
                    }
                    obj = sw;
                    continue;
                }
                if (o[i] instanceof EthIslBase) {
                    EthIslPK islPK = (EthIslPK)o[i].getPK();
                    EthIsl isl = this.findIslBySwitchIntKey(islPK.getSwitchIntKey1(), false);
                    if (isl == null) {
                        isl = this.addIsl((EthIslBase)o[i]);
                    } else if (islPK.equals(isl.getPK())) {
                        isl.getBaseModelObject().sync(o[i]);
                        this.addPropertyChangeEvent(new PropertyChangeEvent(isl, "ethIslSynced", null, isl));
                    } else {
                        EthIslPK removeIslPK = (EthIslPK)isl.getPK();
                        this.removeIsl(removeIslPK);
                        isl = this.addIsl((EthIslBase)o[i]);
                    }
                    obj = isl;
                    continue;
                }
                if (o[i] instanceof EthPortBase) {
                    EthPortBase fcPort = this.findFCPortBySwitchIntKey((SwitchIntKeyIf)o[i].getPK());
                    if (fcPort == null) {
                        this.addEthPort((EthPortBase)o[i]);
                        continue;
                    }
                    fcPort.sync((EthPortBase)o[i]);
                    continue;
                }
                if (!(o[i] instanceof VlanBase)) continue;
                VlanPK vlanPk = (VlanPK)o[i].getPK();
                Vlan vlan = this.findVlanByPK(vlanPk);
                if (vlan == null) {
                    vlan = this.addVlan((VlanBase)o[i]);
                } else if (!vlanPk.equals(vlan.getPK())) {
                    VlanPK removeVlanPK = (VlanPK)vlan.getPK();
                    this.removeVlan(removeVlanPK);
                    vlan = this.addVlan((VlanBase)o[i]);
                }
                obj = vlan;
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    private Vlan findVlanByPK(VlanPK vlanPk) {
        return this._vlanByPK.get(vlanPk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vlan addVlan(VlanBase vlanBase) {
        Vlan vlan;
        if (vlanBase == null) {
            return null;
        }
        VlanPK vlanPK = (VlanPK)vlanBase.getPK();
        HashMap<VlanPK, Vlan> hashMap = this._vlanByPK;
        synchronized (hashMap) {
            vlan = this._vlanByPK.get(vlanPK);
            if (vlan == null) {
                vlan = new Vlan(vlanBase, this);
                this._vlanByPK.put(vlanPK, vlan);
            }
        }
        if (this.inited()) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "vlanAdded", null, vlan));
            this.firePropertyChangeEvents();
        }
        return vlan;
    }

    private Vlan removeVlan(PKIf pk) {
        if (pk == null) {
            return null;
        }
        Vlan vlan = this._vlanByPK.remove((VlanPK)pk);
        if (this.inited() && vlan != null) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "vlanRemoved", vlan, null));
        }
        return vlan;
    }

    public EthPortBase findFCPortBySwitchIntKey(SwitchIntKeyIf switchIntKey) {
        if (switchIntKey == null) {
            return null;
        }
        EthSwitch sw = (EthSwitch)this.findSwitchByPK((PKIf)switchIntKey.getSwitchKey());
        if (sw == null) {
            return null;
        }
        return sw.findEthPort(switchIntKey.getIfindex());
    }

    private EthIsl findIslBySwitchIntKey(SwitchIntKeyIf swIfKey, boolean checkPCMembers) {
        EthIsl isl = this._ethIslBySwitchIntKey.get(swIfKey);
        if (isl == null) {
            isl = this.addIsl(swIfKey);
        }
        return isl;
    }

    private EthIsl addIsl(SwitchIntKeyIf swIntKey) {
        this._logger.trace((Object)"addIsl(SwitchIntKey)");
        EthIsl isl = this._ethIslBySwitchIntKey.get(swIntKey);
        if (isl == null && ClientController.getInstance().isServerActive()) {
            try {
                BaseModelObject islBase = null;
                if (islBase == null || !islBase.isPresent()) {
                    return null;
                }
                isl = this.addIsl((EthIslBase)islBase);
                if (this.inited()) {
                    this.firePropertyChangeEvents();
                }
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in addIsl " + swIntKey), (Throwable)ex);
            }
        }
        return isl;
    }

    public void lanMembersChanged(ChangedModelObject[] o) {
        if (o == null || o.length == 0) {
            return;
        }
        AbstractModelObject obj = null;
        for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                PKIf pk = o[i].getPK();
                short propId = o[i]._propId;
                short attrType = (short)((propId & 0xFF00) >> 8 << 8);
                Serializable oval = o[i].getOldValue();
                Serializable nval = o[i].getNewValue();
                obj = null;
                switch (attrType) {
                    case 1024: {
                        EthSwitch sw = (EthSwitch)this.findSwitchByPK(pk);
                        if (sw == null) {
                            if (!ClientController.getInstance().isServerActive()) break;
                            obj = this.addSwitch(pk);
                            break;
                        }
                        obj = sw;
                        switch (propId) {
                            case 1025: {
                                this.checkIsPresent(propId, obj, nval);
                                break;
                            }
                            case 1040: {
                                sw.setManagementAddresses((InetAddress[])nval);
                                break;
                            }
                            case 1041: {
                                sw.setManagementAddressInUse((InetAddress)nval);
                                if (nval == null || this._abstractSwitchByIpAddress.containsKey(nval)) break;
                                this._abstractSwitchByIpAddress.put((InetAddress)nval, sw);
                                break;
                            }
                            case 1039: {
                                ((EthSwitchBase)sw._baseModelObject).setUnmanageableCause((String)((Object)nval));
                                break;
                            }
                            case 1038: {
                                sw.setManageable((Boolean)nval);
                                break;
                            }
                            case 1047: {
                                break;
                            }
                            case 1034: {
                                sw.setMDS((Boolean)nval);
                                break;
                            }
                            case 1035: {
                                sw.setModelType((Integer)nval);
                                break;
                            }
                            case 1027: {
                                sw.setSysName((String)((Object)nval));
                                break;
                            }
                            case 1028: {
                                sw.setSysContact((String)((Object)nval));
                                break;
                            }
                            case 1029: {
                                sw.setSysLocation((String)((Object)nval));
                                break;
                            }
                            case 1030: {
                                sw.setSysUpTime((Long)nval);
                            }
                            case 1069: {
                                sw.setSwitchUpTime((Long)nval);
                                break;
                            }
                            case 1044: {
                                break;
                            }
                            case 1046: {
                                sw.setFeatureFlags((boolean[])nval);
                                break;
                            }
                            case 1042: {
                                break;
                            }
                            case 1043: {
                                break;
                            }
                            case 1045: {
                                break;
                            }
                            case 1031: {
                                sw.setVersion((String)((Object)nval));
                                break;
                            }
                            case 1036: {
                                sw.setModelName((String)((Object)nval));
                                break;
                            }
                            case 1050: {
                                sw.setIsLicenseViolation((Boolean)nval);
                                break;
                            }
                            case 1048: {
                                sw.setTrapRegistered((Boolean)nval);
                                break;
                            }
                            case 1033: {
                                break;
                            }
                            case 1051: {
                                break;
                            }
                            case 1053: {
                                break;
                            }
                            case 1054: {
                                break;
                            }
                            case 1037: {
                                sw.setCardTypeInSlots((int[])nval);
                                break;
                            }
                            case 1026: {
                                break;
                            }
                            case 1032: {
                                sw.setSerialNumber((String)((Object)nval));
                                break;
                            }
                            case 1052: {
                                sw.setSysDescr((String)((Object)nval));
                                break;
                            }
                            case 1049: {
                                sw.setSyslogRegistered((Boolean)nval);
                                break;
                            }
                            case 1055: {
                                sw.setTelnetEnabled((Boolean)nval);
                                break;
                            }
                            case 1057: {
                                sw.setSSHEnabled((Boolean)nval);
                                break;
                            }
                            case 1056: {
                                break;
                            }
                            case 1060: {
                                if (!(sw instanceof EthSwitch)) break;
                                EthSwitch ethSwitch = sw;
                                ethSwitch.setDeviceId((String)((Object)nval));
                                break;
                            }
                            case 1061: {
                                if (!(sw instanceof EthSwitch)) break;
                                EthSwitch ethSwitch = sw;
                                List newVlanIds = (List)((Object)nval);
                                ethSwitch.setVlans(newVlanIds);
                                break;
                            }
                            case 1058: {
                                sw.setCdpEnabled((Boolean)nval);
                                break;
                            }
                            case 1059: {
                                sw.setGlobalDeviceId((String)((Object)nval));
                                break;
                            }
                            case 1062: {
                                sw.setVtpMgmtDomain((byte[])nval);
                                break;
                            }
                            case 1063: {
                                sw.updateIfMappingTable((HashMap)nval);
                                break;
                            }
                            case 1064: {
                                sw.setNumEthPorts((Integer)nval);
                                break;
                            }
                            case 1066: {
                                sw.setFCoECapable((Boolean)nval);
                                break;
                            }
                            case 1072: {
                                if (!(sw instanceof Vdc)) break;
                                Vdc vdc = (Vdc)sw;
                                vdc.setFCoECapability((Short)nval);
                            }
                        }
                        break;
                    }
                    case 2048: {
                        EthPortBase ethPortBase = null;
                        SwitchIntKeyIf swIfKey = null;
                        if (!(pk instanceof SwitchIntKeyIf)) {
                            this._logger.debug((Object)("lanMembersChanged EthPortBase's pk NOT instanceof SwitchIntKeyIf:" + pk));
                            return;
                        }
                        swIfKey = (SwitchIntKeyIf)pk;
                        EthSwitch sw = (EthSwitch)this.findSwitchByPK((PKIf)swIfKey.getSwitchKey());
                        if (sw == null) {
                            this._logger.debug((Object)("lanMembersChanged EthPortBase's switch NOT found " + swIfKey.getSwitchKey()));
                            return;
                        }
                        ethPortBase = sw.findEthPort(swIfKey.getIfindex());
                        if (ethPortBase == null) {
                            ethPortBase = this.addEthPort(swIfKey);
                            if (ethPortBase == null) {
                                this._logger.debug((Object)("lanMembersChanged EthPortBase NOT found " + swIfKey));
                            }
                            return;
                        }
                        switch (propId) {
                            case 2049: {
                                ethPortBase.setPresent((Boolean)nval);
                                break;
                            }
                            case 2050: {
                                ethPortBase.setIfname((String)((Object)nval));
                                break;
                            }
                            case 2051: {
                                ethPortBase.setIfType((Integer)nval);
                                break;
                            }
                            case 2052: {
                                ethPortBase.setIfSpeed((Long)nval);
                                break;
                            }
                            case 2053: {
                                break;
                            }
                            case 2054: {
                                break;
                            }
                            case 2055: {
                                ethPortBase.setIfOperMode((Integer)nval);
                                break;
                            }
                            case 2056: {
                                break;
                            }
                            case 2057: {
                                ethPortBase.setTrunkMode((Byte)nval);
                                break;
                            }
                            case 2058: {
                                break;
                            }
                            case 2059: {
                                break;
                            }
                            case 2060: {
                                break;
                            }
                            case 2061: {
                                break;
                            }
                            case 2062: {
                                break;
                            }
                            case 2063: {
                                ethPortBase.setIfDescr((String)((Object)nval));
                                break;
                            }
                            case 2064: {
                                break;
                            }
                            case 2065: {
                                ethPortBase.setIfMtu((Integer)nval);
                                break;
                            }
                            case 2066: {
                                ethPortBase.setIfPhysicalAddress((MacAddress)nval);
                                break;
                            }
                            case 2067: {
                                ethPortBase.setVlans((List)((Object)nval));
                                break;
                            }
                            case 2068: {
                                if (nval instanceof Boolean) {
                                    ethPortBase.setChannel((Boolean)nval);
                                    break;
                                }
                                if (nval instanceof Integer) {
                                    ethPortBase.setChannelIfindex((Integer)nval);
                                    break;
                                }
                                ethPortBase.setChildren((ArrayList)nval);
                                break;
                            }
                            case 2069: {
                                break;
                            }
                            case 2070: {
                                break;
                            }
                            case 2077: {
                                break;
                            }
                            case 2071: {
                                ethPortBase.setAccessVlan((Short)nval);
                                break;
                            }
                            case 2072: {
                                ethPortBase.setNativeVlan((Short)nval);
                                break;
                            }
                            case 2073: {
                                break;
                            }
                            case 2074: {
                                ethPortBase.setSharedMode((Integer)nval);
                                break;
                            }
                            case 2076: {
                                ethPortBase.setIfAlias((String)((Object)nval));
                                break;
                            }
                            case 2078: {
                                ethPortBase.setIfOperStatus((Short)nval);
                            }
                        }
                        break;
                    }
                    case 1280: {
                        EthIsl isl;
                        obj = this.findIslBySwitchIntKey(((EthIslPK)pk).getSwitchIntKey1(), false);
                        if (obj == null || obj.getUserObject() == null) break;
                        if (!pk.equals(obj.getPK())) {
                            obj = null;
                        }
                        if ((isl = (EthIsl)obj) == null) break;
                        switch (propId) {
                            case 1284: {
                                break;
                            }
                            case 1287: {
                                break;
                            }
                            case 1286: {
                                break;
                            }
                            case 1282: {
                                isl.setOperMode((Integer)nval);
                                break;
                            }
                            case 1283: {
                                break;
                            }
                            case 1285: {
                                break;
                            }
                            case 1288: {
                                isl.setSpeed((Long)nval);
                                break;
                            }
                            case 1289: {
                                break;
                            }
                            case 1292: {
                                break;
                            }
                            case 1294: {
                                break;
                            }
                            case 1293: {
                                break;
                            }
                            case 1291: {
                                isl.setVlanMembership((List)((Object)nval));
                                break;
                            }
                            case 1296: {
                                isl.setNativeVlan((Short)nval);
                                break;
                            }
                            case 1299: {
                                isl.setAccessVlan((Short)nval);
                                break;
                            }
                            case 1300: {
                                isl.setTrunk((Boolean)nval);
                            }
                        }
                        this.checkIsPresent(propId, obj, nval);
                        break;
                    }
                    case 2816: {
                        Vlan vlan;
                        obj = this.findVlanByPK((VlanPK)pk);
                        if (obj == null || obj.getUserObject() == null) break;
                        if (!pk.equals(obj.getPK())) {
                            obj = null;
                        }
                        if ((vlan = (Vlan)obj) == null) break;
                        switch (propId) {
                            case 2819: {
                                vlan.setAdminState((Byte)nval);
                                break;
                            }
                            case 2817: {
                                vlan.setPresent((Boolean)nval);
                                break;
                            }
                            case 2821: {
                                vlan.setMtu((Integer)nval);
                                break;
                            }
                            case 2818: {
                                vlan.setName((String)((Object)nval));
                                break;
                            }
                            case 2820: {
                                vlan.setOperState((Byte)nval);
                            }
                        }
                        break;
                    }
                    default: {
                        if (!ClientController.isTrace()) break;
                        ClientController.trace("Unknown type changed : " + attrType + ": " + o[i].getClass().getName() + ": " + o[i]);
                    }
                }
                if (obj != null) {
                    this._logger.debug((Object)("CHANGED: " + o[i] + " ::: " + propId + " : " + oval + " -> " + nval));
                    continue;
                }
                this._logger.debug((Object)("Couldn't find(CHANGED): " + o[i] + " ::: " + propId + " : " + oval + " -> " + nval));
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in lanMemeberChanged " + o[i]), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    private boolean checkIsPresent(short propId, AbstractModelObject obj, Serializable nval) {
        if (obj == null || nval == null) {
            return false;
        }
        if (propId == 1025 || propId == 1281) {
            if (!((Boolean)nval).booleanValue()) {
                obj.setLastScanTime(System.currentTimeMillis());
            }
            obj.setPresent((Boolean)nval);
            if (ClientController.isTrace()) {
                ClientController.trace(obj.toString() + " :::isPresent: " + obj.isPresent());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchIpAddressesChanged(EthSwitch sw, InetAddress[] oldAddrs, InetAddress[] newAddrs) {
        HashMap<InetAddress, AbstractSwitch> hashMap = this._abstractSwitchByIpAddress;
        synchronized (hashMap) {
            int i;
            boolean doRemove = true;
            for (i = 0; i < newAddrs.length; ++i) {
                if (newAddrs[i] != null) continue;
                doRemove = false;
            }
            if (oldAddrs != null && doRemove) {
                for (i = 0; i < oldAddrs.length; ++i) {
                    if (newAddrs != null && GenUtil.linearSearch(newAddrs, oldAddrs[i]) >= 0) continue;
                    this._abstractSwitchByIpAddress.remove(oldAddrs[i]);
                    this._logger.warn((Object)("switchIpAddressesChanged removed _switchByIpAddress oldAddrs=" + oldAddrs[i]));
                }
            }
            if (newAddrs != null) {
                for (i = 0; i < newAddrs.length; ++i) {
                    if (oldAddrs != null && GenUtil.linearSearch(oldAddrs, newAddrs[i]) >= 0) continue;
                    this._abstractSwitchByIpAddress.put(newAddrs[i], sw);
                    this._logger.warn((Object)("switchIpAddressesChanged newAddrs=" + newAddrs[i] + " for switch=" + sw));
                }
            }
        }
    }

    public void ipAddressDisplayTypeChanged() {
        AbstractSwitch[] sws = this.getAbstractSwitches();
        if (sws != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                if (sws[i].getInetAddress() == null) continue;
                this.addPropertyChangeEvent(new PropertyChangeEvent(sws[i], "name", null, sws[i].getName()));
            }
        }
    }
}

