/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.sm.client.npv.view.Collapsible;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class CollapseTitlePanel
extends JPanel
implements ActionListener {
    private static final String Expanded_String = ">>";
    private static final String Collapsed_String = "<<";
    private Collapsible collapsible;
    private JButton titleButton;
    private JButton iconButton;
    private JPanel mp = null;

    public CollapseTitlePanel(Collapsible collapsible, boolean expanded, String text) {
        this.collapsible = collapsible;
        this.titleButton = new JButton(text);
        this.titleButton.setToolTipText("Click to collapse/expend");
        this.titleButton.setText(text);
        this.titleButton.setHorizontalTextPosition(2);
        this.titleButton.setHorizontalAlignment(2);
        this.titleButton.setContentAreaFilled(false);
        this.titleButton.setRolloverEnabled(true);
        this.titleButton.setFocusPainted(false);
        this.titleButton.setDefaultCapable(false);
        this.titleButton.setBorder(new EmptyBorder(0, 3, 0, 0));
        this.titleButton.setBorderPainted(false);
        this.titleButton.setCursor(new Cursor(12));
        this.titleButton.addActionListener(this);
        this.iconButton = new JButton();
        this.iconButton.setToolTipText("Click to collapse/expand");
        this.iconButton.setContentAreaFilled(false);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.setFocusPainted(false);
        this.iconButton.setDefaultCapable(false);
        this.iconButton.setBorder(null);
        this.iconButton.setBorderPainted(false);
        this.iconButton.setMargin(new Insets(0, 0, 0, 0));
        this.iconButton.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.iconButton.setCursor(new Cursor(12));
        this.iconButton.addActionListener(this);
        this.mp = new JPanel(new BorderLayout());
        this.mp.setBorder(new EmptyBorder(0, 0, 1, 0){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                g.translate(x, y);
                g.setColor(UIManager.getColor("controlShadow"));
                g.fillRect(0, h - 1, w, 1);
                g.translate(-x, -y);
            }
        });
        this.mp.add((Component)this.titleButton, "Center");
        this.mp.add((Component)this.iconButton, "East");
        this.setLayout(new BorderLayout());
        this.add("Center", this.mp);
        this.setOpaque(false);
        this.setExpanded(expanded);
    }

    public void setTitleFont(Font f) {
        this.titleButton.setFont(f);
        this.iconButton.setFont(f);
    }

    public void setTitleForeground(Color fg) {
        this.titleButton.setForeground(fg);
        this.iconButton.setForeground(fg);
    }

    public void setTitleBackground(Color bg) {
        this.titleButton.setBackground(bg);
        this.iconButton.setBackground(bg);
    }

    public void setExpanded(boolean expanded) {
        if (expanded) {
            this.iconButton.setText(Expanded_String);
        } else {
            this.iconButton.setText(Collapsed_String);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.collapsible.isCollapsed()) {
            this.collapsible.expand();
        } else {
            this.collapsible.collapse();
        }
        this.collapsible.update();
    }

    public void setText(String string) {
        this.titleButton.setText(string);
    }
}

