/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.view.ActionTrackerRenderer;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTableModel;
import com.cisco.dcbu.sm.client.npv.view.TextAreaRenderer;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class MultiCellRenderer
extends DefaultTableCellRenderer {
    private int minHeight = -1;
    private int currHeight = -1;
    KTable innerTable;

    public KTable getInnerTable() {
        return this.innerTable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent retComp = new JLabel();
        if (value.getClass().isArray()) {
            return table.getDefaultRenderer(value.getClass()).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        BulkActionTableModel model = (BulkActionTableModel)table.getModel();
        if (value instanceof SwitchBase) {
            retComp = new JLabel(value.toString());
        } else if (value instanceof String) {
            retComp = new JTextArea(value.toString());
            retComp.setBackground(table.getBackground());
            retComp.setForeground(table.getForeground());
            retComp.setFont(table.getFont());
            ((JTextArea)retComp).setLineWrap(true);
            ((JTextArea)retComp).setWrapStyleWord(true);
            Dimension pref = retComp.getPreferredSize();
            if (table.getRowHeight() < pref.height) {
                table.setRowHeight(row, pref.height + 20);
            }
        } else {
            if (column == BulkActionTableModel.Column.STATUS.ordinal()) {
                retComp = new JLabel("");
                retComp.setOpaque(true);
                List trackers = (List)value;
                String errMessage = new String();
                String progMessage = new String("Started");
                String succMessage = new String();
                String unknMessage = new String();
                String message = new String();
                boolean inProgress = false;
                boolean success = false;
                boolean error = false;
                boolean unknown = false;
                int cnt = 0;
                int defCnt = 0;
                for (SwitchActionTracker tracker : trackers) {
                    if (tracker.getStatus() == SwitchActionTracker.INPROGRESS || tracker.getStatus() == SwitchActionTracker.STARTED) {
                        inProgress = true;
                        continue;
                    }
                    if (tracker.getStatus() == SwitchActionTracker.SUCCESS) {
                        success = true;
                        succMessage = tracker.getShortMessage();
                        ++cnt;
                        continue;
                    }
                    if (tracker.getStatus() == SwitchActionTracker.FAILED || tracker.getStatus() == SwitchActionTracker.ERROR || tracker.getStatus() == SwitchActionTracker.WARNING) {
                        error = true;
                        errMessage = tracker.getShortMessage();
                        continue;
                    }
                    if (tracker.getStatus() == SwitchActionTracker.UNKNOW) {
                        unknown = true;
                        unknMessage = tracker.getShortMessage();
                        continue;
                    }
                    ++defCnt;
                    message = tracker.getShortMessage();
                }
                if (error) {
                    ((JLabel)retComp).setText(errMessage);
                    retComp.setBackground(Color.pink);
                } else if (inProgress || unknown) {
                    ((JLabel)retComp).setText(progMessage);
                    retComp.setBackground(Color.yellow);
                } else if (success && cnt == trackers.size()) {
                    ((JLabel)retComp).setText(succMessage);
                    retComp.setBackground(new Color(128, 255, 128));
                } else if (defCnt == trackers.size()) {
                    ((JLabel)retComp).setText(message);
                    retComp.setBackground(table.getBackground());
                } else {
                    ((JLabel)retComp).setText(progMessage);
                    retComp.setBackground(Color.yellow);
                }
                boolean debug = false;
                if (debug) {
                    System.out.println("row: " + row);
                    System.out.println("error: " + errMessage);
                    System.out.println("inProgress: " + progMessage);
                    System.out.println("unknown: " + unknMessage);
                    System.out.println("success: " + succMessage);
                    System.out.println("def: " + message);
                    System.out.println("tracker size = " + trackers.size() + " cnt = " + cnt + " defCnt = " + defCnt);
                }
                return retComp;
            }
            if (column == 3) {
                final List trackers = (List)value;
                if (this.minHeight == -1) {
                    this.minHeight = table.getRowHeight();
                }
                if (this.currHeight != trackers.size() * this.minHeight) {
                    this.currHeight = trackers.size() * this.minHeight;
                    table.setRowHeight(row, this.currHeight);
                }
                this.innerTable = new KTable(new AbstractTableModel(){

                    @Override
                    public int getColumnCount() {
                        return 1;
                    }

                    @Override
                    public int getRowCount() {
                        return 1;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex) {
                        SwitchActionTracker tracker = (SwitchActionTracker)trackers.get(rowIndex);
                        if (tracker.getStatus() == SwitchActionTracker.INPROGRESS) {
                            return tracker.getShortMessage() + "...";
                        }
                        if (tracker.getStatus() == SwitchActionTracker.SUCCESS) {
                            return tracker.getShortMessage();
                        }
                        if (tracker.getStatus() == SwitchActionTracker.FAILED || tracker.getStatus() == SwitchActionTracker.ERROR || tracker.getStatus() == SwitchActionTracker.WARNING) {
                            return tracker.getShortMessage() + "...";
                        }
                        if (tracker.getStatus() == SwitchActionTracker.UNKNOW) {
                            return tracker.getShortMessage() + "...";
                        }
                        return tracker.getShortMessage();
                    }

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return true;
                    }
                });
                this.innerTable.setAutoResizeMode(4);
                this.innerTable.setShowHorizontalLines(false);
                SwitchActionTracker tracker = (SwitchActionTracker)trackers.get(row);
                if (tracker.getStatus() == SwitchActionTracker.INPROGRESS) {
                    this.innerTable.setBackground(Color.yellow);
                } else if (tracker.getStatus() == SwitchActionTracker.SUCCESS) {
                    this.innerTable.setBackground(new Color(128, 255, 128));
                } else if (tracker.getStatus() == SwitchActionTracker.FAILED || tracker.getStatus() == SwitchActionTracker.ERROR || tracker.getStatus() == SwitchActionTracker.WARNING) {
                    this.innerTable.setBackground(Color.pink);
                } else if (tracker.getStatus() == SwitchActionTracker.UNKNOW) {
                    this.innerTable.setBackground(table.getBackground());
                } else {
                    this.innerTable.setBackground(table.getBackground());
                }
                TextAreaRenderer portStrRenderer = new TextAreaRenderer();
                this.innerTable.setDefaultRenderer(String.class, portStrRenderer);
                ActionTrackerRenderer trackerRenderer = new ActionTrackerRenderer();
                this.innerTable.setDefaultRenderer(SwitchActionTracker.class, trackerRenderer);
                this.innerTable.setRowSelectionAllowed(true);
                retComp = new JPanel();
                retComp.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                retComp.add((Component)this.innerTable, gbc);
            }
        }
        return retComp;
    }
}

