/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.portchnl;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.VshDump;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.ficon.FiconPortAddrList;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.portchnl.PChnlWizard;
import com.cisco.dcbu.sm.client.portchnl.WizIslLink;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PortChannelPanel
extends WizardPanel
implements ItemListener,
ActionListener {
    static final String PORT_VSAN = "Port VSAN:";
    static final String VSAN_LIST = "VSAN List:";
    private JLabel _ficon1Label = new JLabel("e.g. 0xA1, 0xE9");
    private JLabel _ficon2Label = new JLabel("e.g. 0xA1, 0xE9");
    static final String[] _LABELS = new String[]{null, "Channel Id:", "Description:", "FICON Port Address", null, "Channel Id:", "Description:", "FICON Port Address", null, "Port VSAN:", "VSAN List:", "Trunk Mode:", "Speed:", "Core Switch Bandwidth:", null};
    static final String _TOSTR = "To ";
    static final int SW1_DLGSEP = 0;
    static final int SW1_GROUPID = 1;
    static final int SW1_NAME = 2;
    static final int SW1_FICON_PORT = 3;
    static final int SW2_DLGSEP = 4;
    static final int SW2_GROUPID = 5;
    static final int SW2_NAME = 6;
    static final int SW2_FICON_PORT = 7;
    static final int PC_DLGSEP = 8;
    static final int PC_PVSAN = 9;
    static final int PC_VSANLIST = 10;
    static final int PC_TRUNK = 11;
    static final int PC_SPEED = 12;
    static final int PC_RATE = 13;
    static final int FORCE_MODE = 14;
    static final String _forceInfo = "Force Admin, Trunk, Speed, and VSAN attributes to be Identical";
    private Array _fromPorts = new Array();
    private Array _toPorts = new Array();
    private boolean _panelCreated;
    private JComponent[] _fields;
    private RadioButtonPanel _select;
    private RadioButtonPanel _selectChannelMode;
    static MibEnum[] _trnkEnum;
    static MibEnum[] _portModeEnum;
    static final String[] _Selector;
    static final String[] _SelectorPortMode;
    static MibEnum[] _fcIfAdminSpeedEnum;
    private RadioButtonPanel _speedSelection;
    private VarBindList _sw1Pc;
    private VarBindList _sw2Pc;
    private SnmpPeer _sw1;
    private SnmpPeer _sw2;
    private SnmpPeer _coreSwitch;
    private JCheckBox _useForce;
    private chnlProp _chnl1;
    private chnlProp _chnl2;
    private JComponent[] _Labels;
    private StringBuffer _prt1Info = new StringBuffer();
    private StringBuffer _prt2Info = new StringBuffer();
    private JButton _ficonMore1;
    private JButton _ficonMore2;
    public static final String _PortChannel_Wiz_Sig = "PORTCHANNEL";

    static String[] getTrunkModes() {
        MibNode trnkNode = MibNode.get("fcIfAdminTrunkMode");
        _trnkEnum = trnkNode.getEnums();
        String[] trunkModes = new String[_trnkEnum.length];
        int MAXI = _trnkEnum.length;
        for (int i = 0; i < MAXI; ++i) {
            trunkModes[i] = _trnkEnum[i].getLabel();
        }
        return trunkModes;
    }

    static String[] getPortRateModes() {
        MibNode portModeNode = MibNode.get("fcIfPortRateMode");
        _portModeEnum = portModeNode.getEnums();
        String[] trunkModes = new String[_portModeEnum.length];
        int MAXI = _portModeEnum.length;
        for (int i = 0; i < MAXI; ++i) {
            trunkModes[i] = _portModeEnum[i].getLabel();
        }
        return trunkModes;
    }

    static String[] getfcIfAdminSpeed() {
        MibNode fcIfAdminSpeed = MibNode.get("fcIfAdminSpeed");
        _fcIfAdminSpeedEnum = fcIfAdminSpeed.getEnums();
        String[] fcIfAdminSpeedList = new String[_fcIfAdminSpeedEnum.length];
        int MAXI = _fcIfAdminSpeedEnum.length;
        for (int i = 0; i < MAXI; ++i) {
            fcIfAdminSpeedList[i] = _fcIfAdminSpeedEnum[i].getLabel();
        }
        return fcIfAdminSpeedList;
    }

    public PortChannelPanel(JWizard wiz) {
        super("3 of 3: Create Port Channel", "Please review the Channel attributes before pressing Finish to create.  Converting all ISL(s) simultaneously into a port channel may be disruptive.\nNOTE: the Channel may take time to appear in map.", wiz, PChnlWizard._ImagePc);
        this._Labels = DialogUtil.buildLabels(_LABELS);
        this._fields = new JComponent[this._Labels.length];
        this._fields[1] = new FieldPanel(15, 1, 1, 256);
        this._fields[2] = new KTextField(_TOSTR);
        this._fields[5] = new FieldPanel(15, 1, 1, 256);
        this._fields[6] = new KTextField(_TOSTR);
        JButton[] btns = DialogUtil.buildButtons(new String[]{"...", "..."}, (ActionListener)this);
        this._ficonMore1 = btns[0];
        this._ficonMore2 = btns[1];
        this._ficonMore1.setToolTipText("Show First Available FICON Port");
        this._ficonMore2.setToolTipText("Show First Available FICON Port");
        JPanel pnl1 = new JPanel(new FlowLayout());
        pnl1.add(this._ficonMore1);
        pnl1.add(this._ficon1Label);
        JPanel pnl2 = new JPanel(new FlowLayout());
        pnl2.add(this._ficonMore2);
        pnl2.add(this._ficon2Label);
        this._fields[3] = new FieldPanel(10, (JComponent)pnl1);
        this._fields[7] = new FieldPanel(10, (JComponent)pnl2);
        this._ficonMore1.setPreferredSize(new Dimension(15, 20));
        this._ficonMore2.setPreferredSize(new Dimension(15, 20));
        this._fields[8] = new DialogSeparator("Channel Attributes");
        this._fields[9] = new FieldPanel(10, 1, 1, 4093);
        this._fields[10] = new FieldPanel(10, 1, 4093, null, false, " ( 1-4093(4079 Reserved)) e.g. 1-22,29-45");
        ((FieldPanel)this._fields[10]).getComponent(1).setVisible(false);
        this._select = new RadioButtonPanel(_Selector);
        this._fields[11] = this._select;
        this._useForce = new JCheckBox(_forceInfo, true);
        this._fields[14] = this._useForce;
        this._speedSelection = new RadioButtonPanel(PortChannelPanel.getfcIfAdminSpeed(), 8);
        this._fields[12] = this._speedSelection;
        this._selectChannelMode = new RadioButtonPanel(_SelectorPortMode);
        this._fields[13] = this._selectChannelMode;
        this._select.addChangeListener(this);
    }

    private boolean validatePcIndex(int pcIndex) {
        return pcIndex > 0 && pcIndex < 257;
    }

    static int getNextPortchl(VarBindList arPc) {
        int next = 0;
        int oldNext = 0;
        for (int i = 0; i < arPc.size(); ++i) {
            SnmpVarBind vbDat = arPc.getVb(i);
            int[] oid = vbDat.getOid().getValue();
            next = oid[oid.length - 1];
            if (next > oldNext + 1) {
                return oldNext + 1;
            }
            oldNext = next;
        }
        return next + 1;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.showHideDynamicControls();
        }
        super.setVisible(b);
    }

    @Override
    public boolean refresh() {
        this._sw1 = (SnmpPeer)this.getModelValue("PEER_A");
        this._sw2 = (SnmpPeer)this.getModelValue("PEER_B");
        ((JTextField)this._fields[2]).setText(_TOSTR + this._sw2);
        ((JTextField)this._fields[6]).setText(_TOSTR + this._sw1);
        this._sw1Pc = (VarBindList)this.getModelValue("EXISTING_PCHNL_SW1");
        this._sw2Pc = (VarBindList)this.getModelValue("EXISTING_PCHNL_SW2");
        int pchnl1 = PortChannelPanel.getNextPortchl(this._sw1Pc);
        if (!this.validatePcIndex(pchnl1)) {
            this.doPrevious();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Util.errorMessage((Component)PortChannelPanel.this.getWizard(), "Switch " + PortChannelPanel.this._sw1 + " has 256(128 on switch prior to 3.0) port channels. \n" + "Cannot create more port channels on this switch.");
                }
            });
            return false;
        }
        int pchnl2 = PortChannelPanel.getNextPortchl(this._sw2Pc);
        if (!this.validatePcIndex(pchnl2)) {
            this.doPrevious();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Util.errorMessage((Component)PortChannelPanel.this.getWizard(), "Switch " + PortChannelPanel.this._sw2 + " has 256(128 on switch prior to 3.0) port channels. \n" + "Cannot create more port channels on this switch.");
                }
            });
            return false;
        }
        ((FieldPanel)this._fields[1]).setText(Integer.toString(pchnl1));
        ((FieldPanel)this._fields[5]).setText(Integer.toString(pchnl2));
        Array selIsls = (Array)this.getModelValue("ISL_LINKS");
        this._fromPorts.clear();
        this._toPorts.clear();
        boolean flag = false;
        this._prt1Info.setLength(0);
        this._prt2Info.setLength(0);
        boolean isTrunk = true;
        boolean is91X4Switch = false;
        int MAXI = selIsls.size();
        for (int i = 0; i < MAXI; ++i) {
            Object[] selDat = (Object[])selIsls.elementAt(i);
            WizIslLink lk = (WizIslLink)selDat[0];
            if (!lk.isTrunk()) {
                isTrunk = false;
            }
            if (i == 0) {
                Switch swA = lk.getSwitch1();
                is91X4Switch = swA.is91x4Model();
                if (swA.getPeer().getAddress().equals(this._sw1.getAddress())) {
                    flag = true;
                }
            } else {
                this._prt1Info.append(", ");
                this._prt2Info.append(", ");
            }
            int prtFrom = lk.getIfIndex1();
            int prtTo = lk.getIfIndex2();
            if (flag) {
                this._fromPorts.addElement(new int[]{prtFrom, ((WizIslLink)selDat[0])._autoPChnl1 ? 1 : 2});
                this._toPorts.addElement(new int[]{prtTo, ((WizIslLink)selDat[0])._autoPChnl2 ? 1 : 2});
                if (i == 0) {
                    this._prt1Info.append(lk.getSwitch1().isNpvEnabled() ? "(NPV) " : "");
                    this._prt2Info.append(lk.getSwitch2().isNpvEnabled() ? "(NPV) " : "");
                }
                this._prt1Info.append(lk.getSwitch1().ifIndexToName(prtFrom));
                this._prt2Info.append(lk.getSwitch2().ifIndexToName(prtTo));
                continue;
            }
            this._toPorts.addElement(new int[]{prtFrom, ((WizIslLink)selDat[0])._autoPChnl1 ? 1 : 2});
            this._fromPorts.addElement(new int[]{prtTo, ((WizIslLink)selDat[0])._autoPChnl2 ? 1 : 2});
            if (i == 0) {
                this._prt2Info.append(lk.getSwitch1().isNpvEnabled() ? "(NPV) " : "");
                this._prt1Info.append(lk.getSwitch2().isNpvEnabled() ? "(NPV) " : "");
            }
            this._prt1Info.append(lk.getSwitch2().ifIndexToName(prtTo));
            this._prt2Info.append(lk.getSwitch1().ifIndexToName(prtFrom));
        }
        Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
        if (!this._panelCreated) {
            this._fields[0] = new DialogSeparator("Between Switch " + this._sw1 + " (" + this._prt1Info.toString() + ")");
            this._fields[4] = new DialogSeparator("And Switch " + this._sw2 + " (" + this._prt2Info.toString() + ")");
            JPanel p = new JPanel(new GridBagLayout());
            DialogUtil.buildPanel(p, this._Labels, this._fields);
            this.add((Component)p, "Center");
            this._panelCreated = true;
        } else {
            ((DialogSeparator)this._fields[0]).setLabel("Between Switch " + this._sw1 + " (" + this._prt1Info.toString() + ")");
            ((DialogSeparator)this._fields[4]).setLabel("And Switch " + this._sw2 + " (" + this._prt2Info.toString() + ")");
        }
        try {
            this.getLinkPortProp(selIsls);
            if (npvMode.booleanValue()) {
                this._select.setSelected(1);
            } else {
                this._select.setSelected(isTrunk ? 1 : 0);
            }
            ((FieldPanel)this._fields[9]).setText(Integer.toString(this._chnl1._portVsan));
            ((FieldPanel)this._fields[10]).setText("1-4093");
            this.itemStateChanged(null);
            this._selectChannelMode.setVisible(false);
            this._Labels[13].setVisible(false);
            this._selectChannelMode.setVisible(npvMode != null && npvMode != false);
            this._Labels[13].setVisible(npvMode != null && npvMode != false);
            if (this._selectChannelMode.isVisible()) {
                this._selectChannelMode.setSelected(is91X4Switch ? 0 : (this._chnl1._rateMode == 1 ? 0 : 1));
                this._selectChannelMode.setEnabled(!is91X4Switch);
            }
        }
        catch (SnmpException ex) {
            this.doPrevious();
            Util.errorMessage((Component)this.getWizard(), ex);
            return false;
        }
        return true;
    }

    private void showHideDynamicControls() {
        boolean ficonenabled;
        Boolean dynamic = (Boolean)this.getModelValue("DYNAMIC_PCHNL");
        Boolean ficon = (Boolean)this.getModelValue("FICON_ENABLED");
        boolean bl = ficonenabled = ficon != null && ficon != false;
        if (dynamic != null && this._panelCreated) {
            this._fields[3].setVisible(ficonenabled && dynamic == false);
            this._fields[7].setVisible(ficonenabled && dynamic == false);
            this._Labels[3].setVisible(ficonenabled && dynamic == false);
            this._Labels[7].setVisible(ficonenabled && dynamic == false);
            if (ficonenabled && !dynamic.booleanValue()) {
                Switch sww = ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress());
                if (sww != null) {
                    this._ficon1Label.setText(this.getLogicalFiconAddressRange(sww));
                }
                if ((sww = ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress())) != null) {
                    this._ficon2Label.setText(this.getLogicalFiconAddressRange(sww));
                }
            }
            this._fields[0].setVisible(dynamic == false);
            this._fields[1].setVisible(dynamic == false);
            this._fields[2].setVisible(dynamic == false);
            this._fields[4].setVisible(dynamic == false);
            this._fields[5].setVisible(dynamic == false);
            this._fields[14].setVisible(dynamic == false);
            this._fields[6].setVisible(dynamic == false);
            this._Labels[1].setVisible(dynamic == false);
            this._Labels[2].setVisible(dynamic == false);
            this._Labels[5].setVisible(dynamic == false);
            this._Labels[6].setVisible(dynamic == false);
            ((DialogSeparator)this._fields[8]).setLabel(dynamic != false ? "Port Attributes" : "Channel Attributes");
            Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
            this.setDescription((dynamic != false ? "Specify the attributes which will be assigned to selected ISL ports of " + this._sw1 + " (" + this._prt1Info + ") and " + this._sw2 + " (" + this._prt2Info + ") to ensure automatic Port Channel creation." : "Please review the Channel attributes before pressing Finish to create.  Converting all " + (npvMode != false ? "NP link(s)" : "ISL(s)") + " simultaneously into a port channel may be disruptive.\n") + "NOTE: the Channel may take time to appear in map.");
        }
    }

    boolean isValidatePchnl(VarBindList arPc, int prtChnl) throws SnmpException {
        int MAXI = arPc.size();
        for (int i = 0; i < MAXI; ++i) {
            SnmpVarBind vbDat = arPc.getVb(i);
            int[] oid = vbDat.getOid().getValue();
            if (prtChnl != oid[oid.length - 1]) continue;
            return false;
        }
        return true;
    }

    void validateVsan(SnmpPeer peer, int vsan) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get("vsanName").getOid(), vsan));
        SnmpPDU resp = peer.send(pdu);
        VarBindList vbnds = resp.getVariables();
        SnmpVar theVar = vbnds.getVb(0).getVar();
        if (theVar.getType() == 5) {
            throw new SnmpException("VSAN " + vsan + " does not exist on switch " + peer);
        }
    }

    @Override
    public void doFinish() {
        block24: {
            boolean pc1created = false;
            boolean pc2created = false;
            int prtChnl = -1;
            int prtChnl2 = -1;
            try {
                try {
                    prtChnl = ((FieldPanel)this._fields[1]).getInt();
                    prtChnl2 = ((FieldPanel)this._fields[5]).getInt();
                }
                catch (Exception ex) {
                    throw new SnmpException("Invalid port channel id.");
                }
                if (!this.isValidatePchnl(this._sw1Pc, prtChnl)) {
                    throw new SnmpException("The port channel id " + prtChnl + " already exists.");
                }
                if (!this.isValidatePchnl(this._sw2Pc, prtChnl2)) {
                    throw new SnmpException("The port channel id " + prtChnl2 + " already exists.");
                }
                int trunkMode = _trnkEnum[this._select.getSelected()].getValue();
                int prtVsan = 1;
                byte[] vsanList = null;
                try {
                    prtVsan = ((FieldPanel)this._fields[9]).getInt();
                    if (this._select.getSelected() == 1) {
                        vsanList = SnmpBitmap.parse(((FieldPanel)this._fields[10]).getField().getText().trim());
                        if (vsanList == null || vsanList.length == 0) {
                            throw new Exception("Please specify VSAN List.");
                        }
                        if (!SnmpBitmap.getBit(vsanList, prtVsan + 1)) {
                            throw new Exception("Please enter a Port VSAN within the VSAN List range.");
                        }
                    }
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this.getWizard(), ex.getMessage());
                    return;
                }
                this.validateVsan(this._sw1, prtVsan);
                this.validateVsan(this._sw2, prtVsan);
                int[] ficonPorts = this.validateAndGetFiconPort();
                if (ficonPorts == null) {
                    return;
                }
                Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
                if (JOptionPane.showConfirmDialog(this.getWizard(), "Converting " + (npvMode != false ? "NP link(s)" : "ISL(s)") + " into a port channel may be disruptive.\n" + "Do you want to continue?", this.getWizard().getTitle(), 0, 2) != 0) {
                    return;
                }
                int[] memLst1 = new int[this._fromPorts.size()];
                int[] memAutoMode1 = new int[this._fromPorts.size()];
                for (int i = 0; i < this._fromPorts.size(); ++i) {
                    int[] portProp = (int[])this._fromPorts.elementAt(i);
                    memLst1[i] = portProp[0];
                    memAutoMode1[i] = portProp[1];
                }
                this._chnl2._portVsan = this._chnl1._portVsan = prtVsan;
                if (this._useForce.isSelected()) {
                    this._chnl2._adminTrunkMode = this._chnl1._adminTrunkMode = trunkMode;
                }
                VarBindList vbl1 = new VarBindList();
                VarBindList vbl2 = new VarBindList();
                VarBindList vblAutoCr1 = new VarBindList();
                VarBindList vblAutoCr2 = new VarBindList();
                Boolean dynamic = (Boolean)this.getModelValue("DYNAMIC_PCHNL");
                if (dynamic != null && dynamic.booleanValue()) {
                    Array nonSelectedIsl = (Array)this.getModelValue("AVAILABLE_LINKS");
                    PChnlWizard.buidAutoPcModeVbl(nonSelectedIsl, vblAutoCr1, vblAutoCr2, false);
                }
                this.buildPchnlVbl(vbl1, vblAutoCr1, prtChnl, memLst1, memAutoMode1, this._chnl1, vsanList, ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress()));
                VarBindList vbl1a = new VarBindList();
                this.buildPchnlAdminVbl(vbl1a, memLst1);
                int[] memLst2 = new int[this._toPorts.size()];
                int[] memAutoMode2 = new int[this._fromPorts.size()];
                int MAXI = this._toPorts.size();
                for (int i = 0; i < MAXI; ++i) {
                    int[] portProp = (int[])this._toPorts.elementAt(i);
                    memLst2[i] = portProp[0];
                    memAutoMode2[i] = portProp[1];
                }
                this.buildPchnlVbl(vbl2, vblAutoCr2, prtChnl2, memLst2, memAutoMode2, this._chnl2, vsanList, ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress()));
                VarBindList vbl2a = new VarBindList();
                this.buildPchnlAdminVbl(vbl2a, memLst2);
                PChnlWizard.handleSnmpSetFragError(this._sw1, vbl1);
                pc1created = true;
                PChnlWizard.handleSnmpSetFragError(this._sw1, vblAutoCr1);
                int portRateMode = npvMode != null && npvMode.booleanValue() && this._selectChannelMode.isVisible() ? (this._selectChannelMode.getSelected() == 0 ? 1 : 2) : -1;
                this.setStaticPortChannelProperties(this._sw1, ((FieldPanel)this._fields[1]).getInt(), this._chnl1, ((JTextField)this._fields[2]).getText(), vsanList, memLst1, portRateMode);
                PChnlWizard.handleSnmpSetFragError(this._sw2, vbl2);
                pc2created = true;
                PChnlWizard.handleSnmpSetFragError(this._sw2, vblAutoCr2);
                this.setStaticPortChannelProperties(this._sw2, ((FieldPanel)this._fields[5]).getInt(), this._chnl2, ((JTextField)this._fields[6]).getText(), vsanList, memLst2, portRateMode);
                if (vbl1a.size() > 0) {
                    SnmpFetch.set(this._sw1, new SnmpPDU(-93, vbl1a));
                    SnmpFetch.set(this._sw2, new SnmpPDU(-93, vbl2a));
                }
                if (dynamic == null || !dynamic.booleanValue()) {
                    this.setFiconPorts(this._sw1, 0x4000000 + ((FieldPanel)this._fields[1]).getInt() - 1, this._sw2, 0x4000000 + ((FieldPanel)this._fields[5]).getInt() - 1, ficonPorts[0], ficonPorts[1]);
                }
                super.doCancel();
                BrowserFrame.getDataView().refreshWizardOwner(_PortChannel_Wiz_Sig);
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this, ex);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                try {
                    if (pc1created) {
                        SnmpPDU pdu1 = new SnmpPDU(-93, new VarBindList());
                        pdu1.addVar(new SnmpOID(MibNode.get("portChannelRowStatus").getOid(), prtChnl), new SnmpInt(6));
                        SnmpFetch.set(this._sw1, pdu1);
                    }
                    if (pc2created) {
                        SnmpPDU pdu2 = new SnmpPDU(-93, new VarBindList());
                        pdu2.addVar(new SnmpOID(MibNode.get("portChannelRowStatus").getOid(), prtChnl2), new SnmpInt(6));
                        SnmpFetch.set(this._sw2, pdu2);
                    }
                }
                catch (SnmpException ex1) {
                    Util.errorMessage((Component)this, ex);
                    if (!SnmpSession.isTrace()) break block24;
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void buildPchnlVbl(VarBindList vbl, VarBindList vblAutoCr, int prtChnl, int[] memLst, int[] memAutoMode, chnlProp chnl, byte[] vsanList, Switch sw) throws SnmpException {
        boolean isVer20OrHigher = sw.isVersionGreaterThanEqual("2.0(0)");
        Boolean dynamic = (Boolean)this.getModelValue("DYNAMIC_PCHNL");
        if (dynamic != null && dynamic.booleanValue()) {
            this.buildAutoPchnlPropVbl(vbl, memLst, chnl, vsanList);
            this.buildAutoPchnlVbl(vblAutoCr, memLst);
        } else {
            this.buildStaticPchnlVbl(vbl, prtChnl, memLst, memAutoMode, sw);
        }
    }

    private void buildAutoPchnlVbl(VarBindList vbl, int[] memLst) throws SnmpException {
        for (int i = 0; i < memLst.length; ++i) {
            vbl.add(MibNode.get("portChannelGrpIfAutoCreation").getOid(), memLst[i], (SnmpVar)new SnmpInt(1));
        }
    }

    private void buildAutoPchnlPropVbl(VarBindList vbl, int[] memLst, chnlProp chnl, byte[] vsanList) throws SnmpException {
        if (vsanList == null) {
            vsanList = SnmpBitmap.parse("1-4093");
        }
        SnmpString vsan2K = PortInterfaceUtil.getInstance(1).get2KString(vsanList);
        SnmpString vsan4K = PortInterfaceUtil.getInstance(1).get4KString(vsanList);
        for (int i = 0; i < memLst.length; ++i) {
            vbl.add(MibNode.get("vsanIfVsan").getOid(), memLst[i], (SnmpVar)new SnmpInt(chnl._portVsan));
            vbl.add(MibNode.get("fcIfAdminTrunkMode").getOid(), memLst[i], (SnmpVar)new SnmpInt(chnl._adminTrunkMode));
            if (IfIndexUtil.getType(memLst[i]) != 10) {
                int fcAdminSpeed = _fcIfAdminSpeedEnum[this._speedSelection.getSelected()].getValue();
                vbl.add(MibNode.get("fcIfAdminSpeed").getOid(), memLst[i], (SnmpVar)new SnmpInt(fcAdminSpeed));
            }
            vbl.add(MibNode.get("fcIfAllowedVsanList2k").getOid(), memLst[i], (SnmpVar)vsan2K);
            vbl.add(MibNode.get("fcIfAllowedVsanList4k").getOid(), memLst[i], (SnmpVar)vsan4K);
            vbl.add(MibNode.get("fcIfAdminMode").getOid(), memLst[i], (SnmpVar)new SnmpInt(4));
        }
    }

    private void buildStaticPchnlVbl(VarBindList vbl, int prtChnl, int[] memLst, int[] memAutoMode, Switch sw) throws SnmpException {
        boolean isVer20OrHigher = sw.isVersionGreaterThanEqual("2.0(0)");
        if (isVer20OrHigher) {
            for (int i = 0; i < memLst.length; ++i) {
                if (memAutoMode[i] != 1) continue;
                vbl.add(MibNode.get("portChannelGrpIfAutoCreation").getOid(), memLst[i], (SnmpVar)new SnmpInt(2));
            }
        }
        vbl.add(MibNode.get("portChannelRowStatus").getOid(), prtChnl, (SnmpVar)new SnmpInt(4));
        String pcName = "channel" + prtChnl;
        int fcAdminSpeed = _fcIfAdminSpeedEnum[this._speedSelection.getSelected()].getValue();
        vbl.add(MibNode.get("fcIfAdminSpeed").getOid(), sw.nameToIfIndex(pcName), (SnmpVar)new SnmpInt(fcAdminSpeed));
        int mode = this._useForce.isSelected() ? 2 : 1;
        vbl.add(MibNode.get("portChannelAddType").getOid(), prtChnl, (SnmpVar)new SnmpInt(mode));
        if (isVer20OrHigher) {
            vbl.add(MibNode.get("portChannelExtChannelGrpMode").getOid(), prtChnl, (SnmpVar)new SnmpInt(2));
        }
    }

    private void buildPchnlAdminVbl(VarBindList vbl, int[] memLst) throws SnmpException {
        Boolean dynamic = (Boolean)this.getModelValue("DYNAMIC_PCHNL");
        if (dynamic != null && dynamic.booleanValue()) {
            return;
        }
        for (int i = 0; i < memLst.length; ++i) {
            vbl.add(MibNode.get("ifAdminStatus").getOid(), memLst[i], (SnmpVar)new SnmpInt(1));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Boolean dynamic = (Boolean)this.getModelValue("DYNAMIC_PCHNL");
        this._fields[10].setEnabled(this._select.getSelected() == 1 || dynamic != null && dynamic != false);
    }

    void getLinkPortProp(Array selMem) throws SnmpException {
        Object[] selDat = (Object[])selMem.elementAt(0);
        WizIslLink lk = (WizIslLink)selDat[0];
        this._coreSwitch = lk.isNpvLink() ? lk.getSwitch1().getPeer() : null;
        SnmpPDU resp1 = this.getPortProp(lk.getIfIndex1(), lk.getSwitch1().getPeer());
        SnmpPDU resp2 = this.getPortProp(lk.getIfIndex2(), lk.getSwitch2().getPeer());
        this._chnl1 = new chnlProp();
        this._chnl2 = new chnlProp();
        this.setUpChannelProp(this._chnl1, resp1.getVariables());
        this.setUpChannelProp(this._chnl2, resp2.getVariables());
        if (lk.isNpvLink()) {
            this._chnl2._rateMode = this._chnl1._rateMode;
        }
    }

    SnmpPDU getPortProp(int ifIndex, SnmpPeer peer) throws SnmpException {
        int[] ifAdminOid = MibNode.get("fcIfAdminMode").getOid();
        int[] ifTrunkAdminOid = MibNode.get("fcIfAdminTrunkMode").getOid();
        int[] ifSpeedOid = MibNode.get("fcIfAdminSpeed").getOid();
        int[] ifPortVsanOid = MibNode.get("vsanIfVsan").getOid();
        int[] ifAllowedVsan2KOid = MibNode.get("fcIfAllowedVsanList2k").getOid();
        int[] ifAllowedVsan4KOid = MibNode.get("fcIfAllowedVsanList4k").getOid();
        int[] fcIfPortRateModeOid = MibNode.get("fcIfPortRateMode").getOid();
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addVar(new SnmpOID(ifAdminOid, ifIndex));
        pdu.addVar(new SnmpOID(ifTrunkAdminOid, ifIndex));
        pdu.addVar(new SnmpOID(ifSpeedOid, ifIndex));
        pdu.addVar(new SnmpOID(ifPortVsanOid, ifIndex));
        pdu.addVar(new SnmpOID(ifAllowedVsan2KOid, ifIndex));
        pdu.addVar(new SnmpOID(ifAllowedVsan4KOid, ifIndex));
        pdu.addVar(new SnmpOID(fcIfPortRateModeOid, ifIndex));
        return peer.send(pdu);
    }

    void setUpChannelProp(chnlProp chnl, VarBindList theLst) {
        chnl._adminMode = theLst.intValue(0);
        chnl._adminTrunkMode = theLst.intValue(1);
        chnl._adminSpeed = theLst.intValue(2);
        chnl._portVsan = theLst.intValue(3);
        chnl._allowedVsan2K = theLst.byteValue(4);
        chnl._allowedVsan4K = theLst.byteValue(5);
        chnl._rateMode = theLst.getVb(6).getVar().getType() != 5 ? theLst.intValue(6) : -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._ficonMore1 || source == this._ficonMore2) {
            SnmpPeer peer = e.getSource() == this._ficonMore1 ? this._sw1 : this._sw2;
            try {
                String[] cmd = new String[]{"show ficon first-available port-number \n"};
                DefaultLogger._DefLogger.debug((Object)("Command :" + cmd[0]));
                VshDump dlg = new VshDump(Util.getFrameAncestor(this.getWizard()), "First Available FICON Port for " + peer, cmd, peer);
                dlg.setVisible(true);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this.getWizard(), "Show First available FICON port failed.");
            }
        } else {
            this._fields[11].setEnabled(this._useForce.isSelected());
        }
    }

    private void setStaticPortChannelProperties(SnmpPeer peer, int prtChnl, chnlProp chnl, String pchnlName, byte[] vsanList, int[] memLst, int portRateMode) throws SnmpException {
        SnmpString vsan4K;
        Boolean dynamic = (Boolean)this.getModelValue("DYNAMIC_PCHNL");
        if (dynamic != null && dynamic.booleanValue()) {
            return;
        }
        VarBindList vbl = new VarBindList();
        int pchIfIndex = 0x4000000 + prtChnl - 1;
        SnmpString vsan2K = vsanList != null ? PortInterfaceUtil.getInstance(1).get2KString(vsanList) : new SnmpString(chnl._allowedVsan2K);
        SnmpString snmpString = vsan4K = vsanList != null ? PortInterfaceUtil.getInstance(1).get4KString(vsanList) : new SnmpString(chnl._allowedVsan4K);
        if (!this._useForce.isSelected()) {
            vbl.add(MibNode.get("fcIfAdminMode").getOid(), pchIfIndex, (SnmpVar)new SnmpInt(chnl._adminMode));
            vbl.add(MibNode.get("fcIfAdminSpeed").getOid(), pchIfIndex, (SnmpVar)new SnmpInt(chnl._adminSpeed));
        } else {
            Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
            vbl.add(MibNode.get("fcIfAdminMode").getOid(), pchIfIndex, (SnmpVar)new SnmpInt(npvMode == null || npvMode == false ? 4 : chnl._adminMode));
        }
        if (portRateMode != -1 && this._coreSwitch != null && this._coreSwitch.equals(peer)) {
            vbl.add(MibNode.get("fcIfPortRateMode").getOid(), pchIfIndex, (SnmpVar)new SnmpInt(portRateMode));
        }
        vbl.add(MibNode.get("fcIfAdminTrunkMode").getOid(), pchIfIndex, (SnmpVar)new SnmpInt(chnl._adminTrunkMode));
        if (this._select.getSelected() == 1) {
            vbl.add(MibNode.get("fcIfAllowedVsanList2k").getOid(), pchIfIndex, (SnmpVar)vsan2K);
            vbl.add(MibNode.get("fcIfAllowedVsanList4k").getOid(), pchIfIndex, (SnmpVar)vsan4K);
        }
        vbl.add(MibNode.get("vsanIfVsan").getOid(), pchIfIndex, (SnmpVar)new SnmpInt(chnl._portVsan));
        if (null != pchnlName) {
            vbl.add(MibNode.get("ifAlias").getOid(), pchIfIndex, (SnmpVar)new SnmpString(pchnlName));
        }
        vbl.add(MibNode.get("portChannelAddType").getOid(), prtChnl, (SnmpVar)new SnmpInt(this._useForce.isSelected() ? 2 : 1));
        byte[] memLstByte = SnmpIntList.valueOf(memLst);
        vbl.add(MibNode.get("portChannelMemberList").getOid(), prtChnl, (SnmpVar)new SnmpString(memLstByte));
        SnmpFetch.set(peer, new SnmpPDU(-93, vbl));
    }

    private void setFiconPorts(SnmpPeer peer1, int ifIndex1, SnmpPeer peer2, int ifIndex2, int ficPort1, int ficPort2) throws SnmpException {
        boolean ficonenabled;
        Boolean ficon = (Boolean)this.getModelValue("FICON_ENABLED");
        boolean bl = ficonenabled = ficon != null && ficon != false;
        if (!ficonenabled) {
            return;
        }
        StringBuffer errMsg = new StringBuffer();
        if (ficonenabled) {
            Switch swW;
            if (ficPort1 != -1) {
                try {
                    this.setFiconPort(peer1, ifIndex1, ficPort1);
                }
                catch (SnmpException ex) {
                    ClientController.getInstance();
                    swW = ClientController.findFabricSwitchByIpAddress(peer1.getAddress());
                    errMsg.append("Failed to set ficon port " + ficPort1 + " for newly created Port Channel " + swW.ifIndexToName(ifIndex1) + " on " + peer1 + ".");
                }
            }
            if (ficPort2 != -1) {
                try {
                    this.setFiconPort(peer2, ifIndex2, ficPort2);
                }
                catch (SnmpException ex) {
                    if (errMsg.length() > 0) {
                        errMsg.append("\n");
                    }
                    ClientController.getInstance();
                    swW = ClientController.findFabricSwitchByIpAddress(peer2.getAddress());
                    errMsg.append("Failed to set ficon port " + ficPort2 + " for newly created Port Channel " + swW.ifIndexToName(ifIndex2) + " on " + peer2 + ".");
                }
            }
        }
        if (errMsg.length() > 0) {
            throw new SnmpException(errMsg.toString());
        }
    }

    private void setFiconPort(SnmpPeer peer, int ifIndex, int ficPort) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cficonPortIfIndex").getOid(), ficPort, (SnmpVar)new SnmpInt(ifIndex));
        SnmpFetch.set(peer, vbl);
    }

    private String getLogicalFiconAddressRange(Switch sww) {
        byte[] ficonPortRange = ((SwitchBase)sww.getBaseModelObject()).getFiconPortRange();
        if (ficonPortRange != null && ficonPortRange.length > 0) {
            return "0x" + new FiconPortAddrList(ficonPortRange).toString();
        }
        return "";
    }

    private int[] validateAndGetFiconPort() {
        Switch sw1 = ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress());
        Switch sw2 = ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress());
        String ficPortStr = ((FieldPanel)this._fields[3]).getText().trim();
        int ficPort1 = -1;
        try {
            if (ficPortStr != null && ficPortStr.length() > 0) {
                ficPort1 = PortChannelPanel.getNumber(ficPortStr);
                byte[] ficonRange = ((SwitchBase)sw1.getBaseModelObject()).getFiconPortRange();
                if (ficonRange != null && ficonRange.length > 0 && !new FiconPortAddrList(ficonRange).isOn(ficPort1) && JOptionPane.showConfirmDialog(this.getWizard(), "FICON Port address must be in 0x" + new FiconPortAddrList(ficonRange).toString() + " for " + this._sw1 + ". Continue?", this.getWizard().getTitle(), 0) != 0) {
                    return null;
                }
            }
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this.getWizard(), "Invalid FICON Port " + ficPortStr + ". Please specify FICON Port with 0xF7 format.");
            return null;
        }
        ficPortStr = ((FieldPanel)this._fields[7]).getText().trim();
        int ficPort2 = -1;
        try {
            if (ficPortStr != null && ficPortStr.length() > 0) {
                ficPort2 = PortChannelPanel.getNumber(ficPortStr);
                byte[] ficonRange = ((SwitchBase)sw2.getBaseModelObject()).getFiconPortRange();
                if (ficonRange != null && ficonRange.length > 0 && !new FiconPortAddrList(ficonRange).isOn(ficPort2) && JOptionPane.showConfirmDialog(this.getWizard(), "FICON Port address must be in 0x" + new FiconPortAddrList(ficonRange).toString() + " for " + this._sw2 + ". Continue?", this.getWizard().getTitle(), 0) != 0) {
                    return null;
                }
            }
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this.getWizard(), "Invalid FICON Port " + ficPortStr + ".");
            return null;
        }
        return new int[]{ficPort1, ficPort2};
    }

    private static int getNumber(String n) throws NumberFormatException {
        if (n.startsWith("0x")) {
            return Integer.parseInt(n.substring(2), 16);
        }
        return Integer.parseInt(n);
    }

    static {
        _Selector = PortChannelPanel.getTrunkModes();
        _SelectorPortMode = PortChannelPanel.getPortRateModes();
    }

    class chnlProp {
        int _adminMode;
        int _adminTrunkMode;
        int _adminSpeed;
        int _portVsan;
        byte[] _allowedVsan2K;
        byte[] _allowedVsan4K;
        int _rateMode;

        chnlProp() {
        }
    }
}

