/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.se;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.se.SecureEraseManager;
import com.cisco.dcbu.sm.common.model.se.SEJob;
import com.cisco.dcbu.sm.common.model.se.SESession;
import com.jidesoft.grid.HierarchicalTableModel;
import java.awt.Component;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.table.DefaultTableModel;

class SEJobStatusTableModel
extends DefaultTableModel
implements HierarchicalTableModel {
    private static String[] JOB_COLUMN_NAMES = new String[]{"Name", "ID", "Status", "Start Time"};
    private static String[] SESSION_COLUMN_NAMES = new String[]{"ID", "Status", "Percent complete", "Speed (MB/sec)", "Algorithm", "VSAN Id", "VI", "Target port", "LUN Id", "LUN size"};

    public SEJobStatusTableModel(List<SEJob> jobs) {
        super(JOB_COLUMN_NAMES, 0);
        for (SEJob job : jobs) {
            this.addRow(new Object[]{job, job.getId(), job.getStatusString(), job.getStartTime()});
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public boolean hasChild(int row) {
        return true;
    }

    public boolean isExpandable(int row) {
        return true;
    }

    public boolean isHierarchical(int row) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getChildValueAt(int row) {
        DefaultTableModel model = null;
        Object nodeObj = this.getValueAt(row, 0);
        if (nodeObj instanceof SEJob) {
            try {
                BrowserFrame.getDataView().setCursor(Cursor.getPredefinedCursor(3));
                List<SESession> sessions = SecureEraseManager.getInstance().getSessionList((SEJob)nodeObj);
                model = new DefaultTableModel(SESSION_COLUMN_NAMES, 0){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                for (SESession session : sessions) {
                    model.addRow(new Object[]{session.getId(), session.getStatusString(), session.getPercentComplete(), session.getSpeed(), session.getAlgorithm(), session.getVsanId(), session.getViPort(), session.getTargetPort(), session.getLunId(), session.getLunSize()});
                }
            }
            catch (RemoteException e) {
                BrowserFrame.getInstance();
                Util.errorMessage((Component)BrowserFrame.getDataView().getFrmParent(), e);
            }
            finally {
                BrowserFrame.getDataView().setCursor(Cursor.getDefaultCursor());
            }
        }
        return model;
    }
}

