/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.se;

import com.cisco.dcbu.sm.client.se.SecureEraseManager;
import com.cisco.dcbu.sm.common.model.se.SEAlgoInfo;
import com.cisco.dcbu.sm.common.model.se.SELun;
import com.cisco.dcbu.sm.common.model.se.SETarget;
import com.jidesoft.grid.AbstractExpandableRow;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;

public class SessionTableRow
extends AbstractExpandableRow
implements Comparable<SessionTableRow> {
    static HashMap<SessionTableRow, Icon> _icons = new HashMap();
    private transient Object _nodeObj;
    private transient String _name;
    private transient SEAlgoInfo _algorithm;
    private transient boolean _session;
    private List<?> _children;
    private List<SEAlgoInfo> _algoList;

    public SessionTableRow(SETarget target) {
        this._nodeObj = target;
        this._name = target.getTarget().getName();
        this._session = target.isSessionCreate();
        this._algoList = SecureEraseManager.getInstance().getAlgoList();
        this._algorithm = this._algoList.get(0);
    }

    public SessionTableRow(SELun lun) {
        this._nodeObj = lun;
        this._name = lun.toString();
        this._session = lun.isSessionCreate();
        this._algoList = SecureEraseManager.getInstance().getAlgoList();
        this._algorithm = this._algoList.get(0);
    }

    public SEAlgoInfo calculateAlgo() {
        if (this.hasChildren()) {
            List<?> children = this.getChildren();
            if (!children.isEmpty()) {
                SEAlgoInfo prevAlgo = ((SessionTableRow)children.get(0)).getAlgorithm();
                for (Object row : children) {
                    if (!(row instanceof SessionTableRow)) continue;
                    SEAlgoInfo algo = ((SessionTableRow)row).getAlgorithm();
                    if (((SessionTableRow)row).hasChildren()) {
                        algo = ((SessionTableRow)row).calculateAlgo();
                    }
                    if (algo == prevAlgo) continue;
                    byte x = 15;
                    this._algorithm = new SEAlgoInfo(x, "Mixed", "Has a mix of different algorithm types");
                    return this._algorithm;
                }
                this._algorithm = prevAlgo;
                return this._algorithm;
            }
            byte y = 15;
            this._algorithm = new SEAlgoInfo(y, "Mixed", "Has a mix of different algorithm types");
        }
        return this._algorithm;
    }

    public void propagateSession() {
        List<?> children;
        if (this.hasChildren() && !(children = this.getChildren()).isEmpty()) {
            for (Object row : children) {
                if (!(row instanceof SessionTableRow)) continue;
                ((SessionTableRow)row).setSession(this.isSession());
            }
        }
    }

    public void propagateAlgo() {
        List<?> children;
        if (this.hasChildren() && !(children = this.getChildren()).isEmpty()) {
            for (Object row : children) {
                if (!(row instanceof SessionTableRow)) continue;
                ((SessionTableRow)row).setAlgorithm(this.getAlgorithm());
            }
        }
    }

    public boolean calculateSession() {
        List<?> children;
        if (this.hasChildren() && !(children = this.getChildren()).isEmpty()) {
            for (Object row : children) {
                boolean session;
                if (!(row instanceof SessionTableRow) || (session = ((SessionTableRow)row).isSession())) continue;
                this.setSession(session);
                return session;
            }
            this.setSession(true);
            return true;
        }
        return false;
    }

    public Object getValueAt(int columnIndex) {
        try {
            switch (columnIndex) {
                case 0: {
                    return this;
                }
                case 1: {
                    return new Boolean(this._session);
                }
                case 2: {
                    return this._algorithm;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public Class<SessionTableRow> getCellClassAt(int columnIndex) {
        return null;
    }

    public void setChildren(List<?> children) {
        this._children = children;
        if (this._children != null) {
            for (Object row : this._children) {
                if (!(row instanceof Row)) continue;
                ((Row)row).setParent((Expandable)this);
            }
        }
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public List<?> getChildren() {
        if (this._children != null) {
            return this._children;
        }
        return new ArrayList();
    }

    public String getName() {
        return this._name;
    }

    public SEAlgoInfo getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(SEAlgoInfo algo) {
        this._algorithm = algo;
        if (this._nodeObj instanceof SELun) {
            ((SELun)this._nodeObj).setAlgorithm(algo);
        }
    }

    @Override
    public int compareTo(SessionTableRow o) {
        SessionTableRow fileRow = o;
        return this.getName().compareToIgnoreCase(fileRow.getName());
    }

    public void notifyCellUpdated(Object child, int columnIndex) {
        System.out.println(" modified node = " + child + columnIndex);
    }

    public Object getNodeObj() {
        return this._nodeObj;
    }

    public void setNodeObj(Object obj) {
        this._nodeObj = obj;
    }

    public boolean isSession() {
        return this._session;
    }

    public void setSession(boolean _session) {
        this._session = _session;
    }
}

