/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradePanel;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;

class SwitchPanel
extends UpgradePanel {
    SnmpKTable _table;
    UpgradeWizard _wiz;
    Object[] _lastComponent;

    public SwitchPanel(JFrame parent, UpgradeWizard wiz, SnmpPeer[] peers, Upgrade _upgrade) {
        super("Step 1 of 4 - Select Switches", "Select switches to install software images. You must select at least one switch in order to proceed.", parent, wiz, _upgrade);
        Array<Object[]> data = new Array<Object[]>();
        String[] cols = new String[]{"Select", "Switch", "Model", "Running Software Version [Standby]"};
        boolean[] attrs = new boolean[]{true, false, false, false};
        this._wiz = wiz;
        this._table = this.buildTable(cols, attrs, data);
        this.setAllowedAddRemoveColumn(this._table, false);
        TableColumnModel cm = this._table.getColumnModel();
        cm.getColumn(0).setMaxWidth(60);
        for (int i = 0; i < peers.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peers[i].getAddress());
            if (!sw.isManageable() || sw.isUCS() || sw.isN7K()) continue;
            String ver = sw.getVersion();
            if (sw.isHotStandby()) {
                ver = ver + " [" + SwitchPanel.getStandbyVersion(sw) + "]";
            }
            Object[] row = new Object[]{Boolean.TRUE, sw, sw.getSupModel(), ver, null};
            data.addElement(row);
        }
        JScrollPane sp = new JScrollPane(this._table);
        sp.setPreferredSize(this._table.calcPreferredSize());
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", sp);
        this.add(p);
    }

    @Override
    public void doNext() {
        int num = 0;
        Switch[] sws = new Switch[SwitchPanel.getData(this._table).size()];
        boolean is9020 = false;
        int numOf9020 = 0;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            if (!((Boolean)this._table.getValueAt(i, this._table.convertColumnIndexToView(0))).booleanValue()) continue;
            Switch sw = (Switch)this._table.getValueAt(i, this._table.convertColumnIndexToView(1));
            if (sw.isQuail()) {
                ++numOf9020;
                is9020 = true;
            }
            sws[num++] = sw;
        }
        if (num == 0) {
            this.error("You must choose at least one switch.");
            return;
        }
        if (numOf9020 != 0 && numOf9020 != num) {
            this.error("Please choose either MDSs or 9020s for upgrade.");
            return;
        }
        Switch[] finalSws = new Switch[num];
        System.arraycopy(sws, 0, finalSws, 0, num);
        this.setSwitches(finalSws);
        int totalPanel = this._wiz.getPanelTotal();
        if (this._wiz.getPanelCount() == totalPanel) {
            this._lastComponent = this._wiz.getPanelComponentAt(this._wiz.getPanelCount());
        } else if (this._wiz.getPanelCount() < totalPanel && this._lastComponent != null) {
            this._wiz.addPanel((String)this._lastComponent[0], (UpgradePanel)this._lastComponent[1]);
        }
        if (is9020) {
            this.getWizard().last();
        } else {
            this._wiz.removePanelAt(this._wiz.getPanelCount());
            super.doNext();
        }
    }

    void tftpCheck() {
        String err = TFTP.canStartServerAsString();
        if (err != null) {
            this.error("Warning: Local tftp server (port 69) cannot be started.\nDownloading images from local disk to switch is not possible.\nReason: " + err);
        }
    }

    @Override
    protected SnmpKTable createTable(SnmpTableModel model) {
        return new SnmpSwitchPanelTable(model);
    }

    class SnmpSwitchPanelTable
    extends SnmpKTable
    implements ActionListener {
        KTableModel _model;
        String[][] _menuItems;

        public SnmpSwitchPanelTable(KTableModel model) {
            super(model);
            this._menuItems = new String[][]{{"Select All", "A"}, {"Select None", "N"}};
            this._model = model;
        }

        @Override
        protected void buildPopupMenu() {
            this._popup = new JPopupMenu();
            for (int i = 0; i < this._menuItems.length; ++i) {
                this._popup.add(Util.createMenuItem(this._menuItems[i][0], this._menuItems[i][1], this));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().charAt(0) == 'A' || e.getActionCommand().charAt(0) == 'N') {
                boolean none = e.getActionCommand().charAt(0) == 'N';
                this.setSelectionAll(none ? Boolean.FALSE : Boolean.TRUE);
            } else {
                super.actionPerformed(e);
            }
        }

        void setSelectionAll(Object value) {
            for (int i = 0; i < SwitchPanel.this._table.getRowCount(); ++i) {
                SwitchPanel.this._table.setValueAt(value, i, 0);
            }
        }
    }
}

