/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.CliCommandHandler;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.InformationDialog;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SaveZnConfigPnl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BackupZoneDlg
extends JDialog
implements ActionListener {
    public static final String Local_SERVER_FILE_NAME = "lcl_tf_fl_ts";
    public static final String BACKUP_ZONE_FILE_NAME = "bootflash:cpZnbkpFl";
    private JLabel _status;
    JDialog _parent;
    int vsanId;
    Switch configSw;
    SaveCfgPanel saveZnCnfPnl;
    vshRunner runner;
    JButton[] buttons;
    private InformationDialog _logDialog;
    boolean backUpToSwitch;

    public BackupZoneDlg(JDialog parent, Switch sw, int v) {
        this(parent, sw, v, false);
    }

    public BackupZoneDlg(JDialog parent, Switch sw, int v, boolean toSwitch) {
        super(parent);
        this.backUpToSwitch = toSwitch;
        this._parent = parent;
        this.vsanId = v;
        this.configSw = sw;
        this.setTitle((toSwitch ? "Restore " : "Backup " + (v == 0 ? "All" : (v != -1 ? "VSAN " + v : "IVR VSAN"))) + " Zone Configuration - " + sw.getFabric().getPath('/'));
        this.saveZnCnfPnl = new SaveCfgPanel(sw, this.vsanId, toSwitch);
        this._status = new JLabel(" ");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        this.buttons = DialogUtil.buildButtons(new String[]{toSwitch ? "Restore..." : "Backup...", "View Config...", "Close"}, (ActionListener)this);
        if (!toSwitch) {
            this.buttons[1].setVisible(false);
        }
        JPanel lowerPnl = DialogUtil.buildStatusPanel(this.buttons, this._status);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)this.saveZnCnfPnl, lowerPnl);
        this.setDefaultCloseOperation(2);
        this.setModal(false);
        this.setResizable(true);
    }

    private boolean validateInput() {
        String fileName;
        String usrName = this.saveZnCnfPnl.getUser();
        String passWord = this.saveZnCnfPnl.getPass();
        String ipAdd = this.saveZnCnfPnl.getServer();
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ipAdd);
        }
        catch (UnknownHostException ex) {
            Util.errorMessage((Component)this, "Unreachable switch " + ipAdd + ".");
            return false;
        }
        if (this.saveZnCnfPnl.getServerLoc() == 1 && (this.saveZnCnfPnl.getRemoteProto() == 2 || this.saveZnCnfPnl.getRemoteProto() == 1)) {
            if (passWord == null || passWord.length() == 0) {
                Util.errorMessage((Component)this, "Please enter a password");
                return false;
            }
            if (usrName == null || usrName.length() == 0) {
                Util.errorMessage((Component)this, "Please enter a User Name");
                return false;
            }
        }
        if ((fileName = this.saveZnCnfPnl.getFileName()) == null || fileName.length() == 0) {
            Util.errorMessage((Component)this, "Please enter a file Name");
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        this._status.setText(" ");
        switch (cmd) {
            case 'B': 
            case 'R': {
                if (!this.validateInput()) {
                    return;
                }
                if (this.backUpToSwitch) {
                    this.startLog();
                }
                Thread runnerTh = new Thread(new vshRunner(cmd, this));
                this._status.setText(this.backUpToSwitch ? "Starting Restore..." : "Starting Copy...");
                this.buttons[0].setEnabled(false);
                runnerTh.start();
                break;
            }
            case 'V': {
                if (!this.validateInput()) {
                    return;
                }
                if (this.saveZnCnfPnl.getServerLoc() == 1 && JOptionPane.showConfirmDialog(this, "Zone Config file will be first copied from remote server to switch and \nthen copied to local machine via TFTP, before displaying. Continue?", "View Config File", 0) != 0) break;
                this.startLog();
                Thread runnerTh = new Thread(new vshRunner(cmd, this));
                this.buttons[1].setEnabled(false);
                runnerTh.start();
                break;
            }
            case 'C': {
                this.dispose();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.runner != null) {
            this.runner.stop();
        }
        if (this._logDialog != null) {
            this._logDialog.dispose();
        }
        super.dispose();
    }

    void startLog() {
        if (this._logDialog != null) {
            if (this._logDialog.isVisible()) {
                return;
            }
            this._logDialog.dispose();
        }
        this._logDialog = new InformationDialog(this, (this.backUpToSwitch ? "Restore" : "Backup ") + (this.vsanId == 0 ? "All" : "VSAN " + this.vsanId) + " Zone Configuration - " + this.configSw.getFabric().getPath('/'));
        this._logDialog.setVisible(true);
    }

    private void copyLocalZnCnfg(String inFile, String outFile) throws IOException {
        BufferedReader brd = null;
        BufferedWriter bwr = null;
        try {
            String line;
            FileInputStream fi = new FileInputStream(inFile);
            InputStreamReader rd = new InputStreamReader(fi);
            brd = new BufferedReader(rd);
            FileOutputStream fo = new FileOutputStream(outFile);
            OutputStreamWriter wr = new OutputStreamWriter(fo);
            bwr = new BufferedWriter(wr);
            while ((line = brd.readLine()) != null) {
                bwr.write(line, 0, line.length());
                bwr.newLine();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (brd != null) {
                brd.close();
            }
            if (bwr != null) {
                bwr.close();
            }
        }
    }

    class SaveCfgPanel
    extends SaveZnConfigPnl {
        public SaveCfgPanel(Switch sw, int vsan, boolean restoreConfig) {
            super(sw, vsan, restoreConfig);
        }

        @Override
        protected void actionChanged(char action) {
            BackupZoneDlg.this.backUpToSwitch = action == 'R';
            BackupZoneDlg.this.setTitle((BackupZoneDlg.this.backUpToSwitch ? "Restore " : "Backup " + (this.vsanId == 0 ? "All" : "VSAN " + this.vsanId)) + " Zone Configuration - " + BackupZoneDlg.this.configSw.getFabric().getPath('/'));
            if (BackupZoneDlg.this.buttons != null) {
                BackupZoneDlg.this.buttons[0].setText(BackupZoneDlg.this.backUpToSwitch ? "Restore..." : "Backup...");
                BackupZoneDlg.this.buttons[1].setVisible(BackupZoneDlg.this.backUpToSwitch);
            }
        }
    }

    class vshRunner
    implements Runnable {
        CliCommandHandler handler;
        TFTP tftpSrvr;
        char cmd;
        BackupZoneDlg bckDlg;
        static final String SED_IVR_ZN_MODIFIER = "exc 'zoneset activate'  | exc 'ivr nat' | exc 'version' | exc 'snmp-server'";
        static final String SED_ZN_MODIFIER = "exc 'zoneset activate'  | exc 'ivr nat' | exc 'version' | exc 'snmp-server'";
        static final String SED_CONFT_MODIFIER = "sed '1i\\config terminal'";

        public vshRunner(char command, BackupZoneDlg dlg) {
            this.cmd = command;
            this.bckDlg = dlg;
        }

        public void stop() {
            if (this.handler != null) {
                this.handler.closeVsh();
            }
            BackupZoneDlg.this.buttons[0].setEnabled(true);
            BackupZoneDlg.this.buttons[1].setEnabled(true);
        }

        private void logTrace(String output) {
            this.logTrace(output, true);
        }

        private void logTrace(String output, boolean showStatus) {
            DefaultLogger._DefLogger.debug((Object)output);
            if (BackupZoneDlg.this._logDialog != null && BackupZoneDlg.this._logDialog.isVisible()) {
                BackupZoneDlg.this._logDialog.log(output);
            }
            if (showStatus) {
                BackupZoneDlg.this._status.setText(output);
            }
        }

        private boolean canContinue() {
            if (BackupZoneDlg.this.backUpToSwitch && BackupZoneDlg.this._logDialog != null && !BackupZoneDlg.this._logDialog.isVisible()) {
                return false;
            }
            return BackupZoneDlg.this.backUpToSwitch || this.bckDlg.isVisible();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean moveConfigToSwitch(boolean runScript) {
            String output = null;
            String defPrompt = "#";
            try {
                String usrName = BackupZoneDlg.this.saveZnCnfPnl.getUser();
                String passWord = BackupZoneDlg.this.saveZnCnfPnl.getPass();
                String ipAdd = BackupZoneDlg.this.saveZnCnfPnl.getServer().trim();
                defPrompt = this.handler.getStartPrompt();
                String fileName = BackupZoneDlg.this.saveZnCnfPnl.getFileName();
                if (fileName == null || fileName.length() == 0) {
                    throw new Exception("Please enter a file Name");
                }
                defPrompt = defPrompt.substring(0, defPrompt.indexOf("#"));
                if (!this.canContinue()) {
                    boolean bl = false;
                    return bl;
                }
                if (BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() == 0) {
                    this.tftpSrvr = TFTP.getInstance();
                    this.tftpSrvr.addIpAccess(BackupZoneDlg.this.configSw.getSnmpPeer().getAddress().getHostAddress(), "true", "true", "true");
                    this.tftpSrvr.startServer(SnmpSession.isTrace());
                    this.logTrace("Using TFTP Server:" + this.tftpSrvr.getServerAddress().getHostAddress());
                    if (BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() == 0) {
                        String lclFlNm = this.tftpSrvr.getRoot() + File.separator + BackupZoneDlg.Local_SERVER_FILE_NAME;
                        BackupZoneDlg.this.copyLocalZnCnfg(fileName, lclFlNm);
                        fileName = lclFlNm;
                    }
                }
                this.deleteTempConfigFileFromSwitch();
                switch (BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!this.canContinue()) {
                            boolean lclFlNm = false;
                            return lclFlNm;
                        }
                        String cpStr = BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() == 2 ? "scp://" : (BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() == 1 ? "sftp://" : "ftp://");
                        BackupZoneDlg.this._status.setText("copy " + cpStr + usrName + "@" + ipAdd + "/" + "/" + fileName + " " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME);
                        output = this.handler.executeCLICommand("copy " + cpStr + usrName + "@" + ipAdd + "/" + fileName + " " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME + (BackupZoneDlg.this.configSw.isN5K() ? " vrf management" : ""), new String[]{"password:", "Password:", "(yes/no)?", "(y/n)", "username:", this.handler.getCurrentPrompt()}, false, false);
                        if (output.indexOf("(y/n)") != -1) {
                            this.logTrace(output);
                            output = null;
                            output = this.handler.executeCLICommand("y", new String[]{"password:", "Password:", "(yes/no)?", this.handler.getCurrentPrompt()}, false, false);
                        }
                        if (BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() != 3 && output.indexOf("(yes/no)?") != -1) {
                            this.logTrace(output);
                            output = null;
                            output = this.handler.executeCLICommand("yes", new String[]{"password:", "Password:", this.handler.getCurrentPrompt()}, false, false);
                        }
                        if (BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() == 3 && output.toLowerCase().indexOf("username:") != -1) {
                            this.logTrace(output);
                            output = null;
                            output = this.handler.executeCLICommand(usrName, new String[]{"password:", "Password:", "(yes/no)?", this.handler.getCurrentPrompt()}, false, false);
                        }
                        if (output.toLowerCase().indexOf("password:") == -1) break;
                        this.logTrace(output);
                        output = null;
                        output = this.handler.executeCLICommand(passWord, new String[]{"password:", "Password:", this.handler.getCurrentPrompt()}, false, false, true);
                        if (output.toLowerCase().indexOf("password:") != -1) {
                            this.logTrace(output);
                            throw new Exception("Incorrect Password");
                        }
                        if (output.indexOf("100%") != -1 || output.toString().toLowerCase().indexOf("copy complete") != -1 || output.toString().toLowerCase().indexOf("success") != -1 || BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() == 3 && output.trim().length() == 0) {
                            this.logTrace(output);
                            output = null;
                            break;
                        }
                        throw new Exception("Failed to connect. " + output);
                    }
                    case 0: {
                        if (!this.canContinue()) {
                            boolean bl = false;
                            return bl;
                        }
                        BackupZoneDlg.this._status.setText("copy  tftp://" + ipAdd + "/" + fileName + " " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME);
                        output = this.handler.executeCLICommand("copy tftp://" + ipAdd + "/" + (BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() == 0 ? BackupZoneDlg.Local_SERVER_FILE_NAME : fileName) + " " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME + (BackupZoneDlg.this.configSw.isN5K() ? " vrf management" : ""), new String[0], false, false);
                        this.logTrace(output);
                        if (output.toLowerCase().indexOf("successful") == -1) break;
                        output = null;
                    }
                }
                if (output != null && output.trim().length() > 0) {
                    this.logTrace(output);
                    BackupZoneDlg.this._status.setText(output);
                    throw new Exception(output);
                }
                BackupZoneDlg.this._status.setText("Successful backup");
                if (runScript) {
                    if (!this.canContinue()) {
                        boolean bl = false;
                        return bl;
                    }
                    BackupZoneDlg.this._status.setText("Running script file");
                    output = this.handler.executeCLICommand("run-script bootflash:cpZnbkpFl", new String[0], false, false);
                    this.logTrace(output);
                    BackupZoneDlg.this._status.setText("Completed, please check Log");
                }
            }
            catch (Exception ex) {
                BackupZoneDlg.this._status.setText(ex.getMessage());
                Util.errorMessage((Component)BackupZoneDlg.this._parent, ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.tftpSrvr != null) {
                    this.tftpSrvr.stopServer();
                    this.tftpSrvr = null;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean copyFileViaTftpToLocal(String remoteFile) {
            String output = null;
            try {
                String tftpServerAddr;
                try {
                    tftpServerAddr = NetUtil.detectSourceAddress(BackupZoneDlg.this.configSw.getSnmpPeer().getAddress()).getHostAddress();
                }
                catch (Exception ex) {
                    throw new SnmpException("Invalid TFTP Address: " + ex.getMessage());
                }
                this.tftpSrvr = TFTP.getInstance();
                this.tftpSrvr.addIpAccess(BackupZoneDlg.this.configSw.getSnmpPeer().getAddress().getHostAddress(), "true", "true", "true");
                this.tftpSrvr.startServer(SnmpSession.isTrace());
                if (!this.canContinue()) {
                    boolean ex = false;
                    return ex;
                }
                this.logTrace("Local file:" + this.tftpSrvr.getRoot() + "/" + remoteFile);
                String tftpCmd = "copy  bootflash:" + remoteFile + " tftp://" + tftpServerAddr + "/" + remoteFile + (BackupZoneDlg.this.configSw.isN5K() ? " vrf management" : "");
                BackupZoneDlg.this._status.setText(tftpCmd);
                this.logTrace(tftpCmd);
                output = this.handler.executeCLICommand(tftpCmd, new String[0], false, false);
                this.logTrace(output);
                if (output.toLowerCase().indexOf("successful") == -1) {
                    throw new Exception(output);
                }
                this.logTrace(output);
                output = null;
                BackupZoneDlg.this._status.setText("Successful backup");
            }
            catch (Exception ex) {
                BackupZoneDlg.this._status.setText(ex.getMessage());
                Util.errorMessage((Component)BackupZoneDlg.this._parent, ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.tftpSrvr != null) {
                    this.tftpSrvr.stopServer();
                    this.tftpSrvr = null;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean backupZoneConfig() {
            try {
                String output = null;
                String usrName = BackupZoneDlg.this.saveZnCnfPnl.getUser();
                String passWord = BackupZoneDlg.this.saveZnCnfPnl.getPass();
                String ipAdd = BackupZoneDlg.this.saveZnCnfPnl.getServer().trim();
                String confTCmd = "";
                String showZnCfgCmd = "show running-config zone | exc 'zoneset activate'  | exc 'ivr nat' | exc 'version' | exc 'snmp-server'" + confTCmd;
                if (BackupZoneDlg.this.vsanId == -1) {
                    showZnCfgCmd = "show running-config ivr zone | exc 'zoneset activate'  | exc 'ivr nat' | exc 'version' | exc 'snmp-server'" + confTCmd;
                } else if (BackupZoneDlg.this.vsanId > 0) {
                    showZnCfgCmd = "show running-config zone vsan " + BackupZoneDlg.this.vsanId + " | " + "exc 'zoneset activate'  | exc 'ivr nat' | exc 'version' | exc 'snmp-server'" + confTCmd;
                }
                String fileName = BackupZoneDlg.this.saveZnCnfPnl.getFileName();
                if (fileName == null || fileName.length() == 0) {
                    throw new Exception("Please enter a file Name");
                }
                if (!this.canContinue()) {
                    boolean bl = false;
                    return bl;
                }
                String CONFIG_T_PREPENDER = "show cli list | inc 'configure terminal' ";
                this.logTrace(CONFIG_T_PREPENDER + " > " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME);
                output = this.handler.executeCLICommand(CONFIG_T_PREPENDER + " > " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME, new String[]{"[no]", this.handler.getCurrentPrompt()}, false, false);
                this.logTrace(output);
                this.logTrace(showZnCfgCmd + " >> " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME);
                output = this.handler.executeCLICommand(showZnCfgCmd + " >> " + BackupZoneDlg.BACKUP_ZONE_FILE_NAME, new String[]{"[no]", this.handler.getCurrentPrompt()}, false, false);
                this.logTrace(output);
                output = output.indexOf("[no]") != -1 ? this.handler.executeCLICommand("yes", new String[]{this.handler.getCurrentPrompt()}, false, false) : null;
                if (BackupZoneDlg.this.vsanId == 0) {
                    output = this.handler.executeCLICommand("show running-config ivr zone  | exc 'zoneset activate'  | exc 'ivr nat' | exc 'version' | exc 'snmp-server' >> bootflash:cpZnbkpFl", new String[]{"[no]", this.handler.getCurrentPrompt()}, false, false);
                    this.logTrace(output);
                    output = output.indexOf("[no]") != -1 ? this.handler.executeCLICommand("yes", new String[]{this.handler.getCurrentPrompt()}, false, false) : null;
                }
                if (output != null && output.trim().length() > 0) {
                    throw new Exception("Error in getting zone config " + output);
                }
                if (!this.canContinue()) {
                    boolean bl = false;
                    return bl;
                }
                if (BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() == 0) {
                    this.tftpSrvr = TFTP.getInstance();
                    this.tftpSrvr.addIpAccess(BackupZoneDlg.this.configSw.getSnmpPeer().getAddress().getHostAddress(), "true", "true", "true");
                    this.tftpSrvr.startServer(SnmpSession.isTrace());
                }
                switch (BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!this.canContinue()) {
                            boolean bl = false;
                            return bl;
                        }
                        String cpStr = BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() == 2 ? "scp://" : (BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() == 1 ? "sftp://" : "ftp://");
                        BackupZoneDlg.this._status.setText("copy bootflash:cpZnbkpFl " + cpStr + usrName + "@" + ipAdd + "/" + "/" + fileName);
                        output = this.handler.executeCLICommand("copy bootflash:cpZnbkpFl " + cpStr + usrName + "@" + ipAdd + "/" + fileName + (BackupZoneDlg.this.configSw.isN5K() ? " vrf management" : ""), new String[]{"password:", "Password:", "(yes/no)?", this.handler.getCurrentPrompt()}, false, false);
                        if (BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() != 3 && output.indexOf("(yes/no)?") != -1) {
                            this.logTrace(output);
                            output = null;
                            output = this.handler.executeCLICommand("yes", new String[]{"password:", "Password:", this.handler.getCurrentPrompt()}, false, false);
                        }
                        if (output.toLowerCase().indexOf("password:") != -1) {
                            this.logTrace(output);
                            output = null;
                            output = this.handler.executeCLICommand(passWord, new String[]{"password:", "Password:", this.handler.getCurrentPrompt()}, false, false, true);
                            if (output.toLowerCase().indexOf("password:") != -1) {
                                this.logTrace(output);
                                throw new Exception("Incorrect Password");
                            }
                            if (output.toLowerCase().indexOf("permission denied") != -1) {
                                this.logTrace(output);
                                throw new Exception("Permission Denied.  Please see logs. ");
                            }
                            if (output.indexOf("100%") != -1 || output.toString().toLowerCase().indexOf("copy complete") != -1 || output.toString().toLowerCase().indexOf("success") != -1 || BackupZoneDlg.this.saveZnCnfPnl.getRemoteProto() == 3 && output.trim().length() == 0) {
                                this.logTrace(output);
                                output = null;
                                break;
                            }
                            throw new Exception("Remote copy failed. " + output);
                        }
                        BackupZoneDlg.this._status.setText("Remote copy failed");
                        throw new Exception("Remote copy failed. " + output);
                    }
                    case 0: {
                        if (!this.canContinue()) {
                            boolean bl = false;
                            return bl;
                        }
                        BackupZoneDlg.this._status.setText("copy bootflash:cpZnbkpFl tftp://" + ipAdd + "/" + fileName);
                        output = this.handler.executeCLICommand("copy bootflash:cpZnbkpFl tftp://" + ipAdd + "/" + (BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() == 0 ? BackupZoneDlg.Local_SERVER_FILE_NAME : fileName) + (BackupZoneDlg.this.configSw.isN5K() ? " vrf management" : ""), new String[0], false, false);
                        if (output.toLowerCase().indexOf("successful") != -1) {
                            this.logTrace(output);
                            output = null;
                        }
                        if (BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() != 0) break;
                        String lclFlNm = this.tftpSrvr.getRoot() + File.separator + BackupZoneDlg.Local_SERVER_FILE_NAME;
                        BackupZoneDlg.this.copyLocalZnCnfg(lclFlNm, fileName);
                    }
                }
                if (output != null && output.trim().length() > 0) {
                    this.logTrace(output);
                    BackupZoneDlg.this._status.setText(output);
                    throw new Exception(output);
                }
                BackupZoneDlg.this._status.setText("Successful backup");
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                BackupZoneDlg.this._status.setText(ex.getMessage());
                Util.errorMessage((Component)BackupZoneDlg.this._parent, ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.tftpSrvr != null) {
                    this.tftpSrvr.stopServer();
                    this.tftpSrvr = null;
                }
            }
        }

        private void deleteTempConfigFileFromSwitch() {
            String output = null;
            try {
                output = null;
                output = this.handler.executeCLICommand("del bootflash:cpZnbkpFl", new String[]{"[y", "(yes", this.handler.getCurrentPrompt()}, false, false);
                this.logTrace(output, false);
                DefaultLogger._DefLogger.debug((Object)output);
                if (output.indexOf("[y") != -1 || output.indexOf("(yes") != -1) {
                    output = null;
                    output = this.handler.executeCLICommand("y", new String[0], false, false);
                    DefaultLogger._DefLogger.debug((Object)output);
                }
            }
            catch (Exception ex) {
                BackupZoneDlg.this._status.setText(ex.getMessage());
                Util.errorMessage((Component)BackupZoneDlg.this._parent, ex.getMessage());
            }
        }

        private CliCommandHandler getNewCliCommanderInstance() throws IOException, SnmpException {
            if (this.handler != null) {
                this.handler.closeVsh();
            }
            return new CliCommandHandler(null, BackupZoneDlg.this.configSw.getSnmpPeer(), ExternalTools.isUseSSH());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                block19: {
                    block20: {
                        block16: {
                            block17: {
                                this.logTrace("Getting CLI connection to " + BackupZoneDlg.this.configSw);
                                this.handler = this.getNewCliCommanderInstance();
                                if (this.cmd != 'B' && this.cmd != 'R') break block16;
                                if (!BackupZoneDlg.this.backUpToSwitch) break block17;
                                if (this.moveConfigToSwitch(true)) break block18;
                                if (this.handler != null) {
                                    this.deleteTempConfigFileFromSwitch();
                                    this.handler.closeVsh();
                                }
                                this.handler = null;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        BackupZoneDlg.this.buttons[1].setEnabled(true);
                                        BackupZoneDlg.this.buttons[0].setEnabled(true);
                                    }
                                });
                                return;
                            }
                            if (this.backupZoneConfig()) break block18;
                            if (this.handler != null) {
                                this.deleteTempConfigFileFromSwitch();
                                this.handler.closeVsh();
                            }
                            this.handler = null;
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        if (this.cmd != 'V') break block18;
                        if (BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() != 1) break block19;
                        BackupZoneDlg.this._logDialog.log("Copying config file from remote server to switch...");
                        if (this.moveConfigToSwitch(false)) break block20;
                        if (this.handler != null) {
                            this.deleteTempConfigFileFromSwitch();
                            this.handler.closeVsh();
                        }
                        this.handler = null;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    if (this.copyFileViaTftpToLocal("cpZnbkpFl")) break block19;
                    if (this.handler != null) {
                        this.deleteTempConfigFileFromSwitch();
                        this.handler.closeVsh();
                    }
                    this.handler = null;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                try {
                    int count;
                    String flNm = BackupZoneDlg.this.saveZnCnfPnl.getServerLoc() == 1 ? TFTP.getInstance().getRoot() + File.separator + "cpZnbkpFl" : BackupZoneDlg.this.saveZnCnfPnl.getFileName();
                    FileInputStream input = null;
                    input = new FileInputStream(flNm);
                    byte[] buffer = new byte[8192];
                    BackupZoneDlg.this._logDialog.clear();
                    while ((count = input.read(buffer, 0, buffer.length)) != -1) {
                        BackupZoneDlg.this._logDialog.log(new String(buffer, 0, count));
                    }
                }
                catch (Exception iox) {
                    try {
                        BackupZoneDlg.this._status.setText(iox.getMessage());
                        Util.errorMessage((Component)BackupZoneDlg.this._parent, iox.getMessage());
                        if (this.handler != null) {
                            this.deleteTempConfigFileFromSwitch();
                            this.handler.closeVsh();
                        }
                        this.handler = null;
                    }
                    catch (Throwable throwable) {
                        if (this.handler != null) {
                            this.deleteTempConfigFileFromSwitch();
                            this.handler.closeVsh();
                        }
                        this.handler = null;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            if (this.handler != null) {
                this.deleteTempConfigFileFromSwitch();
                this.handler.closeVsh();
            }
            this.handler = null;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

