/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;

public class IvrDeviceAlias {
    private int _ivrVsan;
    private DeviceAlias da;

    public IvrDeviceAlias(DeviceAlias devAlias, int ivrVsan) {
        this.da = devAlias;
        this._ivrVsan = ivrVsan;
    }

    public String toString() {
        return this.da.toString();
    }

    public int getIvrVsan() {
        return this._ivrVsan;
    }

    public Vsan getVsan() {
        EndPort port = this.da.getEndPort();
        if (port != null) {
            Vsan[] vsans = port.getVsans();
            if (vsans != null && vsans.length == 1) {
                return vsans[0];
            }
            return port.getSwitch().getVsan((short)this._ivrVsan);
        }
        return null;
    }

    public EndPort getEndPort() {
        return this.da.getEndPort();
    }

    public DeviceAlias getDeviceAlias() {
        return this.da;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IvrEndPort)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return ((IvrDeviceAlias)obj).getDeviceAlias().equals(this.da) && ((IvrEndPort)obj).getIvrVsan() == this._ivrVsan;
    }
}

