/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshDump;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.OutputTextArea;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class RestoreZoneConfig
extends JDialog
implements ActionListener,
DocumentListener {
    private static final int SAVE_BUTTON = 0;
    private JButton[] _buttons;
    private JFrame _parent;
    private OutputTextArea _configData;
    private FieldPanel _configFile;
    private Switch _sw;
    private JLabel _status;
    private Vsan _vsan;
    private String _tftpServerAddress;

    public RestoreZoneConfig(JDialog parent, Switch sw, Vsan v, String serverAddress) {
        super(parent);
        this._parent = Util.getFrameAncestor(parent);
        this._sw = sw;
        this._vsan = v;
        this._tftpServerAddress = serverAddress;
        this.buildSaveConfigDialog(this._parent);
    }

    private void buildSaveConfigDialog(JFrame parent) {
        this._parent = parent;
        this.setDefaultCloseOperation(2);
        this.setTitle("Restore Zone Configuration - " + this._sw.getFabric().getPath('/'));
        String[] labels = new String[]{null, "From Backup File:"};
        JComponent[] values = new JComponent[labels.length];
        JButton fileEllipsis = new JButton("...");
        fileEllipsis.setMargin(Util.getNoBorder());
        fileEllipsis.addActionListener(this);
        fileEllipsis.setActionCommand("F");
        this._configFile = new FieldPanel(20, (JComponent)fileEllipsis);
        values[1] = this._configFile;
        values[0] = new DialogSeparator();
        String[] btnLbl = new String[]{"Save File", "Continue Restore...", "Close"};
        this._buttons = DialogUtil.buildButtons(btnLbl, (ActionListener)this);
        JTextArea notes = new JTextArea();
        notes.setWrapStyleWord(true);
        notes.setEditable(false);
        notes.setLineWrap(true);
        notes.setOpaque(false);
        notes.setFont((Font)UIManager.getDefaults().get("Table.font"));
        notes.append("Please select zone configuration to be copied to " + this._sw + ". You can edit configuration before sending it to " + this._sw + " or save the edited configuration to a file.");
        this._configData = new OutputTextArea(true);
        this._configData.getTextArea().getDocument().addDocumentListener(this);
        JPanel mainPnl = new JPanel(new BorderLayout());
        mainPnl.add((Component)notes, "North");
        JPanel centerPnl = new JPanel(new BorderLayout());
        centerPnl.add((Component)DialogUtil.buildPanel(DialogUtil.buildLabels(labels), values), "North");
        centerPnl.add((Component)new JScrollPane(this._configData.getTextArea()), "Center");
        mainPnl.add((Component)centerPnl, "Center");
        this._status = new JLabel(" ");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        this._buttons[0].setEnabled(false);
        JPanel lowerPnl = DialogUtil.buildStatusPanel(this._buttons, this._status);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPnl, lowerPnl);
        this.setResizable(true);
        this.setSize(400, 400);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        this._status.setText(" ");
        switch (cmd) {
            case 'F': {
                String fName = Util.getFileName(this._parent, "Choose restore Filename", "*" + (this._vsan != null ? "VSAN" + this._vsan.getId() + "_" : "ivr_") + "zones_cfg.txt", 0, ClientCache.getLocation(), true);
                if (fName == null) break;
                this._configFile.setText(fName);
                this.readFile();
                break;
            }
            case 'S': {
                this.saveFile();
                break;
            }
            case 'C': {
                if (e.getActionCommand().charAt(1) == 'o') {
                    if (this._configData.getTextArea().getText().trim().length() == 0 && !this.readFile()) {
                        return;
                    }
                    this._status.setText("Check CLI Restore dialog for CLI commands result.");
                    this.restoreZoneData();
                    break;
                }
                this.dispose();
            }
        }
    }

    private boolean readFile() {
        if (this._configFile.getText() != null && this._configFile.getText().trim().length() > 0) {
            FileInputStream input = null;
            try {
                int count;
                input = new FileInputStream(this._configFile.getText().trim());
                byte[] buffer = new byte[8192];
                this._configData.getTextArea().setText("");
                while ((count = input.read(buffer, 0, buffer.length)) != -1) {
                    this._configData.getTextArea().append(new String(buffer, 0, count));
                }
                if (this._sw.isQuail()) {
                    this._configData.getTextArea().append("end\n");
                }
                this._configData.getTextArea().setCaretPosition(0);
                input.close();
                this._buttons[0].setEnabled(false);
            }
            catch (IOException ex) {
                Util.errorMessage((Component)this, ex.getMessage());
                return false;
            }
        } else {
            Util.errorMessage((Component)this, "Please specify a file name.");
            return false;
        }
        return true;
    }

    private boolean saveFile() {
        if (this._configFile.getText() != null && this._configFile.getText().length() > 0) {
            this.saveFile(this._configFile.getText());
            this._buttons[0].setEnabled(false);
            this._status.setText("Saved.");
        } else {
            Util.errorMessage((Component)this, "Please specify a file name.");
        }
        return false;
    }

    private boolean saveFile(String name) {
        try {
            PrintStream pout = new PrintStream(new FileOutputStream(name));
            Document doc = this._configData.getTextArea().getDocument();
            pout.write(doc.getText(0, doc.getLength() - 1).getBytes());
            pout.flush();
            pout.close();
            return true;
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreZoneData() {
        TFTP tftpSrvr = null;
        try {
            if (this._configData.getTextArea().getText().trim().length() == 0) {
                Util.errorMessage((Component)this, "Please specify a file name.");
                return;
            }
            Object vpnAdd = null;
            try {
                tftpSrvr = TFTP.getInstance();
                tftpSrvr.addIpAccess(SmZoneUtil.getSwitchPeer(this._sw).getAddress().getHostAddress(), "true", "true", "true");
                tftpSrvr.startServer(SnmpSession.isTrace());
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                Util.errorMessage((Component)this, "Could not start tftp server: " + ex.getMessage());
                return;
            }
            String fileName = "RestoreZones.cfg";
            String fullFileName = tftpSrvr.getRoot() + File.separator + fileName;
            if (this.saveFile(fullFileName)) {
                String vrf;
                Vsh vshTest = Vsh.get(this._parent, SmZoneUtil.getSwitchPeer(this._sw), false);
                String string = vrf = this._sw.isN5K() ? " vrf management" : "";
                if (vshTest == null) {
                    return;
                }
                Vsh.put(vshTest);
                DefaultLogger._DefLogger.debug((Object)("Using Server Address " + this._tftpServerAddress + " for tftp restore."));
                String[] cmdString = new String[]{vshTest != null && vshTest.getPrompt().indexOf("conf") != -1 ? "end\n" : "\n\n", "copy tftp://" + this._tftpServerAddress + "/" + fileName + " bootflash:" + fileName + vrf + "\n", "run-script bootflash:" + fileName + "\n", "\n\n"};
                VshDump dlg = new VshDump(this._parent, "Restore Zone Configuration - " + this._sw.getFabric().getPath('/'), cmdString, SmZoneUtil.getSwitchPeer(this._sw));
                dlg.setVisible(true);
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex.getMessage());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this._buttons[0].setEnabled(true);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this._buttons[0].setEnabled(true);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this._buttons[0].setEnabled(true);
    }

    class RestoreVshDump
    extends VshDump {
        TFTP tftpServer;

        public RestoreVshDump(JFrame parent, String title, String[] cmds, SnmpPeer peer, TFTP tftpSrvr) throws IOException {
            super(parent, title, cmds, peer);
            this.tftpServer = null;
            this.tftpServer = tftpSrvr;
        }

        @Override
        public void dispose() {
            if (this.tftpServer != null) {
                this.tftpServer.stopServer();
            }
            super.dispose();
        }
    }
}

