/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import java.util.ArrayList;

public class SmIvrZoneSwitch
extends IvrZoneSwitch {
    protected SmIvrZoneSwitch() {
    }

    protected SmIvrZoneSwitch(VersionPeer sw) throws SnmpException {
        super(sw);
    }

    public static ArrayList getNonIvrNatAndNonManageableSwitches(Fabric f) {
        ArrayList<Switch> list = new ArrayList<Switch>();
        Switch[] sws = f.getSwitches();
        if (sws != null) {
            for (int i = 0; i < sws.length; ++i) {
                if (sws[i].isMDS() && sws[i].isManageable() && !sws[i].isVersionLessThan("2.1(0)")) continue;
                list.add(sws[i]);
            }
        }
        return list;
    }

    public static ArrayList discoverSwitchProperties(Fabric f) throws SnmpException {
        return SmIvrZoneSwitch.discoverSwitchProperties(SmZoneUtil.getIvrCapableVersionPeers(f), new SmIvrZoneSwitch());
    }

    @Override
    protected IvrZoneSwitch buildIvrSwitchOb(VersionPeer sw) throws SnmpException {
        return new SmIvrZoneSwitch(sw);
    }

    public Switch getSwitch() {
        return ClientController.findFabricSwitchByIpAddress(this.getPeer().getAddress());
    }

    public static ArrayList buildSwitchLFromIvrZoneSwitch(ArrayList ivrSwList) {
        ArrayList<Switch> listSw = new ArrayList<Switch>();
        for (int i = 0; i < ivrSwList.size(); ++i) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(((IvrZoneSwitch)ivrSwList.get(i)).getVersionPeer().getSwitchPeer().getAddress());
            if (sw == null) continue;
            listSw.add(sw);
        }
        return listSw;
    }
}

